/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import video.api.client.api.ApiCallback;
import video.api.client.api.ApiClient;
import video.api.client.api.ApiException;
import video.api.client.api.ApiResponse;
import video.api.client.api.Pair;
import video.api.client.api.models.Environment;
import video.api.client.api.models.LiveStreamSession;
import video.api.client.api.models.Page;
import video.api.client.api.models.PlayerSessionEvent;
import video.api.client.api.models.RawStatisticsListLiveStreamAnalyticsResponse;
import video.api.client.api.models.RawStatisticsListPlayerSessionEventsResponse;
import video.api.client.api.models.RawStatisticsListSessionsResponse;
import video.api.client.api.models.VideoSession;

public class RawStatisticsApi {
    private ApiClient localVarApiClient;

    public RawStatisticsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public RawStatisticsApi() {
        this.localVarApiClient = new ApiClient(Environment.PRODUCTION.basePath);
    }

    public RawStatisticsApi(String basePath) {
        this.localVarApiClient = new ApiClient(basePath);
    }

    public RawStatisticsApi(String apiKey, String basePath) {
        this.localVarApiClient = new ApiClient(apiKey, basePath);
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call listLiveStreamSessionsCall(String liveStreamId, String period, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/analytics/live-streams/{liveStreamId}".replaceAll("\\{liveStreamId\\}", this.localVarApiClient.escapeString(liveStreamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (period != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("period", period));
        }
        if (currentPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currentPage", currentPage));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call listLiveStreamSessionsValidateBeforeCall(String liveStreamId, String period, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        if (liveStreamId == null) {
            throw new ApiException("Missing the required parameter 'liveStreamId' when calling listLiveStreamSessions");
        }
        Call localVarCall = this.listLiveStreamSessionsCall(liveStreamId, period, currentPage, pageSize, _callback);
        return localVarCall;
    }

    private ApiResponse<RawStatisticsListLiveStreamAnalyticsResponse> listLiveStreamSessionsWithHttpInfo(String liveStreamId, String period, Integer currentPage, Integer pageSize) throws ApiException {
        Call localVarCall = this.listLiveStreamSessionsValidateBeforeCall(liveStreamId, period, currentPage, pageSize, null);
        Type localVarReturnType = new TypeToken<RawStatisticsListLiveStreamAnalyticsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public APIlistLiveStreamSessionsRequest listLiveStreamSessions(String liveStreamId) {
        return new APIlistLiveStreamSessionsRequest(liveStreamId);
    }

    private Call listSessionEventsCall(String sessionId, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/analytics/sessions/{sessionId}/events".replaceAll("\\{sessionId\\}", this.localVarApiClient.escapeString(sessionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (currentPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currentPage", currentPage));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call listSessionEventsValidateBeforeCall(String sessionId, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        if (sessionId == null) {
            throw new ApiException("Missing the required parameter 'sessionId' when calling listSessionEvents");
        }
        Call localVarCall = this.listSessionEventsCall(sessionId, currentPage, pageSize, _callback);
        return localVarCall;
    }

    private ApiResponse<RawStatisticsListPlayerSessionEventsResponse> listSessionEventsWithHttpInfo(String sessionId, Integer currentPage, Integer pageSize) throws ApiException {
        Call localVarCall = this.listSessionEventsValidateBeforeCall(sessionId, currentPage, pageSize, null);
        Type localVarReturnType = new TypeToken<RawStatisticsListPlayerSessionEventsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public APIlistSessionEventsRequest listSessionEvents(String sessionId) {
        return new APIlistSessionEventsRequest(sessionId);
    }

    private Call listVideoSessionsCall(String videoId, String period, Map<String, String> metadata, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/analytics/videos/{videoId}".replaceAll("\\{videoId\\}", this.localVarApiClient.escapeString(videoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (period != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("period", period));
        }
        if (metadata != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("metadata", metadata));
        }
        if (currentPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currentPage", currentPage));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, _callback);
    }

    private Call listVideoSessionsValidateBeforeCall(String videoId, String period, Map<String, String> metadata, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        if (videoId == null) {
            throw new ApiException("Missing the required parameter 'videoId' when calling listVideoSessions");
        }
        Call localVarCall = this.listVideoSessionsCall(videoId, period, metadata, currentPage, pageSize, _callback);
        return localVarCall;
    }

    private ApiResponse<RawStatisticsListSessionsResponse> listVideoSessionsWithHttpInfo(String videoId, String period, Map<String, String> metadata, Integer currentPage, Integer pageSize) throws ApiException {
        Call localVarCall = this.listVideoSessionsValidateBeforeCall(videoId, period, metadata, currentPage, pageSize, null);
        Type localVarReturnType = new TypeToken<RawStatisticsListSessionsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public APIlistVideoSessionsRequest listVideoSessions(String videoId) {
        return new APIlistVideoSessionsRequest(videoId);
    }

    public class APIlistVideoSessionsRequest {
        private final String videoId;
        private String period;
        private Map<String, String> metadata;
        private Integer currentPage;
        private Integer pageSize;

        private APIlistVideoSessionsRequest(String videoId) {
            this.videoId = videoId;
        }

        public APIlistVideoSessionsRequest period(String period) {
            this.period = period;
            return this;
        }

        public APIlistVideoSessionsRequest metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public APIlistVideoSessionsRequest currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public APIlistVideoSessionsRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RawStatisticsApi.this.listVideoSessionsCall(this.videoId, this.period, this.metadata, this.currentPage, this.pageSize, _callback);
        }

        public Page<VideoSession> execute() throws ApiException {
            ApiResponse localVarResp = RawStatisticsApi.this.listVideoSessionsWithHttpInfo(this.videoId, this.period, this.metadata, this.currentPage, this.pageSize);
            return new Page<VideoSession>(((RawStatisticsListSessionsResponse)localVarResp.getData()).getData(), ((RawStatisticsListSessionsResponse)localVarResp.getData()).getPagination(), () -> {
                try {
                    return this.copy().currentPage((this.currentPage == null ? 1 : this.currentPage) + 1).execute();
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private APIlistVideoSessionsRequest copy() {
            APIlistVideoSessionsRequest copy = new APIlistVideoSessionsRequest(this.videoId);
            copy.period(this.period);
            copy.metadata(this.metadata);
            copy.currentPage(this.currentPage);
            copy.pageSize(this.pageSize);
            return copy;
        }

        public ApiResponse<RawStatisticsListSessionsResponse> executeWithHttpInfo() throws ApiException {
            return RawStatisticsApi.this.listVideoSessionsWithHttpInfo(this.videoId, this.period, this.metadata, this.currentPage, this.pageSize);
        }
    }

    public class APIlistSessionEventsRequest {
        private final String sessionId;
        private Integer currentPage;
        private Integer pageSize;

        private APIlistSessionEventsRequest(String sessionId) {
            this.sessionId = sessionId;
        }

        public APIlistSessionEventsRequest currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public APIlistSessionEventsRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RawStatisticsApi.this.listSessionEventsCall(this.sessionId, this.currentPage, this.pageSize, _callback);
        }

        public Page<PlayerSessionEvent> execute() throws ApiException {
            ApiResponse localVarResp = RawStatisticsApi.this.listSessionEventsWithHttpInfo(this.sessionId, this.currentPage, this.pageSize);
            return new Page<PlayerSessionEvent>(((RawStatisticsListPlayerSessionEventsResponse)localVarResp.getData()).getData(), ((RawStatisticsListPlayerSessionEventsResponse)localVarResp.getData()).getPagination(), () -> {
                try {
                    return this.copy().currentPage((this.currentPage == null ? 1 : this.currentPage) + 1).execute();
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private APIlistSessionEventsRequest copy() {
            APIlistSessionEventsRequest copy = new APIlistSessionEventsRequest(this.sessionId);
            copy.currentPage(this.currentPage);
            copy.pageSize(this.pageSize);
            return copy;
        }

        public ApiResponse<RawStatisticsListPlayerSessionEventsResponse> executeWithHttpInfo() throws ApiException {
            return RawStatisticsApi.this.listSessionEventsWithHttpInfo(this.sessionId, this.currentPage, this.pageSize);
        }
    }

    public class APIlistLiveStreamSessionsRequest {
        private final String liveStreamId;
        private String period;
        private Integer currentPage;
        private Integer pageSize;

        private APIlistLiveStreamSessionsRequest(String liveStreamId) {
            this.liveStreamId = liveStreamId;
        }

        public APIlistLiveStreamSessionsRequest period(String period) {
            this.period = period;
            return this;
        }

        public APIlistLiveStreamSessionsRequest currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public APIlistLiveStreamSessionsRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RawStatisticsApi.this.listLiveStreamSessionsCall(this.liveStreamId, this.period, this.currentPage, this.pageSize, _callback);
        }

        public Page<LiveStreamSession> execute() throws ApiException {
            ApiResponse localVarResp = RawStatisticsApi.this.listLiveStreamSessionsWithHttpInfo(this.liveStreamId, this.period, this.currentPage, this.pageSize);
            return new Page<LiveStreamSession>(((RawStatisticsListLiveStreamAnalyticsResponse)localVarResp.getData()).getData(), ((RawStatisticsListLiveStreamAnalyticsResponse)localVarResp.getData()).getPagination(), () -> {
                try {
                    return this.copy().currentPage((this.currentPage == null ? 1 : this.currentPage) + 1).execute();
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private APIlistLiveStreamSessionsRequest copy() {
            APIlistLiveStreamSessionsRequest copy = new APIlistLiveStreamSessionsRequest(this.liveStreamId);
            copy.period(this.period);
            copy.currentPage(this.currentPage);
            copy.pageSize(this.pageSize);
            return copy;
        }

        public ApiResponse<RawStatisticsListLiveStreamAnalyticsResponse> executeWithHttpInfo() throws ApiException {
            return RawStatisticsApi.this.listLiveStreamSessionsWithHttpInfo(this.liveStreamId, this.period, this.currentPage, this.pageSize);
        }
    }
}

