/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;

public class Webhook
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_WEBHOOK_ID = "webhookId";
    @SerializedName(value="webhookId")
    private String webhookId;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_EVENTS = "events";
    @SerializedName(value="events")
    private List<String> events = null;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;

    public Webhook webhookId(String webhookId) {
        this.webhookId = webhookId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="webhook_XXXXXXXXXXXXXXX", value="Unique identifier of the webhook")
    public String getWebhookId() {
        return this.webhookId;
    }

    public void setWebhookId(String webhookId) {
        this.webhookId = webhookId;
    }

    public Webhook createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When an webhook was created, presented in ISO-8601 format.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Webhook events(List<String> events) {
        this.events = events;
        return this;
    }

    public Webhook addEventsItem(String eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<String>();
        }
        this.events.add(eventsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"video.encoding.quality.completed\"]", value="A list of events that will trigger the webhook.")
    public List<String> getEvents() {
        return this.events;
    }

    public void setEvents(List<String> events) {
        this.events = events;
    }

    public Webhook url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="http://clientnotificationserver.com/notif?myquery=query", value="URL of the webhook")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook webhook = (Webhook)o;
        return Objects.equals(this.webhookId, webhook.webhookId) && Objects.equals(this.createdAt, webhook.createdAt) && Objects.equals(this.events, webhook.events) && Objects.equals(this.url, webhook.url);
    }

    public int hashCode() {
        return Objects.hash(this.webhookId, this.createdAt, this.events, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Webhook {\n");
        sb.append("    webhookId: ").append(this.toIndentedString(this.webhookId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

