/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.android.network.request;

import com.recurly.android.RecurlyApi;
import com.recurly.android.model.Addon;
import com.recurly.android.model.BaseModel;
import com.recurly.android.model.CartSummary;
import com.recurly.android.model.Coupon;
import com.recurly.android.model.Plan;
import com.recurly.android.model.PlanPrice;
import com.recurly.android.model.PlanPricing;
import com.recurly.android.model.PriceSummary;
import com.recurly.android.model.Pricing;
import com.recurly.android.model.Tax;
import com.recurly.android.network.RecurlyError;
import com.recurly.android.network.request.CouponRequest;
import com.recurly.android.network.request.PlanRequest;
import com.recurly.android.network.request.TaxRequest;
import com.recurly.android.network.request.WrapperRequest;
import java.util.HashMap;
import java.util.Map;

public class PricingRequest
extends WrapperRequest {
    private String planCode;
    private int planQuantity;
    private String couponCode;
    private Map<String, Integer> addons;
    private String currency;
    private String country;
    private String postalCode;
    private String vatNumber;
    private PricingFetchHandler mFetchHandler;
    private RecurlyApi.PricingResponseHandler mHandler;
    protected Pricing mLastPricing;
    protected Plan mPlan;
    protected Coupon mCoupon;
    protected Tax mTax;
    protected HashMap<String, Float> mAddonTotals;

    public PricingRequest(String planCode, int planQuantity, String couponCode, Map<String, Integer> addons, String country, String postalCode, String vatNumber) {
        this.planCode = planCode;
        this.planQuantity = planQuantity;
        this.couponCode = couponCode;
        this.addons = addons;
        this.currency = BaseModel.getCurrency();
        this.country = country;
        this.postalCode = postalCode;
        this.vatNumber = vatNumber;
    }

    public String getPlanCode() {
        return this.planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    public int getPlanQuantity() {
        return this.planQuantity;
    }

    public void setPlanQuantity(int planQuantity) {
        this.planQuantity = planQuantity;
    }

    public String getCouponCode() {
        return this.couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public Map<String, Integer> getAddons() {
        return this.addons;
    }

    public void setAddons(Map<String, Integer> addons) {
        this.addons = addons;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getVatNumber() {
        return this.vatNumber;
    }

    public void setVatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
    }

    @Override
    public RecurlyError validate() {
        if (this.planCode == null) {
            return RecurlyError.validationError("plan code");
        }
        if (this.planQuantity <= 0) {
            return RecurlyError.validationError("plan quantity");
        }
        if (this.currency == null) {
            return RecurlyError.validationError("currency");
        }
        return null;
    }

    protected void setRequiresRefetch() {
        this.mLastPricing = null;
        if (this.mFetchHandler != null && this.mFetchHandler.isUpdating()) {
            this.mFetchHandler.cancel();
        }
    }

    public boolean requiresUpdate() {
        return this.mLastPricing == null;
    }

    protected RecurlyError recalculate() {
        this.mLastPricing = null;
        if (this.mPlan == null) {
            return RecurlyError.genericServerError("Plan not found for pricing request");
        }
        PlanPrice planPrice = this.mPlan.getPricing();
        if (planPrice == null) {
            return RecurlyError.genericServerError("Plan pricing not found for pricing request");
        }
        float setupFee = planPrice.getSetupFee();
        HashMap<String, Float> addonsChosen = new HashMap<String, Float>();
        float addonTotal = 0.0f;
        if (this.addons != null && this.addons.size() > 0) {
            for (Map.Entry<String, Integer> entry : this.addons.entrySet()) {
                int quantity = entry.getValue();
                String addonName = entry.getKey();
                Addon addon = this.mPlan.getAddon(addonName);
                if (addon == null || addon.getPricing() == null) continue;
                float addonPrice = addon.getPricing().getUnitAmount();
                addonTotal += addonPrice * (float)quantity;
                addonsChosen.put(addonName, Float.valueOf(addonPrice * (float)quantity));
            }
        }
        this.mAddonTotals = addonsChosen;
        float discountRate = 0.0f;
        float discountTotal = 0.0f;
        if (this.mCoupon != null) {
            switch (this.mCoupon.getDiscountType()) {
                case DISCOUNT_TYPE_PERCENT: {
                    discountRate = this.mCoupon.getDiscountRate();
                    break;
                }
                case DISCOUNT_TYPE_FIXED_AMOUNT: {
                    discountTotal = this.mCoupon.getDiscountAmount();
                    break;
                }
            }
        }
        float planCost = planPrice.getUnitAmount() * (float)this.planQuantity;
        float taxRate = 0.0f;
        if (this.mTax != null) {
            taxRate = this.mTax.getRate();
        }
        String currencySymbol = planPrice.getSymbol();
        CartSummary cartSummary = new CartSummary();
        cartSummary.setPlan(new PlanPricing());
        cartSummary.getPlan().setSetupFee(setupFee);
        cartSummary.getPlan().setUnit(planPrice.getUnitAmount());
        cartSummary.setAddons(this.mAddonTotals);
        PriceSummary now = new PriceSummary();
        PriceSummary recurring = new PriceSummary();
        now.setSetupFee(setupFee);
        now.setAddons(addonTotal);
        recurring.setAddons(addonTotal);
        now.setSubtotal(planCost + addonTotal + setupFee);
        recurring.setSubtotal(planCost + addonTotal);
        if (discountRate > 0.0f) {
            now.setDiscount(discountRate * now.getSubtotal());
            recurring.setDiscount(discountRate * recurring.getSubtotal());
        } else {
            now.setDiscount(discountTotal);
            recurring.setDiscount(discountTotal);
        }
        if (taxRate > 0.0f) {
            now.setTax(taxRate * now.getSubtotal());
            recurring.setTax(taxRate * recurring.getSubtotal());
        }
        now.updateTotal();
        recurring.updateTotal();
        Pricing pricing = new Pricing();
        pricing.setNext(recurring);
        pricing.setNow(now);
        pricing.setBase(cartSummary);
        pricing.setCurrencyCode(this.currency);
        pricing.setCurrencySymbol(currencySymbol);
        this.mLastPricing = pricing;
        return null;
    }

    protected void recalculateAndNotify() {
        this.mFinished = true;
        RecurlyError error = this.recalculate();
        if (this.mHandler != null) {
            if (error != null) {
                this.mHandler.onPricingFailure(error);
            } else {
                this.mHandler.onPricingSuccess(this.mLastPricing);
            }
        }
    }

    protected void completeWithError(RecurlyError error) {
        this.mFinished = true;
        if (this.mHandler != null) {
            this.mHandler.onPricingFailure(error);
        }
    }

    public Pricing getPricing() {
        return this.mLastPricing;
    }

    public void setHandler(RecurlyApi.PricingResponseHandler handler) {
        this.mHandler = handler;
    }

    public void fetchRequiredData(RecurlyApi recurlyApi) {
        if (this.mFetchHandler != null) {
            this.mFetchHandler.cancel();
        }
        this.mFetchHandler = new PricingFetchHandler();
        this.mFetchHandler.update(recurlyApi);
    }

    private class PricingFetchHandler {
        private boolean mCancelled;
        private boolean mUpdating;

        private PricingFetchHandler() {
        }

        private void fetchPlan(final RecurlyApi recurlyApi) {
            if (this.mCancelled) {
                return;
            }
            recurlyApi.getPlan(new PlanRequest.Builder().setPlanCode(PricingRequest.this.getPlanCode()).build(), new RecurlyApi.PlanResponseHandler(){

                @Override
                public void onPlanSuccess(Plan plan) {
                    if (PricingFetchHandler.this.mCancelled) {
                        return;
                    }
                    PricingRequest.this.mPlan = plan;
                    PricingFetchHandler.this.fetchCoupon(recurlyApi);
                }

                @Override
                public void onPlanFailure(RecurlyError exception) {
                    if (PricingFetchHandler.this.mCancelled) {
                        return;
                    }
                    PricingRequest.this.completeWithError(exception);
                }
            });
        }

        private void fetchCoupon(final RecurlyApi recurlyApi) {
            if (this.mCancelled) {
                return;
            }
            if (PricingRequest.this.getCouponCode() == null || PricingRequest.this.getCouponCode().isEmpty()) {
                this.fetchTax(recurlyApi);
            } else {
                recurlyApi.getCoupon(new CouponRequest(PricingRequest.this.getPlanCode(), PricingRequest.this.getCouponCode()), new RecurlyApi.CouponResponseHandler(){

                    @Override
                    public void onCouponSuccess(Coupon coupon) {
                        if (PricingFetchHandler.this.mCancelled) {
                            return;
                        }
                        PricingRequest.this.mCoupon = coupon;
                        PricingFetchHandler.this.fetchTax(recurlyApi);
                    }

                    @Override
                    public void onCouponFailure(RecurlyError exception) {
                        if (PricingFetchHandler.this.mCancelled) {
                            return;
                        }
                        PricingRequest.this.completeWithError(exception);
                    }
                });
            }
        }

        private void fetchTax(RecurlyApi recurlyApi) {
            if (this.mCancelled) {
                return;
            }
            if (PricingRequest.this.mPlan.isTaxExempt()) {
                this.didFetchAll();
            } else {
                if (PricingRequest.this.country == null || PricingRequest.this.country.isEmpty()) {
                    PricingRequest.this.completeWithError(RecurlyError.validationError("country code"));
                    return;
                }
                if (PricingRequest.this.postalCode == null || PricingRequest.this.postalCode.isEmpty()) {
                    PricingRequest.this.completeWithError(RecurlyError.validationError("postal code"));
                    return;
                }
                recurlyApi.getPostalTax(new TaxRequest.Builder().setCountryCode(PricingRequest.this.getCountry()).setPostalCode(PricingRequest.this.getPostalCode()).build(), new RecurlyApi.TaxResponseHandler(){

                    @Override
                    public void onTaxSuccess(Tax tax) {
                        if (PricingFetchHandler.this.mCancelled) {
                            return;
                        }
                        PricingRequest.this.mTax = tax;
                        PricingFetchHandler.this.didFetchAll();
                    }

                    @Override
                    public void onTaxFailure(RecurlyError exception) {
                        if (PricingFetchHandler.this.mCancelled) {
                            return;
                        }
                        PricingRequest.this.completeWithError(exception);
                    }
                });
            }
        }

        private void didFetchAll() {
            if (this.mCancelled) {
                return;
            }
            PricingRequest.this.recalculateAndNotify();
        }

        public void cancel() {
            this.mCancelled = true;
            PricingRequest.this.mFinished = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(RecurlyApi recurlyApi) {
            PricingFetchHandler pricingFetchHandler = this;
            synchronized (pricingFetchHandler) {
                if (this.mUpdating) {
                    return;
                }
                this.mUpdating = true;
                this.mCancelled = false;
            }
            this.fetchPlan(recurlyApi);
        }

        public boolean isUpdating() {
            return this.mUpdating;
        }
    }

    public static class Builder {
        private String mPlan;
        private int mPlanQuantity;
        private String mCoupon;
        private Map<String, Integer> mAddons;
        private String mCountry;
        private String mPostalCode;
        private String mVatNumber;

        public Builder setPlan(String plan) {
            this.mPlan = plan;
            return this;
        }

        public Builder setPlanQuantity(int planQuantity) {
            this.mPlanQuantity = planQuantity;
            return this;
        }

        public Builder setCoupon(String coupon) {
            this.mCoupon = coupon;
            return this;
        }

        public Builder addAddon(String addon, int quantity) {
            if (this.mAddons == null) {
                this.mAddons = new HashMap<String, Integer>();
            }
            this.mAddons.put(addon, quantity);
            return this;
        }

        public Builder setAddons(Map<String, Integer> addons) {
            this.mAddons = addons;
            return this;
        }

        public Builder setCountry(String country) {
            this.mCountry = country;
            return this;
        }

        public Builder setPostalCode(String postalCode) {
            this.mPostalCode = postalCode;
            return this;
        }

        public Builder setVatNumber(String vatNumber) {
            this.mVatNumber = vatNumber;
            return this;
        }

        public PricingRequest build() {
            return new PricingRequest(this.mPlan, this.mPlanQuantity, this.mCoupon, this.mAddons, this.mCountry, this.mPostalCode, this.mVatNumber);
        }
    }
}

