/*
 * Decompiled with CFR 0.152.
 */
package us.springett.parsers.cpe;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.CpeParsingException;
import us.springett.parsers.cpe.Part;

public final class CpeParser {
    private static final Pattern SCHEMA_22_OFFICIAL = Pattern.compile("[c][pP][eE]:/[AHOaho]?(:[A-Za-z0-9\\._\\-~%]*){0,6}");
    private static final Pattern SCHEMA_22 = Pattern.compile("[c][pP][eE]:/(?<part>[AHOaho])?(?::)(?<vendor>([A-Za-z0-9\\._\\-~%]*)){0,1}(?::){0,1}(?<product>([A-Za-z0-9\\._\\-~%]*)){0,1}(?::){0,1}(?<version>([A-Za-z0-9\\._\\-~%]*)){0,1}(?::){0,1}(?<update>([A-Za-z0-9\\._\\-~%]*)){0,1}(?::){0,1}(?<edition>([A-Za-z0-9\\._\\-~%]*)){0,1}(?::){0,1}(?<language>([A-Za-z0-9\\._\\-~%]*)){0,1}");
    private static final Pattern SCHEMA_23_OFFICIAL = Pattern.compile("cpe:2\\.3:[aho\\*\\-](:(((\\?*|\\*?)([a-zA-Z0-9\\-\\._]|(\\\\[\\\\\\*\\?!\"#$$%&'\\(\\)\\+,/:;<=>@\\[\\]\\^`\\{\\|}~]))+(\\?*|\\*?))|[\\*\\-])){5}(:(([a-zA-Z]{2,3}(-([a-zA-Z]{2}|[0-9]{3}))?)|[\\*\\-]))(:(((\\?*|\\*?)([a-zA-Z0-9\\-\\._]|(\\\\[\\\\\\*\\?!\"#$$%&'\\(\\)\\+,/:;<=>@\\[\\]\\^`\\{\\|}~]))+(\\?*|\\*?))|[\\*\\-])){4}");
    private static final Pattern SCHEMA_23 = Pattern.compile("cpe:2\\.3:(?<part>[aho\\*\\-])(?::)(?<vendor>(((\\?*|\\*?)([a-zA-Z0-9\\-\\._]|(\\\\[\\\\\\*\\?!\"#$$%&'\\(\\)\\+,\\/:;<=>@\\[\\]\\^`\\{\\|}~]))+(\\?*|\\*?))|[\\*\\-]))(?::)(?<product>(((\\?*|\\*?)([a-zA-Z0-9\\-\\._]|(\\\\[\\\\\\*\\?!\"#$$%&'\\(\\)\\+,\\/:;<=>@\\[\\]\\^`\\{\\|}~]))+(\\?*|\\*?))|[\\*\\-]))(?::)(?<version>(((\\?*|\\*?)([a-zA-Z0-9\\-\\._]|(\\\\[\\\\\\*\\?!\"#$$%&'\\(\\)\\+,\\/:;<=>@\\[\\]\\^`\\{\\|}~]))+(\\?*|\\*?))|[\\*\\-]))(?::)(?<update>(((\\?*|\\*?)([a-zA-Z0-9\\-\\._]|(\\\\[\\\\\\*\\?!\"#$$%&'\\(\\)\\+,\\/:;<=>@\\[\\]\\^`\\{\\|}~]))+(\\?*|\\*?))|[\\*\\-]))(?::)(?<edition>(((\\?*|\\*?)([a-zA-Z0-9\\-\\._]|(\\\\[\\\\\\*\\?!\"#$$%&'\\(\\)\\+,\\/:;<=>@\\[\\]\\^`\\{\\|}~]))+(\\?*|\\*?))|[\\*\\-]))(?::)(?<language>(((\\?*|\\*?)([a-zA-Z0-9\\-\\._]|(\\\\[\\\\\\*\\?!\"#$$%&'\\(\\)\\+,\\/:;<=>@\\[\\]\\^`\\{\\|}~]))+(\\?*|\\*?))|[\\*\\-]))(?::)(?<swEdition>(((\\?*|\\*?)([a-zA-Z0-9\\-\\._]|(\\\\[\\\\\\*\\?!\"#$$%&'\\(\\)\\+,\\/:;<=>@\\[\\]\\^`\\{\\|}~]))+(\\?*|\\*?))|[\\*\\-]))(?::)(?<targetSw>(((\\?*|\\*?)([a-zA-Z0-9\\-\\._]|(\\\\[\\\\\\*\\?!\"#$$%&'\\(\\)\\+,\\/:;<=>@\\[\\]\\^`\\{\\|}~]))+(\\?*|\\*?))|[\\*\\-]))(?::)(?<targetHw>(((\\?*|\\*?)([a-zA-Z0-9\\-\\._]|(\\\\[\\\\\\*\\?!\"#$$%&'\\(\\)\\+,\\/:;<=>@\\[\\]\\^`\\{\\|}~]))+(\\?*|\\*?))|[\\*\\-]))(?::)(?<other>(((\\?*|\\*?)([a-zA-Z0-9\\-\\._]|(\\\\[\\\\\\*\\?!\"#$$%&'\\(\\)\\+,\\/:;<=>@\\[\\]\\^`\\{\\|}~]))+(\\?*|\\*?))|[\\*\\-]))");
    private static final Map<String, Part> PARTS_INDEX = new HashMap<String, Part>(Part.values().length);

    private CpeParser() {
    }

    private static Part resolvePartByAbbreviation(String part) {
        return PARTS_INDEX.get(part);
    }

    public static Cpe parse(String cpeString) throws CpeParsingException {
        Matcher matcher22 = SCHEMA_22.matcher(cpeString);
        if (matcher22.matches()) {
            Cpe cpe = new Cpe();
            cpe.setPart(CpeParser.resolvePartByAbbreviation(matcher22.group("part")));
            cpe.setVendor(CpeParser.trimToNull(matcher22.group("vendor")));
            cpe.setProduct(CpeParser.trimToNull(matcher22.group("product")));
            cpe.setVersion(CpeParser.trimToNull(matcher22.group("version")));
            cpe.setUpdate(CpeParser.trimToNull(matcher22.group("update")));
            cpe.setEdition(CpeParser.trimToNull(matcher22.group("edition")));
            cpe.setLanguage(CpeParser.trimToNull(matcher22.group("language")));
            return cpe;
        }
        Matcher matcher23 = SCHEMA_23.matcher(cpeString);
        if (matcher23.matches()) {
            Cpe cpe = new Cpe();
            cpe.setPart(CpeParser.resolvePartByAbbreviation(matcher23.group("part")));
            cpe.setVendor(CpeParser.trimToNull(matcher23.group("vendor")));
            cpe.setProduct(CpeParser.trimToNull(matcher23.group("product")));
            cpe.setVersion(CpeParser.trimToNull(matcher23.group("version")));
            cpe.setUpdate(CpeParser.trimToNull(matcher23.group("update")));
            cpe.setEdition(CpeParser.trimToNull(matcher23.group("edition")));
            cpe.setLanguage(CpeParser.trimToNull(matcher23.group("language")));
            cpe.setSwEdition(CpeParser.trimToNull(matcher23.group("swEdition")));
            cpe.setTargetSw(CpeParser.trimToNull(matcher23.group("targetSw")));
            cpe.setTargetHw(CpeParser.trimToNull(matcher23.group("targetHw")));
            cpe.setOther(CpeParser.trimToNull(matcher23.group("other")));
            return cpe;
        }
        throw new CpeParsingException("The CPE string specified does not conform to the CPE 2.2 or 2.3 specification");
    }

    public static boolean isValid(String cpeString) {
        return CpeParser.isVersion22(cpeString) || CpeParser.isVersion23(cpeString);
    }

    public static boolean isVersion22(String cpeString) {
        Matcher matcher = SCHEMA_22_OFFICIAL.matcher(cpeString);
        return matcher.matches();
    }

    public static boolean isVersion23(String cpeString) {
        Matcher matcher = SCHEMA_23_OFFICIAL.matcher(cpeString);
        return matcher.matches();
    }

    private static String trimToNull(String input) {
        if (input == null) {
            return null;
        }
        String result = input.trim();
        return result.equals("") ? null : result;
    }

    static {
        for (Part part : Part.values()) {
            PARTS_INDEX.put(part.getAbbreviation(), part);
        }
    }
}

