/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class GroundContactPoint
extends ExternalForcePoint {
    private static final long serialVersionUID = 2334921180229856021L;
    private final YoFramePoint3D touchdownLocation;
    private final YoDouble fs;
    private final YoFrameVector3D surfaceNormal;
    private final YoBoolean slip;
    private final YoInteger collisionCount;

    public GroundContactPoint(String name, Robot robot) {
        this(name, null, robot.getRobotsYoRegistry());
    }

    public GroundContactPoint(String name, YoRegistry registry) {
        this(name, null, registry);
    }

    public GroundContactPoint(String name, Tuple3DReadOnly offset, Robot robot) {
        this(name, offset, robot.getRobotsYoRegistry());
    }

    public GroundContactPoint(String name, Tuple3DReadOnly offset, YoRegistry registry) {
        super(name, offset, registry);
        this.touchdownLocation = new YoFramePoint3D(name + "_td", "", ReferenceFrame.getWorldFrame(), registry);
        this.fs = new YoDouble(name + "_fs", "GroundContactPoint foot switch", registry);
        this.slip = new YoBoolean(name + "_slip", "GroundContactPoint slipping", registry);
        this.collisionCount = new YoInteger(name + "_coll", "GroundContactPoint colliding", registry);
        this.surfaceNormal = new YoFrameVector3D(name + "_n", "", ReferenceFrame.getWorldFrame(), registry);
    }

    public boolean isSlipping() {
        return this.slip.getBooleanValue();
    }

    public boolean isInContact() {
        return this.fs.getDoubleValue() > 0.5;
    }

    public void disable() {
        this.fs.set(-1.0);
    }

    public boolean isDisabled() {
        return this.fs.getDoubleValue() < -0.5;
    }

    public void setIsSlipping(boolean isSlipping) {
        this.slip.set(isSlipping);
    }

    public int getCollisionCount() {
        return this.collisionCount.getIntegerValue();
    }

    public void incrementCollisionCount() {
        this.collisionCount.increment();
    }

    public void setInContact() {
        this.fs.set(1.0);
    }

    public void setNotInContact() {
        this.fs.set(0.0);
    }

    public void setIsInContact(boolean isInContact) {
        if (isInContact) {
            this.setInContact();
        } else {
            this.setNotInContact();
        }
    }

    public void getTouchdownLocation(Point3DBasics touchdownLocationToPack) {
        touchdownLocationToPack.set((Tuple3DReadOnly)this.touchdownLocation);
    }

    public YoFramePoint3D getYoTouchdownLocation() {
        return this.touchdownLocation;
    }

    public YoDouble getYoFootSwitch() {
        return this.fs;
    }

    public void setTouchdownLocation(Point3DReadOnly touchdownLocation) {
        this.touchdownLocation.set((Tuple3DReadOnly)touchdownLocation);
    }

    public void setTouchdownToCurrentLocation() {
        this.touchdownLocation.set((FrameTuple3DReadOnly)this.getYoPosition());
    }

    public void getSurfaceNormal(Vector3DBasics vectorToPack) {
        vectorToPack.set((Tuple3DReadOnly)this.surfaceNormal);
    }

    public void setSurfaceNormal(Vector3DReadOnly surfaceNormal) {
        this.surfaceNormal.set((Tuple3DReadOnly)surfaceNormal);
    }

    public void setSurfaceNormal(double fx, double fy, double fz) {
        this.surfaceNormal.set(fx, fy, fz);
    }

    public YoFrameVector3D getYoSurfaceNormal() {
        return this.surfaceNormal;
    }
}

