/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.engine.featherstone;

import java.io.Serializable;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.CollisionDerivativeException;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.CollisionDerivativeVector;

public class CollisionRungeKutta
implements Serializable {
    private static final long serialVersionUID = 8085611439415747376L;
    private static final boolean REPORT = false;
    double minStepSize_;
    double stepSize_;
    double accuracy_;
    double currentStepSize_;
    boolean verbose;
    boolean adaptive_;
    private int NVARS;
    int[] nok = new int[1];
    int[] nbad = new int[1];
    double[] dydx;
    double[] yend;
    double[] yerr;
    static final int MAXSTP = 10000;
    static final double TINY = 1.0E-30;
    int kmax;
    int kount;
    double[] xp;
    double[][] yp;
    double dxsav;
    double[] x;
    double[] hnext;
    double[] hdid;
    double[] yscal;
    double[] y;
    static final double SAFETY = 0.9;
    static final double PGROW = -0.2;
    static final double PSHRNK = -0.25;
    static final double ERRCON = 1.89E-4;
    double[] ytemp;
    static final double a2 = 0.2;
    static final double a3 = 0.3;
    static final double a4 = 0.6;
    static final double a5 = 1.0;
    static final double a6 = 0.875;
    static final double b21 = 0.2;
    static final double b31 = 0.075;
    static final double b32 = 0.225;
    static final double b41 = 0.3;
    static final double b42 = -0.9;
    static final double b43 = 1.2;
    static final double b51 = -0.2037037037037037;
    static final double b52 = 2.5;
    static final double b53 = -2.5925925925925926;
    static final double b54 = 1.2962962962962963;
    static final double b61 = 0.029495804398148147;
    static final double b62 = 0.341796875;
    static final double b63 = 0.041594328703703706;
    static final double b64 = 0.40034541377314814;
    static final double b65 = 0.061767578125;
    static final double c1 = 0.09788359788359788;
    static final double c3 = 0.4025764895330113;
    static final double c4 = 0.21043771043771045;
    static final double c6 = 0.2891022021456804;
    static final double dc5 = -0.019321986607142856;
    static final double dc1 = -0.004293774801587311;
    static final double dc3 = 0.018668586093857853;
    static final double dc4 = -0.034155026830808066;
    static final double dc6 = 0.03910220214568039;
    double[] ak2;
    double[] ak3;
    double[] ak4;
    double[] ak5;
    double[] ak6;
    double[] ytemp2;

    public CollisionRungeKutta(int NVARS) {
        this.NVARS = NVARS;
        this.dydx = new double[NVARS];
        this.yend = new double[NVARS];
        this.yerr = new double[NVARS];
        this.x = new double[1];
        this.hnext = new double[1];
        this.hdid = new double[1];
        this.yscal = new double[NVARS];
        this.y = new double[NVARS];
        this.ytemp = new double[NVARS];
        this.ak2 = new double[NVARS];
        this.ak3 = new double[NVARS];
        this.ak4 = new double[NVARS];
        this.ak5 = new double[NVARS];
        this.ak6 = new double[NVARS];
        this.ytemp2 = new double[NVARS];
        this.stepSize_ = 0.05;
        this.currentStepSize_ = 0.05;
        this.minStepSize_ = this.stepSize_ / 100.0;
        this.accuracy_ = 1.0E-6;
        this.adaptive_ = true;
    }

    public void setStepSize(double stepSize) {
        this.stepSize_ = stepSize;
        if (stepSize < 100.0 * this.minStepSize_) {
            this.minStepSize_ = this.stepSize_ / 100.0;
        }
    }

    public void setMinimumStepSize(double stepSize) {
        this.minStepSize_ = stepSize;
    }

    public void setAdaptive() {
        this.adaptive_ = true;
    }

    public void setNonAdaptive() {
        this.adaptive_ = false;
    }

    public void setAccuracy(double accuracy) {
        this.accuracy_ = accuracy;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setVerbose() {
        this.verbose = !this.verbose;
    }

    public int goodSteps() {
        return this.nok[0];
    }

    public int badSteps() {
        return this.nbad[0];
    }

    public int steps() {
        return this.nok[0] + this.nbad[0];
    }

    public double stepSize() {
        return this.currentStepSize_;
    }

    public void integrate(double[] y, double[] range, CollisionDerivativeVector dv) throws ODEException, CollisionDerivativeException {
        double h = this.stepSize_;
        double hmin = this.minStepSize_;
        this.nbad[0] = 0;
        this.nok[0] = 0;
        if (this.adaptive_) {
            this.odeint(y, range, this.accuracy_, h, hmin, this.nok, this.nbad, dv);
            if (this.verbose) {
                System.out.println("nok = " + this.nok[0] + "\tnbad = " + this.nbad[0]);
            }
        } else {
            this.rkdumb(y, range, h, dv);
        }
    }

    void rkdumb(double[] ystart, double[] range, double h, CollisionDerivativeVector dv) throws CollisionDerivativeException {
        double end = range[1];
        double start = range[0];
        int nSteps = (int)Math.abs((end - start) / h);
        if (nSteps < 1) {
            nSteps = 1;
        }
        h = (end - start) / (double)nSteps;
        for (int step = 0; step < nSteps; ++step) {
            double x = start + (double)step * h;
            dv.derivs(x, ystart, this.dydx);
            this.rkck(ystart, this.dydx, x, h, this.yend, this.yerr, dv);
            for (int n = 0; n < this.NVARS; ++n) {
                ystart[n] = this.yend[n];
            }
        }
        range[1] = start + (double)(nSteps - 1) * h;
    }

    void odeint(double[] ystart, double[] range, double eps, double h1, double hmin, int[] nok, int[] nbad, CollisionDerivativeVector dv) throws ODEException, CollisionDerivativeException {
        double x1 = range[0];
        double x2 = range[1];
        this.x[0] = x1;
        double h = Math.abs(h1);
        if (x2 < x1) {
            h = -h;
        }
        this.kount = 0;
        nbad[0] = 0;
        nok[0] = 0;
        for (int i = 0; i < this.NVARS; ++i) {
            this.y[i] = ystart[i];
        }
        double xsav = 0.0;
        if (this.kmax > 0) {
            xsav = this.x[0] - this.dxsav * 2.0;
        }
        if (dv.isStuck(this.y)) {
            range[1] = this.x[0];
            return;
        }
        for (int nstp = 1; nstp <= 10000; ++nstp) {
            int i;
            dv.derivs(this.x[0], this.y, this.dydx);
            for (i = 0; i < this.NVARS; ++i) {
                this.yscal[i] = Math.abs(this.y[i]) + Math.abs(this.dydx[i] * h) + 1.0E-30;
            }
            if (this.kmax > 0 && this.kount < this.kmax - 1 && Math.abs(this.x[0] - xsav) > Math.abs(this.dxsav)) {
                this.xp[++this.kount] = this.x[0];
                for (i = 0; i < this.NVARS; ++i) {
                    this.yp[i][this.kount] = this.y[i];
                }
                xsav = this.x[0];
            }
            if ((this.x[0] + h - x2) * (this.x[0] + h - x1) > 0.0) {
                h = x2 - this.x[0];
            }
            this.rkqs(this.y, this.dydx, this.x, h, eps, this.yscal, this.hdid, this.hnext, dv);
            if (this.hdid[0] == h) {
                nok[0] = nok[0] + 1;
            } else {
                nbad[0] = nbad[0] + 1;
            }
            if ((this.x[0] - x2) * (x2 - x1) >= 0.0 || dv.isStuck(this.y)) {
                for (i = 0; i < this.NVARS; ++i) {
                    ystart[i] = this.y[i];
                }
                if (this.kmax != 0) {
                    this.xp[++this.kount] = this.x[0];
                    for (i = 0; i < this.NVARS; ++i) {
                        this.yp[i][this.kount] = this.y[i];
                    }
                }
                range[1] = this.x[0];
                return;
            }
            if (Math.abs(this.hnext[0]) <= hmin) {
                throw new ODEException("Step size too small in odeint.");
            }
            this.currentStepSize_ = h = this.hnext[0];
        }
        System.err.println("Too many steps in routine odeint.");
    }

    void rkqs(double[] y, double[] dydx, double[] x, double htry, double eps, double[] yscal, double[] hdid, double[] hnext, CollisionDerivativeVector dv) throws ODEException, CollisionDerivativeException {
        int i;
        double h;
        double errmax;
        block3: {
            double htemp;
            double xnew;
            errmax = 0.0;
            h = htry;
            do {
                this.rkck(y, dydx, x[0], h, this.ytemp, this.yerr, dv);
                errmax = 0.0;
                for (i = 0; i < this.NVARS; ++i) {
                    errmax = Math.max(errmax, Math.abs(this.yerr[i] / yscal[i]));
                }
                if ((errmax /= eps) <= 1.0) break block3;
                htemp = 0.9 * h * Math.pow(errmax, -0.25);
            } while ((xnew = x[0] + (h = h >= 0.0 ? Math.max(htemp, 0.1 * h) : Math.min(htemp, 0.1 * h))) != x[0]);
            throw new ODEException("stepsize underflow in rkqs.");
        }
        hnext[0] = errmax > 1.89E-4 ? 0.9 * h * Math.pow(errmax, -0.2) : 5.0 * h;
        hdid[0] = h;
        x[0] = x[0] + hdid[0];
        for (i = 0; i < this.NVARS; ++i) {
            y[i] = this.ytemp[i];
        }
    }

    void rkck(double[] y, double[] dydx, double x, double h, double[] yout, double[] yerr, CollisionDerivativeVector dv) throws CollisionDerivativeException {
        int i;
        for (i = 0; i < this.NVARS; ++i) {
            this.ytemp2[i] = y[i] + 0.2 * h * dydx[i];
        }
        dv.derivs(x + 0.2 * h, this.ytemp2, this.ak2);
        for (i = 0; i < this.NVARS; ++i) {
            this.ytemp2[i] = y[i] + h * (0.075 * dydx[i] + 0.225 * this.ak2[i]);
        }
        dv.derivs(x + 0.3 * h, this.ytemp2, this.ak3);
        for (i = 0; i < this.NVARS; ++i) {
            this.ytemp2[i] = y[i] + h * (0.3 * dydx[i] + -0.9 * this.ak2[i] + 1.2 * this.ak3[i]);
        }
        dv.derivs(x + 0.6 * h, this.ytemp2, this.ak4);
        for (i = 0; i < this.NVARS; ++i) {
            this.ytemp2[i] = y[i] + h * (-0.2037037037037037 * dydx[i] + 2.5 * this.ak2[i] + -2.5925925925925926 * this.ak3[i] + 1.2962962962962963 * this.ak4[i]);
        }
        dv.derivs(x + 1.0 * h, this.ytemp2, this.ak5);
        for (i = 0; i < this.NVARS; ++i) {
            this.ytemp2[i] = y[i] + h * (0.029495804398148147 * dydx[i] + 0.341796875 * this.ak2[i] + 0.041594328703703706 * this.ak3[i] + 0.40034541377314814 * this.ak4[i] + 0.061767578125 * this.ak5[i]);
        }
        dv.derivs(x + 0.875 * h, this.ytemp2, this.ak6);
        for (i = 0; i < this.NVARS; ++i) {
            yout[i] = y[i] + h * (0.09788359788359788 * dydx[i] + 0.4025764895330113 * this.ak3[i] + 0.21043771043771045 * this.ak4[i] + 0.2891022021456804 * this.ak6[i]);
        }
        for (i = 0; i < this.NVARS; ++i) {
            yerr[i] = h * (-0.004293774801587311 * dydx[i] + 0.018668586093857853 * this.ak3[i] + -0.034155026830808066 * this.ak4[i] + -0.019321986607142856 * this.ak5[i] + 0.03910220214568039 * this.ak6[i]);
        }
    }

    void error(String msg) {
        System.out.println("comphys.numerics.RungeKutta: " + msg);
    }

    class ODEException
    extends Exception
    implements Serializable {
        private static final long serialVersionUID = -9101473542052720197L;

        public ODEException() {
        }

        public ODEException(String message) {
            super(message);
        }
    }
}

