/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.examples;

import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.util.LinearGroundContactModel;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.simulationconstructionset.util.ground.WavyGroundProfile;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class FallingBrickRobot
extends Robot
implements RobotController {
    private static final double BASE_H = 0.1;
    private static final double BASE_W = 0.2;
    private static final double BASE_L = 0.3;
    private static final double B1 = 0.05;
    private static final double M1 = 1.7;
    private static final double Ixx1 = 0.1;
    private static final double Iyy1 = 0.5;
    private static final double Izz1 = 0.9;
    private static final double G = 9.81;
    private final YoRegistry registry = new YoRegistry("FallingBrickController");
    YoDouble q_x;
    YoDouble q_y;
    YoDouble q_z;
    YoDouble qd_x;
    YoDouble qd_y;
    YoDouble qd_z;
    YoDouble qdd_x;
    YoDouble qdd_y;
    YoDouble qdd_z;
    YoDouble q_qs;
    YoDouble q_qx;
    YoDouble q_qy;
    YoDouble q_qz;
    YoDouble qd_wx;
    YoDouble qd_wy;
    YoDouble qd_wz;
    YoDouble qdd_wx;
    YoDouble qdd_wy;
    YoDouble qdd_wz;
    YoDouble energy;
    YoDouble q_qlength;
    YoDouble theta_x;
    YoDouble qdd2_wx;
    YoDouble qdd2_wy;
    YoDouble qdd2_wz;
    Joint floatingJoint;

    public FallingBrickRobot() {
        super("FallingBrick");
        this.setGravity(0.0, 0.0, -9.81);
        this.floatingJoint = new FloatingJoint("base", (Tuple3DReadOnly)new Vector3D(0.0, 0.0, 0.0), this);
        Link link1 = this.base("base", YoAppearance.Red());
        this.floatingJoint.setLink(link1);
        this.addRootJoint(this.floatingJoint);
        GroundContactPoint gc1 = new GroundContactPoint("gc1", (Tuple3DReadOnly)new Vector3D(0.15, 0.1, 0.05), this);
        this.floatingJoint.addGroundContactPoint(gc1);
        GroundContactPoint gc2 = new GroundContactPoint("gc2", (Tuple3DReadOnly)new Vector3D(0.15, -0.1, 0.05), this);
        this.floatingJoint.addGroundContactPoint(gc2);
        GroundContactPoint gc3 = new GroundContactPoint("gc3", (Tuple3DReadOnly)new Vector3D(-0.15, 0.1, 0.05), this);
        this.floatingJoint.addGroundContactPoint(gc3);
        GroundContactPoint gc4 = new GroundContactPoint("gc4", (Tuple3DReadOnly)new Vector3D(-0.15, -0.1, 0.05), this);
        this.floatingJoint.addGroundContactPoint(gc4);
        GroundContactPoint gc5 = new GroundContactPoint("gc5", (Tuple3DReadOnly)new Vector3D(0.15, 0.1, -0.05), this);
        this.floatingJoint.addGroundContactPoint(gc5);
        GroundContactPoint gc6 = new GroundContactPoint("gc6", (Tuple3DReadOnly)new Vector3D(0.15, -0.1, -0.05), this);
        this.floatingJoint.addGroundContactPoint(gc6);
        GroundContactPoint gc7 = new GroundContactPoint("gc7", (Tuple3DReadOnly)new Vector3D(-0.15, 0.1, -0.05), this);
        this.floatingJoint.addGroundContactPoint(gc7);
        GroundContactPoint gc8 = new GroundContactPoint("gc8", (Tuple3DReadOnly)new Vector3D(-0.15, -0.1, -0.05), this);
        this.floatingJoint.addGroundContactPoint(gc8);
        GroundContactPoint gc9 = new GroundContactPoint("gc9", (Tuple3DReadOnly)new Vector3D(0.0, 0.0, 0.15000000000000002), this);
        this.floatingJoint.addGroundContactPoint(gc9);
        GroundContactPoint gc10 = new GroundContactPoint("gc10", (Tuple3DReadOnly)new Vector3D(0.0, 0.0, -0.15000000000000002), this);
        this.floatingJoint.addGroundContactPoint(gc10);
        this.setController(this);
        LinearGroundContactModel groundModel = new LinearGroundContactModel(this, 1422.0, 150.6, 50.0, 1000.0, this.getRobotsYoRegistry());
        WavyGroundProfile profile = new WavyGroundProfile();
        groundModel.setGroundProfile3D(profile);
        this.setGroundContactModel(groundModel);
        this.initRobot();
        this.initControl();
    }

    private Link base(String name, AppearanceDefinition appearance) {
        Link ret = new Link(name);
        ret.setMass(1.7);
        ret.setMomentOfInertia(0.1, 0.5, 0.9);
        ret.setComOffset(0.0, 0.0, 0.0);
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.translate(0.0, 0.0, -0.05);
        linkGraphics.addPyramidCube(0.3, 0.2, 0.1, 0.1, appearance);
        ret.setLinkGraphics(linkGraphics);
        return ret;
    }

    public void initRobot() {
        this.q_qlength = new YoDouble("q_qlength", this.registry);
        this.theta_x = new YoDouble("theta_x", this.registry);
        this.t.set(0.0);
        this.q_x = (YoDouble)this.findVariable("q_x");
        this.q_y = (YoDouble)this.findVariable("q_y");
        this.q_z = (YoDouble)this.findVariable("q_z");
        this.qd_x = (YoDouble)this.findVariable("qd_x");
        this.qd_y = (YoDouble)this.findVariable("qd_y");
        this.qd_z = (YoDouble)this.findVariable("qd_z");
        this.qdd_x = (YoDouble)this.findVariable("qdd_x");
        this.qdd_y = (YoDouble)this.findVariable("qdd_y");
        this.qdd_z = (YoDouble)this.findVariable("qdd_z");
        this.q_qs = (YoDouble)this.findVariable("q_qs");
        this.q_qx = (YoDouble)this.findVariable("q_qx");
        this.q_qy = (YoDouble)this.findVariable("q_qy");
        this.q_qz = (YoDouble)this.findVariable("q_qz");
        this.qd_wx = (YoDouble)this.findVariable("qd_wx");
        this.qd_wy = (YoDouble)this.findVariable("qd_wy");
        this.qd_wz = (YoDouble)this.findVariable("qd_wz");
        this.qdd_wx = (YoDouble)this.findVariable("qdd_wx");
        this.qdd_wy = (YoDouble)this.findVariable("qdd_wy");
        this.qdd_wz = (YoDouble)this.findVariable("qdd_wz");
        this.q_x.set(0.0);
        this.q_y.set(0.0);
        this.q_z.set(0.6);
        this.qd_x.set(0.0);
        this.qd_y.set(0.0);
        this.qd_z.set(0.0);
        this.q_qs.set(0.707);
        this.q_qx.set(0.3);
        this.q_qy.set(0.4);
        this.q_qz.set(0.5);
        this.qd_wx.set(1.0E-4);
        this.qd_wy.set(1.0);
        this.qd_wz.set(0.5001);
    }

    public void initControl() {
        this.qdd2_wx = new YoDouble("qdd2_wx", this.registry);
        this.qdd2_wy = new YoDouble("qdd2_wy", this.registry);
        this.qdd2_wz = new YoDouble("qdd2_wz", this.registry);
        this.energy = new YoDouble("energy", this.registry);
    }

    public void doControl() {
        this.energy.set(16.677 * this.q_z.getDoubleValue() + 0.85 * this.qd_x.getDoubleValue() * this.qd_x.getDoubleValue() + 0.85 * this.qd_y.getDoubleValue() * this.qd_y.getDoubleValue() + 0.85 * this.qd_z.getDoubleValue() * this.qd_z.getDoubleValue() + 0.05 * this.qd_wx.getDoubleValue() * this.qd_wx.getDoubleValue() + 0.25 * this.qd_wy.getDoubleValue() * this.qd_wy.getDoubleValue() + 0.45 * this.qd_wz.getDoubleValue() * this.qd_wz.getDoubleValue());
        this.qdd2_wx.set(-4.0 * this.qd_wy.getDoubleValue() * this.qd_wz.getDoubleValue());
        this.qdd2_wy.set(1.6 * this.qd_wz.getDoubleValue() * this.qd_wx.getDoubleValue());
        this.qdd2_wz.set(-0.4444444444444445 * this.qd_wx.getDoubleValue() * this.qd_wy.getDoubleValue());
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }

    public void initialize() {
    }

    public String getDescription() {
        return this.getName();
    }
}

