/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.StringTokenizer;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public class KDTree {
    private final boolean hasObjects;
    private final int maxPointsInLeaves;
    private final Object[] objects;
    private final KDNode root;
    private LinkedHashSet<Integer> novelPointIndexes;
    private static final boolean DEBUG = false;

    public KDTree(double[][] points, Object[] objects, int maxPointsInLeaves) {
        if (points == objects) {
            throw new RuntimeException("Do not use the same keys and values in constructing a KDTree. If they are the same, then just use the key constructor");
        }
        this.makeAllPointsNovel(points.length);
        this.hasObjects = true;
        this.objects = objects;
        this.maxPointsInLeaves = maxPointsInLeaves;
        if (points.length != objects.length) {
            System.err.println("KDTree::KDTree(): number of points and objects differ.  Creating empty KDTree.");
            this.root = null;
        } else {
            this.root = new KDNode(points, 0, points.length - 1, maxPointsInLeaves);
        }
    }

    public KDTree(double[][] points, int maxPointsInLeaves) {
        this.hasObjects = false;
        this.objects = null;
        this.maxPointsInLeaves = maxPointsInLeaves;
        this.makeAllPointsNovel(points.length);
        this.root = new KDNode(points, 0, points.length - 1, maxPointsInLeaves);
    }

    public KDTree(String BDITerrainFilePath, int maxPointsInLeaves) {
        this.hasObjects = false;
        this.objects = null;
        this.maxPointsInLeaves = maxPointsInLeaves;
        double[][] points = KDTree.loadPoints3D(BDITerrainFilePath);
        this.makeAllPointsNovel(points.length);
        this.root = new KDNode(points, 0, points.length - 1, maxPointsInLeaves);
    }

    private void makeAllPointsNovel(int numPoints) {
        this.novelPointIndexes = new LinkedHashSet();
        for (int i = 0; i < numPoints; ++i) {
            this.novelPointIndexes.add(i);
        }
    }

    public double[][] getPoints() {
        return this.root.points;
    }

    public void getExtents(double[] min, double[] max) {
        this.root.getExtents(min, max);
    }

    public KDTree prunePointsCopy(double minDistanceBetweenPoints) {
        int numPoints = this.root.points.length;
        this.makeAllPointsNovel(numPoints);
        int numDimensions = this.root.points[0].length;
        LinkedHashSet<Integer> inCover = this.novelPointIndexes;
        ArrayList<Integer> coverIndexes = new ArrayList<Integer>();
        for (int i = 0; i < numPoints; ++i) {
            if (!inCover.contains(i)) continue;
            coverIndexes.add(i);
            ArrayList<Integer> arrayList = this.getClosestNovelPointIndexes(this.root.points[i], minDistanceBetweenPoints, false);
        }
        int numPointsInCover = coverIndexes.size();
        double[][] newPoints = new double[numPointsInCover][numDimensions];
        if (!this.hasObjects) {
            for (int i = 0; i < numPointsInCover; ++i) {
                newPoints[i] = this.root.points[(Integer)coverIndexes.get(i)];
            }
            return new KDTree(newPoints, this.maxPointsInLeaves);
        }
        Object[] newObjects = new Object[numPointsInCover];
        for (int i = 0; i < numPointsInCover; ++i) {
            newPoints[i] = this.root.points[(Integer)coverIndexes.get(i)];
            newObjects[i] = this.objects[(Integer)coverIndexes.get(i)];
        }
        return new KDTree(newPoints, newObjects, this.maxPointsInLeaves);
    }

    public double[] closestPoint(double[] testPoint) {
        return this.root.closestPoint(testPoint);
    }

    public double[] closestPoint(double[] testPoint, double maxDistance) {
        return this.root.closestPoint(testPoint, maxDistance * maxDistance);
    }

    public double[] closestPointBruteForceSearch(double[] testPoint) {
        return this.root.closestPointBruteForceSearch(testPoint);
    }

    public Object closestObject(double[] testPoint) {
        if (!this.hasObjects) {
            System.err.println("KDTree::closestObject(): no objects exist. Returning null.");
            return null;
        }
        int closestIndex = this.root.closestPointIndex(testPoint);
        return this.objects[closestIndex];
    }

    public Object closestObject(double[] testPoint, double maxDistance) {
        if (!this.hasObjects) {
            System.err.println("KDTree::closestObject(): no objects exist. Returning null.");
            return null;
        }
        int closestIndex = this.root.closestPointIndex(testPoint, maxDistance * maxDistance, null, null);
        if (closestIndex == -1) {
            return null;
        }
        return this.objects[closestIndex];
    }

    public ArrayList<Object> closestObjects(double[] testPoint, int numObjects, double maxDistance) {
        int closestIndex;
        if (!this.hasObjects) {
            System.err.println("KDTree::closestObject(): no objects exist. Returning null.");
            return null;
        }
        ArrayList<Integer> excludedIndexes = new ArrayList<Integer>();
        ArrayList<Object> nearestObjects = new ArrayList<Object>();
        for (int i = 0; i < numObjects && (closestIndex = this.root.closestPointIndex(testPoint, maxDistance * maxDistance, excludedIndexes, null)) != -1; ++i) {
            excludedIndexes.add(closestIndex);
            nearestObjects.add(this.objects[closestIndex]);
        }
        return nearestObjects;
    }

    public ArrayList<double[]> closestPoints(double[] testPoint, int numPoints, double maxDistance) {
        int closestIndex;
        ArrayList<Integer> excludedIndexes = new ArrayList<Integer>();
        ArrayList<double[]> nearestPoints = new ArrayList<double[]>();
        for (int i = 0; i < numPoints && (closestIndex = this.root.closestPointIndex(testPoint, maxDistance * maxDistance, excludedIndexes, null)) != -1; ++i) {
            excludedIndexes.add(closestIndex);
            nearestPoints.add(this.root.points[closestIndex]);
        }
        return nearestPoints;
    }

    public Object getClosestNovelObject(double[] testPoint, double maxDistance, boolean preserveAsNovel) {
        int closestNovelIndex = this.getClosestNovelPointIndex(testPoint, maxDistance, preserveAsNovel);
        return this.objects[closestNovelIndex];
    }

    public ArrayList<Object> getClosestNovelObjects(double[] testPoint, double maxDistance, boolean preserveAsNovel) {
        ArrayList<Integer> closestNovelIndexes = this.getClosestNovelPointIndexes(testPoint, maxDistance, preserveAsNovel);
        ArrayList<Object> closestObjects = new ArrayList<Object>();
        for (int index : closestNovelIndexes) {
            closestObjects.add(this.objects[index]);
        }
        return closestObjects;
    }

    private void makeIndexesNovel(ArrayList<Integer> indexes) {
        this.novelPointIndexes.addAll(indexes);
    }

    private ArrayList<Integer> getClosestNovelPointIndexes(double[] testPoint, double maxDistance, boolean preserveAsNovel) {
        ArrayList<Integer> nearestIndexes = new ArrayList<Integer>();
        int closestIndex = this.getClosestNovelPointIndex(testPoint, maxDistance, false);
        while (closestIndex >= 0) {
            nearestIndexes.add(closestIndex);
            closestIndex = this.getClosestNovelPointIndex(testPoint, maxDistance, false);
        }
        if (preserveAsNovel) {
            this.makeIndexesNovel(nearestIndexes);
        }
        return nearestIndexes;
    }

    private int getClosestNovelPointIndex(double[] testPoint, double maxDistance, boolean preserveAsNovel) {
        int closestIndex = this.root.closestPointIndex(testPoint, maxDistance * maxDistance, null, this.novelPointIndexes);
        if (closestIndex >= 0 && !preserveAsNovel) {
            this.novelPointIndexes.remove(closestIndex);
        }
        return closestIndex;
    }

    public static double[][] loadPoints3D(String filename) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(filename));
            System.out.println("Found " + filename);
            double[][] points = KDTree.loadPoints3D(bufferedReader);
            bufferedReader.close();
            return points;
        }
        catch (IOException e) {
            System.out.println("Could not open " + filename);
            return null;
        }
    }

    public static double[][] loadPoints3D(BufferedReader bufferedReader) {
        ArrayList<Point3D> pointArray = new ArrayList<Point3D>();
        try {
            String lineIn;
            do {
                if ((lineIn = bufferedReader.readLine()) == null) continue;
                StringTokenizer s = new StringTokenizer(lineIn, " ");
                double x = Double.parseDouble(s.nextToken());
                double y = Double.parseDouble(s.nextToken());
                double z = Double.parseDouble(s.nextToken());
                if (s.hasMoreTokens()) {
                    System.err.println("KDTree::loadPoints3D(): extra element ");
                }
                pointArray.add(new Point3D(x, y, z));
            } while (lineIn != null);
            double[][] points = new double[pointArray.size()][3];
            for (int i = 0; i < pointArray.size(); ++i) {
                points[i] = new double[]{((Point3D)pointArray.get(i)).getX(), ((Point3D)pointArray.get(i)).getY(), ((Point3D)pointArray.get(i)).getZ()};
            }
            return points;
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        return null;
    }

    public static double distanceSquared(double[] point1, double[] point2) {
        if (point1.length != point2.length) {
            System.err.println("KDTree::Node::distanceSquared(): point dimensions do not match.  Returning NaN.");
            return Double.NaN;
        }
        double distanceSquared = 0.0;
        for (int i = 0; i < point1.length; ++i) {
            distanceSquared += (point1[i] - point2[i]) * (point1[i] - point2[i]);
        }
        return distanceSquared;
    }

    public static void main(String[] args) {
        String fileName = "TerrainFiles/terrainC.asc";
        int maxPointsInLeaves = 10;
        Random random = new Random();
        long treeBuildStart = System.currentTimeMillis();
        KDTree tree = new KDTree(fileName, maxPointsInLeaves);
        long treeBuildEnd = System.currentTimeMillis();
        double[][] points = tree.getPoints();
        System.out.println("It took " + (treeBuildEnd - treeBuildStart) + " millis to build the tree with " + points.length + " points.");
        double[] minExtents = new double[3];
        double[] maxExtents = new double[3];
        tree.getExtents(minExtents, maxExtents);
        Point3D minExtents3d = new Point3D(minExtents);
        Point3D maxExtents3d = new Point3D(maxExtents);
        System.out.println("minExtents = " + minExtents3d);
        System.out.println("maxExtents = " + maxExtents3d);
        System.out.println("Pruning the Tree");
        long treePruneStart = System.currentTimeMillis();
        double NEW_POINT_RESOLUTION = 10.0;
        tree = tree.prunePointsCopy(10.0);
        long treePruneEnd = System.currentTimeMillis();
        points = tree.getPoints();
        System.out.println("It took " + (treePruneEnd - treePruneStart) + " millis to prune the tree to " + points.length + " points.");
        KDTree.testTree(tree, 10);
        int bruteNumTests = 1000;
        long bruteStart = System.currentTimeMillis();
        double[] bestPoint = null;
        for (int i = 0; i < bruteNumTests; ++i) {
            int randomIndex = random.nextInt(points.length - 1);
            double[] testPoint = points[randomIndex];
            double bestDistance = Double.POSITIVE_INFINITY;
            for (int j = 0; j < points.length; ++j) {
                double distance = KDTree.distanceSquared(testPoint, points[j]);
                if (!(distance < bestDistance)) continue;
                bestDistance = distance;
                bestPoint = points[j];
            }
            if (testPoint[0] == bestPoint[0] && testPoint[1] == bestPoint[1] && testPoint[2] == bestPoint[2]) continue;
            System.err.println("Bad news: points did not match.");
        }
        long bruteEnd = System.currentTimeMillis();
        System.out.println("For " + bruteNumTests + " brute force queries, number of millis = " + (bruteEnd - bruteStart));
        System.out.println("Tests done.");
    }

    private static void testTree(KDTree tree, int maxDistancePrints) {
        Random random = new Random();
        double[][] points = tree.getPoints();
        System.out.println("##### NUMBER OF POINTS IN TREE TO TEST: " + points.length);
        long kdStart = System.currentTimeMillis();
        int kdNumTests = 1000;
        double DISTANCE_MOVE = 10.0;
        for (int i = 0; i < kdNumTests; ++i) {
            int randomIndex = random.nextInt(points.length - 1);
            double[] testPoint = new double[]{points[randomIndex][0], points[randomIndex][1], points[randomIndex][2]};
            testPoint[0] = testPoint[0] + Math.random() * DISTANCE_MOVE;
            testPoint[1] = testPoint[1] + Math.random() * DISTANCE_MOVE;
            double[] closestPoint = tree.closestPoint(testPoint);
            double distanceSquared = KDTree.distanceSquared(testPoint, closestPoint);
            if (!(distanceSquared > 2.0 * DISTANCE_MOVE * DISTANCE_MOVE)) continue;
            System.err.println("Bad news: points did not match.");
        }
        long kdEnd = System.currentTimeMillis();
        System.out.println("For " + kdNumTests + " KD queries, number of millis = " + (kdEnd - kdStart));
        kdStart = System.currentTimeMillis();
        kdNumTests = 1000;
        for (int i = 0; i < kdNumTests; ++i) {
            int randomIndex = random.nextInt(points.length - 1);
            double[] testPoint = new double[]{points[randomIndex][0], points[randomIndex][1], points[randomIndex][2]};
            testPoint[0] = testPoint[0] + Math.random() * DISTANCE_MOVE;
            testPoint[1] = testPoint[1] + Math.random() * DISTANCE_MOVE;
            int numPoints = 10;
            for (int j = 0; j < numPoints; ++j) {
            }
        }
        kdEnd = System.currentTimeMillis();
        System.out.println("For " + kdNumTests + " multiple-point queries, number of millis = " + (kdEnd - kdStart));
    }

    public static void testLookupTimingOnGrid(KDTree kdTree, boolean checkWithBruteForce) {
        int numberOfTotalRuns = 0;
        long totalStartTime = System.currentTimeMillis();
        for (double z = 0.0; z < 100.0; z += 10.0) {
            long startTime = System.currentTimeMillis();
            int numberOfRuns = 0;
            for (double x = 0.0; x < 600.0; x += 60.0) {
                for (double y = 0.0; y < 600.0; y += 60.0) {
                    double[] closestBruteForce;
                    ++numberOfRuns;
                    ++numberOfTotalRuns;
                    double[] queryPoint = new double[]{x, y, z};
                    double[] closestPoint = kdTree.closestPoint(queryPoint);
                    if (!checkWithBruteForce || (closestBruteForce = kdTree.closestPointBruteForceSearch(queryPoint)) == closestPoint) continue;
                    System.err.println("Doesn't match brute force!!!");
                    throw new RuntimeException("Doesn't match brute force!!!");
                }
            }
            long endTime = System.currentTimeMillis();
            double totalTime = endTime - startTime;
            double averageTime = totalTime / (double)numberOfRuns;
            System.out.println("Ran " + numberOfRuns + " lookups in " + totalTime + " ms");
            System.out.println("z = " + z + " Average time = " + averageTime);
        }
        long endTime = System.currentTimeMillis();
        double totalTime = endTime - totalStartTime;
        double averageTime = totalTime / (double)numberOfTotalRuns;
        System.out.println("Ran " + numberOfTotalRuns + " lookups in " + totalTime + " ms");
        System.out.println(" Average time = " + averageTime);
    }

    public static void testLookupSamePointOnGrid(KDTree kdTree) {
        long startTime = System.currentTimeMillis();
        System.out.println("Starting testLookupSamePointOnGrid");
        double[][] points = kdTree.getPoints();
        for (int i = 0; i < points.length; ++i) {
            double[] closestPoint2;
            double[] closestPoint = kdTree.closestPoint(points[i]);
            if (points[i] != closestPoint) {
                Point3D point = new Point3D(points[i]);
                Point3D closest = new Point3D(closestPoint);
                System.out.println("point " + i + " = " + point + " did not match closestPoint = " + closest);
            }
            if ((closestPoint2 = kdTree.closestPoint(points[i])) == closestPoint) continue;
            System.out.println("closestPoint2 = " + closestPoint2 + " did not match closestPoint = " + closestPoint);
            throw new RuntimeException("things are not working");
        }
        System.out.println("Finished testLookupSamePointOnGrid for " + points.length);
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) * 0.001;
        System.out.println("Took " + totalTime + " seconds for " + points.length + " points.");
        double averageTime = totalTime / (double)points.length;
        System.out.println("Average Time per query was " + averageTime * 1000.0 + " miliseconds.\n");
    }

    public static void testLookupSamePointPlusDeltaOnGrid(KDTree kdTree, double maxDelta, int skipPoints, double maxDistance) {
        long startTime = System.currentTimeMillis();
        System.out.println("Starting testLookupSamePointPlusDeltaOnGrid. maxDelta = " + maxDelta);
        double[][] points = kdTree.getPoints();
        int pointsConsidered = 0;
        int i = 0;
        while (i < points.length) {
            double[] point = points[i];
            double[] adjustedPoint = new double[point.length];
            for (int j = 0; j < point.length; ++j) {
                double delta = maxDelta * (2.0 * Math.random() - 1.0);
                adjustedPoint[j] = point[j] + delta;
            }
            double[] closestPoint = kdTree.closestPoint(adjustedPoint);
            if (points[i] != closestPoint && closestPoint != null) {
                Point3D adjusted = new Point3D(adjustedPoint);
                Point3D initial = new Point3D(points[i]);
                Point3D closest = new Point3D(closestPoint);
                if (adjusted.distance((Point3DReadOnly)initial) <= adjusted.distance((Point3DReadOnly)closest)) {
                    System.out.println("point " + i + " = " + initial + " did not match adjustedPoint = " + adjusted + " instead it matched " + closest);
                }
            }
            i += skipPoints;
            ++pointsConsidered;
        }
        System.out.println("Finished testLookupSamePointPlusDeltaOnGrid for " + pointsConsidered);
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) * 0.001;
        System.out.println("Took " + totalTime + " seconds for " + pointsConsidered + " points.");
        double averageTime = totalTime / (double)pointsConsidered;
        System.out.println("Average Time per query was " + averageTime * 1000.0 + " miliseconds.\n");
    }

    private class KDNode {
        private final double[][] points;
        private final int startIndex;
        private final int endIndex;
        private double splitValue;
        private int splitDimension;
        private KDNode leftChild;
        private KDNode rightChild;
        private boolean isLeaf;
        private double[] minExtents;
        private double[] maxExtents;

        public KDNode(double[][] points, int startIndex, int endIndex, int maxPointsInLeaves) {
            this.points = points;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.splitDimension = -1;
            this.splitValue = Double.NaN;
            this.leftChild = null;
            this.rightChild = null;
            int dimensions = points[0].length;
            this.minExtents = new double[dimensions];
            this.maxExtents = new double[dimensions];
            if (endIndex - startIndex + 1 > maxPointsInLeaves) {
                this.isLeaf = false;
                this.split(maxPointsInLeaves);
            } else {
                this.isLeaf = true;
                for (int i = 0; i < dimensions; ++i) {
                    this.minExtents[i] = Double.POSITIVE_INFINITY;
                    this.maxExtents[i] = Double.NEGATIVE_INFINITY;
                    for (int index = startIndex; index <= endIndex; ++index) {
                        double[] point = points[index];
                        if (point[i] > this.maxExtents[i]) {
                            this.maxExtents[i] = point[i];
                        }
                        if (!(point[i] < this.minExtents[i])) continue;
                        this.minExtents[i] = point[i];
                    }
                }
            }
        }

        public void getExtents(double[] minExtent, double[] maxExtent) {
            for (int i = 0; i < this.minExtents.length; ++i) {
                minExtent[i] = this.minExtents[i];
                maxExtent[i] = this.maxExtents[i];
            }
        }

        private double[] getMinExtents() {
            return this.minExtents;
        }

        private double[] getMaxExtents() {
            return this.maxExtents;
        }

        private void split(int maxPointsInLeaves) {
            this.setSplitParameters();
            int leftMarker = this.startIndex - 1;
            int rightMarker = this.endIndex + 1;
            while (leftMarker < rightMarker) {
                while (this.points[++leftMarker][this.splitDimension] < this.splitValue) {
                }
                while (this.points[--rightMarker][this.splitDimension] > this.splitValue) {
                }
                if (leftMarker >= rightMarker) continue;
                double[] temp = this.points[leftMarker];
                this.points[leftMarker] = this.points[rightMarker];
                this.points[rightMarker] = temp;
                if (!KDTree.this.hasObjects) continue;
                Object tempObject = KDTree.this.objects[leftMarker];
                KDTree.this.objects[leftMarker] = KDTree.this.objects[rightMarker];
                KDTree.this.objects[rightMarker] = tempObject;
            }
            if (leftMarker > this.endIndex || rightMarker < this.startIndex) {
                throw new RuntimeException("Must test for which marker is valid and use that!");
            }
            this.leftChild = new KDNode(this.points, this.startIndex, leftMarker - 1, maxPointsInLeaves);
            this.rightChild = new KDNode(this.points, leftMarker, this.endIndex, maxPointsInLeaves);
            double[] minExtentsLeft = this.leftChild.getMinExtents();
            double[] maxExtentsLeft = this.leftChild.getMaxExtents();
            double[] minExtentsRight = this.rightChild.getMinExtents();
            double[] maxExtentsRight = this.rightChild.getMaxExtents();
            for (int i = 0; i < minExtentsLeft.length; ++i) {
                this.minExtents[i] = Math.min(minExtentsLeft[i], minExtentsRight[i]);
                this.maxExtents[i] = Math.max(maxExtentsLeft[i], maxExtentsRight[i]);
            }
        }

        private void setSplitParameters() {
            int pointDimensionality = this.points[0].length;
            double widestWidth = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < pointDimensionality; ++i) {
                double minValue;
                double maxValue = minValue = this.points[this.startIndex][i];
                for (int j = this.startIndex + 1; j < this.endIndex; ++j) {
                    if (this.points[j][i] < minValue) {
                        minValue = this.points[j][i];
                        continue;
                    }
                    if (!(this.points[j][i] > maxValue)) continue;
                    maxValue = this.points[j][i];
                }
                if (!(widestWidth < maxValue - minValue)) continue;
                widestWidth = maxValue - minValue;
                this.splitDimension = i;
                this.splitValue = minValue + widestWidth / 2.0;
            }
        }

        private double[] closestPoint(double[] testPoint) {
            return this.points[this.closestPointIndex(testPoint)];
        }

        private double[] closestPoint(double[] testPoint, double maxDistance) {
            int closestIndex = this.closestPointIndex(testPoint, maxDistance, null, null);
            if (closestIndex == -1) {
                return null;
            }
            return this.points[this.closestPointIndex(testPoint)];
        }

        private double[] closestPointBruteForceSearch(double[] testPoint) {
            double[] closestPoint = null;
            double closestDistanceSquared = Double.POSITIVE_INFINITY;
            for (double[] point : this.points) {
                double distanceSquared = KDTree.distanceSquared(testPoint, point);
                if (!(distanceSquared < closestDistanceSquared)) continue;
                closestDistanceSquared = distanceSquared;
                closestPoint = point;
            }
            return closestPoint;
        }

        private int closestPointIndex(double[] testPoint) {
            return this.closestPointIndex(testPoint, Double.POSITIVE_INFINITY, null, null);
        }

        private int closestPointIndex(double[] testPoint, double maxDistanceSquared, ArrayList<Integer> excludedIndexes, HashSet<Integer> subsetIndexes) {
            int closestIndex = -1;
            if (this.isLeaf) {
                double bestDistanceSquared = Double.POSITIVE_INFINITY;
                for (int i = this.startIndex; i <= this.endIndex; ++i) {
                    double distanceSquared;
                    if (subsetIndexes != null && !subsetIndexes.contains(i) || excludedIndexes != null && excludedIndexes.contains(i) || !((distanceSquared = KDTree.distanceSquared(testPoint, this.points[i])) < bestDistanceSquared) || !(distanceSquared <= maxDistanceSquared)) continue;
                    bestDistanceSquared = distanceSquared;
                    closestIndex = i;
                }
            } else {
                KDNode secondNode;
                KDNode firstNode;
                if (testPoint[this.splitDimension] < this.splitValue) {
                    firstNode = this.leftChild;
                    secondNode = this.rightChild;
                } else {
                    firstNode = this.rightChild;
                    secondNode = this.leftChild;
                }
                closestIndex = firstNode.closestPointIndex(testPoint, maxDistanceSquared, excludedIndexes, subsetIndexes);
                double firstDistanceSquared = closestIndex != -1 ? KDTree.distanceSquared(testPoint, this.points[closestIndex]) : Double.POSITIVE_INFINITY;
                double distanceToSplitSquared = (this.splitValue - testPoint[this.splitDimension]) * (this.splitValue - testPoint[this.splitDimension]);
                if (distanceToSplitSquared < firstDistanceSquared && distanceToSplitSquared < maxDistanceSquared) {
                    int otherClosestIndex;
                    double otherDistanceSquared;
                    double[] otherMinExtents = secondNode.getMinExtents();
                    double[] otherMaxExtents = secondNode.getMaxExtents();
                    int dimensions = otherMinExtents.length;
                    double distanceToNearestExtentSquared = 0.0;
                    for (int index = 0; index < dimensions; ++index) {
                        if (testPoint[index] <= otherMinExtents[index]) {
                            distanceToNearestExtentSquared += (testPoint[index] - otherMinExtents[index]) * (testPoint[index] - otherMinExtents[index]);
                            continue;
                        }
                        if (!(testPoint[index] >= otherMaxExtents[index])) continue;
                        distanceToNearestExtentSquared += (testPoint[index] - otherMaxExtents[index]) * (testPoint[index] - otherMaxExtents[index]);
                    }
                    if (distanceToNearestExtentSquared < firstDistanceSquared && distanceToNearestExtentSquared < maxDistanceSquared && (otherDistanceSquared = (otherClosestIndex = secondNode.closestPointIndex(testPoint, maxDistanceSquared, excludedIndexes, subsetIndexes)) != -1 ? KDTree.distanceSquared(testPoint, this.points[otherClosestIndex]) : Double.POSITIVE_INFINITY) < firstDistanceSquared) {
                        closestIndex = otherClosestIndex;
                    }
                }
            }
            return closestIndex;
        }
    }
}

