/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfigurationList;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraMountList;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraPropertiesHolder;
import us.ihmc.jMonkeyEngineToolkit.camera.CaptureDevice;
import us.ihmc.jMonkeyEngineToolkit.camera.TrackingDollyCameraController;
import us.ihmc.jMonkeyEngineToolkit.camera.ViewportAdapter;
import us.ihmc.simulationconstructionset.GotoInPointCommandExecutor;
import us.ihmc.simulationconstructionset.GotoOutPointCommandExecutor;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.TimeHolder;
import us.ihmc.simulationconstructionset.ViewportConfiguration;
import us.ihmc.simulationconstructionset.commands.AllCommandsExecutor;
import us.ihmc.simulationconstructionset.commands.ExportSnapshotCommandExecutor;
import us.ihmc.simulationconstructionset.commands.RunCommandsExecutor;
import us.ihmc.simulationconstructionset.commands.ViewportSelectorCommandExecutor;
import us.ihmc.simulationconstructionset.commands.ViewportSelectorCommandListener;
import us.ihmc.simulationconstructionset.gui.ActiveCanvas3DHolder;
import us.ihmc.simulationconstructionset.gui.GraphArrayPanel;
import us.ihmc.simulationconstructionset.gui.StandardGUIActions;
import us.ihmc.simulationconstructionset.gui.StandardSimulationGUI;
import us.ihmc.simulationconstructionset.gui.ViewportAdapterAndCameraControllerHolder;
import us.ihmc.simulationconstructionset.gui.ViewportPanel;
import us.ihmc.simulationconstructionset.gui.config.ExtraPanelSelector;
import us.ihmc.simulationconstructionset.gui.config.VarGroupList;
import us.ihmc.simulationconstructionset.gui.config.ViewportConfigurationList;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.AboutDialogGenerator;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.AllDialogConstructorsHolder;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.CameraPropertiesDialogGenerator;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ExportSnapshotDialogGenerator;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.GUIEnablerAndDisabler;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.MediaCaptureDialogGenerator;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ResizeViewportDialogGenerator;
import us.ihmc.simulationconstructionset.synchronization.SimulationSynchronizer;
import us.ihmc.simulationconstructionset.videos.ExportVideo;
import us.ihmc.yoVariables.buffer.YoBuffer;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.registry.YoVariableList;

public class ViewportWindow
implements ViewportSelectorCommandExecutor,
ActiveCanvas3DHolder,
ExtraPanelSelector {
    private JFrame frame;
    private Container contentPane;
    private JPanel viewportJPanel;
    private ViewportSelectorCommandListener viewportSelectorCommandListener;
    private JSplitPane jsplitpane;
    private StandardGUIActions windowGUIActions;
    private StandardSimulationGUI myGUI;
    private ViewportConfigurationList viewportConfigurationList;
    private ViewportPanel viewportPanel;
    private JPanel buttonPanel;
    private ArrayList<Component> tempPanelsHolder = new ArrayList();
    private boolean isViewportHidden = false;
    private final String name;

    public ViewportWindow(AllCommandsExecutor allCommandsExecutor, YoVariableHolder yoVariableHolder, TimeHolder timeHolder, String selectedViewportName, ViewportConfigurationList viewportConfigurationList, CameraConfigurationList cameraConfigurationList, CameraMountList cameraMountList, Robot[] robots, VarGroupList varGroupList, GraphArrayPanel myGraphArrayPanel, StandardSimulationGUI myGUI, Graphics3DAdapter graphics3DAdapter, YoBuffer dataBuffer, StandardGUIActions mainGUIActions, int screenID, boolean maximizeWindow, SimulationSynchronizer simulationSynchronizer) {
        this.viewportConfigurationList = viewportConfigurationList;
        this.myGUI = myGUI;
        this.windowGUIActions = mainGUIActions;
        this.name = selectedViewportName != null ? selectedViewportName : "Unnamed";
        GraphicsConfiguration configurationToUse = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = graphicsEnvironment.getScreenDevices();
        for (int j = 0; j < devices.length; ++j) {
            if (devices[j].toString().indexOf("screen=" + screenID) < 0) continue;
            configurationToUse = devices[j].getDefaultConfiguration();
        }
        this.frame = new JFrame("Viewport Window", configurationToUse);
        this.frame.setName("Viewport Window");
        this.contentPane = this.frame.getContentPane();
        this.windowGUIActions = new StandardGUIActions();
        this.viewportPanel = new ViewportPanel(yoVariableHolder, allCommandsExecutor, this.windowGUIActions, cameraConfigurationList, cameraMountList, graphics3DAdapter);
        ViewportConfiguration viewportConfig = viewportConfigurationList.getViewportConfiguration(selectedViewportName);
        this.viewportPanel.setupViews(this.frame.getGraphicsConfiguration().getDevice(), viewportConfig);
        AllCommandsExecutor guiEnablerAndDisabler = allCommandsExecutor;
        AllCommandsExecutor runCommandsExecutor = allCommandsExecutor;
        AllCommandsExecutor gotoInPointCommandExecutor = allCommandsExecutor;
        AllCommandsExecutor gotoOutPointCommandExecutor = allCommandsExecutor;
        AllCommandsExecutor dataBufferCommandsExecutor = allCommandsExecutor;
        final ViewportWindow activeCanvas3DHolder = this;
        StandardSimulationGUI viewportSelector = myGUI;
        ExportSnapshotCommandExecutor exportSnapshotCommandExecutor = new ExportSnapshotCommandExecutor(){

            @Override
            public void exportSnapshot(File snapshotFile) {
                CaptureDevice canvas3D = activeCanvas3DHolder.getActiveCaptureDevice();
                canvas3D.exportSnapshot(snapshotFile);
            }
        };
        ExportSnapshotDialogGenerator exportSnapshotDialogConstructor = new ExportSnapshotDialogGenerator(exportSnapshotCommandExecutor, guiEnablerAndDisabler, robots, activeCanvas3DHolder, this.frame);
        ExportVideo exportVideoCommandExecutor = new ExportVideo(timeHolder, myGUI, dataBufferCommandsExecutor, gotoInPointCommandExecutor, gotoOutPointCommandExecutor, runCommandsExecutor, guiEnablerAndDisabler, activeCanvas3DHolder, simulationSynchronizer);
        AllCommandsExecutor stopCommandExecutor = allCommandsExecutor;
        MediaCaptureDialogGenerator mediaCaptureDialogConstructor = new MediaCaptureDialogGenerator(exportVideoCommandExecutor, guiEnablerAndDisabler, stopCommandExecutor, viewportSelector, myGUI, mainGUIActions, activeCanvas3DHolder);
        CameraPropertiesDialogGenerator cameraPropertiesDialogGenerator = new CameraPropertiesDialogGenerator(this.viewportPanel, this.frame, this.frame);
        ResizeViewportDialogGenerator resizeViewportDialogConstructor = new ResizeViewportDialogGenerator(this.frame, myGUI);
        this.windowGUIActions.createViewportWindowActions(mainGUIActions, exportSnapshotDialogConstructor, mediaCaptureDialogConstructor, cameraPropertiesDialogGenerator, resizeViewportDialogConstructor, this.viewportPanel, this);
        this.buttonPanel = this.windowGUIActions.createViewportWindowButtons();
        JMenuBar menuBar = this.windowGUIActions.createViewportWindowMenus();
        this.windowGUIActions.extraPanelsMenu = new JMenu("Extra Panels");
        this.windowGUIActions.setupExtraPanelsMenu(myGUI.getExtraPanelConfigurationList(), this);
        this.contentPane.setLayout(new BorderLayout());
        this.viewportJPanel = new JPanel(new BorderLayout());
        this.viewportJPanel.add(this.viewportPanel);
        this.contentPane.add(this.viewportJPanel);
        this.frame.setJMenuBar(menuBar);
        this.contentPane.add("South", this.buttonPanel);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setSize(screenSize.width * 7 / 8, screenSize.height * 7 / 8);
        this.frame.validate();
        if (maximizeWindow) {
            this.frame.setExtendedState(6);
        }
        this.frame.setVisible(true);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                for (Component panel : ViewportWindow.this.tempPanelsHolder) {
                    ViewportWindow.this.makeCheckMarksConsistentForExtraPanels(panel.getName(), false);
                }
            }
        });
        myGUI.makeCheckMarksConsistentWithMainPanel(this);
    }

    public ViewportWindow(AllCommandsExecutor allCommandsExecutor, AllDialogConstructorsHolder allDialogConstructorsHolder, SimulationConstructionSet sim, Robot[] robots, TimeHolder timeHolder, YoVariableHolder yoVariableHolder, RunCommandsExecutor runCommandsExecutor, GotoInPointCommandExecutor gotoInPointCommandExecutor, GotoOutPointCommandExecutor gotoOutPointCommandExecutor, GUIEnablerAndDisabler guiEnablerAndDisabler, String selectedViewportName, ViewportConfigurationList viewportConfigurationList, CameraConfigurationList cameraConfigurationList, YoVariableList varList, CameraMountList cameraMountList, VarGroupList varGroupList, GraphArrayPanel myGraphArrayPanel, AboutDialogGenerator aboutEditorPane, StandardSimulationGUI myGUI, Graphics3DAdapter graphicsAdapter, YoBuffer dataBuffer, StandardGUIActions mainGUIActions, int screenID, boolean maximizeWindow, SimulationSynchronizer simulationSynchronizer) {
        this.viewportConfigurationList = viewportConfigurationList;
        this.myGUI = myGUI;
        this.windowGUIActions = mainGUIActions;
        this.name = selectedViewportName != null ? selectedViewportName : "Unnamed";
        this.frame = new JFrame("Viewport Window");
        this.frame.setName("Viewport Window");
        this.contentPane = this.frame.getContentPane();
        this.windowGUIActions = new StandardGUIActions();
        this.viewportPanel = new ViewportPanel(yoVariableHolder, runCommandsExecutor, this.windowGUIActions, cameraConfigurationList, cameraMountList, graphicsAdapter);
        ViewportConfiguration viewportConfig = viewportConfigurationList.getViewportConfiguration(selectedViewportName);
        this.viewportPanel.setupViews(this.frame.getGraphicsConfiguration().getDevice(), viewportConfig);
        AllCommandsExecutor dataBufferCommandsExecutor = allCommandsExecutor;
        final ViewportWindow activeCanvas3DHolder = this;
        StandardSimulationGUI viewportSelector = myGUI;
        ExportSnapshotCommandExecutor exportSnapshotCommandExecutor = new ExportSnapshotCommandExecutor(){

            @Override
            public void exportSnapshot(File snapshotFile) {
                CaptureDevice capturableCanvas = activeCanvas3DHolder.getActiveCaptureDevice();
                capturableCanvas.exportSnapshot(snapshotFile);
            }
        };
        ExportSnapshotDialogGenerator exportSnapshotDialogConstructor = new ExportSnapshotDialogGenerator(exportSnapshotCommandExecutor, guiEnablerAndDisabler, robots, activeCanvas3DHolder, this.frame);
        ExportVideo exportVideoCommandExecutor = new ExportVideo(timeHolder, myGUI, dataBufferCommandsExecutor, gotoInPointCommandExecutor, gotoOutPointCommandExecutor, runCommandsExecutor, guiEnablerAndDisabler, activeCanvas3DHolder, simulationSynchronizer);
        SimulationConstructionSet stopCommandExecutor = sim;
        MediaCaptureDialogGenerator mediaCaptureDialogConstructor = new MediaCaptureDialogGenerator(exportVideoCommandExecutor, guiEnablerAndDisabler, stopCommandExecutor, viewportSelector, myGUI, mainGUIActions, activeCanvas3DHolder);
        CameraPropertiesDialogGenerator cameraPropertiesDialogGenerator = new CameraPropertiesDialogGenerator(this.viewportPanel, this.frame, this.frame);
        ResizeViewportDialogGenerator resizeViewportDialogConstructor = new ResizeViewportDialogGenerator(this.frame, myGUI);
        this.windowGUIActions.createViewportWindowActions(mainGUIActions, exportSnapshotDialogConstructor, mediaCaptureDialogConstructor, cameraPropertiesDialogGenerator, resizeViewportDialogConstructor, this.viewportPanel, this);
        this.buttonPanel = this.windowGUIActions.createViewportWindowButtons();
        JMenuBar menuBar = this.windowGUIActions.createViewportWindowMenus();
        this.windowGUIActions.extraPanelsMenu = new JMenu("Extra Panels");
        this.windowGUIActions.setupExtraPanelsMenu(myGUI.getExtraPanelConfigurationList(), this);
        this.contentPane.setLayout(new BorderLayout());
        this.viewportJPanel = new JPanel(new BorderLayout());
        this.viewportJPanel.add(this.viewportPanel);
        this.contentPane.add(this.viewportJPanel);
        this.frame.setJMenuBar(menuBar);
        this.contentPane.add("South", this.buttonPanel);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setSize(screenSize.width * 7 / 8, screenSize.height * 7 / 8);
        this.frame.validate();
        if (maximizeWindow) {
            this.frame.setExtendedState(6);
        }
        this.frame.setVisible(true);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                for (Component panel : ViewportWindow.this.tempPanelsHolder) {
                    ViewportWindow.this.makeCheckMarksConsistentForExtraPanels(panel.getName(), false);
                }
            }
        });
        myGUI.makeCheckMarksConsistentWithMainPanel(this);
    }

    public String getName() {
        return this.name;
    }

    public void makeExtraPanelsMenuConsistent(String panelName, boolean isSelected) {
        for (int i = 0; i < this.windowGUIActions.extraPanelsMenu.getItemCount(); ++i) {
            if (!panelName.equals(this.windowGUIActions.extraPanelsMenu.getItem(i).getText())) continue;
            this.windowGUIActions.extraPanelsMenu.getItem(i).setSelected(isSelected);
        }
    }

    public boolean isSelectedPanel(String panelName) {
        boolean isSelected = false;
        for (int i = 0; i < this.windowGUIActions.extraPanelsMenu.getItemCount(); ++i) {
            if (!panelName.equals(this.windowGUIActions.extraPanelsMenu.getItem(i).getText()) || !this.windowGUIActions.extraPanelsMenu.getItem(i).isSelected()) continue;
            isSelected = true;
        }
        return isSelected;
    }

    public void removeExtraPanel(String panelName) {
        this.tempPanelsHolder.remove(this.myGUI.getExtraPanel(panelName));
        this.drawViewportWithExtraPanels();
    }

    public String savingExtraPanels() {
        Object textToWrite = "";
        for (Component name : this.tempPanelsHolder) {
            textToWrite = (String)textToWrite + name.getName() + ",";
        }
        return textToWrite;
    }

    public void addPanelToTempHolder(Component extraPanel) {
        this.tempPanelsHolder.add(extraPanel);
        this.drawViewportWithExtraPanels();
    }

    private void drawViewportWithExtraPanels() {
        if (this.viewportJPanel != null) {
            this.viewportJPanel.removeAll();
        }
        if (this.jsplitpane != null) {
            this.jsplitpane.removeAll();
        }
        if (this.tempPanelsHolder.size() == 0) {
            this.viewportJPanel.add(this.viewportPanel);
        } else {
            ArrayList<JSplitPane> dividers = new ArrayList<JSplitPane>();
            this.jsplitpane = new JSplitPane(1, this.viewportPanel, this.tempPanelsHolder.get(0));
            dividers.add(this.jsplitpane);
            for (int i = 1; i < this.tempPanelsHolder.size(); ++i) {
                this.jsplitpane = new JSplitPane(1, this.jsplitpane, this.tempPanelsHolder.get(i));
                dividers.add(this.jsplitpane);
            }
            int currentPlaceOfLastDivider = 0;
            for (int j = 0; j < dividers.size(); ++j) {
                ((JSplitPane)dividers.get(j)).setDividerLocation(currentPlaceOfLastDivider + this.viewportJPanel.getWidth() / (dividers.size() + 1));
                currentPlaceOfLastDivider += this.viewportJPanel.getWidth() / (dividers.size() + 1);
            }
            this.viewportJPanel.add(this.jsplitpane);
        }
        int width = this.frame.getWidth() + 1;
        int height = this.frame.getHeight() + 1;
        Dimension d = new Dimension(width, height);
        this.frame.setSize(d);
        this.viewportPanel.repaint();
        this.viewportJPanel.updateUI();
    }

    public void makeCheckMarksConsistentForExtraPanels(String panelName, boolean isSelected) {
        this.myGUI.makeCheckMarksConsistentForExtraPanels(panelName, isSelected);
    }

    @Override
    public void selectPanel(String panelName) {
        if (this.isSelectedPanel(panelName)) {
            this.makeCheckMarksConsistentForExtraPanels(panelName, true);
            this.tempPanelsHolder.add(this.myGUI.getExtraPanel(panelName));
            this.drawViewportWithExtraPanels();
        } else {
            boolean wasInThisWindow = true;
            if (!this.tempPanelsHolder.contains(this.myGUI.getExtraPanel(panelName))) {
                wasInThisWindow = false;
            }
            this.makeCheckMarksConsistentForExtraPanels(panelName, false);
            this.myGUI.removeExtraPanel(panelName);
            if (!wasInThisWindow) {
                this.tempPanelsHolder.add(this.myGUI.getExtraPanel(panelName));
                this.drawViewportWithExtraPanels();
            }
        }
    }

    public ViewportPanel getViewportPanel() {
        return this.viewportPanel;
    }

    public CameraPropertiesHolder getActiveCamera() {
        return this.viewportPanel.getCameraPropertiesForActiveCamera();
    }

    public ViewportAdapter getActiveView() {
        return this.viewportPanel.getActiveView();
    }

    public ArrayList<ViewportAdapterAndCameraControllerHolder> getCameraAdapters() {
        return this.viewportPanel.getCameraAdapters();
    }

    @Override
    public TrackingDollyCameraController getCamera() {
        return this.viewportPanel.getCamera();
    }

    @Override
    public CaptureDevice getActiveCaptureDevice() {
        return this.getActiveView().getCaptureDevice();
    }

    public StandardGUIActions getGUIActions() {
        return this.windowGUIActions;
    }

    public boolean isVisable() {
        return this.frame.isVisible();
    }

    @Override
    public void selectViewport(String viewportName) {
        ViewportConfiguration viewportConfiguration = this.viewportConfigurationList.getViewportConfiguration(viewportName);
        if (viewportConfiguration == null) {
            return;
        }
        this.viewportPanel.setupViews(this.frame.getGraphicsConfiguration().getDevice(), viewportConfiguration);
        this.viewportPanel.updateUI();
        this.makeCheckBoxesConsistentWithCamera();
    }

    public void makeCheckBoxesConsistentWithCamera() {
        this.windowGUIActions.makeCheckBoxesConsistentWithCamera();
    }

    @Override
    public void showViewport() {
        this.isViewportHidden = false;
        this.contentPane.removeAll();
        this.contentPane.add(this.viewportPanel);
        this.contentPane.add("South", this.buttonPanel);
        this.viewportSelectorCommandListener.updateViewportStatus();
        this.viewportPanel.updateUI();
    }

    @Override
    public void hideViewport() {
        this.isViewportHidden = true;
        this.contentPane.removeAll();
        this.contentPane.add("South", this.buttonPanel);
        this.viewportSelectorCommandListener.updateViewportStatus();
        this.viewportPanel.updateUI();
    }

    public void closeWindow() {
        this.frame.setVisible(false);
    }

    @Override
    public boolean isViewportHidden() {
        return this.isViewportHidden;
    }

    @Override
    public void registerViewportSelectorCommandListener(ViewportSelectorCommandListener viewportSelectorCommandListener) {
        this.viewportSelectorCommandListener = viewportSelectorCommandListener;
    }

    public String getMainViewPortPanelXML(boolean visible_ViewPort) {
        return this.viewportPanel.getXMLStyleRepresentationOfMainViewPort(visible_ViewPort);
    }

    public String getXMLStyleRepresentationOfClass(ViewportAdapterAndCameraControllerHolder view3d, int canvasNumber) {
        return this.viewportPanel.getXMLStyleRepresentationOfClassViewPorts(view3d, canvasNumber);
    }

    @Override
    public void closeAndDispose() {
        this.viewportPanel.closeAndDispose();
        if (this.windowGUIActions != null) {
            this.windowGUIActions.closeAndDispose();
            this.windowGUIActions = null;
        }
        this.frame.setMenuBar(null);
        this.frame.removeAll();
        this.frame.dispose();
        this.windowGUIActions = null;
    }
}

