/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.config;

import java.util.ArrayList;
import us.ihmc.simulationconstructionset.gui.config.EntryBoxGroup;

public class EntryBoxGroupList {
    private final ArrayList<EntryBoxGroup> groups = new ArrayList();

    public void addEntryBoxGroup(EntryBoxGroup group) {
        this.groups.add(group);
    }

    public void removeEntryBoxGroup(EntryBoxGroup group) {
        this.groups.remove(group);
    }

    public String[] getEntryBoxGroupNames() {
        int n = this.groups.size();
        String[] ret = new String[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = this.groups.get(i).getName();
        }
        return ret;
    }

    public EntryBoxGroup getEntryBoxGroup(String name) {
        int n = this.groups.size();
        for (int i = 0; i < n; ++i) {
            EntryBoxGroup group = this.groups.get(i);
            if (!group.getName().equals(name)) continue;
            return group;
        }
        return null;
    }

    public String getNextGroupName(String currentGroupName) {
        for (int i = 0; i < this.groups.size(); ++i) {
            EntryBoxGroup entryBoxGroup = this.groups.get(i);
            if (!currentGroupName.equals(entryBoxGroup.getName())) continue;
            int index = (i + 1) % this.groups.size();
            return this.groups.get(index).getName();
        }
        if (this.groups.isEmpty()) {
            return "";
        }
        return this.groups.get(0).getName();
    }

    public String getPreviousGroupName(String currentGroupName) {
        for (int i = 0; i < this.groups.size(); ++i) {
            EntryBoxGroup entryBoxGroup = this.groups.get(i);
            if (!currentGroupName.equals(entryBoxGroup.getName())) continue;
            int index = (i - 1 + this.groups.size()) % this.groups.size();
            return this.groups.get(index).getName();
        }
        if (this.groups.isEmpty()) {
            return "";
        }
        return this.groups.get(0).getName();
    }
}

