/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.simulationconstructionset.util.ground.GroundProfileFromHeightMap;

public class BumpyGroundProfile
extends GroundProfileFromHeightMap {
    private static final double xMinDefault = -10.0;
    private static final double xMaxDefault = 10.0;
    private static final double yMinDefault = -10.0;
    private static final double yMaxDefault = 10.0;
    private static final double xAmp1Default = 0.2;
    private static final double xFreq1Default = 0.1;
    private static final double xAmp2Default = 0.1;
    private static final double xFreq2Default = 0.5;
    private static final double yAmp1Default = 0.1;
    private static final double yFreq1Default = 0.07;
    private static final double yAmp2Default = 0.05;
    private static final double yFreq2Default = 0.37;
    private final BoundingBox3D boundingBox;
    private final double xAmp1;
    private final double xFreq1;
    private final double xAmp2;
    private final double xFreq2;
    private final double yAmp1;
    private final double yFreq1;
    private final double yAmp2;
    private final double yFreq2;
    private final double flatgroundBoxWidthAtZero;

    public BumpyGroundProfile() {
        this(0.2, 0.1, 0.1, 0.5, 0.1, 0.07, 0.05, 0.37);
    }

    public BumpyGroundProfile(double xAmp1, double xFreq1, double xAmp2, double xFreq2, double yAmp1, double yFreq1, double yAmp2, double yFreq2, double flatgroundBoxWidthAtZero) {
        this(xAmp1, xFreq1, xAmp2, xFreq2, yAmp1, yFreq1, yAmp2, yFreq2, -10.0, 10.0, -10.0, 10.0, flatgroundBoxWidthAtZero);
    }

    public BumpyGroundProfile(double xAmp1, double xFreq1, double xAmp2, double xFreq2, double yAmp1, double yFreq1, double yAmp2, double yFreq2) {
        this(xAmp1, xFreq1, xAmp2, xFreq2, yAmp1, yFreq1, yAmp2, yFreq2, -10.0, 10.0, -10.0, 10.0);
    }

    public BumpyGroundProfile(double xAmp1, double xFreq1, double xAmp2, double xFreq2, double yAmp1, double yFreq1, double yAmp2, double yFreq2, double xMin, double xMax, double yMin, double yMax) {
        this(xAmp1, xFreq1, xAmp2, xFreq2, yAmp1, yFreq1, yAmp2, yFreq2, xMin, xMax, yMin, yMax, 0.0);
    }

    public BumpyGroundProfile(double xAmp1, double xFreq1, double xAmp2, double xFreq2, double yAmp1, double yFreq1, double yAmp2, double yFreq2, double xMin, double xMax, double yMin, double yMax, double flatgroundBoxWidthAtZero) {
        this.xAmp1 = xAmp1;
        this.xFreq1 = xFreq1;
        this.xAmp2 = xAmp2;
        this.xFreq2 = xFreq2;
        this.yAmp1 = yAmp1;
        this.yFreq1 = yFreq1;
        this.yAmp2 = yAmp2;
        this.yFreq2 = yFreq2;
        this.flatgroundBoxWidthAtZero = flatgroundBoxWidthAtZero;
        double zMax = Math.abs(xAmp1) + Math.abs(xAmp2) + Math.abs(yAmp1) + Math.abs(yAmp2);
        double zMin = -zMax;
        this.boundingBox = new BoundingBox3D(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        if (Math.abs(x) < this.flatgroundBoxWidthAtZero / 2.0 && Math.abs(y) < this.flatgroundBoxWidthAtZero / 2.0) {
            if (normalToPack != null) {
                normalToPack.setX(0.0);
                normalToPack.setY(0.0);
                normalToPack.setZ(1.0);
            }
            return 0.0;
        }
        double height = this.xAmp1 * Math.sin(Math.PI * 2 * this.xFreq1 * x) + this.xAmp2 * Math.sin(Math.PI * 2 * this.xFreq2 * x) + (this.yAmp1 * Math.sin(Math.PI * 2 * this.yFreq1 * y) + this.yAmp2 * Math.sin(Math.PI * 2 * this.yFreq2 * y));
        if (normalToPack != null) {
            double dzdx = this.xAmp1 * 2.0 * Math.PI * this.xFreq1 * Math.cos(Math.PI * 2 * this.xFreq1 * x) + this.xAmp2 * 2.0 * Math.PI * this.xFreq2 * Math.cos(Math.PI * 2 * this.xFreq2 * x);
            double dzdy = this.yAmp1 * 2.0 * Math.PI * this.yFreq1 * Math.cos(Math.PI * 2 * this.yFreq1 * y) + this.yAmp2 * 2.0 * Math.PI * this.yFreq2 * Math.cos(Math.PI * 2 * this.yFreq2 * y);
            normalToPack.setX(-dzdx);
            normalToPack.setY(-dzdy);
            normalToPack.setZ(1.0);
            normalToPack.normalize();
        }
        return height;
    }

    public double heightAt(double x, double y, double z) {
        return this.heightAndNormalAt(x, y, z, null);
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }
}

