/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.collision.simple;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.simulationconstructionset.physics.CollisionShapeDescription;

public class CapsuleShapeDescription<T extends CapsuleShapeDescription<T>>
implements CollisionShapeDescription<T> {
    private double radius;
    private LineSegment3D lineSegmentInShapeFrame = new LineSegment3D();
    private LineSegment3D lineSegment = new LineSegment3D();
    private final BoundingBox3D boundingBox = new BoundingBox3D(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private boolean boundingBoxNeedsUpdating = true;
    private RigidBodyTransform transform = new RigidBodyTransform();
    private RigidBodyTransform tempTransform = new RigidBodyTransform();
    private final Point3D tempPointForRollingWorldFrame = new Point3D();
    private final Point3D tempPointForRollingShapeFrame = new Point3D();
    private final Vector3D tempVectorForRollingWorldFrame = new Vector3D();
    private final Vector3D tempVectorForRollingShapeFrame = new Vector3D();

    public CapsuleShapeDescription(double radius, LineSegment3DReadOnly lineSegment) {
        this.radius = radius;
        this.lineSegmentInShapeFrame.set(lineSegment);
        this.lineSegment.set(lineSegment);
        this.boundingBoxNeedsUpdating = true;
    }

    public CapsuleShapeDescription(double radius, double height) {
        if (height < 2.0 * radius) {
            throw new RuntimeException("Capsule height must be at least 2.0 * radius!");
        }
        this.radius = radius;
        this.lineSegmentInShapeFrame.set(0.0, 0.0, -height / 2.0 + radius, 0.0, 0.0, height / 2.0 - radius);
        this.lineSegment.set(0.0, 0.0, -height / 2.0 + radius, 0.0, 0.0, height / 2.0 - radius);
        this.boundingBoxNeedsUpdating = true;
    }

    @Override
    public CapsuleShapeDescription<T> copy() {
        CapsuleShapeDescription<T> copy = new CapsuleShapeDescription<T>(this.radius, (LineSegment3DReadOnly)this.lineSegment);
        copy.setTransform(this.transform);
        return copy;
    }

    public double getRadius() {
        return this.radius;
    }

    public void getTransform(RigidBodyTransform transformToPack) {
        transformToPack.set(this.transform);
    }

    public void setTransform(RigidBodyTransform transform) {
        this.transform.set(transform);
        this.lineSegment.applyTransform((Transform)transform);
    }

    public void getLineSegment(LineSegment3D lineSegmentToPack) {
        lineSegmentToPack.set(this.lineSegment);
    }

    public void getLineSegmentInShapeFrame(LineSegment3D lineSegmentInShapeFrameToPack) {
        lineSegmentInShapeFrameToPack.set(this.lineSegmentInShapeFrame);
    }

    @Override
    public void setFrom(T capsuleShapeDescription) {
        this.radius = ((CapsuleShapeDescription)capsuleShapeDescription).getRadius();
        ((CapsuleShapeDescription)capsuleShapeDescription).getLineSegment(this.lineSegment);
        ((CapsuleShapeDescription)capsuleShapeDescription).getLineSegmentInShapeFrame(this.lineSegmentInShapeFrame);
        this.boundingBoxNeedsUpdating = true;
        ((CapsuleShapeDescription)capsuleShapeDescription).getTransform(this.transform);
    }

    @Override
    public void applyTransform(RigidBodyTransform transformToWorld) {
        this.transform.preMultiply((RigidBodyTransformReadOnly)transformToWorld);
        this.lineSegment.applyTransform((Transform)transformToWorld);
        this.boundingBoxNeedsUpdating = true;
    }

    @Override
    public void getBoundingBox(BoundingBox3D boundingBoxToPack) {
        if (this.boundingBoxNeedsUpdating) {
            this.updateBoundingBox();
            this.boundingBoxNeedsUpdating = false;
        }
        boundingBoxToPack.set(this.boundingBox);
    }

    private void updateBoundingBox() {
        double zMax;
        double zMin;
        double yMax;
        double yMin;
        double xMax;
        double xMin;
        Point3DBasics firstEndpoint = this.lineSegment.getFirstEndpoint();
        Point3DBasics secondEndpoint = this.lineSegment.getSecondEndpoint();
        if (firstEndpoint.getX() < secondEndpoint.getX()) {
            xMin = firstEndpoint.getX();
            xMax = secondEndpoint.getX();
        } else {
            xMin = secondEndpoint.getX();
            xMax = firstEndpoint.getX();
        }
        if (firstEndpoint.getY() < secondEndpoint.getY()) {
            yMin = firstEndpoint.getY();
            yMax = secondEndpoint.getY();
        } else {
            yMin = secondEndpoint.getY();
            yMax = firstEndpoint.getY();
        }
        if (firstEndpoint.getZ() < secondEndpoint.getZ()) {
            zMin = firstEndpoint.getZ();
            zMax = secondEndpoint.getZ();
        } else {
            zMin = secondEndpoint.getZ();
            zMax = firstEndpoint.getZ();
        }
        this.boundingBox.set(xMin - this.radius, yMin - this.radius, zMin - this.radius, xMax + this.radius, yMax + this.radius, zMax + this.radius);
    }

    @Override
    public boolean isPointInside(Point3D pointInWorld) {
        return this.lineSegment.distanceSquared((Point3DReadOnly)pointInWorld) <= this.radius * this.radius;
    }

    @Override
    public boolean rollContactIfRolling(Vector3D surfaceNormal, Point3D pointToRoll) {
        this.tempTransform.set(this.transform);
        this.tempTransform.invert();
        this.tempPointForRollingWorldFrame.set(pointToRoll);
        this.tempVectorForRollingWorldFrame.set(surfaceNormal);
        this.tempTransform.transform((Point3DBasics)this.tempPointForRollingWorldFrame);
        this.tempTransform.transform((Vector3DBasics)this.tempVectorForRollingWorldFrame);
        boolean isRolling = this.rollContactIfRollingShapeFrame(this.tempVectorForRollingWorldFrame, this.tempPointForRollingWorldFrame);
        this.transform.transform((Point3DBasics)this.tempPointForRollingWorldFrame);
        pointToRoll.set(this.tempPointForRollingWorldFrame);
        return isRolling;
    }

    public boolean rollContactIfRollingShapeFrame(Vector3D surfaceNormalInShapeFrame, Point3D pointToRollInShapeFrame) {
        this.tempVectorForRollingShapeFrame.set(surfaceNormalInShapeFrame);
        double height = 2.0 * (this.lineSegmentInShapeFrame.getSecondEndpoint().getZ() + this.radius);
        if (pointToRollInShapeFrame.getZ() > -height / 2.0 + this.radius && pointToRollInShapeFrame.getZ() < height / 2.0 - this.radius) {
            this.tempVectorForRollingShapeFrame.setZ(0.0);
        }
        this.lineSegmentInShapeFrame.orthogonalProjection((Point3DReadOnly)pointToRollInShapeFrame, (Point3DBasics)this.tempPointForRollingShapeFrame);
        double currentRadiusOfPenetration = pointToRollInShapeFrame.distance((Point3DReadOnly)this.tempPointForRollingShapeFrame);
        this.tempVectorForRollingShapeFrame.normalize();
        this.tempVectorForRollingShapeFrame.scale(currentRadiusOfPenetration);
        this.tempPointForRollingShapeFrame.add((Tuple3DReadOnly)this.tempVectorForRollingShapeFrame);
        pointToRollInShapeFrame.set(this.tempPointForRollingShapeFrame);
        return true;
    }
}

