/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.videos;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraController;
import us.ihmc.simulationconstructionset.commands.ExportVideoCommandExecutor;
import us.ihmc.simulationconstructionset.gui.ActiveCanvas3DHolder;
import us.ihmc.simulationconstructionset.gui.StandardGUIActions;
import us.ihmc.simulationconstructionset.gui.StandardSimulationGUI;
import us.ihmc.simulationconstructionset.gui.TickUpdateListener;
import us.ihmc.simulationconstructionset.gui.ViewportPanel;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.GUIEnablerAndDisabler;
import us.ihmc.simulationconstructionset.videos.VideoFileFilter;

public class VideoSaveDialog
implements TickUpdateListener {
    private final Resolution[] dimensions = new Resolution[]{new Resolution(640, 360), new Resolution(1280, 720), new Resolution(1920, 1080), new Resolution(640, 480), new Resolution(800, 600)};
    private final int frameWidth = 720;
    private final int frameHeight = 600;
    private final int previewWidth = 720;
    private final int previewHeight = 360;
    private final GUIEnablerAndDisabler guiEnablerAndDisabler;
    private final StandardSimulationGUI myGUI;
    private JDialog exportDialog;
    private ViewportPanel viewportPanel;
    private JTextField frameRateTextField;
    private JTextField playbackRateTextField;
    private final Dimension dimension = new Dimension(1900, 1080);
    private final ExportVideoCommandExecutor exportVideoCommandExecutor;

    public VideoSaveDialog(Window owner, StandardSimulationGUI myGUI, StandardGUIActions standardGUIActions, ActiveCanvas3DHolder activeCanvas3DHolder, ExportVideoCommandExecutor exportVideoCommandExecutor, GUIEnablerAndDisabler guiEnablerAndDisabler) {
        this.exportVideoCommandExecutor = exportVideoCommandExecutor;
        this.exportDialog = new JDialog(owner, "Export Video");
        this.exportDialog.setName("Export Video");
        this.guiEnablerAndDisabler = guiEnablerAndDisabler;
        this.myGUI = myGUI;
        this.exportDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                VideoSaveDialog.this.close();
            }
        });
        this.exportDialog.setSize(720, 600);
        Container container = this.exportDialog.getContentPane();
        container.setLayout(null);
        this.viewportPanel = myGUI.createViewportPanel();
        this.viewportPanel.getCamera().copyPositionTrackingDollyConfiguration(activeCanvas3DHolder.getCamera());
        this.setResolution(this.dimensions[0]);
        JPanel previewPanel = new JPanel();
        previewPanel.setLayout(null);
        previewPanel.setBounds(0, 0, 720, 360);
        previewPanel.add(this.viewportPanel);
        container.add(previewPanel);
        JPanel panel = new JPanel();
        panel.setBounds(0, 360, 720, 240);
        container.add(panel);
        StandardGUIActions videoActions = new StandardGUIActions();
        videoActions.createVideoExportActions(standardGUIActions, this.viewportPanel);
        JPanel toolbar = videoActions.createVideoExportPanelButtons();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(toolbar);
        JPanel settings = new JPanel();
        JComboBox<Resolution> resolutions = new JComboBox<Resolution>(this.dimensions);
        resolutions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoSaveDialog.this.setResolution((Dimension)((JComboBox)e.getSource()).getSelectedItem());
            }
        });
        JPanel frPanel = new JPanel();
        JLabel frameRateLabel = new JLabel("Frame Rate");
        this.frameRateTextField = new JTextField("30", 3);
        frPanel.add(frameRateLabel);
        frPanel.add(this.frameRateTextField);
        JPanel pbPanel = new JPanel();
        JLabel playbackRateLabel = new JLabel("Playback Rate");
        this.playbackRateTextField = new JTextField("1", 3);
        pbPanel.add(playbackRateLabel);
        pbPanel.add(this.playbackRateTextField);
        JButton export = new JButton("Export");
        export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoSaveDialog.this.selectVideoLoction();
            }
        });
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoSaveDialog.this.close();
            }
        });
        settings.add(resolutions, "Center");
        settings.add((Component)frPanel, "Center");
        settings.add((Component)pbPanel, "Center");
        settings.add((Component)export, "Center");
        settings.add((Component)close, "Center");
        panel.add(settings);
        myGUI.addTickUpdateListener(this);
        this.exportDialog.setVisible(true);
    }

    private void selectVideoLoction() {
        JFileChooser saveDialog = new JFileChooser(System.getProperty("user.home"));
        saveDialog.setFileFilter(new VideoFileFilter());
        File selectedFile = null;
        if (0 == saveDialog.showSaveDialog(this.exportDialog)) {
            selectedFile = saveDialog.getSelectedFile();
        }
        if (selectedFile != null) {
            float frameRate = new Float(this.frameRateTextField.getText()).floatValue();
            float playBackRate = new Float(this.playbackRateTextField.getText()).floatValue();
            Boolean isSequanceSelected = false;
            this.exportVideoCommandExecutor.createVideo((CameraController)this.viewportPanel.getCamera(), selectedFile, this.dimension, isSequanceSelected, playBackRate, frameRate);
        }
    }

    private void close() {
        this.exportDialog.setVisible(false);
        this.viewportPanel.closeAndDispose();
        this.viewportPanel = null;
        this.exportDialog.dispose();
        this.exportDialog = null;
        this.guiEnablerAndDisabler.enableGUIComponents();
        this.myGUI.removeTickUpdateListener(this);
    }

    private void setResolution(Dimension dimension) {
        int height;
        int width;
        double screenAspect;
        double aspectRatio = dimension.getWidth() / dimension.getHeight();
        if (aspectRatio > (screenAspect = 2.0)) {
            width = 720;
            height = (int)(1.0 / aspectRatio * 720.0);
        } else {
            width = (int)(aspectRatio * 360.0);
            height = 360;
        }
        this.viewportPanel.setBounds((720 - width) / 2, (360 - height) / 2, width, height);
        this.viewportPanel.repaint();
        this.viewportPanel.revalidate();
        this.dimension.setSize(dimension);
    }

    @Override
    public void update(int tick) {
        if (this.viewportPanel != null && this.viewportPanel.getCamera().useKeyCameraPoints()) {
            this.viewportPanel.getCamera().setKeyFrameTime(tick);
        }
    }

    private class Resolution
    extends Dimension {
        public Resolution() {
        }

        public Resolution(Dimension d) {
            super(d);
        }

        public Resolution(int width, int height) {
            super(width, height);
        }

        @Override
        public String toString() {
            return this.width + " x " + this.height;
        }
    }
}

