/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SpatialVector;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;

public class JointWrenchSensor {
    private final String name;
    private final YoFrameVector3D jointWrenchForce;
    private final YoFrameVector3D jointWrenchTorque;
    private final Vector3D offsetFromJoint = new Vector3D();
    private final Vector3D tempVector = new Vector3D();

    public JointWrenchSensor(String name, Tuple3DReadOnly offsetFromJoint, Robot robot) {
        this.name = name;
        this.jointWrenchForce = new YoFrameVector3D(name + "_f", null, robot.getRobotsYoRegistry());
        this.jointWrenchTorque = new YoFrameVector3D(name + "_t", null, robot.getRobotsYoRegistry());
        this.offsetFromJoint.set(offsetFromJoint);
    }

    public void getOffsetFromJoint(Tuple3DBasics offsetFromJointToPack) {
        offsetFromJointToPack.set((Tuple3DReadOnly)this.offsetFromJoint);
    }

    public void getJointForce(Tuple3DBasics forceToPack) {
        forceToPack.set((Tuple3DReadOnly)this.jointWrenchForce);
    }

    public void getJointTorque(Tuple3DBasics torqueToPack) {
        torqueToPack.set((Tuple3DReadOnly)this.jointWrenchTorque);
    }

    public void setWrench(SpatialVector wrenchToSet) {
        wrenchToSet.getTop((Vector3DBasics)this.tempVector);
        this.jointWrenchForce.set((Tuple3DReadOnly)this.tempVector);
        wrenchToSet.getBottom((Vector3DBasics)this.tempVector);
        this.jointWrenchTorque.set((Tuple3DReadOnly)this.tempVector);
    }

    public Vector3DReadOnly getOffsetFromJoint() {
        return this.offsetFromJoint;
    }

    public void getTransformToParentJoint(RigidBodyTransformBasics transformToPack) {
        transformToPack.setTranslationAndIdentityRotation((Tuple3DReadOnly)this.offsetFromJoint);
    }

    public String getName() {
        return this.name;
    }
}

