/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.simulationconstructionset.util.ground.GroundProfileFromHeightMap;

public class StepUpGroundProfile
extends GroundProfileFromHeightMap {
    private final BoundingBox3D boundingBox;
    private final double groundXStep;
    private final double groundZStep;

    public StepUpGroundProfile(double groundXStep, double groundZStep) {
        double xMin = -1.0;
        double xMax = 4.0;
        double yMin = -1.0;
        double yMax = 1.0;
        this.groundXStep = groundXStep;
        this.groundZStep = groundZStep;
        double zMin = Double.NEGATIVE_INFINITY;
        double zMax = Double.POSITIVE_INFINITY;
        this.boundingBox = new BoundingBox3D(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    @Override
    public void closestIntersectionAndNormalAt(double x, double y, double z, Point3DBasics intersection, Vector3DBasics normal) {
        this.closestIntersectionTo(x, y, z, intersection);
        this.surfaceNormalAt(x, y, z, normal);
    }

    public void closestIntersectionTo(double x, double y, double z, Point3DBasics intersection) {
        intersection.set(x, y, this.heightAt(x, y, z));
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double height = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return height;
    }

    public double heightAt(double x, double y, double z) {
        if (x > this.groundXStep) {
            return this.groundZStep;
        }
        return 0.0;
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics normal) {
        normal.set(0.0, 0.0, 1.0);
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }
}

