/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogConstructors;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import us.ihmc.simulationconstructionset.gui.GraphArrayPanel;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.GUIEnablerAndDisabler;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.SaveGraphConfigurationDialogConstructor;
import us.ihmc.tools.gui.MyFileFilter;

public class SaveGraphConfigurationDialogGenerator
implements SaveGraphConfigurationDialogConstructor {
    private FileFilter dataFileFilter = new MyFileFilter(new String[]{".graphConf"}, "GraphGroup Configuration (.graphConf)");
    private File chosenFile;
    private JFileChooser dataFileChooser;
    private JFrame frame;
    private GUIEnablerAndDisabler guiEnablerAndDisabler;
    private GraphArrayPanel graphArrayPanel;

    public SaveGraphConfigurationDialogGenerator(GUIEnablerAndDisabler guiEnablerAndDisabler, JFrame frame, GraphArrayPanel graphArrayPanel) {
        this.graphArrayPanel = graphArrayPanel;
        this.frame = frame;
        this.guiEnablerAndDisabler = guiEnablerAndDisabler;
        try {
            File Configs = new File("Configurations");
            String path = Configs.toURI().getPath();
            this.dataFileChooser = new JFileChooser();
            this.setCurrentDirectory(path);
            this.dataFileChooser.setAcceptAllFileFilterUsed(false);
            this.dataFileChooser.addChoosableFileFilter(this.dataFileFilter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setCurrentDirectory(File dir) {
        this.dataFileChooser.setCurrentDirectory(dir);
    }

    @Override
    public void setCurrentDirectory(String dir) {
        this.dataFileChooser.setCurrentDirectory(new File(dir));
    }

    @Override
    public void constructDialog() {
        this.guiEnablerAndDisabler.disableGUIComponents();
        String fileEnding = ".graphConf";
        if (this.dataFileChooser.showSaveDialog(this.frame) == 0) {
            try {
                this.chosenFile = this.dataFileChooser.getSelectedFile();
                String filename = this.chosenFile.getName();
                if (!filename.endsWith(fileEnding)) {
                    filename = filename.concat(fileEnding);
                    if (!this.chosenFile.getName().equals(filename)) {
                        File newChosenFile;
                        this.chosenFile = newChosenFile = new File(this.chosenFile.getParent(), filename);
                    }
                }
                BufferedWriter output = null;
                output = new BufferedWriter(new FileWriter(this.chosenFile));
                output.write(this.writeGUIConfig());
                ((Writer)output).close();
                System.out.println("Your file has been written");
            }
            catch (Exception e) {
                System.err.println("Error While Writting/Saving Gui Configuration File");
                e.printStackTrace();
            }
        }
        this.guiEnablerAndDisabler.enableGUIComponents();
    }

    private String writeGUIConfig() {
        String textToWrite = "";
        textToWrite = textToWrite + "\n" + this.graphArrayPanel.getXMLRepresentationOfClass();
        return textToWrite;
    }

    public void closeAndDispose() {
        this.dataFileFilter = null;
        this.chosenFile = null;
        this.dataFileChooser = null;
        this.frame = null;
        this.guiEnablerAndDisabler = null;
        this.graphArrayPanel = null;
    }
}

