/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogConstructors;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfiguration;
import us.ihmc.simulationconstructionset.GroundContactModel;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.gui.StandardSimulationGUI;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.LoadRobotConfigurationDialogConstructor;
import us.ihmc.simulationconstructionset.robotdefinition.RobotDefinitionFixedFrame;
import us.ihmc.simulationconstructionset.util.XMLReaderUtility;
import us.ihmc.tools.gui.MyFileFilter;

public class LoadRobotConfigurationDialogGenerator
implements LoadRobotConfigurationDialogConstructor {
    private FileFilter dataFileFilter = new MyFileFilter(new String[]{".robotConf"}, "Robot Configuration (.robotConf)");
    private File chosenFile;
    private JFileChooser dataFileChooser;
    private JFrame frame;
    private StandardSimulationGUI myGUI;
    private SimulationConstructionSet sim;

    public LoadRobotConfigurationDialogGenerator(SimulationConstructionSet sim, JFrame frame, StandardSimulationGUI myGUI) {
        this.frame = frame;
        this.sim = sim;
        this.myGUI = myGUI;
        try {
            String defaultDirString;
            URL defaultDirURL;
            this.dataFileChooser = new JFileChooser();
            if (sim != null && (defaultDirURL = sim.getClass().getResource(".")) != null && (defaultDirString = defaultDirURL.getPath()) != null) {
                int idx = defaultDirString.indexOf("classes");
                if (idx > 0) {
                    defaultDirString = defaultDirString.substring(0, idx);
                }
                this.setCurrentDirectory(defaultDirString);
            }
            this.dataFileChooser.setAcceptAllFileFilterUsed(false);
            this.dataFileChooser.addChoosableFileFilter(this.dataFileFilter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setCurrentDirectory(File dir) {
        this.dataFileChooser.setCurrentDirectory(dir);
    }

    @Override
    public void setCurrentDirectory(String dir) {
        this.dataFileChooser.setCurrentDirectory(new File(dir));
    }

    @Override
    public void constructDialog() {
        this.sim.disableGUIComponents();
        String fileEnding = ".robotConf";
        if (this.dataFileChooser.showOpenDialog(this.frame) == 0) {
            try {
                String tempLine;
                this.chosenFile = this.dataFileChooser.getSelectedFile();
                String filename = this.chosenFile.getName();
                if (!filename.endsWith(fileEnding)) {
                    filename = filename.concat(fileEnding);
                    if (!this.chosenFile.getName().equals(filename)) {
                        File newChosenFile;
                        this.chosenFile = newChosenFile = new File(this.chosenFile.getParent(), filename);
                    }
                }
                String name = this.chosenFile.getName().substring(0, this.chosenFile.getName().length() - fileEnding.length());
                System.out.println("Loading: " + name);
                BufferedReader reader = new BufferedReader(new FileReader(this.chosenFile));
                String xmlRepresentation = "";
                while ((tempLine = reader.readLine()) != null) {
                    xmlRepresentation = xmlRepresentation + tempLine;
                }
                GroundContactModel gcm = null;
                Robot[] robots = this.sim.getRobots();
                if (robots.length > 0) {
                    gcm = robots[0].getGroundContactModel();
                }
                RobotDefinitionFixedFrame robotDef = new RobotDefinitionFixedFrame();
                robotDef.createRobotDefinitionFromRobotConfigurationString(xmlRepresentation);
                Robot r = new Robot(robotDef, "Loaded");
                r.setGroundContactModel(gcm);
                this.sim.setRobot(r);
                reader.close();
                System.out.println("Your file has been loaded.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.sim.enableGUIComponents();
    }

    public void setupMainViewport(String xmlRepresentation) {
        boolean visible = this.myGUI.setViewportFromXMLDescription(xmlRepresentation);
        if (!visible) {
            this.myGUI.hideViewport();
        }
    }

    public void setupViewportWindows(String xmlRepresentation) {
        int numberofviewports = Integer.parseInt(XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)"<Number of ViewPorts>", (String)"</Number of ViewPorts>"));
        for (int i = 1; i < numberofviewports; ++i) {
            CameraConfiguration config = new CameraConfiguration("viewport" + i);
            boolean maximizeWindow = true;
            String first = "<Viewport" + i + ">";
            String second = "</Viewport" + i + ">";
            String textToLoad = XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)first, (String)second);
            String visible = XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Visible>", (String)"</Visible>").trim();
            double posX = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Viewport Camera X>", (String)"</Viewport Camera X>"));
            double posY = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Viewport Camera Y>", (String)"</Viewport Camera Y>"));
            double posZ = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Viewport Camera Z>", (String)"</Viewport Camera Z>"));
            config.setCameraPosition(posX, posY, posZ);
            String Dolly = XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Dolly data>", (String)"</Dolly data>");
            double DollyX = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Position X>", (String)"</Position X>"));
            double DollyY = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Position Y>", (String)"</Position Y>"));
            double DollyZ = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Position Z>", (String)"</Position Z>"));
            config.setCameraDollyOffsets(DollyX, DollyY, DollyZ);
            String Dolly_Boolean = XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Dolly>", (String)"</Dolly>");
            String Dolly_Boolean_X = XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Dolly X>", (String)"</Dolly X>");
            String Dolly_Boolean_Y = XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Dolly Y>", (String)"</Dolly Y>");
            String Dolly_Boolean_Z = XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Dolly Z>", (String)"</Dolly Z>");
            boolean dolly_set = true;
            boolean dolly_setX = true;
            boolean dolly_setY = true;
            boolean dolly_setZ = true;
            if (Dolly_Boolean.equals("false")) {
                dolly_set = false;
            }
            if (Dolly_Boolean_X.equals("false")) {
                dolly_setX = false;
            }
            if (Dolly_Boolean_Y.equals("false")) {
                dolly_setY = false;
            }
            if (Dolly_Boolean_Z.equals("false")) {
                dolly_setZ = false;
            }
            config.setCameraDolly(dolly_set, dolly_setX, dolly_setY, dolly_setZ);
            String Track = XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Track data>", (String)"</Track data>");
            double TrackX = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Position X>", (String)"</Position X>"));
            double TrackY = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Position Y>", (String)"</Position Y>"));
            double TrackZ = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Position Z>", (String)"</Position Z>"));
            config.setCameraTrackingOffsets(TrackX, TrackY, TrackZ);
            String Track_Boolean = XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Track>", (String)"</Track>");
            String Track_Boolean_X = XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Track X>", (String)"</Track X>");
            String Track_Boolean_Y = XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Track Y>", (String)"</Track Y>");
            String Track_Boolean_Z = XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Track Z>", (String)"</Track Z>");
            boolean track_set = true;
            boolean track_setX = true;
            boolean track_setY = true;
            boolean track_setZ = true;
            if (Track_Boolean.equals("false")) {
                track_set = false;
            }
            if (Track_Boolean_X.equals("false")) {
                track_setX = false;
            }
            if (Track_Boolean_Y.equals("false")) {
                track_setY = false;
            }
            if (Track_Boolean_Z.equals("false")) {
                track_setZ = false;
            }
            config.setCameraTracking(track_set, track_setX, track_setY, track_setZ);
            String Fix = XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Fix Position>", (String)"</Fix Position>");
            double FixX = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Fix, (String)"<Fix X>", (String)"</Fix X>"));
            double FixY = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Fix, (String)"<Fix Y>", (String)"</Fix Y>"));
            double FixZ = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Fix, (String)"<Fix Z>", (String)"</Fix Z>"));
            config.setCameraFix(FixX, FixY, FixZ);
            if (visible.equals("false")) {
                this.myGUI.createNewViewportWindow("viewport" + i, 1, maximizeWindow, config).hideViewport();
                continue;
            }
            this.myGUI.createNewViewportWindow("viewport" + i, 1, maximizeWindow, config);
        }
    }

    public void setupConfiguration(String configurationName) {
        this.myGUI.setupConfiguration(configurationName, configurationName, configurationName);
        this.myGUI.selectGraphConfiguration(configurationName);
    }

    public void loadEntryBoxArrayPanel(String XMLStyleRepresentation) {
        String XMLData = XMLReaderUtility.getMiddleString((int)0, (String)XMLStyleRepresentation, (String)"<Entry Boxes>", (String)"</Entry Boxes>");
        int index = 0;
        int currentNumberOfVariables = 0;
        while (XMLReaderUtility.getEndIndexOfSubString((int)index, (String)XMLData, (String)",") <= XMLData.length() && XMLReaderUtility.getEndIndexOfSubString((int)index, (String)XMLData, (String)",") > 0) {
            ++currentNumberOfVariables;
            ++index;
        }
        if (index < XMLData.length()) {
            ++currentNumberOfVariables;
        }
        String[] name = new String[currentNumberOfVariables];
        currentNumberOfVariables = 0;
        index = 0;
        while (XMLReaderUtility.getEndIndexOfSubString((int)index, (String)XMLData, (String)",") <= XMLData.length() && XMLReaderUtility.getEndIndexOfSubString((int)index, (String)XMLData, (String)",") > 0) {
            int endIndex = XMLReaderUtility.getEndIndexOfSubString((int)index, (String)XMLData, (String)",");
            name[currentNumberOfVariables] = XMLData.substring(index, endIndex - 1);
            name[currentNumberOfVariables] = name[currentNumberOfVariables].trim();
            ++currentNumberOfVariables;
            index = endIndex;
        }
        if (index < XMLData.length()) {
            name[currentNumberOfVariables] = XMLData.substring(index, XMLData.length());
            name[currentNumberOfVariables] = name[currentNumberOfVariables].trim();
        }
        this.sim.setupEntryBoxGroup(this.chosenFile.getName(), name);
        this.myGUI.updateGUI();
        this.myGUI.selectEntryBoxGroup(this.chosenFile.getName());
    }
}

