/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.simulationconstructionset.util.ground.GroundProfileFromHeightMap;

public class StepDownsGroundprofile
extends GroundProfileFromHeightMap {
    private static final double xMinDefault = -20.0;
    private static final double xMaxDefault = 20.0;
    private static final double yMinDefault = -20.0;
    private static final double yMaxDefault = 20.0;
    private static final double amplitudeDefault = 0.1;
    private static final double frequencyDefault = 0.3;
    private static final double offsetDefault = 0.0;
    private static final double heightOffsetDefault = 0.0;
    private final BoundingBox3D boundingBox;
    private final double amplitude;
    private final double frequency;
    private final double offset;
    private final double heightOffset;

    public StepDownsGroundprofile() {
        this(0.1, 0.3, 0.0);
    }

    public StepDownsGroundprofile(double amplitude, double frequency, double offset) {
        this(amplitude, frequency, offset, 0.0);
    }

    public StepDownsGroundprofile(double amplitude, double frequency, double offset, double heightOffset) {
        this(amplitude, frequency, offset, heightOffset, -20.0, 20.0, -20.0, 20.0);
    }

    public StepDownsGroundprofile(double amplitude, double frequency, double offset, double heightOffset, double xMin, double xMax, double yMin, double yMax) {
        this.amplitude = amplitude;
        this.frequency = frequency;
        this.offset = offset;
        this.heightOffset = heightOffset;
        double zMin = Double.NEGATIVE_INFINITY;
        double zMax = Double.POSITIVE_INFINITY;
        this.boundingBox = new BoundingBox3D(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double height = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return height;
    }

    public double heightAt(double x, double y, double z) {
        double height = this.heightOffset;
        if (this.boundingBox.isXYInsideInclusive(x, y)) {
            height = this.amplitude * Math.sin(Math.PI * 2 * this.frequency * (x + this.offset));
        }
        height = height > this.amplitude * 0.8 ? this.amplitude + this.heightOffset : (height < -this.amplitude * 0.8 ? -this.amplitude + this.heightOffset : this.heightOffset);
        return height;
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics normal) {
        double dzdx = 0.0;
        normal.setX(-dzdx);
        normal.setY(0.0);
        normal.setZ(1.0);
        normal.normalize();
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }
}

