/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfiguration;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfigurationList;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraController;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraMountList;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraTrackingAndDollyPositionHolder;
import us.ihmc.jMonkeyEngineToolkit.camera.CaptureDevice;
import us.ihmc.jMonkeyEngineToolkit.camera.ClassicCameraController;
import us.ihmc.jMonkeyEngineToolkit.camera.TrackingDollyCameraController;
import us.ihmc.jMonkeyEngineToolkit.camera.ViewportAdapter;
import us.ihmc.simulationconstructionset.ViewportConfiguration;
import us.ihmc.simulationconstructionset.ViewportPanelConfiguration;
import us.ihmc.simulationconstructionset.commands.RunCommandsExecutor;
import us.ihmc.simulationconstructionset.gui.ActiveCameraHolder;
import us.ihmc.simulationconstructionset.gui.ActiveCanvas3DHolder;
import us.ihmc.simulationconstructionset.gui.Canvas3DPanel;
import us.ihmc.simulationconstructionset.gui.StandardGUIActions;
import us.ihmc.simulationconstructionset.gui.ViewportAdapterAndCameraControllerHolder;
import us.ihmc.simulationconstructionset.gui.camera.CameraTrackAndDollyYoVariablesHolder;
import us.ihmc.simulationconstructionset.gui.config.CameraSelector;
import us.ihmc.simulationconstructionset.util.XMLReaderUtility;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.variable.YoDouble;

public class ViewportPanel
extends JPanel
implements CameraSelector,
ActiveCameraHolder,
ActiveCanvas3DHolder {
    private static final long serialVersionUID = -2903057563160516887L;
    private static final boolean DEBUG_CLOSE_AND_DISPOSE = false;
    private ArrayList<ViewportAdapterAndCameraControllerHolder> standard3DViews = new ArrayList();
    private ArrayList<Canvas3DPanel> canvasPanels = new ArrayList();
    private ViewportAdapterAndCameraControllerHolder activeView;
    private CameraConfigurationList cameraConfigurationList;
    private CameraMountList cameraMountList;
    private YoVariableHolder yoVariableHolder;
    private RunCommandsExecutor runCommandsExecutor;
    private Graphics3DAdapter graphics3DAdapter;
    private StandardGUIActions standardGUIActions;

    public ViewportPanel(YoVariableHolder yoVariableHolder, RunCommandsExecutor runCommandsExecutor, StandardGUIActions standardGUIActions, CameraConfigurationList cameraConfigurationList, CameraMountList cameraMountList, Graphics3DAdapter graphics3DAdapater) {
        this.yoVariableHolder = yoVariableHolder;
        this.runCommandsExecutor = runCommandsExecutor;
        this.standardGUIActions = standardGUIActions;
        this.cameraConfigurationList = cameraConfigurationList;
        this.cameraMountList = cameraMountList;
        this.graphics3DAdapter = graphics3DAdapater;
    }

    public TrackingDollyCameraController getCameraPropertiesForActiveCamera() {
        return this.activeView.getCameraController();
    }

    public void setupViews(GraphicsDevice graphicsDevice, ViewportConfiguration viewportConfig) {
        this.setupViews(graphicsDevice, viewportConfig, null);
    }

    public void setupViews(GraphicsDevice graphicsDevice, ViewportConfiguration viewportConfig, JFrame jFrame) {
        this.removeAll();
        this.clearStandard3DViews();
        this.canvasPanels.clear();
        if (viewportConfig == null) {
            this.setLayout(new GridLayout(1, 1));
            CameraTrackAndDollyYoVariablesHolder cameraTrackAndDollyYoVariablesHolder = new CameraTrackAndDollyYoVariablesHolder(this.yoVariableHolder);
            ViewportAdapter standard3DView = this.graphics3DAdapter.createNewViewport(graphicsDevice, false, false);
            ClassicCameraController classicCameraController = jFrame != null ? ClassicCameraController.createClassicCameraControllerAndAddListeners((ViewportAdapter)standard3DView, (CameraTrackingAndDollyPositionHolder)cameraTrackAndDollyYoVariablesHolder, (Graphics3DAdapter)this.graphics3DAdapter, (JFrame)jFrame) : ClassicCameraController.createClassicCameraControllerAndAddListeners((ViewportAdapter)standard3DView, (CameraTrackingAndDollyPositionHolder)cameraTrackAndDollyYoVariablesHolder, (Graphics3DAdapter)this.graphics3DAdapter);
            ViewportAdapterAndCameraControllerHolder viewportAdapterAndCameraControllerHolder = new ViewportAdapterAndCameraControllerHolder(standard3DView, (TrackingDollyCameraController)classicCameraController);
            standard3DView.setCameraController((CameraController)classicCameraController);
            this.standard3DViews.add(viewportAdapterAndCameraControllerHolder);
            this.activeView = viewportAdapterAndCameraControllerHolder;
            Canvas3DPanel panel_j = new Canvas3DPanel(this.runCommandsExecutor, viewportAdapterAndCameraControllerHolder, this);
            this.add(panel_j);
            return;
        }
        ArrayList<ViewportPanelConfiguration> panelConfigs = viewportConfig.getPanelConfigurations();
        GridBagLayout gridBag = new GridBagLayout();
        this.setLayout(gridBag);
        for (int i = 0; i < panelConfigs.size(); ++i) {
            GridBagConstraints c = new GridBagConstraints();
            ViewportPanelConfiguration panelConfiguration = panelConfigs.get(i);
            CameraTrackAndDollyYoVariablesHolder cameraTrackAndDollyYoVariablesHolder = new CameraTrackAndDollyYoVariablesHolder(this.yoVariableHolder);
            ViewportAdapter standard3DView = this.graphics3DAdapter.createNewViewport(graphicsDevice, false, false);
            ClassicCameraController classicCameraController = ClassicCameraController.createClassicCameraControllerAndAddListeners((ViewportAdapter)standard3DView, (CameraTrackingAndDollyPositionHolder)cameraTrackAndDollyYoVariablesHolder, (Graphics3DAdapter)this.graphics3DAdapter);
            ViewportAdapterAndCameraControllerHolder viewportAdapterAndCameraControllerHolder = new ViewportAdapterAndCameraControllerHolder(standard3DView, (TrackingDollyCameraController)classicCameraController);
            standard3DView.setCameraController((CameraController)classicCameraController);
            this.standard3DViews.add(viewportAdapterAndCameraControllerHolder);
            CameraConfiguration cameraConfig = this.cameraConfigurationList.getCameraConfiguration(panelConfiguration.cameraName);
            if (cameraConfig == null) {
                System.err.println("Warning. No camera named " + panelConfiguration.cameraName);
                continue;
            }
            this.setCameraConfiguration(viewportAdapterAndCameraControllerHolder.getCameraController(), cameraConfig, this.yoVariableHolder, this.cameraMountList);
            Canvas3DPanel panel_j = new Canvas3DPanel(this.runCommandsExecutor, viewportAdapterAndCameraControllerHolder, this);
            this.canvasPanels.add(panel_j);
            c.gridx = panelConfiguration.gridx;
            c.gridy = panelConfiguration.gridy;
            c.gridwidth = panelConfiguration.gridwidth;
            c.gridheight = panelConfiguration.gridheight;
            c.weightx = panelConfiguration.gridwidth;
            c.weighty = panelConfiguration.gridheight;
            c.fill = 1;
            gridBag.setConstraints(panel_j, c);
            this.add(panel_j);
            if (i == 0) {
                this.activeView = viewportAdapterAndCameraControllerHolder;
                panel_j.setActive(true);
                continue;
            }
            panel_j.setActive(false);
        }
    }

    public ViewportAdapter getActiveView() {
        return this.activeView.getViewportAdapter();
    }

    public void setActiveView(ViewportAdapterAndCameraControllerHolder view, Canvas3DPanel activePanel) {
        if (this.activeView == view) {
            return;
        }
        view.getCameraController().reset();
        this.activeView = view;
        for (Canvas3DPanel canvas3DPanel : this.canvasPanels) {
            canvas3DPanel.setActive(false);
        }
        activePanel.setActive(true);
        if (this.standardGUIActions != null) {
            this.standardGUIActions.makeCheckBoxesConsistentWithCamera();
        }
    }

    public StandardGUIActions getStandardGUIActions() {
        return this.standardGUIActions;
    }

    public ArrayList<ViewportAdapterAndCameraControllerHolder> getCameraAdapters() {
        return this.standard3DViews;
    }

    public void closeAndDispose() {
        if (this.standard3DViews != null) {
            this.clearStandard3DViews();
            this.standard3DViews = null;
        }
        if (this.canvasPanels != null) {
            for (Canvas3DPanel canvas3dPanel : this.canvasPanels) {
                canvas3dPanel.closeAndDispose();
            }
            this.canvasPanels.clear();
            this.canvasPanels = null;
        }
        this.activeView = null;
        this.cameraConfigurationList = null;
        this.cameraMountList = null;
        this.yoVariableHolder = null;
        this.standardGUIActions = null;
        this.runCommandsExecutor = null;
        this.graphics3DAdapter = null;
    }

    @Override
    public TrackingDollyCameraController getCamera() {
        return this.activeView.getCameraController();
    }

    public TrackingDollyCameraController[] getCameras() {
        TrackingDollyCameraController[] cameras = new TrackingDollyCameraController[this.standard3DViews.size()];
        for (int i = 0; i < this.standard3DViews.size(); ++i) {
            cameras[i] = this.standard3DViews.get(i).getCameraController();
        }
        return cameras;
    }

    public void setClipDistances(double near, double far) {
        this.activeView.getCameraController().setClipDistanceNear(near);
        this.activeView.getCameraController().setClipDistanceFar(far);
    }

    public void setFieldOfView(double fieldOfView) {
        this.activeView.getCameraController().setFieldOfView(fieldOfView);
    }

    public void setCameraTrackingVars(YoDouble xVar, YoDouble yVar, YoDouble zVar) {
        CameraTrackAndDollyYoVariablesHolder cameraTrackAndDollyVariablesHolder = (CameraTrackAndDollyYoVariablesHolder)this.activeView.getCameraController().getCameraTrackAndDollyVariablesHolder();
        cameraTrackAndDollyVariablesHolder.setTrackingVars(xVar, yVar, zVar);
    }

    public void setCameraDollyVars(YoDouble xVar, YoDouble yVar, YoDouble zVar) {
        CameraTrackAndDollyYoVariablesHolder cameraTrackAndDollyVariablesHolder = (CameraTrackAndDollyYoVariablesHolder)this.activeView.getCameraController().getCameraTrackAndDollyVariablesHolder();
        cameraTrackAndDollyVariablesHolder.setDollyVars(xVar, yVar, zVar);
    }

    public void setCameraTrackingOffsets(double dx, double dy, double dz) {
        this.activeView.getCameraController().setTrackingOffsets(dx, dy, dz);
    }

    public void setCameraDollyOffsets(double dx, double dy, double dz) {
        this.activeView.getCameraController().setDollyOffsets(dx, dy, dz);
    }

    public void setCameraFix(double fixX, double fixY, double fixZ) {
        this.activeView.getCameraController().setFixPosition(fixX, fixY, fixZ);
    }

    public void setCameraFix(Tuple3DBasics cameraFix) {
        this.activeView.getCameraController().setFixPosition(cameraFix.getX(), cameraFix.getY(), cameraFix.getZ());
    }

    public void setCameraPosition(double posX, double posY, double posZ) {
        this.activeView.getCameraController().setCameraPosition(posX, posY, posZ);
    }

    public void setCameraPosition(Tuple3DBasics cameraPosition) {
        this.activeView.getCameraController().setCameraPosition(cameraPosition.getX(), cameraPosition.getY(), cameraPosition.getZ());
    }

    public void setCameraTracking(boolean track, boolean trackX, boolean trackY, boolean trackZ) {
        this.activeView.getCameraController().setTracking(track, trackX, trackY, trackZ);
    }

    public void setCameraDolly(boolean dolly, boolean dollyX, boolean dollyY, boolean dollyZ) {
        this.activeView.getCameraController().setDolly(dolly, dollyX, dollyY, dollyZ);
    }

    public void setCameraConfiguration(CameraConfiguration config, YoVariableHolder holder) {
        this.setCameraConfiguration(this.activeView.getCameraController(), config, holder, this.cameraMountList);
    }

    public synchronized void clearStandard3DViews() {
        for (ViewportAdapterAndCameraControllerHolder viewportAdapterAndCameraControllerHolder : this.standard3DViews) {
            this.graphics3DAdapter.closeViewport(viewportAdapterAndCameraControllerHolder.getViewportAdapter());
            viewportAdapterAndCameraControllerHolder.closeAndDispose();
        }
        this.standard3DViews.clear();
    }

    @Override
    public CaptureDevice getActiveCaptureDevice() {
        return this.getActiveView().getCaptureDevice();
    }

    public void selectActiveCanvas3D(int canvasIndex) {
        if (canvasIndex >= this.canvasPanels.size()) {
            return;
        }
        Canvas3DPanel canvasPanel = this.canvasPanels.get(canvasIndex);
        this.setActiveView(canvasPanel.getStandard3DView(), canvasPanel);
    }

    @Override
    public void selectCamera(String name) {
        CameraConfiguration config = this.cameraConfigurationList.getCameraConfiguration(name);
        if (config == null) {
            return;
        }
        this.setCameraConfiguration(config, this.yoVariableHolder);
    }

    public String getXMLStyleRepresentationofMultiViews(String currentView) {
        String textToWrite = "";
        textToWrite = textToWrite + "<Current View>" + currentView + "</Current View>";
        for (int i = 0; i < this.canvasPanels.size(); ++i) {
            int label = i + 1;
            textToWrite = textToWrite + "\n<Canvas " + label + ">";
            textToWrite = textToWrite + "\n<Camera X>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().getCamX() + "</Camera X>";
            textToWrite = textToWrite + "\n<Camera Y>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().getCamY() + "</Camera Y>";
            textToWrite = textToWrite + "\n<Camera Z>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().getCamZ() + "</Camera Z>";
            textToWrite = textToWrite + "\n <Dolly data> \n <Position X>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().getDollyXOffset() + "</Position X>\n <Position Y>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().getDollyYOffset() + "</Position Y>\n <Position Z>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().getDollyZOffset() + "</Position Z>";
            textToWrite = textToWrite + "\n<Dolly Booleans>\n<Dolly>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().isDolly() + "</Dolly>\n<Dolly X>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().isDollyX() + "</Dolly X>\n<Dolly Y>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().isDollyY() + "</Dolly Y>\n<Dolly Z>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().isDollyY() + "</Dolly Z>\n</Dolly Booleans>";
            textToWrite = textToWrite + "\n</Dolly data>";
            textToWrite = textToWrite + "\n <Track data> \n <Position X>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().getTrackingXOffset() + "</Position X>\n <Position Y>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().getTrackingYOffset() + "</Position Y>\n <Position Z>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().getTrackingZOffset() + "</Position Z>";
            textToWrite = textToWrite + "\n <Track Booleans>\n<Track>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().isTracking() + "</Track>\n<Track X>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().isTrackingX() + "</Track X>\n<Track Y>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().isTrackingY() + "</Track Y>\n<Track Z>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().isTracking() + "</Track Z>\n</Track Booleans>";
            textToWrite = textToWrite + "\n</Track data>";
            textToWrite = textToWrite + "\n<Fix Position>\n<Fix X>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().getFixX() + "</Fix X>\n<Fix Y>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().getFixY() + "</Fix Y>\n<Fix Z>" + this.canvasPanels.get(i).getStandard3DView().getCameraController().getFixZ() + "</Fix Z>\n</Fix Position>";
            textToWrite = textToWrite + "\n</Canvas " + label + ">";
        }
        if (this.canvasPanels.size() == 0) {
            textToWrite = textToWrite + "\n <Canvas 1> \n <Camera X>" + this.getCamera().getCamX() + "</Camera X>\n <Camera Y>" + this.getCamera().getCamY() + "</Camera Y>\n <Camera Z>" + this.getCamera().getCamZ() + "</Camera Z>";
            textToWrite = textToWrite + "\n <Dolly data> \n <Position X>" + this.getCameraPropertiesForActiveCamera().getDollyXOffset() + "</Position X>\n <Position Y>" + this.getCameraPropertiesForActiveCamera().getDollyYOffset() + "</Position Y>\n <Position Z>" + this.getCameraPropertiesForActiveCamera().getDollyZOffset() + "</Position Z>";
            textToWrite = textToWrite + "\n<Dolly Booleans>\n<Dolly>" + this.getCameraPropertiesForActiveCamera().isDolly() + "</Dolly>\n<Dolly X>" + this.getCameraPropertiesForActiveCamera().isDollyX() + "</Dolly X>\n<Dolly Y>" + this.getCameraPropertiesForActiveCamera().isDollyY() + "</Dolly Y>\n<Dolly Z>" + this.getCameraPropertiesForActiveCamera().isDollyY() + "</Dolly Z>\n</Dolly Booleans>";
            textToWrite = textToWrite + "\n</Dolly data>";
            textToWrite = textToWrite + "\n <Track data> \n <Position X>" + this.getCameraPropertiesForActiveCamera().getTrackingXOffset() + "</Position X>\n <Position Y>" + this.getCameraPropertiesForActiveCamera().getTrackingYOffset() + "</Position Y>\n <Position Z>" + this.getCameraPropertiesForActiveCamera().getTrackingZOffset() + "</Position Z>";
            textToWrite = textToWrite + "\n <Track Booleans>\n<Track>" + this.getCameraPropertiesForActiveCamera().isTracking() + "</Track>\n<Track X>" + this.getCameraPropertiesForActiveCamera().isTrackingX() + "</Track X>\n<Track Y>" + this.getCameraPropertiesForActiveCamera().isTrackingY() + "</Track Y>\n<Track Z>" + this.getCameraPropertiesForActiveCamera().isTracking() + "</Track Z>\n</Track Booleans>";
            textToWrite = textToWrite + "\n</Track data>";
            textToWrite = textToWrite + "\n<Fix Position>\n<Fix X>" + this.getCameraPropertiesForActiveCamera().getFixX() + "</Fix X>\n<Fix Y>" + this.getCameraPropertiesForActiveCamera().getFixY() + "</Fix Y>\n<Fix Z>" + this.getCameraPropertiesForActiveCamera().getFixZ() + "</Fix Z>\n</Fix Position>";
            textToWrite = textToWrite + "\n</Canvas 1>";
        }
        return textToWrite;
    }

    public String getXMLStyleRepresentationOfMainViewPort(boolean visible_ViewPort) {
        String textToWrite = "";
        textToWrite = textToWrite + "\n <Main Viewport> \n<Visible> " + visible_ViewPort + "</Visible>";
        textToWrite = textToWrite + "\n</Main Viewport>";
        return textToWrite;
    }

    public String getXMLStyleRepresentationOfClassViewPorts(ViewportAdapterAndCameraControllerHolder view3d, int canvasNumber) {
        String textToWrite = "";
        textToWrite = textToWrite + "\n<Canvas" + canvasNumber + ">";
        textToWrite = textToWrite + "\n<Viewport Camera X>" + view3d.getCameraController().getCamX() + "</Viewport Camera X>";
        textToWrite = textToWrite + "\n<Viewport Camera Y>" + view3d.getCameraController().getCamY() + "</Viewport Camera Y>";
        textToWrite = textToWrite + "\n<Viewport Camera Z>" + view3d.getCameraController().getCamZ() + "</Viewport Camera Z>";
        textToWrite = textToWrite + "\n <Dolly data> \n <Position X>" + view3d.getCameraController().getDollyXOffset() + "</Position X>\n <Position Y>" + view3d.getCameraController().getDollyYOffset() + "</Position Y>\n <Position Z>" + view3d.getCameraController().getDollyZOffset() + "</Position Z>";
        textToWrite = textToWrite + "\n<Dolly Booleans>\n<Dolly>" + view3d.getCameraController().isDolly() + "</Dolly>\n<Dolly X>" + view3d.getCameraController().isDollyX() + "</Dolly X>\n<Dolly Y>" + view3d.getCameraController().isDollyY() + "</Dolly Y>\n<Dolly Z>" + view3d.getCameraController().isDollyY() + "</Dolly Z>\n</Dolly Booleans>";
        textToWrite = textToWrite + "\n</Dolly data>";
        textToWrite = textToWrite + "\n <Track data> \n <Position X>" + view3d.getCameraController().getTrackingXOffset() + "</Position X>\n <Position Y>" + view3d.getCameraController().getTrackingYOffset() + "</Position Y>\n <Position Z>" + view3d.getCameraController().getTrackingZOffset() + "</Position Z>";
        textToWrite = textToWrite + "\n <Track Booleans>\n<Track>" + view3d.getCameraController().isTracking() + "</Track>\n<Track X>" + view3d.getCameraController().isTrackingX() + "</Track X>\n<Track Y>" + view3d.getCameraController().isTrackingY() + "</Track Y>\n<Track Z>" + view3d.getCameraController().isTracking() + "</Track Z>\n</Track Booleans>";
        textToWrite = textToWrite + "\n</Track data>";
        textToWrite = textToWrite + "\n<Fix Position>\n<Fix X>" + view3d.getCameraController().getFixX() + "</Fix X>\n<Fix Y>" + view3d.getCameraController().getFixY() + "</Fix Y>\n<Fix Z>" + view3d.getCameraController().getFixZ() + "</Fix Z>\n</Fix Position>";
        textToWrite = textToWrite + "\n</Canvas" + canvasNumber + ">";
        return textToWrite;
    }

    public boolean setMainViewPortFromXMLDescription(String importXML) {
        String textToLoad = XMLReaderUtility.getMiddleString((int)0, (String)importXML, (String)"<Main Viewport>", (String)"</Main Viewport>");
        String visible = XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Visible>", (String)"</Visible>");
        return visible.trim().equalsIgnoreCase("true");
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    private int sizeForSetUpOfMultiViews(String currentView) {
        int size = 1;
        if (currentView.equals("Split Screen")) {
            size = 2;
        }
        if (currentView.equals("Three Views")) {
            size = 3;
        }
        if (currentView.equals("Four Views")) {
            size = 4;
        }
        return size;
    }

    public void setupMultiViews(String xmlRepresentation, String currentView) {
        for (int i = 0; i < this.sizeForSetUpOfMultiViews(currentView); ++i) {
            int label = i + 1;
            String first = "<Canvas " + label + ">";
            String second = "</Canvas " + label + ">";
            String textToLoad = XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)first, (String)second);
            double posX = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Camera X>", (String)"</Camera X>"));
            double posY = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Camera Y>", (String)"</Camera Y>"));
            double posZ = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Camera Z>", (String)"</Camera Z>"));
            this.canvasPanels.get(i).getStandard3DView().getCameraController().setCameraPosition(posX, posY, posZ);
            String Dolly = XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Dolly data>", (String)"</Dolly data>");
            double DollyX = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Position X>", (String)"</Position X>"));
            double DollyY = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Position Y>", (String)"</Position Y>"));
            double DollyZ = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Position Z>", (String)"</Position Z>"));
            this.canvasPanels.get(i).getStandard3DView().getCameraController().setDollyOffsets(DollyX, DollyY, DollyZ);
            String Dolly_Boolean = XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Dolly>", (String)"</Dolly>");
            String Dolly_Boolean_X = XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Dolly X>", (String)"</Dolly X>");
            String Dolly_Boolean_Y = XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Dolly Y>", (String)"</Dolly Y>");
            String Dolly_Boolean_Z = XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Dolly Z>", (String)"</Dolly Z>");
            boolean dolly_set = true;
            boolean dolly_setX = true;
            boolean dolly_setY = true;
            boolean dolly_setZ = true;
            if (Dolly_Boolean.equals("false")) {
                dolly_set = false;
            }
            if (Dolly_Boolean_X.equals("false")) {
                dolly_setX = false;
            }
            if (Dolly_Boolean_Y.equals("false")) {
                dolly_setY = false;
            }
            if (Dolly_Boolean_Z.equals("false")) {
                dolly_setZ = false;
            }
            this.canvasPanels.get(i).getStandard3DView().getCameraController().setDolly(dolly_set, dolly_setX, dolly_setY, dolly_setZ);
            String Track = XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Track data>", (String)"</Track data>");
            double TrackX = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Position X>", (String)"</Position X>"));
            double TrackY = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Position Y>", (String)"</Position Y>"));
            double TrackZ = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Position Z>", (String)"</Position Z>"));
            this.canvasPanels.get(i).getStandard3DView().getCameraController().setTrackingOffsets(TrackX, TrackY, TrackZ);
            String Track_Boolean = XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Track>", (String)"</Track>");
            String Track_Boolean_X = XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Track X>", (String)"</Track X>");
            String Track_Boolean_Y = XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Track Y>", (String)"</Track Y>");
            String Track_Boolean_Z = XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Track Z>", (String)"</Track Z>");
            boolean track_set = true;
            boolean track_setX = true;
            boolean track_setY = true;
            boolean track_setZ = true;
            if (Track_Boolean.equals("false")) {
                track_set = false;
            }
            if (Track_Boolean_X.equals("false")) {
                track_setX = false;
            }
            if (Track_Boolean_Y.equals("false")) {
                track_setY = false;
            }
            if (Track_Boolean_Z.equals("false")) {
                track_setZ = false;
            }
            this.canvasPanels.get(i).getStandard3DView().getCameraController().setTracking(track_set, track_setX, track_setY, track_setZ);
            String Fix = XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Fix Position>", (String)"</Fix Position>");
            double FixX = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Fix, (String)"<Fix X>", (String)"</Fix X>"));
            double FixY = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Fix, (String)"<Fix Y>", (String)"</Fix Y>"));
            double FixZ = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Fix, (String)"<Fix Z>", (String)"</Fix Z>"));
            this.canvasPanels.get(i).getStandard3DView().getCameraController().setFixPosition(FixX, FixY, FixZ);
        }
    }

    public void setupMultiViews_ViewportWindows(String xmlRepresentation, String currentView) {
        for (int i = 0; i < this.sizeForSetUpOfMultiViews(currentView); ++i) {
            int label = i + 1;
            String first = "<Canvas" + label + ">";
            String second = "</Canvas" + label + ">";
            String textToLoad = XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)first, (String)second);
            double posX = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Viewport Camera X>", (String)"</Viewport Camera X>"));
            double posY = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Viewport Camera Y>", (String)"</Viewport Camera Y>"));
            double posZ = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Viewport Camera Z>", (String)"</Viewport Camera Z>"));
            this.canvasPanels.get(i).getStandard3DView().getCameraController().setCameraPosition(posX, posY, posZ);
            String Dolly = XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Dolly data>", (String)"</Dolly data>");
            double DollyX = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Position X>", (String)"</Position X>"));
            double DollyY = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Position Y>", (String)"</Position Y>"));
            double DollyZ = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Position Z>", (String)"</Position Z>"));
            this.canvasPanels.get(i).getStandard3DView().getCameraController().setDollyOffsets(DollyX, DollyY, DollyZ);
            String Dolly_Boolean = XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Dolly>", (String)"</Dolly>");
            String Dolly_Boolean_X = XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Dolly X>", (String)"</Dolly X>");
            String Dolly_Boolean_Y = XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Dolly Y>", (String)"</Dolly Y>");
            String Dolly_Boolean_Z = XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Dolly Z>", (String)"</Dolly Z>");
            boolean dolly_set = true;
            boolean dolly_setX = true;
            boolean dolly_setY = true;
            boolean dolly_setZ = true;
            if (Dolly_Boolean.equals("false")) {
                dolly_set = false;
            }
            if (Dolly_Boolean_X.equals("false")) {
                dolly_setX = false;
            }
            if (Dolly_Boolean_Y.equals("false")) {
                dolly_setY = false;
            }
            if (Dolly_Boolean_Z.equals("false")) {
                dolly_setZ = false;
            }
            this.canvasPanels.get(i).getStandard3DView().getCameraController().setDolly(dolly_set, dolly_setX, dolly_setY, dolly_setZ);
            String Track = XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Track data>", (String)"</Track data>");
            double TrackX = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Position X>", (String)"</Position X>"));
            double TrackY = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Position Y>", (String)"</Position Y>"));
            double TrackZ = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Position Z>", (String)"</Position Z>"));
            this.canvasPanels.get(i).getStandard3DView().getCameraController().setTrackingOffsets(TrackX, TrackY, TrackZ);
            String Track_Boolean = XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Track>", (String)"</Track>");
            String Track_Boolean_X = XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Track X>", (String)"</Track X>");
            String Track_Boolean_Y = XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Track Y>", (String)"</Track Y>");
            String Track_Boolean_Z = XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Track Z>", (String)"</Track Z>");
            boolean track_set = true;
            boolean track_setX = true;
            boolean track_setY = true;
            boolean track_setZ = true;
            if (Track_Boolean.equals("false")) {
                track_set = false;
            }
            if (Track_Boolean_X.equals("false")) {
                track_setX = false;
            }
            if (Track_Boolean_Y.equals("false")) {
                track_setY = false;
            }
            if (Track_Boolean_Z.equals("false")) {
                track_setZ = false;
            }
            this.canvasPanels.get(i).getStandard3DView().getCameraController().setTracking(track_set, track_setX, track_setY, track_setZ);
            String Fix = XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Fix Position>", (String)"</Fix Position>");
            double FixX = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Fix, (String)"<Fix X>", (String)"</Fix X>"));
            double FixY = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Fix, (String)"<Fix Y>", (String)"</Fix Y>"));
            double FixZ = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Fix, (String)"<Fix Z>", (String)"</Fix Z>"));
            this.canvasPanels.get(i).getStandard3DView().getCameraController().setFixPosition(FixX, FixY, FixZ);
        }
    }

    public void setCameraTracking(boolean cameraTracking) {
    }

    private void setCameraConfiguration(TrackingDollyCameraController camera, CameraConfiguration config, YoVariableHolder holder, CameraMountList mountList) {
        camera.setConfiguration(config, mountList);
        CameraTrackAndDollyYoVariablesHolder cameraTrackAndDollyYoVariablesHolder = (CameraTrackAndDollyYoVariablesHolder)camera.getCameraTrackAndDollyVariablesHolder();
        YoDouble trackXVar = (YoDouble)holder.findVariable(config.getTrackXVar());
        YoDouble trackYVar = (YoDouble)holder.findVariable(config.getTrackYVar());
        YoDouble trackZVar = (YoDouble)holder.findVariable(config.getTrackZVar());
        cameraTrackAndDollyYoVariablesHolder.setTrackingVars(trackXVar, trackYVar, trackZVar);
        YoDouble dollyXVar = (YoDouble)holder.findVariable(config.getDollyXVar());
        YoDouble dollyYVar = (YoDouble)holder.findVariable(config.getDollyYVar());
        YoDouble dollyZVar = (YoDouble)holder.findVariable(config.getDollyZVar());
        cameraTrackAndDollyYoVariablesHolder.setDollyVars(dollyXVar, dollyYVar, dollyZVar);
        if (config.getFieldOfViewVar() != null) {
            YoDouble fieldOfViewVar = (YoDouble)this.yoVariableHolder.findVariable(config.getFieldOfViewVar());
            cameraTrackAndDollyYoVariablesHolder.setFieldOfViewVar(fieldOfViewVar);
        }
        if (this.standardGUIActions != null) {
            this.standardGUIActions.makeCheckBoxesConsistentWithCamera();
        }
    }
}

