/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.shape.primitives.Ramp3D;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;
import us.ihmc.simulationconstructionset.util.ground.TerrainObject3D;

public class RotatableRampTerrainObject
implements TerrainObject3D,
HeightMapWithNormals {
    private final double xGlobalMin;
    private final double xGlobalMax;
    private final double yGlobalMin;
    private final double yGlobalMax;
    private final double xLocalMin;
    private final double xLocalMax;
    private final double yLocalMin;
    private final double yLocalMax;
    private final double height;
    private final double run;
    private final BoundingBox3D boundingBox;
    private RigidBodyTransform transform;
    private RigidBodyTransform inverseTransform;
    Point3D pointToTransform = new Point3D();
    private Graphics3DObject linkGraphics;
    private final ArrayList<Shape3DReadOnly> terrainCollisionShapes = new ArrayList();

    public RotatableRampTerrainObject(double xCenter, double yCenter, double run, double width, double height, double degreesYaw, AppearanceDefinition appearance) {
        double absRun;
        boolean slopeDown = run < 0.0;
        double radiansYaw = Math.toRadians(degreesYaw);
        this.transform = new RigidBodyTransform();
        RotationMatrix a1 = new RotationMatrix();
        a1.setToYawOrientation(radiansYaw + (slopeDown ? Math.PI : 0.0));
        this.transform.getRotation().set((RotationMatrixReadOnly)a1);
        this.transform.getTranslation().set((Tuple3DReadOnly)new Vector3D(xCenter, yCenter, 0.0));
        this.inverseTransform = new RigidBodyTransform();
        this.inverseTransform.setAndInvert((RigidBodyTransformReadOnly)this.transform);
        Point2D[] rampCorners = new Point2D[]{this.transformToGlobalCoordinates(new Point2D(-run / 2.0, width / 2.0)), this.transformToGlobalCoordinates(new Point2D(run / 2.0, width / 2.0)), this.transformToGlobalCoordinates(new Point2D(-run / 2.0, -width / 2.0)), this.transformToGlobalCoordinates(new Point2D(run / 2.0, -width / 2.0))};
        this.height = height;
        this.run = absRun = Math.abs(run);
        this.xLocalMin = -absRun / 2.0;
        this.xLocalMax = absRun / 2.0;
        this.yLocalMin = -width / 2.0;
        this.yLocalMax = width / 2.0;
        this.xGlobalMin = Math.min(Math.min(rampCorners[0].getX(), rampCorners[1].getX()), Math.min(rampCorners[2].getX(), rampCorners[3].getX()));
        this.xGlobalMax = Math.max(Math.max(rampCorners[0].getX(), rampCorners[1].getX()), Math.max(rampCorners[2].getX(), rampCorners[3].getX()));
        this.yGlobalMin = Math.min(Math.min(rampCorners[0].getY(), rampCorners[1].getY()), Math.min(rampCorners[2].getY(), rampCorners[3].getY()));
        this.yGlobalMax = Math.max(Math.max(rampCorners[0].getY(), rampCorners[1].getY()), Math.max(rampCorners[2].getY(), rampCorners[3].getY()));
        this.linkGraphics = new Graphics3DObject();
        this.linkGraphics.translate(xCenter, yCenter, 0.0);
        this.linkGraphics.rotate(radiansYaw + (slopeDown ? Math.PI : 0.0), Axis3D.Z);
        this.linkGraphics.addWedge(absRun, width, height, appearance);
        Point3D minPoint = new Point3D(this.xGlobalMin, this.yGlobalMin, Double.NEGATIVE_INFINITY);
        Point3D maxPoint = new Point3D(this.xGlobalMax, this.yGlobalMax, height);
        this.boundingBox = new BoundingBox3D((Point3DReadOnly)minPoint, (Point3DReadOnly)maxPoint);
        Ramp3D ramp3DShape = new Ramp3D((RigidBodyTransformReadOnly)this.transform, absRun, width, height);
        this.terrainCollisionShapes.add((Shape3DReadOnly)ramp3DShape);
    }

    public RotatableRampTerrainObject(double xCenter, double yCenter, double run, double width, double height, double degreesYaw) {
        this(xCenter, yCenter, run, width, height, degreesYaw, YoAppearance.Black());
    }

    private Point2D transformToGlobalCoordinates(Point2D localCoordinate) {
        this.pointToTransform.setX(localCoordinate.getX());
        this.pointToTransform.setY(localCoordinate.getY());
        this.pointToTransform.setZ(0.0);
        this.transform.transform((Point3DBasics)this.pointToTransform);
        return new Point2D(this.pointToTransform.getX(), this.pointToTransform.getY());
    }

    private Point2D transformToLocalCoordinates(Point2D globalCoordinate) {
        this.pointToTransform.setX(globalCoordinate.getX());
        this.pointToTransform.setY(globalCoordinate.getY());
        this.pointToTransform.setZ(0.0);
        this.inverseTransform.transform((Point3DBasics)this.pointToTransform);
        return new Point2D(this.pointToTransform.getX(), this.pointToTransform.getY());
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        return this.linkGraphics;
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double heightAt = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, heightAt, normalToPack);
        return heightAt;
    }

    public double heightAt(double xGlobal, double yGlobal, double zGlobal) {
        double yLocal;
        Point2D localPoint = this.transformToLocalCoordinates(new Point2D(xGlobal, yGlobal));
        double xLocal = localPoint.getX();
        if (this.localPointOnRamp(xLocal, yLocal = localPoint.getY())) {
            return (xLocal - this.xLocalMin) / this.run * this.height;
        }
        return 0.0;
    }

    private boolean localPointOnRamp(double xLocal, double yLocal) {
        return xLocal >= this.xLocalMin && xLocal <= this.xLocalMax && yLocal >= this.yLocalMin && yLocal <= this.yLocalMax;
    }

    public void surfaceNormalAt(double xGlobal, double yGlobal, double z, Vector3DBasics normal) {
        Point2D localPoint = this.transformToLocalCoordinates(new Point2D(xGlobal, yGlobal));
        double xLocal = localPoint.getX();
        double yLocal = localPoint.getY();
        double threshhold = 0.015;
        normal.setX(0.0);
        normal.setY(0.0);
        normal.setZ(1.0);
        if (!this.localPointOnRamp(xLocal, yLocal)) {
            return;
        }
        if (z > this.heightAt(xGlobal, yGlobal, z) - threshhold) {
            normal.setX(this.height);
            normal.setY(0.0);
            normal.setZ(-this.run);
            normal.normalize();
            if (normal.getZ() < 0.0) {
                normal.scale(-1.0);
            }
        } else if (Math.abs(xLocal - this.xLocalMax) < threshhold) {
            if (this.xLocalMax > this.xLocalMin) {
                normal.setX(1.0);
            } else {
                normal.setX(-1.0);
            }
            normal.setY(0.0);
            normal.setZ(0.0);
        } else if (Math.abs(yLocal - this.yLocalMin) < threshhold) {
            normal.setX(0.0);
            normal.setY(-1.0);
            normal.setZ(0.0);
        } else if (Math.abs(yLocal - this.yLocalMax) < threshhold) {
            normal.setX(0.0);
            normal.setY(1.0);
            normal.setZ(0.0);
        }
        this.transform.transform(normal);
    }

    public void closestIntersectionTo(double x, double y, double z, Point3DBasics intersection) {
        intersection.setX(x);
        intersection.setY(y);
        intersection.setZ(this.heightAt(x, y, z));
    }

    public void closestIntersectionAndNormalAt(double x, double y, double z, Point3D intersection, Vector3D normal) {
        this.closestIntersectionTo(x, y, z, (Point3DBasics)intersection);
        this.surfaceNormalAt(x, y, z, (Vector3DBasics)normal);
    }

    public boolean checkIfInside(double x, double y, double z, Point3DBasics intersectionToPack, Vector3DBasics normalToPack) {
        this.closestIntersectionTo(x, y, z, intersectionToPack);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return z < intersectionToPack.getZ();
    }

    public boolean isClose(double x, double y, double z) {
        return this.boundingBox.isXYInsideInclusive(x, y);
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }

    public HeightMapWithNormals getHeightMapIfAvailable() {
        return this;
    }

    public List<Shape3DReadOnly> getTerrainCollisionShapes() {
        return this.terrainCollisionShapes;
    }
}

