/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import us.ihmc.graphicsDescription.graphInterfaces.SelectedVariableHolder;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.commands.AllCommandsExecutor;
import us.ihmc.simulationconstructionset.commands.SelectGraphConfigurationCommandExecutor;
import us.ihmc.simulationconstructionset.gui.GraphArrayPanel;
import us.ihmc.simulationconstructionset.gui.StandardGUIActions;
import us.ihmc.simulationconstructionset.gui.config.Configuration;
import us.ihmc.simulationconstructionset.gui.config.ConfigurationList;
import us.ihmc.simulationconstructionset.gui.config.GraphConfigurationList;
import us.ihmc.simulationconstructionset.gui.config.GraphGroup;
import us.ihmc.simulationconstructionset.gui.config.GraphGroupList;
import us.ihmc.simulationconstructionset.gui.config.GraphGroupSelector;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ExportGraphsToFileGenerator;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.GUIEnablerAndDisabler;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.LoadGraphGroupDialogGenerator;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.PrintGraphsDialogGenerator;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.SaveGraphConfigurationDialogGenerator;
import us.ihmc.yoVariables.buffer.YoBuffer;

public class GraphArrayWindow
implements SelectGraphConfigurationCommandExecutor,
GraphGroupSelector {
    protected final GraphArrayPanel myGraphArrayPanel;
    private final JFrame frame;
    private final String name;
    private final ConfigurationList configurationList;
    private final GraphGroupList graphGroupList;
    private final GraphConfigurationList graphConfigurationList;
    private StandardGUIActions windowGUIActions;
    private String selectedConfigurationName;
    private String selectedGraphGroupName;

    public GraphArrayWindow(AllCommandsExecutor allCommandsExecutor, SimulationConstructionSet sim, GUIEnablerAndDisabler guiEnablerAndDisabler, ConfigurationList configurationList, GraphGroupList graphGroupList, String graphGroupName, GraphConfigurationList graphConfigurationList, SelectedVariableHolder selectedVariableHolder, YoBuffer dataBuffer, StandardGUIActions mainGUIActions, int screenID, Point windowLocation, Dimension windowSize, boolean maximizeWindow) {
        String windowName;
        this.configurationList = configurationList;
        this.graphGroupList = graphGroupList;
        this.graphConfigurationList = graphConfigurationList;
        GraphicsConfiguration configurationToUse = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = graphicsEnvironment.getScreenDevices();
        for (int j = 0; j < devices.length; ++j) {
            if (devices[j].toString().indexOf("screen=" + screenID) < 0) continue;
            configurationToUse = devices[j].getDefaultConfiguration();
        }
        if (graphGroupName != null) {
            windowName = "Graph Window: " + graphGroupName;
            this.name = graphGroupName;
        } else {
            windowName = "Graph Window";
            this.name = "Unnamed";
        }
        this.frame = new JFrame(windowName, configurationToUse);
        this.frame.setName(windowName);
        this.myGraphArrayPanel = new GraphArrayPanel(selectedVariableHolder, dataBuffer, this.frame, sim.getGUI());
        this.windowGUIActions = new StandardGUIActions();
        SaveGraphConfigurationDialogGenerator saveGraphConfigurationDialogConstructor = new SaveGraphConfigurationDialogGenerator(guiEnablerAndDisabler, this.frame, this.myGraphArrayPanel);
        LoadGraphGroupDialogGenerator loadGraphGroupDialogConstructor = new LoadGraphGroupDialogGenerator(sim, sim.getStandardSimulationGUI(), this, this.frame, this.myGraphArrayPanel);
        PrintGraphsDialogGenerator printGraphsDialogConstructor = new PrintGraphsDialogGenerator(this.myGraphArrayPanel);
        ExportGraphsToFileGenerator exportGraphsToFileConstructor = new ExportGraphsToFileGenerator(sim, this.frame, this.myGraphArrayPanel, sim.getStandardSimulationGUI());
        this.windowGUIActions.createGraphWindowActions(mainGUIActions, this.myGraphArrayPanel, saveGraphConfigurationDialogConstructor, loadGraphGroupDialogConstructor, printGraphsDialogConstructor, exportGraphsToFileConstructor);
        JPanel buttonPanel = this.windowGUIActions.createGraphWindowButtons();
        JMenuBar menuBar = this.windowGUIActions.createGraphWindowMenus();
        this.frame.setJMenuBar(menuBar);
        this.frame.getContentPane().add((Component)buttonPanel, "South");
        JPanel graphArrayAndButtonPanel = new JPanel(new BorderLayout());
        graphArrayAndButtonPanel.add("Center", this.myGraphArrayPanel);
        JPanel graphButtonPanel = this.myGraphArrayPanel.createGraphButtonPanel();
        graphArrayAndButtonPanel.add("South", graphButtonPanel);
        this.frame.getContentPane().add(graphArrayAndButtonPanel);
        this.selectGraphGroup(graphGroupName);
        if (windowLocation != null) {
            this.frame.setLocation(windowLocation);
        }
        this.frame.pack();
        if (maximizeWindow) {
            this.frame.setExtendedState(6);
        } else if (windowSize != null) {
            this.frame.setSize(windowSize);
        }
        this.frame.setVisible(true);
    }

    public int getScreenID() {
        String idString = this.frame.getGraphicsConfiguration().getDevice().getIDstring();
        return Integer.parseInt(idString.substring(idString.length() - 1, idString.length()));
    }

    public Dimension getWindowSize() {
        return this.frame.getSize();
    }

    public Point getWindowLocationOnScreen() {
        Point locationOnScreen = this.frame.getLocationOnScreen();
        return locationOnScreen;
    }

    public String getName() {
        return this.name;
    }

    public JFrame getJFrame() {
        return this.frame;
    }

    public StandardGUIActions getGUIActions() {
        return this.windowGUIActions;
    }

    public void updateGraphs() {
        this.myGraphArrayPanel.repaintGraphs();
    }

    public boolean isVisable() {
        return this.frame.isVisible();
    }

    public void closeWindow() {
        this.frame.dispose();
    }

    public void repaint() {
        this.myGraphArrayPanel.repaint();
    }

    public GraphArrayPanel getGraphArrayPanel() {
        return this.myGraphArrayPanel;
    }

    public boolean isPainting() {
        return this.myGraphArrayPanel.isPaintingPanel();
    }

    public void updateGUI() {
        this.myGraphArrayPanel.repaint();
    }

    @Override
    public void selectGraphConfiguration(String name) {
        this.selectedConfigurationName = name;
        Configuration config = this.configurationList.getConfiguration(name);
        if (config == null) {
            return;
        }
        this.selectGraphGroup(config.getGraphGroupName());
    }

    @Override
    public void selectGraphGroup(String name) {
        this.selectedGraphGroupName = name;
        if (this.myGraphArrayPanel == null) {
            return;
        }
        GraphGroup group = this.graphGroupList.getGraphGroup(name);
        if (group == null) {
            return;
        }
        this.myGraphArrayPanel.removeAllGraphs();
        this.myGraphArrayPanel.setNumColumns(group.getNumColumns());
        ArrayList<String[][]> graphVars = group.getGraphVars();
        for (int i = 0; i < graphVars.size(); ++i) {
            this.setupGraph(graphVars.get(i));
        }
    }

    public void setupGraph(String ... varnames) {
        this.myGraphArrayPanel.setupGraph(varnames);
    }

    public void setupGraph(String[][] varnames) {
        if (varnames.length > 1 && varnames[1].length > 0) {
            this.myGraphArrayPanel.setupGraph(varnames[0], this.graphConfigurationList.getGraphConfiguration(varnames[1][0]));
        } else {
            this.myGraphArrayPanel.setupGraph(varnames[0]);
        }
    }

    public void zoomFullView() {
        this.myGraphArrayPanel.zoomFullView();
    }

    public boolean allowTickUpdatesNow() {
        return this.myGraphArrayPanel.allowTickUpdatesNow();
    }

    public void closeAndDispose() {
        if (this.windowGUIActions != null) {
            this.windowGUIActions.closeAndDispose();
            this.windowGUIActions = null;
        }
        this.frame.setMenuBar(null);
        this.frame.removeAll();
        this.frame.dispose();
    }
}

