/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.commands.AllCommandsExecutor;
import us.ihmc.simulationconstructionset.commands.ViewportSelectorCommandListener;
import us.ihmc.simulationconstructionset.gui.EventDispatchThreadHelper;
import us.ihmc.simulationconstructionset.gui.GUIConfigurationSaveAndLoad;
import us.ihmc.simulationconstructionset.gui.GraphArrayWindow;
import us.ihmc.simulationconstructionset.gui.StandardSimulationGUI;
import us.ihmc.simulationconstructionset.gui.ViewportWindow;
import us.ihmc.simulationconstructionset.gui.YoVariableSliderWindow;
import us.ihmc.yoVariables.buffer.YoBuffer;
import us.ihmc.yoVariables.buffer.interfaces.KeyPointsChangedListener;

public class StandardAllCommandsExecutor
implements AllCommandsExecutor {
    private StandardSimulationGUI standardSimulationGUI;
    private SimulationConstructionSet simulationConstructionSet;
    private YoBuffer dataBuffer;
    private ArrayList<ViewportSelectorCommandListener> viewportSelectorCommandListenersToRegister = new ArrayList();
    private ArrayList<KeyPointsChangedListener> keyPointsChangedListenersToRegister = new ArrayList();
    private boolean alreadyStartedClosing = false;

    public void setup(SimulationConstructionSet simulationConstructionSet, StandardSimulationGUI standardSimulationGUI, YoBuffer dataBuffer) {
        if (this.simulationConstructionSet != null) {
            throw new RuntimeException("this.simulationConstructionSet != null");
        }
        if (this.standardSimulationGUI != null) {
            throw new RuntimeException("this.standardSimulationGUI != null");
        }
        if (this.dataBuffer != null) {
            throw new RuntimeException("this.dataBuffer != null");
        }
        this.simulationConstructionSet = simulationConstructionSet;
        this.standardSimulationGUI = standardSimulationGUI;
        this.dataBuffer = dataBuffer;
        for (ViewportSelectorCommandListener viewportSelectorCommandListener : this.viewportSelectorCommandListenersToRegister) {
            standardSimulationGUI.registerViewportSelectorCommandListener(viewportSelectorCommandListener);
        }
        for (KeyPointsChangedListener keyPointsChangedListener : this.keyPointsChangedListenersToRegister) {
            dataBuffer.getKeyPointsHandler().addListener(keyPointsChangedListener);
        }
    }

    @Override
    public void addCameraKey() {
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.addCameraKey();
        }
    }

    public List<Integer> getCameraKeyPoints() {
        return this.standardSimulationGUI.getCameraKeyPoints();
    }

    @Override
    public void addKeyPoint() {
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.setKeyPoint();
        }
    }

    public List<Integer> getKeyPoints() {
        return this.standardSimulationGUI.getKeyPoints();
    }

    @Override
    public GraphArrayWindow createNewGraphWindow() {
        return this.createNewGraphWindow(null);
    }

    @Override
    public GraphArrayWindow createNewGraphWindow(String graphGroupName) {
        String mainFrameDeviceId = this.standardSimulationGUI.getFrame().getGraphicsConfiguration().getDevice().getIDstring();
        String lastCharacter = mainFrameDeviceId.substring(mainFrameDeviceId.length() - 1);
        int screenIdToDisplay = 0;
        if (StringUtils.isNumeric((CharSequence)lastCharacter)) {
            screenIdToDisplay = Integer.valueOf(lastCharacter);
        }
        return this.createNewGraphWindow(graphGroupName, screenIdToDisplay, null, null, false);
    }

    @Override
    public GraphArrayWindow createNewGraphWindow(String graphGroupName, int screenID, Point windowLocation, Dimension windowSize, boolean maximizeWindow) {
        if (this.standardSimulationGUI != null) {
            return this.standardSimulationGUI.createNewGraphWindow(graphGroupName, screenID, windowLocation, windowSize, maximizeWindow);
        }
        return null;
    }

    @Override
    public GraphArrayWindow getGraphArrayWindow(String windowName) {
        if (this.standardSimulationGUI != null) {
            return this.standardSimulationGUI.getGraphArrayWindow(windowName);
        }
        return null;
    }

    @Override
    public ViewportWindow createNewViewportWindow() {
        return this.createNewViewportWindow(null);
    }

    @Override
    public ViewportWindow createNewViewportWindow(String viewportName) {
        String mainFrameDeviceId = this.standardSimulationGUI.getFrame().getGraphicsConfiguration().getDevice().getIDstring();
        String lastCharacter = mainFrameDeviceId.substring(mainFrameDeviceId.length() - 1);
        int screenIdToDisplay = 0;
        if (StringUtils.isNumeric((CharSequence)lastCharacter)) {
            screenIdToDisplay = Integer.valueOf(lastCharacter);
        }
        return this.createNewViewportWindow(viewportName, screenIdToDisplay, false);
    }

    @Override
    public ViewportWindow createNewViewportWindow(String viewportName, int screenID, boolean maximizeWindow) {
        if (this.standardSimulationGUI != null) {
            return this.standardSimulationGUI.createNewViewportWindow(viewportName, screenID, maximizeWindow);
        }
        return null;
    }

    @Override
    public ViewportWindow getViewportWindow(String windowName) {
        if (this.standardSimulationGUI != null) {
            return this.standardSimulationGUI.getViewportWindow(windowName);
        }
        return null;
    }

    @Override
    public YoVariableSliderWindow createNewYoVariableSliderWindow() {
        return this.createNewYoVariableSliderWindow(null);
    }

    @Override
    public YoVariableSliderWindow createNewYoVariableSliderWindow(String viewportName) {
        String mainFrameDeviceId = this.standardSimulationGUI.getFrame().getGraphicsConfiguration().getDevice().getIDstring();
        String lastCharacter = mainFrameDeviceId.substring(mainFrameDeviceId.length() - 1);
        int screenIdToDisplay = 0;
        if (StringUtils.isNumeric((CharSequence)lastCharacter)) {
            screenIdToDisplay = Integer.valueOf(lastCharacter);
        }
        return this.createNewYoVariableSliderWindow(viewportName, screenIdToDisplay, false);
    }

    @Override
    public YoVariableSliderWindow createNewYoVariableSliderWindow(String viewportName, int screenID, boolean maximizeWindow) {
        if (this.standardSimulationGUI != null) {
            return this.standardSimulationGUI.createNewParameterSliderWindow(viewportName, screenID, maximizeWindow);
        }
        return null;
    }

    @Override
    public YoVariableSliderWindow getParameterSliderWindow(String windowName) {
        throw new RuntimeException("method not implemented");
    }

    @Override
    public void cropBuffer() {
        this.dataBuffer.cropBuffer();
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.zoomFullView();
        }
    }

    @Override
    public void packBuffer() {
        this.dataBuffer.shiftBuffer();
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.updateGraphs();
        }
    }

    @Override
    public void cutBuffer() {
        this.dataBuffer.cutBuffer();
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.zoomFullView();
        }
    }

    @Override
    public void thinBuffer(int keepEveryNthPoint) {
        this.dataBuffer.thinData(keepEveryNthPoint);
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.zoomFullView();
        }
    }

    @Override
    public void gotoInPoint() {
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.gotoInPoint();
        }
    }

    @Override
    public void gotoOutPoint() {
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.gotoOutPoint();
        }
    }

    @Override
    public void nextCameraKey() {
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.nextCameraKey();
        }
    }

    @Override
    public void play() {
        this.simulationConstructionSet.play();
    }

    @Override
    public void previousCameraKey() {
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.previousCameraKey();
        }
    }

    @Override
    public void removeCameraKey() {
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.removeCameraKey();
        }
    }

    @Override
    public void setInPoint() {
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.setInPoint();
        } else {
            this.dataBuffer.setInPoint();
        }
    }

    @Override
    public void setOutPoint() {
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.setOutPoint();
        } else {
            this.dataBuffer.setOutPoint();
        }
    }

    public void setInOutPointFullBuffer() {
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.setInOutPointFullBuffer();
        } else {
            this.dataBuffer.setInOutPointFullBuffer();
        }
    }

    @Override
    public void simulate() {
        this.simulationConstructionSet.simulate();
    }

    @Override
    public boolean isSimulating() {
        return this.simulationConstructionSet.isSimulating();
    }

    @Override
    public void stepBackward() {
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.stepBackward();
        } else {
            this.dataBuffer.tickAndReadFromBuffer(-1);
        }
    }

    @Override
    public void stepForward() {
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.stepForward();
        } else {
            this.dataBuffer.tickAndReadFromBuffer(1);
        }
    }

    @Override
    public void stop() {
        this.simulationConstructionSet.stop();
    }

    @Override
    public void toggleCameraKeyMode() {
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.toggleCameraKeyMode();
        }
    }

    public boolean areKeyPointsEnabled() {
        return this.dataBuffer.getKeyPointsHandler().areKeyPointsEnabled();
    }

    public void toggleKeyPoints() {
        this.dataBuffer.getKeyPointsHandler().toggleKeyPoints();
    }

    public void addListener(KeyPointsChangedListener listener) {
        if (this.dataBuffer != null) {
            this.dataBuffer.getKeyPointsHandler().addListener(listener);
        } else {
            this.keyPointsChangedListenersToRegister.add(listener);
        }
    }

    @Override
    public void selectViewport(String viewportName) {
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.selectViewport(viewportName);
        }
    }

    @Override
    public void hideViewport() {
        if (this.standardSimulationGUI != null) {
            EventDispatchThreadHelper.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StandardAllCommandsExecutor.this.standardSimulationGUI.hideViewport();
                }
            });
        }
    }

    @Override
    public void showViewport() {
        if (this.standardSimulationGUI != null) {
            EventDispatchThreadHelper.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StandardAllCommandsExecutor.this.standardSimulationGUI.showViewport();
                }
            });
        }
    }

    @Override
    public boolean isViewportHidden() {
        if (this.standardSimulationGUI != null) {
            return this.standardSimulationGUI.isViewportHidden();
        }
        return true;
    }

    @Override
    public void registerViewportSelectorCommandListener(ViewportSelectorCommandListener commandListener) {
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.registerViewportSelectorCommandListener(commandListener);
        } else {
            this.viewportSelectorCommandListenersToRegister.add(commandListener);
        }
    }

    @Override
    public void zoomIn() {
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.zoomIn();
        }
    }

    @Override
    public void zoomOut() {
        if (this.standardSimulationGUI != null) {
            this.standardSimulationGUI.zoomOut();
        }
    }

    @Override
    public void selectGUIConfigFromFile(String fullPath) {
        GUIConfigurationSaveAndLoad defaultSaveAndLoad = new GUIConfigurationSaveAndLoad(this.simulationConstructionSet, this.standardSimulationGUI);
        defaultSaveAndLoad.loadGUIConfiguration(fullPath);
    }

    @Override
    public void setPlaybackRealTimeRate(double realtimeRate) {
        this.simulationConstructionSet.setPlaybackRealTimeRate(realtimeRate);
    }

    @Override
    public double getPlaybackRealTimeRate() {
        return this.simulationConstructionSet.getPlaybackRealTimeRate();
    }

    public int getInPoint() {
        return this.simulationConstructionSet.getInPoint();
    }

    public void setCurrentIndex(int index) {
        this.simulationConstructionSet.setCurrentIndex(index);
    }

    public boolean tickAndReadFromBuffer(int ticks) {
        return this.simulationConstructionSet.tickAndReadFromBuffer(ticks);
    }

    public boolean tickButDoNotNotifySimulationRewoundListeners(int ticks) {
        return this.simulationConstructionSet.tickButDoNotNotifySimulationRewoundListeners(ticks);
    }

    public int getCurrentIndex() {
        return this.simulationConstructionSet.getCurrentIndex();
    }

    public boolean isIndexBetweenBounds(int indexToCheck) {
        return this.simulationConstructionSet.isIndexBetweenBounds(indexToCheck);
    }

    public int getOutPoint() {
        return this.simulationConstructionSet.getOutPoint();
    }

    public int getBufferSize() {
        return this.simulationConstructionSet.getBufferSize();
    }

    @Override
    public void exportSnapshot(File snapshotFile) {
        this.simulationConstructionSet.exportSnapshot(snapshotFile);
    }

    @Override
    public void enableGUIComponents() {
        this.simulationConstructionSet.enableGUIComponents();
    }

    @Override
    public void disableGUIComponents() {
        this.simulationConstructionSet.disableGUIComponents();
    }

    @Override
    public void closeAndDispose() {
        if (this.alreadyStartedClosing) {
            return;
        }
        this.alreadyStartedClosing = true;
        this.standardSimulationGUI = null;
        this.simulationConstructionSet = null;
        this.dataBuffer = null;
        if (this.viewportSelectorCommandListenersToRegister != null) {
            for (ViewportSelectorCommandListener viewportSelectorCommandListener : this.viewportSelectorCommandListenersToRegister) {
                viewportSelectorCommandListener.closeAndDispose();
            }
            this.viewportSelectorCommandListenersToRegister.clear();
        }
        if (this.keyPointsChangedListenersToRegister != null) {
            this.keyPointsChangedListenersToRegister.clear();
        }
        this.viewportSelectorCommandListenersToRegister = null;
        this.keyPointsChangedListenersToRegister = null;
    }
}

