/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.KinematicPoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.JointPhysics;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ExternalForcePoint
extends KinematicPoint {
    private static final long serialVersionUID = -7715587266631433612L;
    private final YoFrameVector3D force;
    private final YoFrameVector3D moment;
    private final YoFrameVector3D impulse;
    private RotationMatrix R0_coll = new RotationMatrix();
    private RotationMatrix Rcoll_0 = new RotationMatrix();
    private RotationMatrix Rk_coll = new RotationMatrix();
    private RotationMatrix Rk_coll2 = new RotationMatrix();
    private Vector3D u_coll = new Vector3D();
    private Matrix3D Ki_collision_total = new Matrix3D();
    private final Vector3D zAxis = new Vector3D();
    private final Vector3D yAxis = new Vector3D();
    private final Vector3D xAxis = new Vector3D();
    public boolean active = false;
    private final Vector3D otherObjectVelocity = new Vector3D();

    public ExternalForcePoint(String name, Robot robot) {
        this(name, null, robot.getRobotsYoRegistry());
    }

    public ExternalForcePoint(String name, YoRegistry registry) {
        this(name, null, registry);
    }

    public ExternalForcePoint(String name, Tuple3DReadOnly offset, Robot robot) {
        this(name, offset, robot.getRobotsYoRegistry());
    }

    public ExternalForcePoint(String name, Tuple3DReadOnly offset, YoRegistry registry) {
        super(name, offset, registry);
        this.force = new YoFrameVector3D(name + "_f", "", ReferenceFrame.getWorldFrame(), registry);
        this.moment = new YoFrameVector3D(name + "_m", "", ReferenceFrame.getWorldFrame(), registry);
        this.impulse = new YoFrameVector3D(name + "_p", "", ReferenceFrame.getWorldFrame(), registry);
    }

    @Override
    public String toString() {
        return "name: " + this.getName() + "x: " + this.getX() + ", y: " + this.getY() + ", z: " + this.getZ();
    }

    public boolean isForceAndMomentZero() {
        return this.force.getX() == 0.0 && this.force.getY() == 0.0 && this.force.getZ() == 0.0 && this.moment.getX() == 0.0 && this.moment.getY() == 0.0 && this.moment.getZ() == 0.0;
    }

    @Override
    public void reset() {
        super.reset();
        this.force.setToZero();
        this.impulse.setToZero();
        this.active = false;
        this.R0_coll.setToZero();
        this.Rcoll_0.setToZero();
        this.Rk_coll.setToZero();
        this.Rk_coll2.setToZero();
        this.u_coll.set(0.0, 0.0, 0.0);
        this.Ki_collision_total.setToZero();
        this.zAxis.set(0.0, 0.0, 0.0);
        this.yAxis.set(0.0, 0.0, 0.0);
        this.xAxis.set(0.0, 0.0, 0.0);
    }

    public boolean resolveMicroCollision(double penetrationSquared, ExternalForcePoint externalForcePointTwo, Vector3DReadOnly negative_normal, double epsilon, double mu, Vector3DBasics p_world) {
        if ((epsilon += 1000000.0 * penetrationSquared) > 20.0) {
            epsilon = 20.0;
        }
        return this.resolveCollision(externalForcePointTwo, negative_normal, epsilon, mu, p_world);
    }

    public boolean resolveCollision(ExternalForcePoint externalForcePoint, Vector3DReadOnly collisionNormalInWorld, double epsilon, double mu, Vector3DBasics impulseInWorldToPack) {
        this.otherObjectVelocity.set(externalForcePoint.getXVelocity(), externalForcePoint.getYVelocity(), externalForcePoint.getZVelocity());
        boolean movingTogether = this.computeRotationAndRelativeVelocity(collisionNormalInWorld, (Vector3DReadOnly)this.otherObjectVelocity, impulseInWorldToPack);
        if (!movingTogether) {
            externalForcePoint.impulse.setToZero();
            return false;
        }
        this.Rk_coll.set(this.parentJoint.physics.Ri_0);
        this.Rk_coll.multiply((RotationMatrixReadOnly)this.R0_coll);
        Matrix3D Ki_collision = this.parentJoint.physics.computeKiCollision((Vector3DReadOnly)this.tempVectorForOffsetFromCOM, (RotationMatrixReadOnly)this.Rk_coll);
        this.Rk_coll2.set(externalForcePoint.parentJoint.physics.Ri_0);
        this.Rk_coll2.multiply((RotationMatrixReadOnly)this.R0_coll);
        Matrix3D Ki_collision2 = externalForcePoint.parentJoint.physics.computeKiCollision((Vector3DReadOnly)externalForcePoint.tempVectorForOffsetFromCOM, (RotationMatrixReadOnly)this.Rk_coll2);
        this.Ki_collision_total.add((Matrix3DReadOnly)Ki_collision, (Matrix3DReadOnly)Ki_collision2);
        this.parentJoint.physics.integrateCollision((Matrix3DReadOnly)this.Ki_collision_total, (Vector3DReadOnly)this.u_coll, epsilon, mu, impulseInWorldToPack);
        this.parentJoint.physics.applyImpulse((Vector3DReadOnly)impulseInWorldToPack);
        impulseInWorldToPack.scale(-1.0);
        JointPhysics<?> jointPhysics = externalForcePoint.parentJoint.physics;
        jointPhysics.applyImpulse((Vector3DReadOnly)impulseInWorldToPack);
        this.R0_coll.transform((Tuple3DBasics)impulseInWorldToPack);
        this.impulse.set(-impulseInWorldToPack.getX(), -impulseInWorldToPack.getY(), -impulseInWorldToPack.getZ());
        externalForcePoint.impulse.set((Tuple3DReadOnly)impulseInWorldToPack);
        this.parentJoint.rob.updateVelocities();
        externalForcePoint.parentJoint.rob.updateVelocities();
        return true;
    }

    public boolean resolveCollision(Vector3DReadOnly velocityOfOtherObjectInWorld, Vector3DReadOnly collisionNormalInWorld, double epsilon, double mu, Vector3DBasics impulseInWorldToPack) {
        boolean movingTogether = this.computeRotationAndRelativeVelocity(collisionNormalInWorld, velocityOfOtherObjectInWorld, impulseInWorldToPack);
        if (!movingTogether) {
            return false;
        }
        this.Rk_coll.set(this.parentJoint.physics.Ri_0);
        this.Rk_coll.multiply((RotationMatrixReadOnly)this.R0_coll);
        this.parentJoint.physics.resolveCollision((Vector3DReadOnly)this.tempVectorForOffsetFromCOM, (RotationMatrixReadOnly)this.Rk_coll, (Vector3DReadOnly)this.u_coll, epsilon, mu, impulseInWorldToPack);
        this.R0_coll.transform((Tuple3DBasics)impulseInWorldToPack);
        this.impulse.set((Tuple3DReadOnly)impulseInWorldToPack);
        this.parentJoint.rob.updateVelocities();
        return true;
    }

    public boolean resolveMicroCollision(double penetrationSquared, Vector3DReadOnly velocityOfOtherObjectInWorld, Vector3DReadOnly collisionNormalInWorld, double epsilon, double mu, Vector3DBasics impulseInWorldToPack) {
        boolean movingTogether = this.computeRotationAndRelativeVelocity(collisionNormalInWorld, velocityOfOtherObjectInWorld, impulseInWorldToPack);
        if (!movingTogether) {
            return false;
        }
        this.Rk_coll.set(this.parentJoint.physics.Ri_0);
        this.Rk_coll.multiply((RotationMatrixReadOnly)this.R0_coll);
        this.parentJoint.physics.resolveMicroCollision(penetrationSquared, (Vector3DReadOnly)this.tempVectorForOffsetFromCOM, (RotationMatrixReadOnly)this.Rk_coll, (Vector3DReadOnly)this.u_coll, epsilon, mu, impulseInWorldToPack);
        this.R0_coll.transform((Tuple3DBasics)impulseInWorldToPack);
        this.impulse.set((Tuple3DReadOnly)impulseInWorldToPack);
        this.parentJoint.rob.updateVelocities();
        return true;
    }

    private boolean computeRotationAndRelativeVelocity(Vector3DReadOnly collisionNormalInWorld, Vector3DReadOnly otherObjectVelocityInWorld, Vector3DBasics impulseInWorldToPack) {
        this.computeRotationFromNormalVector((RotationMatrixBasics)this.R0_coll, collisionNormalInWorld);
        this.Rcoll_0.set(this.R0_coll);
        this.Rcoll_0.transpose();
        this.u_coll.set(this.getXVelocity() - otherObjectVelocityInWorld.getX(), this.getYVelocity() - otherObjectVelocityInWorld.getY(), this.getZVelocity() - otherObjectVelocityInWorld.getZ());
        this.Rcoll_0.transform((Tuple3DBasics)this.u_coll);
        if (this.u_coll.getZ() > 0.0) {
            impulseInWorldToPack.set(0.0, 0.0, 0.0);
            this.impulse.setToZero();
            return false;
        }
        return true;
    }

    public void getForce(Vector3DBasics vectorToPack) {
        vectorToPack.set((Tuple3DReadOnly)this.force);
    }

    public void getMoment(Vector3DBasics vectorToPack) {
        vectorToPack.set((Tuple3DReadOnly)this.moment);
    }

    public void setForce(Vector3DReadOnly force) {
        this.force.set((Tuple3DReadOnly)force);
    }

    public void setForce(double fx, double fy, double fz) {
        this.force.set(fx, fy, fz);
    }

    public void setMoment(Vector3D moment) {
        this.moment.set((Tuple3DReadOnly)moment);
    }

    public void setMoment(double mx, double my, double mz) {
        this.moment.set(mx, my, mz);
    }

    public void getImpulse(Vector3D vectorToPack) {
        vectorToPack.set((Tuple3DReadOnly)this.impulse);
    }

    public void setImpulse(Vector3D impulse) {
        this.impulse.set((Tuple3DReadOnly)impulse);
    }

    public void setImpulse(double px, double py, double pz) {
        this.impulse.set(px, py, pz);
    }

    public YoFrameVector3D getYoForce() {
        return this.force;
    }

    public YoFrameVector3D getYoMoment() {
        return this.moment;
    }

    public YoFrameVector3D getYoImpulse() {
        return this.impulse;
    }

    private void computeRotationFromNormalVector(RotationMatrixBasics rot, Vector3DReadOnly vec) {
        this.zAxis.set((Tuple3DReadOnly)vec);
        this.zAxis.normalize();
        this.yAxis.set(0.0, 1.0, 0.0);
        if (Math.abs(this.zAxis.getY()) > 0.99) {
            this.yAxis.set(1.0, 0.0, 0.0);
        }
        this.xAxis.cross((Tuple3DReadOnly)this.yAxis, (Tuple3DReadOnly)this.zAxis);
        this.xAxis.normalize();
        this.yAxis.cross((Tuple3DReadOnly)this.zAxis, (Tuple3DReadOnly)this.xAxis);
        rot.setColumns((Tuple3DReadOnly)this.xAxis, (Tuple3DReadOnly)this.yAxis, (Tuple3DReadOnly)this.zAxis);
    }
}

