/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;

public class WavyGroundProfile
implements GroundProfile3D,
HeightMapWithNormals {
    private double xMin = -2.0;
    private double xMax = 2.0;
    private double yMin = -2.0;
    private double yMax = 2.0;
    private double zMin = -10.0;
    private double zMax = 10.0;
    private BoundingBox3D boundingBox = new BoundingBox3D((Point3DReadOnly)new Point3D(this.xMin, this.yMin, this.zMin), (Point3DReadOnly)new Point3D(this.xMax, this.yMax, this.zMax));

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double heightAt = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, heightAt, normalToPack);
        return heightAt;
    }

    public double heightAt(double x, double y, double z) {
        if (x > this.xMin && x < this.xMax && y > this.yMin && y < this.yMax) {
            return 1.0 * Math.exp(-Math.abs(2.0 * x)) * Math.exp(-Math.abs(2.0 * y)) * Math.sin(4.39822971502571 * x);
        }
        return 0.0;
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics normal) {
        normal.setX(0.0);
        normal.setY(0.0);
        normal.setZ(1.0);
    }

    public void closestIntersectionTo(double x, double y, double z, Point3DBasics point) {
        point.setX(x);
        point.setY(y);
        point.setZ(this.heightAt(x, y, z));
    }

    public void closestIntersectionAndNormalAt(double x, double y, double z, Point3DBasics point, Vector3DBasics normal) {
        this.closestIntersectionTo(x, y, z, point);
        this.surfaceNormalAt(x, y, z, normal);
    }

    public boolean checkIfInside(double x, double y, double z, Point3DBasics intersectionToPack, Vector3DBasics normalToPack) {
        this.closestIntersectionTo(x, y, z, intersectionToPack);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return z < intersectionToPack.getZ();
    }

    public boolean isClose(double x, double y, double z) {
        return this.boundingBox.isInsideInclusive(x, y, z);
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }

    public HeightMapWithNormals getHeightMapIfAvailable() {
        return this;
    }
}

