/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraMountInterface;
import us.ihmc.simulationconstructionset.CameraMount;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.GroundContactPointGroup;
import us.ihmc.simulationconstructionset.IMUMount;
import us.ihmc.simulationconstructionset.JointWrenchSensor;
import us.ihmc.simulationconstructionset.KinematicPoint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.LoopClosureSoftConstraint;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulatedSensor;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.JointPhysics;
import us.ihmc.simulationconstructionset.simulatedSensors.LidarMount;
import us.ihmc.simulationconstructionset.simulatedSensors.WrenchCalculatorInterface;
import us.ihmc.simulationconstructionset.util.CommonJoint;
import us.ihmc.yoVariables.variable.YoDouble;

public abstract class Joint
implements CommonJoint,
Serializable {
    private static final long serialVersionUID = -1158152164230922246L;
    public static final double MAX_TRANS_ACCEL = 1.0E12;
    public static final double MAX_ROT_ACCEL = 1.0E7;
    public Joint parentJoint;
    public Link link;
    protected String name;
    protected int numDOF;
    public Robot rob;
    public final RigidBodyTransform transformToNext = new RigidBodyTransform();
    private final RigidBodyTransform offsetTransform3D = new RigidBodyTransform();
    public final RigidBodyTransform jointTransform3D = new RigidBodyTransform();
    protected List<CameraMount> cameraMounts;
    protected List<LidarMount> lidarMounts;
    protected List<IMUMount> imuMounts;
    protected List<WrenchCalculatorInterface> forceSensors;
    public final List<Joint> childrenJoints = new ArrayList<Joint>();
    public final List<LoopClosureSoftConstraint> childrenConstraints = new ArrayList<LoopClosureSoftConstraint>();
    private final List<SimulatedSensor> sensors = new ArrayList<SimulatedSensor>();
    public JointPhysics<?> physics;
    private boolean isDynamic = true;
    private Vector3D tempVector3d = new Vector3D();
    private Quaternion tempQuat4d = new Quaternion();

    protected Joint(String name, Tuple3DReadOnly offsetVec, Robot rob, int numDOF) {
        this.name = name;
        this.rob = rob;
        this.numDOF = numDOF;
        this.setOffset(offsetVec);
    }

    public Joint getParentJoint() {
        return this.parentJoint;
    }

    public List<Joint> getChildrenJoints() {
        return this.childrenJoints;
    }

    public void getChildrenJoints(List<Joint> arrayListToPack) {
        arrayListToPack.addAll(this.childrenJoints);
    }

    public void recursiveGetChildrenJoints(List<Joint> arrayListToPack) {
        arrayListToPack.addAll(this.childrenJoints);
        for (Joint joint : this.childrenJoints) {
            joint.recursiveGetChildrenJoints(arrayListToPack);
        }
    }

    public void recursiveGetOneDegreeOfFreedomJoints(List<OneDegreeOfFreedomJoint> oneDegreeOfFreedomJointsToPack) {
        if (this instanceof OneDegreeOfFreedomJoint) {
            oneDegreeOfFreedomJointsToPack.add((OneDegreeOfFreedomJoint)this);
        }
        for (Joint joint : this.childrenJoints) {
            joint.recursiveGetOneDegreeOfFreedomJoints(oneDegreeOfFreedomJointsToPack);
        }
    }

    public List<LoopClosureSoftConstraint> getChildrenConstraints() {
        return this.childrenConstraints;
    }

    public void recursiveGetChildrenConstraints(List<LoopClosureSoftConstraint> constraintsToPack) {
        constraintsToPack.addAll(this.childrenConstraints);
        for (Joint joint : this.childrenJoints) {
            joint.recursiveGetChildrenConstraints(constraintsToPack);
        }
    }

    public String getName() {
        return this.name;
    }

    protected List<CameraMount> getCameraMounts() {
        return this.cameraMounts;
    }

    protected List<LidarMount> getLidarMounts() {
        return this.lidarMounts;
    }

    protected List<IMUMount> getIMUMounts() {
        return this.imuMounts;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setDynamic(boolean isDynamic) {
        this.isDynamic = isDynamic;
    }

    public void addGroundContactPoint(GroundContactPoint point) {
        this.physics.addGroundContactPoint(point);
    }

    public void addGroundContactPoint(int groupIdentifier, GroundContactPoint point) {
        this.physics.addGroundContactPoint(groupIdentifier, point);
    }

    public void addJointWrenchSensor(JointWrenchSensor jointWrenchSensor) {
        this.physics.addJointWrenchSensor(jointWrenchSensor);
    }

    public JointWrenchSensor getJointWrenchSensor() {
        return this.physics.getJointWrenchSensor();
    }

    public void addKinematicPoint(KinematicPoint point) {
        this.physics.addKinematicPoint(point);
    }

    public void addExternalForcePoint(ExternalForcePoint point) {
        this.physics.addExternalForcePoint(point);
    }

    public String toString() {
        StringBuffer retBuffer = new StringBuffer();
        Vector3D translation = new Vector3D();
        retBuffer.append("Joint: " + this.name + "\n");
        if (this.parentJoint != null) {
            retBuffer.append("  Parent Joint: " + this.parentJoint.name + "\n");
        } else {
            retBuffer.append("  Root Joint \n");
        }
        translation.set((Tuple3DReadOnly)this.transformToNext.getTranslation());
        retBuffer.append("   Location vector: " + translation + "\n");
        retBuffer.append("   offset vector: " + this.offsetTransform3D.getTranslation() + "\n");
        retBuffer.append("   link: " + this.link);
        if (this.physics != null) {
            retBuffer.append(this.physics);
        }
        return retBuffer.toString();
    }

    protected abstract void update();

    protected void recursiveUpdateJoints(RigidBodyTransformReadOnly tToHere, boolean updatePoints, boolean updateCameraMounts, boolean updateIMUMounts, double time) {
        this.update();
        if (tToHere != null) {
            this.transformToNext.set(tToHere);
        } else {
            this.transformToNext.setIdentity();
        }
        this.transformToNext.multiply((RigidBodyTransformReadOnly)this.getOffsetTransform3D());
        this.transformToNext.multiply((RigidBodyTransformReadOnly)this.getJointTransform3D());
        if (updatePoints) {
            this.updatePoints((RigidBodyTransformReadOnly)this.transformToNext, time);
        }
        if (updateCameraMounts) {
            this.updateCameraMounts((RigidBodyTransformReadOnly)this.transformToNext);
        }
        if (updateIMUMounts) {
            this.updateIMUMountsPositionAndVelocity((RigidBodyTransformReadOnly)this.transformToNext);
        }
        for (int i = 0; i < this.childrenJoints.size(); ++i) {
            Joint childJoint = this.childrenJoints.get(i);
            childJoint.recursiveUpdateJoints((RigidBodyTransformReadOnly)this.transformToNext, updatePoints, updateCameraMounts, updateIMUMounts, time);
        }
    }

    protected void recursiveUpdateJointsIMUMountAccelerations() {
        this.updateIMUMountsAcceleration((RigidBodyTransformReadOnly)this.transformToNext);
        for (int i = 0; i < this.childrenJoints.size(); ++i) {
            Joint childJoint = this.childrenJoints.get(i);
            childJoint.recursiveUpdateJointsIMUMountAccelerations();
        }
    }

    public RigidBodyTransform getJointTransform3D() {
        return this.jointTransform3D;
    }

    protected void updateCameraMounts(RigidBodyTransformReadOnly tToHere) {
        if (this.cameraMounts != null) {
            for (int i = 0; i < this.cameraMounts.size(); ++i) {
                CameraMount mount = this.cameraMounts.get(i);
                mount.updateTransform(tToHere);
            }
        }
    }

    protected void updateLidarMounts(RigidBodyTransformReadOnly tToHere) {
        if (this.lidarMounts != null) {
            for (int i = 0; i < this.lidarMounts.size(); ++i) {
                LidarMount mount = this.lidarMounts.get(i);
                mount.updateTransform(tToHere, this.rob.getTime());
            }
        }
    }

    protected void updateIMUMountsPositionAndVelocity(RigidBodyTransformReadOnly tToHere) {
        if (this.imuMounts != null) {
            for (int i = 0; i < this.imuMounts.size(); ++i) {
                IMUMount mount = this.imuMounts.get(i);
                mount.updateIMUMountPositionAndVelocity();
            }
        }
    }

    protected void updateIMUMountsAcceleration(RigidBodyTransformReadOnly tToHere) {
        if (this.imuMounts != null) {
            for (int i = 0; i < this.imuMounts.size(); ++i) {
                IMUMount mount = this.imuMounts.get(i);
                mount.updateIMUMountAcceleration();
            }
        }
    }

    private void updateSensorMounts(RigidBodyTransformReadOnly tToHere, double time) {
        for (int i = 0; i < this.sensors.size(); ++i) {
            SimulatedSensor simulatedSensor = this.sensors.get(i);
            simulatedSensor.updateTransform(tToHere, time);
        }
    }

    protected void updatePoints(RigidBodyTransformReadOnly tToHere, double time) {
        int i;
        this.updateSensorMounts(tToHere, time);
        if (this.physics.groundContactPointGroupList != null) {
            for (i = 0; i < this.physics.groundContactPointGroupList.size(); ++i) {
                ArrayList<GroundContactPoint> groundContactPoints = this.physics.groundContactPointGroupList.get(i).getGroundContactPoints();
                for (int y = 0; y < groundContactPoints.size(); ++y) {
                    GroundContactPoint childPoint = (GroundContactPoint)groundContactPoints.get(y);
                    childPoint.updatePointPosition(tToHere);
                }
            }
        }
        if (this.physics.kinematicPoints != null) {
            for (i = 0; i < this.physics.kinematicPoints.size(); ++i) {
                KinematicPoint childPoint = this.physics.kinematicPoints.get(i);
                childPoint.updatePointPosition(tToHere);
            }
        }
    }

    public void addJoint(Joint childJoint) {
        childJoint.parentJoint = this;
        this.childrenJoints.add(childJoint);
    }

    public void addLoopClosureConstraint(LoopClosureSoftConstraint childConstraint) {
        childConstraint.setParentJoint(this);
        this.childrenConstraints.add(childConstraint);
    }

    public RigidBodyTransform getOffsetTransform3D() {
        return this.offsetTransform3D;
    }

    public void addCameraMount(CameraMount mount) {
        if (this.cameraMounts == null) {
            this.cameraMounts = new ArrayList<CameraMount>();
        }
        this.cameraMounts.add(mount);
        mount.setParentJoint(this);
    }

    public void addLidarMount(LidarMount mount) {
        if (this.lidarMounts == null) {
            this.lidarMounts = new ArrayList<LidarMount>();
        }
        this.lidarMounts.add(mount);
        mount.setParentJoint(this);
    }

    public void addIMUMount(IMUMount mount) {
        if (this.imuMounts == null) {
            this.imuMounts = new ArrayList<IMUMount>();
        }
        this.imuMounts.add(mount);
        mount.setParentJoint(this);
    }

    public void addForceSensor(WrenchCalculatorInterface forceSensor) {
        if (this.forceSensors == null) {
            this.forceSensors = new ArrayList<WrenchCalculatorInterface>();
        }
        this.forceSensors.add(forceSensor);
    }

    public Link getLink() {
        return this.link;
    }

    protected int getNumDOF() {
        return this.numDOF;
    }

    public void setOffset(Tuple3DReadOnly offset) {
        this.setOffset(offset.getX(), offset.getY(), offset.getZ());
    }

    public void setOffset(double x, double y, double z) {
        this.offsetTransform3D.getTranslation().set(x, y, z);
    }

    public Vector3DReadOnly getOffset() {
        return this.offsetTransform3D.getTranslation();
    }

    public void getOffset(Vector3DBasics offsetToPack) {
        offsetToPack.set((Tuple3DReadOnly)this.getOffset());
    }

    public void setLink(Link newLink) {
        this.link = newLink;
        this.link.setParentJoint(this);
    }

    protected void recursiveGetCameraMounts(List<CameraMountInterface> list) {
        if (this.cameraMounts != null) {
            list.addAll(this.cameraMounts);
        }
        for (int i = 0; i < this.childrenJoints.size(); ++i) {
            Joint child = this.childrenJoints.get(i);
            child.recursiveGetCameraMounts(list);
        }
    }

    protected void recursiveGetLidarMounts(List<LidarMount> list) {
        if (this.lidarMounts != null) {
            list.addAll(this.lidarMounts);
        }
        for (int i = 0; i < this.childrenJoints.size(); ++i) {
            Joint child = this.childrenJoints.get(i);
            child.recursiveGetLidarMounts(list);
        }
    }

    protected void recursiveGetForceSensors(List<WrenchCalculatorInterface> list) {
        if (this.forceSensors != null) {
            list.addAll(this.forceSensors);
        }
        for (int i = 0; i < this.childrenJoints.size(); ++i) {
            Joint child = this.childrenJoints.get(i);
            child.recursiveGetForceSensors(list);
        }
    }

    protected void recursiveGetIMUMounts(List<IMUMount> list) {
        if (this.imuMounts != null) {
            list.addAll(this.imuMounts);
        }
        for (int i = 0; i < this.childrenJoints.size(); ++i) {
            Joint child = this.childrenJoints.get(i);
            child.recursiveGetIMUMounts(list);
        }
    }

    protected void recursiveGetSensors(List<SimulatedSensor> simulatedSensorsToPack) {
        this.getSensors(simulatedSensorsToPack);
        for (int i = 0; i < this.childrenJoints.size(); ++i) {
            Joint child = this.childrenJoints.get(i);
            child.recursiveGetSensors(simulatedSensorsToPack);
        }
    }

    private void getSensors(List<SimulatedSensor> simulatedSensorsToPack) {
        simulatedSensorsToPack.addAll(this.sensors);
    }

    public void addSensor(SimulatedSensor simulatedSensor) {
        this.sensors.add(simulatedSensor);
    }

    public void recursiveGetAllGroundContactPoints(List<GroundContactPoint> groundContactPoints) {
        this.physics.recursiveGetAllGroundContactPoints(groundContactPoints);
    }

    public void getTransformToWorld(RigidBodyTransformBasics ret) {
        ret.set((RigidBodyTransformReadOnly)this.transformToNext);
    }

    public void getTransformToWorld(Orientation3DBasics rotation, Tuple3DBasics translation) {
        this.transformToNext.get(rotation, translation);
    }

    public void getRotationToWorld(Orientation3DBasics rotation) {
        rotation.set((Orientation3DReadOnly)this.transformToNext.getRotation());
    }

    public void getTranslationToWorld(Tuple3DBasics translation) {
        translation.set((Tuple3DReadOnly)this.transformToNext.getTranslation());
    }

    public void getXYZToWorld(YoDouble x, YoDouble y, YoDouble z) {
        this.getTranslationToWorld((Tuple3DBasics)this.tempVector3d);
        x.set(this.tempVector3d.getX());
        y.set(this.tempVector3d.getY());
        z.set(this.tempVector3d.getZ());
    }

    public void getYawPitchRollToWorld(YoDouble yaw, YoDouble pitch, YoDouble roll) {
        this.getRotationToWorld((Orientation3DBasics)this.tempQuat4d);
        double q_x = this.tempQuat4d.getX();
        double q_y = this.tempQuat4d.getY();
        double q_z = this.tempQuat4d.getZ();
        double q_w = this.tempQuat4d.getS();
        yaw.set(Math.atan2(2.0 * q_x * q_y + 2.0 * q_z * q_w, 1.0 - 2.0 * q_y * q_y - 2.0 * q_z * q_z));
        pitch.set(Math.asin(-2.0 * q_x * q_z + 2.0 * q_w * q_y));
        roll.set(Math.atan2(2.0 * q_y * q_z + 2.0 * q_x * q_w, 1.0 - 2.0 * q_x * q_x - 2.0 * q_y * q_y));
    }

    public double[] get3DRotation() {
        double[] rotation = new double[3];
        this.getRotationToWorld((Orientation3DBasics)this.tempQuat4d);
        double q_x = this.tempQuat4d.getX();
        double q_y = this.tempQuat4d.getY();
        double q_z = this.tempQuat4d.getZ();
        double q_w = this.tempQuat4d.getS();
        rotation[2] = Math.atan2(2.0 * q_x * q_y + 2.0 * q_z * q_w, 1.0 - 2.0 * q_y * q_y - 2.0 * q_z * q_z);
        rotation[1] = Math.asin(-2.0 * q_x * q_z + 2.0 * q_w * q_y);
        rotation[0] = Math.atan2(2.0 * q_y * q_z + 2.0 * q_x * q_w, 1.0 - 2.0 * q_x * q_x - 2.0 * q_y * q_y);
        return rotation;
    }

    public Link getLink(String linkName) {
        if (this.link.getName().equals(linkName)) {
            return this.link;
        }
        for (Joint childJoint : this.childrenJoints) {
            Link link = childJoint.getLink(linkName);
            if (link == null) continue;
            return link;
        }
        return null;
    }

    public void removeChildJoint(Joint jointToRemove) {
        boolean removed = this.childrenJoints.remove(jointToRemove);
        if (!removed) {
            throw new RuntimeException("Could not remove joint. Joint " + jointToRemove.getName() + " was not a child of joint " + this.getName());
        }
        jointToRemove.parentJoint = null;
    }

    public Robot getRobot() {
        return this.rob;
    }

    public void getJointAxis(Vector3DBasics axisToPack) {
        this.physics.getJointAxis(axisToPack);
    }

    public void removeExternalForcePoint(ExternalForcePoint externalForcePoint) {
        this.physics.removeExternalForcePoint(externalForcePoint);
    }

    public GroundContactPointGroup getGroundContactPointGroup() {
        return this.physics.getGroundContactPointGroup();
    }

    public GroundContactPointGroup getGroundContactPointGroup(int groupIdentifier) {
        return this.physics.getGroundContactPointGroup(groupIdentifier);
    }

    public List<ExternalForcePoint> getExternalForcePoints() {
        return this.physics.getExternalForcePoints();
    }

    public ExternalForcePoint recursiveGetExternalForcePoint(String name) {
        ExternalForcePoint externalForcePoint = this.physics.getExternalForcePoint(name);
        if (externalForcePoint != null) {
            return externalForcePoint;
        }
        for (int i = 0; i < this.childrenJoints.size(); ++i) {
            Joint child = this.childrenJoints.get(i);
            externalForcePoint = child.recursiveGetExternalForcePoint(name);
            if (externalForcePoint == null) continue;
            return externalForcePoint;
        }
        return null;
    }

    public Joint recursivelyGetJoint(String name) {
        if (this.getName().equals(name)) {
            return this;
        }
        for (int i = 0; i < this.childrenJoints.size(); ++i) {
            Joint child = this.childrenJoints.get(i);
            Joint jointToReturn = child.recursivelyGetJoint(name);
            if (jointToReturn == null) continue;
            return jointToReturn;
        }
        return null;
    }
}

