/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.util.ground.Contactable;

public class StickSlipContactCalculator {
    private final Point3D contactAPosition = new Point3D();
    private final Point3D contactBPosition = new Point3D();
    private final Vector3D contactAVelocity = new Vector3D();
    private final Vector3D contactBVelocity = new Vector3D();
    private final Vector3D velocityDifference = new Vector3D();
    private final Point3D contactableClosestPoint = new Point3D();
    private final Vector3D contactableSurfaceNormal = new Vector3D();
    private final Vector3D contactForceDirection = new Vector3D();
    private final Vector3D contactForceFromSpring = new Vector3D();
    private final Vector3D contactForceFromDamper = new Vector3D();
    private final Vector3D totalContactForce = new Vector3D();
    private final Vector3D normalContactForce = new Vector3D();
    private final Vector3D parallelContactForce = new Vector3D();
    private final Vector3D slipVector = new Vector3D();

    public void doContactMade(ExternalForcePoint contactPointA, Contactable contactableB, GroundContactPoint contactPointB) {
        contactPointA.getPosition((Tuple3DBasics)this.contactAPosition);
        contactPointB.setOffsetWorld((Tuple3DReadOnly)this.contactAPosition);
        contactableB.updateContactPoints();
        contactPointB.setIsInContact(true);
        contactPointB.setIsSlipping(false);
    }

    public void doContactBroken(ExternalForcePoint contactPointA, GroundContactPoint contactPointB) {
        contactPointB.setIsInContact(false);
        contactPointB.setIsSlipping(false);
        this.totalContactForce.set(0.0, 0.0, 0.0);
        this.applyContactForces(contactPointA, contactPointB);
    }

    public void doCurrentlyInContact(ExternalForcePoint contactPointA, Contactable contactableB, GroundContactPoint contactPointB, double kContact, double bContact, double alphaStick, double alphaSlip) {
        this.computeSpringDamperAndTotalForces(contactPointA, contactableB, contactPointB, kContact, bContact);
        this.projectTotalForceOntoLineBetweenPoints();
        this.checkForSlipping(contactableB, contactPointB, alphaStick, alphaSlip);
        this.applyContactForces(contactPointA, contactPointB);
    }

    private void computeSpringDamperAndTotalForces(ExternalForcePoint contactPointA, Contactable contactableB, GroundContactPoint contactPointB, double kContact, double bContact) {
        contactPointA.getPosition((Tuple3DBasics)this.contactAPosition);
        contactPointB.getPosition((Tuple3DBasics)this.contactBPosition);
        contactableB.closestIntersectionAndNormalAt(this.contactableClosestPoint, this.contactableSurfaceNormal, this.contactBPosition);
        this.contactForceDirection.set((Tuple3DReadOnly)this.contactBPosition);
        this.contactForceDirection.sub((Tuple3DReadOnly)this.contactAPosition);
        if (this.contactForceDirection.length() < 1.0E-7) {
            this.contactForceFromSpring.set(0.0, 0.0, 0.0);
            this.contactForceFromDamper.set(0.0, 0.0, 0.0);
        } else {
            this.contactForceFromSpring.set(this.contactForceDirection);
            this.contactForceFromSpring.scale(kContact);
            contactPointA.getVelocity((Vector3DBasics)this.contactAVelocity);
            contactPointB.getVelocity((Vector3DBasics)this.contactBVelocity);
            this.velocityDifference.set(this.contactBVelocity);
            this.velocityDifference.sub((Tuple3DReadOnly)this.contactAVelocity);
            this.contactForceFromDamper.set(this.velocityDifference);
            this.contactForceFromDamper.scale(bContact);
        }
        this.totalContactForce.set(this.contactForceFromSpring);
        this.totalContactForce.add((Tuple3DReadOnly)this.contactForceFromDamper);
    }

    private void applyContactForces(ExternalForcePoint contactPointA, GroundContactPoint contactPointB) {
        contactPointA.setForce((Vector3DReadOnly)this.totalContactForce);
        this.totalContactForce.negate();
        contactPointB.setForce((Vector3DReadOnly)this.totalContactForce);
    }

    private void checkForSlipping(Contactable contactableB, GroundContactPoint contactPointB, double alphaStick, double alphaSlip) {
        this.normalContactForce.set(this.contactableSurfaceNormal);
        this.normalContactForce.scale(this.contactableSurfaceNormal.dot((Vector3DReadOnly)this.totalContactForce));
        this.parallelContactForce.set(this.totalContactForce);
        this.parallelContactForce.sub((Tuple3DReadOnly)this.normalContactForce);
        double parallelForceMagnitude = this.parallelContactForce.length();
        double normalForceMagnitude = this.normalContactForce.length();
        double ratio = parallelForceMagnitude / normalForceMagnitude;
        boolean isAlreadySlipping = contactPointB.isSlipping();
        if (ratio > alphaStick || isAlreadySlipping && ratio > alphaSlip) {
            contactPointB.setIsSlipping(true);
            double parallelSlipForce = alphaSlip * normalForceMagnitude;
            double parallelScale = parallelSlipForce / parallelForceMagnitude;
            if (parallelScale < 1.0) {
                this.parallelContactForce.scale(parallelScale);
            }
            this.totalContactForce.add((Tuple3DReadOnly)this.normalContactForce, (Tuple3DReadOnly)this.parallelContactForce);
            this.slipVector.set(this.parallelContactForce);
            if (parallelForceMagnitude > 1.0E-7) {
                this.slipVector.scale(1.0 / parallelForceMagnitude);
            }
            double distanceBetweenContactPoints = this.contactAPosition.distance((Point3DReadOnly)this.contactBPosition);
            this.slipVector.scale(-0.05 * distanceBetweenContactPoints);
            this.contactBPosition.add((Tuple3DReadOnly)this.slipVector);
            contactPointB.setOffsetWorld((Tuple3DReadOnly)this.contactBPosition);
            contactableB.updateContactPoints();
        } else {
            contactPointB.setIsSlipping(false);
        }
    }

    private void projectTotalForceOntoLineBetweenPoints() {
        this.contactForceDirection.set((Tuple3DReadOnly)this.contactBPosition);
        this.contactForceDirection.sub((Tuple3DReadOnly)this.contactAPosition);
        if (this.contactForceDirection.length() > 1.0E-10) {
            this.contactForceDirection.normalize();
            double dotProduct = this.totalContactForce.dot((Vector3DReadOnly)this.contactForceDirection);
            this.totalContactForce.set(this.contactForceDirection);
            this.totalContactForce.scale(dotProduct);
        }
    }
}

