/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.Graphics3DSpotLight;
import us.ihmc.graphicsDescription.GraphicsUpdatable;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.color.MutableColor;
import us.ihmc.graphicsDescription.graphInterfaces.SelectedVariableHolder;
import us.ihmc.graphicsDescription.image.DepthImageCallback;
import us.ihmc.graphicsDescription.image.ImageCallback;
import us.ihmc.graphicsDescription.input.SelectedListener;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.graphicsDescription.structure.Graphics3DNodeType;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DBackgroundScaleMode;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfiguration;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfigurationList;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraMountList;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraTrackingAndDollyPositionHolder;
import us.ihmc.jMonkeyEngineToolkit.camera.CaptureDevice;
import us.ihmc.jMonkeyEngineToolkit.camera.ClassicCameraController;
import us.ihmc.jMonkeyEngineToolkit.camera.OffscreenBufferDepthImageServer;
import us.ihmc.jMonkeyEngineToolkit.camera.OffscreenBufferVideoServer;
import us.ihmc.jMonkeyEngineToolkit.camera.TrackingDollyCameraController;
import us.ihmc.jMonkeyEngineToolkit.camera.ViewportAdapter;
import us.ihmc.simulationconstructionset.ExitActionListener;
import us.ihmc.simulationconstructionset.ExtraPanelConfiguration;
import us.ihmc.simulationconstructionset.GraphConfiguration;
import us.ihmc.simulationconstructionset.GroundContactModel;
import us.ihmc.simulationconstructionset.HeightMapFromGroundContactModel;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.ViewportConfiguration;
import us.ihmc.simulationconstructionset.commands.AllCommandsExecutor;
import us.ihmc.simulationconstructionset.commands.SelectGraphConfigurationCommandExecutor;
import us.ihmc.simulationconstructionset.commands.ViewportSelectorCommandExecutor;
import us.ihmc.simulationconstructionset.commands.ViewportSelectorCommandListener;
import us.ihmc.simulationconstructionset.graphics.GraphicsDynamicGraphicsObject;
import us.ihmc.simulationconstructionset.graphics.GraphicsRobot;
import us.ihmc.simulationconstructionset.gui.ActiveCameraHolder;
import us.ihmc.simulationconstructionset.gui.ActiveCanvas3DHolder;
import us.ihmc.simulationconstructionset.gui.BookmarkedVariablesHolder;
import us.ihmc.simulationconstructionset.gui.CameraHolder;
import us.ihmc.simulationconstructionset.gui.Canvas3DPanel;
import us.ihmc.simulationconstructionset.gui.EntryBoxArrayPanel;
import us.ihmc.simulationconstructionset.gui.EntryBoxArrayTabbedPanel;
import us.ihmc.simulationconstructionset.gui.EventDispatchThreadHelper;
import us.ihmc.simulationconstructionset.gui.ExitActionListenerNotifier;
import us.ihmc.simulationconstructionset.gui.GUIConfigurationSaveAndLoad;
import us.ihmc.simulationconstructionset.gui.GraphArrayPanel;
import us.ihmc.simulationconstructionset.gui.GraphArrayWindow;
import us.ihmc.simulationconstructionset.gui.SplashPanel;
import us.ihmc.simulationconstructionset.gui.StandardGUIActions;
import us.ihmc.simulationconstructionset.gui.StandardViewSetup;
import us.ihmc.simulationconstructionset.gui.TickUpdateListener;
import us.ihmc.simulationconstructionset.gui.TimeStepMouseWheelListener;
import us.ihmc.simulationconstructionset.gui.ViewportAdapterAndCameraControllerHolder;
import us.ihmc.simulationconstructionset.gui.ViewportPanel;
import us.ihmc.simulationconstructionset.gui.ViewportWindow;
import us.ihmc.simulationconstructionset.gui.YoVariableDoubleClickListener;
import us.ihmc.simulationconstructionset.gui.YoVariableExplorerTabbedPane;
import us.ihmc.simulationconstructionset.gui.YoVariableSliderWindow;
import us.ihmc.simulationconstructionset.gui.camera.CameraTrackAndDollyYoVariablesHolder;
import us.ihmc.simulationconstructionset.gui.config.CameraSelector;
import us.ihmc.simulationconstructionset.gui.config.Configuration;
import us.ihmc.simulationconstructionset.gui.config.ConfigurationList;
import us.ihmc.simulationconstructionset.gui.config.EntryBoxGroup;
import us.ihmc.simulationconstructionset.gui.config.EntryBoxGroupList;
import us.ihmc.simulationconstructionset.gui.config.EntryBoxGroupSelector;
import us.ihmc.simulationconstructionset.gui.config.ExtraPanelConfigurationList;
import us.ihmc.simulationconstructionset.gui.config.ExtraPanelSelector;
import us.ihmc.simulationconstructionset.gui.config.GraphConfigurationList;
import us.ihmc.simulationconstructionset.gui.config.GraphGroup;
import us.ihmc.simulationconstructionset.gui.config.GraphGroupList;
import us.ihmc.simulationconstructionset.gui.config.GraphGroupSelector;
import us.ihmc.simulationconstructionset.gui.config.VarGroup;
import us.ihmc.simulationconstructionset.gui.config.VarGroupList;
import us.ihmc.simulationconstructionset.gui.config.VarGroupSelector;
import us.ihmc.simulationconstructionset.gui.config.ViewportConfigurationList;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.AllDialogConstructorsHolder;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.GUIEnablerAndDisabler;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.StandardAllDialogConstructorsGenerator;
import us.ihmc.simulationconstructionset.gui.hierarchyTree.NamespaceHierarchyTree;
import us.ihmc.simulationconstructionset.gui.yoVariableSearch.YoVariableListPanel;
import us.ihmc.simulationconstructionset.gui.yoVariableSearch.YoVariablePanelJPopupMenu;
import us.ihmc.simulationconstructionset.gui.yoVariableSearch.YoVariableSearchPanel;
import us.ihmc.simulationconstructionset.synchronization.SimulationSynchronizer;
import us.ihmc.simulationconstructionset.util.AdditionalPanelTools;
import us.ihmc.simulationconstructionset.util.XMLReaderUtility;
import us.ihmc.simulationconstructionset.util.ground.FlatGroundProfile;
import us.ihmc.tools.TimestampProvider;
import us.ihmc.tools.thread.CloseableAndDisposableRegistry;
import us.ihmc.yoVariables.buffer.YoBuffer;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.registry.YoVariableList;
import us.ihmc.yoVariables.tools.YoSearchTools;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class StandardSimulationGUI
implements SelectGraphConfigurationCommandExecutor,
GraphGroupSelector,
EntryBoxGroupSelector,
CameraSelector,
ViewportSelectorCommandExecutor,
CameraHolder,
ActiveCameraHolder,
ActiveCanvas3DHolder,
ExtraPanelSelector,
VarGroupSelector,
ExitActionListenerNotifier {
    private static final boolean UPDATE_UI = false;
    private static final boolean DEBUG_CLOSE_AND_DISPOSE = false;
    private static JWindow splashWindow;
    private Graphics3DAdapter graphics3dAdapter;
    private ConcurrentLinkedQueue<GraphicsUpdatable> graphicsUpdatables = new ConcurrentLinkedQueue();
    private LinkedHashMap<Robot, GraphicsRobot> graphicsRobots = new LinkedHashMap();
    private List<ExitActionListener> exitActionListeners = new ArrayList<ExitActionListener>();
    private ConfigurationList configurationList = new ConfigurationList();
    private CameraMountList cameraMountList = new CameraMountList();
    private GraphGroupList graphGroupList = new GraphGroupList();
    private GraphConfigurationList graphConfigurationList = new GraphConfigurationList();
    private EntryBoxGroupList entryBoxGroupList = new EntryBoxGroupList();
    private CameraConfigurationList cameraConfigurationList = new CameraConfigurationList();
    private ExtraPanelConfigurationList extraPanelConfigurationList = new ExtraPanelConfigurationList();
    private int updateCounts = 0;
    private ViewportConfigurationList viewportConfigurationList = new ViewportConfigurationList();
    private List<GraphArrayWindow> graphArrayWindows = new ArrayList<GraphArrayWindow>();
    private List<ViewportWindow> viewportWindows = new ArrayList<ViewportWindow>();
    private boolean isViewportHidden = false;
    protected JPanel buttonPanel;
    private Container contentPane;
    private JSplitPane splitPane;
    private int dividerLocation;
    private ViewportSelectorCommandListener viewportSelectorCommandListener;
    private JFrame jFrame;
    private JApplet jApplet;
    private Container parentContainer;
    private Thread shutdownHook;
    private JMenuBar menuBar;
    private YoVariableExplorerTabbedPane yoVariableExplorerTabbedPane;
    private YoBuffer myDataBuffer;
    protected EntryBoxArrayTabbedPanel myEntryBoxArrayPanel;
    protected GraphArrayPanel myGraphArrayPanel;
    private JPanel numericContentPane;
    private Robot[] robots;
    private SelectedVariableHolder selectedVariableHolder;
    private SimulationConstructionSet sim;
    private final YoVariableHolder yoVariableHolder;
    private final GUIEnablerAndDisabler guiEnablerAndDisabler;
    private AllCommandsExecutor allCommandsExecutor;
    private ViewportWindow viewportWindow;
    private GraphArrayWindow graphArrayWindow;
    private final SimulationSynchronizer simulationSynchronizer;
    private StandardGUIActions standardGUIActions;
    private AllDialogConstructorsHolder allDialogConstructorsHolder;
    private VarGroupList varGroupList;
    private ViewportPanel viewportPanel;
    private TimeStepMouseWheelListener timeStepMouseWheelListener;
    private JPanel mainPanel;
    private JPanel mainPanelHolder;
    private String currentView = "Normal View";
    public Canvas3DPanel canvas;
    private JSplitPane jSplitPane;
    private boolean rePaintOnSetPoint = true;
    private int multiViewCanvas = 0;
    private List<Component> tempPanelsHolder = new ArrayList<Component>();
    private YoRegistry rootRegistry;
    private String configFileName = "defaultRegistry.conf";
    private String guiConfigFileEnding = "GuiConfiguration.dat";
    private BookmarkedVariablesHolder bookmarkedVariablesHolder;
    private List<TickUpdateListener> tickUpdateListeners = new ArrayList<TickUpdateListener>();
    private CloseableAndDisposableRegistry closeableAndDisposableRegistry = new CloseableAndDisposableRegistry();
    private List<String> panelsSelectedEarly = new ArrayList<String>();
    private boolean scsWindowOpened = false;
    private double yoGraphicsGlobalScale = 1.0;

    public StandardSimulationGUI(Graphics3DAdapter graphics3dAdapter, SimulationSynchronizer simulationSynchronizer, AllCommandsExecutor allCommandsExecutor, AllDialogConstructorsHolder allDialogConstructorsHolder, SimulationConstructionSet sim, YoVariableHolder yoVariableHolder, Robot[] robots, YoBuffer buffer, VarGroupList varGroupList, JApplet jApplet, YoRegistry rootRegistry) {
        this(graphics3dAdapter, simulationSynchronizer, allCommandsExecutor, allDialogConstructorsHolder, sim, yoVariableHolder, robots, buffer, varGroupList, null, jApplet, rootRegistry);
    }

    public StandardSimulationGUI(Graphics3DAdapter graphics3dAdapter, SimulationSynchronizer simulationSynchronizer, AllCommandsExecutor allCommandsExecutor, AllDialogConstructorsHolder allDialogConstructorsHolder, SimulationConstructionSet sim, YoVariableHolder yoVariableHolder, Robot[] robots, YoBuffer buffer, VarGroupList varGroupList, JFrame frame, YoRegistry rootRegistry) {
        this(graphics3dAdapter, simulationSynchronizer, allCommandsExecutor, allDialogConstructorsHolder, sim, yoVariableHolder, robots, buffer, varGroupList, frame, null, rootRegistry);
    }

    public StandardSimulationGUI(Graphics3DAdapter graphics3dAdapter, SimulationSynchronizer simulationSynchronizer, AllCommandsExecutor allCommandsExecutor, AllDialogConstructorsHolder allDialogConstructorsHolder, SimulationConstructionSet sim, YoVariableHolder yoVariableHolder, Robot[] robots, YoBuffer buffer, VarGroupList varGroupList, JFrame frame, JApplet jApplet, YoRegistry rootRegistry) {
        this.graphics3dAdapter = graphics3dAdapter;
        this.simulationSynchronizer = simulationSynchronizer;
        this.allCommandsExecutor = allCommandsExecutor;
        this.sim = sim;
        this.yoVariableHolder = yoVariableHolder;
        this.guiEnablerAndDisabler = sim;
        this.robots = robots;
        this.myDataBuffer = buffer;
        this.varGroupList = varGroupList;
        this.jFrame = frame;
        this.jApplet = jApplet;
        this.rootRegistry = rootRegistry;
        this.bookmarkedVariablesHolder = new BookmarkedVariablesHolder();
        this.parentContainer = frame != null ? frame : jApplet;
        this.selectedVariableHolder = new SelectedVariableHolder();
        if (robots != null) {
            for (Robot robot : robots) {
                robot.getCameraMountList(this.cameraMountList);
            }
        }
    }

    public ExtraPanelConfigurationList getExtraPanelConfigurationList() {
        return this.extraPanelConfigurationList;
    }

    public JFrame getFrame() {
        return this.jFrame;
    }

    public ViewportPanel getViewportPanel() {
        return this.viewportPanel;
    }

    public void addRobot(Robot robot) {
        boolean wereAlreadySet;
        boolean bl = wereAlreadySet = this.robots != null;
        if (!wereAlreadySet) {
            this.setRobots(new Robot[]{robot});
            return;
        }
        Robot[] newRobots = new Robot[this.robots.length + 1];
        for (int i = 0; i < this.robots.length; ++i) {
            newRobots[i] = this.robots[i];
        }
        newRobots[newRobots.length - 1] = robot;
        this.robots = newRobots;
        robot.getCameraMountList(this.cameraMountList);
        this.createGraphicsRobot(robot);
    }

    public void setRobots(Robot[] robots) {
        boolean wereAlreadySet;
        boolean bl = wereAlreadySet = this.robots != null;
        if (wereAlreadySet) {
            throw new RuntimeException("robots != null. Can only setRobots once!");
        }
        this.robots = robots;
        HeightMap heightMap = null;
        if (robots != null && robots.length > 0) {
            GroundContactModel groundContactModel = robots[0].getGroundContactModel();
            heightMap = HeightMapFromGroundContactModel.getHeightMap(groundContactModel);
        }
        this.setup(heightMap);
        if (robots != null) {
            for (Robot robot : robots) {
                robot.getCameraMountList(this.cameraMountList);
            }
        }
        if (robots != null) {
            this.updateRobotsAndCamera();
        }
    }

    public GraphArrayWindow getGraphArrayWindow(String windowName) {
        if (this.graphArrayWindows == null) {
            return null;
        }
        for (int i = 0; i < this.graphArrayWindows.size(); ++i) {
            GraphArrayWindow graphArrayWindow = this.graphArrayWindows.get(i);
            if (!graphArrayWindow.getName().equals(windowName)) continue;
            return graphArrayWindow;
        }
        return null;
    }

    public GraphArrayWindow createNewGraphWindow(final String graphGroupName, final int screenID, final Point windowLocation, final Dimension windowSize, final boolean maximizeWindow) {
        if (this.graphArrayWindows == null) {
            this.graphArrayWindows = new ArrayList<GraphArrayWindow>();
        }
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                StandardSimulationGUI.this.graphArrayWindow = new GraphArrayWindow(StandardSimulationGUI.this.allCommandsExecutor, StandardSimulationGUI.this.sim, StandardSimulationGUI.this.guiEnablerAndDisabler, StandardSimulationGUI.this.configurationList, StandardSimulationGUI.this.graphGroupList, graphGroupName, StandardSimulationGUI.this.graphConfigurationList, StandardSimulationGUI.this.selectedVariableHolder, StandardSimulationGUI.this.myDataBuffer, StandardSimulationGUI.this.standardGUIActions, screenID, windowLocation, windowSize, maximizeWindow);
            }
        });
        this.graphArrayWindows.add(this.graphArrayWindow);
        StandardGUIActions windowGUIActions = this.graphArrayWindow.getGUIActions();
        windowGUIActions.setupConfigurationMenu(this.configurationList, this.graphArrayWindow, this.allCommandsExecutor);
        GUIConfigurationSaveAndLoad guiConfigurationSaveAndLoad = new GUIConfigurationSaveAndLoad(this.guiEnablerAndDisabler, this);
        guiConfigurationSaveAndLoad.loadGraphConfigurationsInConfigurationMenu();
        windowGUIActions.setupGraphGroupsMenu(this.graphGroupList, this.graphArrayWindow);
        return this.graphArrayWindow;
    }

    public ViewportWindow getViewportWindow(String windowName) {
        if (this.viewportWindows == null) {
            return null;
        }
        for (ViewportWindow viewportWindow : this.viewportWindows) {
            if (!viewportWindow.getName().equals(windowName)) continue;
            return viewportWindow;
        }
        return null;
    }

    public ViewportWindow createNewViewportWindow(String viewportName, int screenID, boolean maximizeWindow) {
        return this.createNewViewportWindow(viewportName, screenID, maximizeWindow, null);
    }

    public ViewportWindow createNewViewportWindow(String viewportName, final int screenID, final boolean maximizeWindow, CameraConfiguration camConfig) {
        if (this.viewportWindows == null) {
            this.viewportWindows = new ArrayList<ViewportWindow>();
        }
        final SimulationConstructionSet yoVariableHolder = this.sim;
        final SimulationConstructionSet timeHolder = this.sim;
        final String selectedViewportName = viewportName;
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                StandardSimulationGUI.this.viewportWindow = new ViewportWindow(StandardSimulationGUI.this.allCommandsExecutor, yoVariableHolder, timeHolder, selectedViewportName, StandardSimulationGUI.this.viewportConfigurationList, StandardSimulationGUI.this.cameraConfigurationList, StandardSimulationGUI.this.cameraMountList, StandardSimulationGUI.this.robots, StandardSimulationGUI.this.varGroupList, StandardSimulationGUI.this.myGraphArrayPanel, StandardSimulationGUI.this.getStandardSimulationGUI(), StandardSimulationGUI.this.graphics3dAdapter, StandardSimulationGUI.this.myDataBuffer, StandardSimulationGUI.this.standardGUIActions, screenID, maximizeWindow, StandardSimulationGUI.this.simulationSynchronizer);
            }
        });
        if (camConfig != null) {
            this.viewportWindow.getViewportPanel().setCameraConfiguration(camConfig, (YoVariableHolder)this.rootRegistry);
        }
        this.viewportWindows.add(this.viewportWindow);
        final StandardGUIActions viewportGUIActions = this.viewportWindow.getGUIActions();
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                viewportGUIActions.setupCameraMenu(StandardSimulationGUI.this.cameraConfigurationList, StandardSimulationGUI.this.viewportWindow.getViewportPanel());
                viewportGUIActions.setupViewportMenu(StandardSimulationGUI.this.allCommandsExecutor, StandardSimulationGUI.this.viewportConfigurationList, StandardSimulationGUI.this.viewportWindow);
            }
        });
        return this.viewportWindow;
    }

    public YoVariableSliderWindow createNewParameterSliderWindow(String viewportName, int screenID, boolean maximizeWindow) {
        return new YoVariableSliderWindow(this.selectedVariableHolder, this.closeableAndDisposableRegistry);
    }

    public void setupMultiViews(String viewportName, ViewportPanel viewport_Panel) {
        if (this.robots == null) {
            return;
        }
        ViewportConfiguration config = this.viewportConfigurationList.getViewportConfiguration(viewportName);
        if (config == null) {
            return;
        }
        viewport_Panel.setupViews(this.jFrame.getGraphicsConfiguration().getDevice(), config);
        this.makeCheckBoxesConsistentWithCamera();
        this.currentView = viewportName;
        int width = this.sim.getJFrame().getWidth() + 1;
        int height = this.sim.getJFrame().getHeight() + 1;
        Dimension d = new Dimension(width, height);
        this.sim.setFrameSize(d);
        viewport_Panel.repaint();
    }

    public void setup(final HeightMap heightMap) {
        this.createGraphicsRobots();
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                StandardSimulationGUI.this.initGUI(heightMap);
                StandardSimulationGUI.this.showGUI();
            }
        });
    }

    public static void showSplashScreen() {
        SplashPanel splashPanel = new SplashPanel();
        splashWindow = splashPanel.showSplashScreen();
    }

    public static void disposeSplashWindow() {
        if (splashWindow != null) {
            splashWindow.dispose();
        }
    }

    private void showGUI() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int screenWidth = gd.getDisplayMode().getWidth();
        int screenHeight = gd.getDisplayMode().getHeight();
        int width = (int)((double)screenWidth * 7.0 / 8.0);
        int height = (int)((double)screenHeight * 7.0 / 8.0);
        this.parentContainer.setSize(width, height);
        int x = width / 16;
        int y = height / 16;
        this.parentContainer.setLocation(x, y);
        this.parentContainer.validate();
    }

    private void initGUI(HeightMap heightMap) {
        if (heightMap == null) {
            heightMap = new FlatGroundProfile();
        }
        if (this.jFrame != null) {
            this.contentPane = this.jFrame.getContentPane();
        } else if (this.jApplet != null) {
            this.contentPane = this.jApplet.getContentPane();
        }
        this.contentPane.removeAll();
        if (this.robots != null) {
            this.myEntryBoxArrayPanel = new EntryBoxArrayTabbedPanel(this.parentContainer, this.selectedVariableHolder);
            this.yoVariableExplorerTabbedPane = new YoVariableExplorerTabbedPane(new YoVariableDoubleClickListener(this.myDataBuffer, this.jFrame), this.jFrame, this.bookmarkedVariablesHolder, this.selectedVariableHolder, null, this.sim, this.rootRegistry);
            YoVariableSearchPanel variableSearchPanel = new YoVariableSearchPanel(this.selectedVariableHolder, this.myDataBuffer, this.myGraphArrayPanel, this.myEntryBoxArrayPanel, this.bookmarkedVariablesHolder, this.yoVariableExplorerTabbedPane);
            this.yoVariableExplorerTabbedPane.addVariableSearchPanel(variableSearchPanel);
            this.myGraphArrayPanel = new GraphArrayPanel(this.selectedVariableHolder, this.myDataBuffer, this.jFrame, this);
        }
        if (this.jFrame != null) {
            this.jFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (StandardSimulationGUI.this.standardGUIActions != null) {
                        StandardSimulationGUI.this.saveDefaultGUIConfigurationFile();
                    }
                    if (StandardSimulationGUI.this.sim.systemExitDisabled()) {
                        StandardSimulationGUI.this.sim.closeAndDispose();
                    } else {
                        System.exit(0);
                    }
                }

                @Override
                public void windowOpened(WindowEvent e) {
                    StandardSimulationGUI.this.scsWindowOpened = true;
                    for (String earlySelection : StandardSimulationGUI.this.panelsSelectedEarly) {
                        StandardSimulationGUI.this.selectPanel(earlySelection);
                    }
                }
            });
            this.jFrame.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    StandardSimulationGUI.this.frameResized();
                }
            });
            if (this.shutdownHook == null) {
                this.shutdownHook = new Thread(){

                    @Override
                    public void run() {
                        StandardSimulationGUI.this.notifyExitActionListeners();
                    }
                };
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
        }
        if (this.robots != null) {
            this.contentPane.setLayout(new GridLayout(1, 1));
        } else {
            this.contentPane.setLayout(new BorderLayout());
        }
        this.graphics3dAdapter.setHeightMap(heightMap);
        if (this.robots != null) {
            this.standardGUIActions = new StandardGUIActions();
            this.allDialogConstructorsHolder = new StandardAllDialogConstructorsGenerator(this.sim, this.robots, this.myDataBuffer, this, this.varGroupList, this.myGraphArrayPanel, this, this.parentContainer, this.jFrame, this.simulationSynchronizer, this.standardGUIActions);
        }
        this.viewportPanel = this.createViewportPanel();
        this.timeStepMouseWheelListener = new TimeStepMouseWheelListener(this);
        this.viewportPanel.addMouseWheelListener(this.timeStepMouseWheelListener);
        this.contentPane.addMouseWheelListener(this.timeStepMouseWheelListener);
        this.splitPane = new JSplitPane(0);
        this.contentPane.add(this.splitPane);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanelHolder = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)this.viewportPanel, "Center");
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setDividerSize(3);
        this.mainPanelHolder.add(this.mainPanel);
        this.splitPane.setTopComponent(this.mainPanelHolder);
        this.splitPane.setResizeWeight(1.0);
        this.dividerLocation = this.splitPane.getDividerLocation();
        if (this.robots != null) {
            this.numericContentPane = new JPanel(new BorderLayout());
            this.splitPane.setBottomComponent(this.numericContentPane);
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.splitPane.setDividerLocation(screenSize.height * 7 / 8 / 2);
        if (this.robots != null) {
            this.standardGUIActions.createMainWindowActions(this.allCommandsExecutor, this.allDialogConstructorsHolder, this.viewportPanel);
            this.buttonPanel = this.standardGUIActions.createMainWindowButtons();
            this.menuBar = this.standardGUIActions.createMainWindowMenus(this);
            StandardViewSetup.setupStandardViews(this);
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            if (this.jFrame != null) {
                this.jFrame.setJMenuBar(this.menuBar);
            } else {
                this.jApplet.setJMenuBar(this.menuBar);
            }
        }
        if (this.robots != null) {
            JButton plusButton = new JButton("+");
            plusButton.setName("Add Numeric Entry Box");
            JButton minusButton = new JButton("-");
            minusButton.setName("Remove Numeric Entry Box");
            plusButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StandardSimulationGUI.this.myEntryBoxArrayPanel.addEmptyTab();
                }
            });
            minusButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StandardSimulationGUI.this.myEntryBoxArrayPanel.getCurrentPanel().closeAndDispose();
                    StandardSimulationGUI.this.myEntryBoxArrayPanel.remove(StandardSimulationGUI.this.myEntryBoxArrayPanel.getCurrentPanel());
                }
            });
            this.numericContentPane.add("North", this.buttonPanel);
            JPanel graphArrayAndButtonPanel = new JPanel(new BorderLayout());
            graphArrayAndButtonPanel.add("Center", this.myGraphArrayPanel);
            JPanel graphButtonPanel = this.myGraphArrayPanel.createGraphButtonPanel();
            graphArrayAndButtonPanel.add("South", graphButtonPanel);
            JPanel entryBoxPanel = new JPanel(new BorderLayout());
            JPanel entryBoxControlPanel = new JPanel(new GridLayout(1, 2));
            entryBoxControlPanel.add(plusButton);
            entryBoxControlPanel.add(minusButton);
            entryBoxPanel.add((Component)entryBoxControlPanel, "West");
            entryBoxPanel.add((Component)this.myEntryBoxArrayPanel, "Center");
            JPanel graphArrayButtonAndEntryBoxPanel = new JPanel(new BorderLayout());
            graphArrayButtonAndEntryBoxPanel.add((Component)graphArrayAndButtonPanel, "Center");
            graphArrayButtonAndEntryBoxPanel.add((Component)entryBoxPanel, "South");
            JSplitPane jSplitPane = new JSplitPane(1, true, this.yoVariableExplorerTabbedPane, graphArrayButtonAndEntryBoxPanel);
            jSplitPane.setDividerSize(3);
            jSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent dividerLocationPropertyChangeEvent) {
                    StandardSimulationGUI.this.yoVariableExplorerTabbedPane.getYoVariableSearchPanel().refreshSearchPanelWidth();
                }
            });
            this.numericContentPane.add("Center", jSplitPane);
            YoVariablePanelJPopupMenu varPanelJPopupMenu = new YoVariablePanelJPopupMenu(this.myGraphArrayPanel, this.myEntryBoxArrayPanel, this.selectedVariableHolder, this.yoVariableExplorerTabbedPane, this.bookmarkedVariablesHolder);
            this.yoVariableExplorerTabbedPane.setVarPanelJPopupMenu(varPanelJPopupMenu);
        }
    }

    private void createGraphicsRobots() {
        if (this.robots != null) {
            for (Robot robot : this.robots) {
                this.createGraphicsRobot(robot);
            }
        }
    }

    private void createGraphicsRobot(Robot robot) {
        GraphicsRobot graphicsRobot = new GraphicsRobot(robot);
        this.graphicsUpdatables.add(graphicsRobot);
        this.graphicsRobots.put(robot, graphicsRobot);
        this.graphics3dAdapter.addRootNode(graphicsRobot.getRootNode());
    }

    public ViewportPanel createViewportPanel() {
        GraphicsDevice device = null;
        if (this.jFrame != null) {
            device = this.jFrame.getGraphicsConfiguration().getDevice();
        }
        ViewportPanel viewportPanel = new ViewportPanel(this.yoVariableHolder, this.allCommandsExecutor, this.standardGUIActions, this.cameraConfigurationList, this.cameraMountList, this.graphics3dAdapter);
        viewportPanel.setupViews(device, null, this.jFrame);
        return viewportPanel;
    }

    public YoVariableExplorerTabbedPane getCombinedVarPanel() {
        return this.yoVariableExplorerTabbedPane;
    }

    public void updateNamespaceHierarchyTree() {
        NamespaceHierarchyTree namespaceHierarchyTree = this.yoVariableExplorerTabbedPane.getNamespaceHierarchyTree();
        namespaceHierarchyTree.createdNewRegistries();
    }

    public void attachExitActionListener(ExitActionListener listener) {
        this.exitActionListeners.add(listener);
    }

    public void addButton(AbstractButton button) {
        this.buttonPanel.add(button);
        this.buttonPanel.updateUI();
    }

    public void addComboBox(JComboBox<?> comboBox) {
        this.buttonPanel.add(comboBox);
        this.buttonPanel.updateUI();
    }

    public void addJLabel(JLabel label) {
        this.buttonPanel.add(label);
        this.buttonPanel.updateUI();
    }

    public void addTextField(JTextField textField) {
        this.buttonPanel.add(textField);
        this.buttonPanel.updateUI();
    }

    public void addRadioButton(JRadioButton button) {
        this.buttonPanel.add(button);
        this.buttonPanel.updateUI();
    }

    public void addCheckBox(JCheckBox checkBox) {
        this.buttonPanel.add(checkBox);
        this.buttonPanel.updateUI();
    }

    public void addMenuBar(JMenuBar menuBar) {
        if (this.buttonPanel != null) {
            this.buttonPanel.add(menuBar);
            this.buttonPanel.updateUI();
        }
    }

    public void addVarList(final YoVariableList list) {
        if (list != null && !list.isEmpty()) {
            EventDispatchThreadHelper.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    StandardSimulationGUI.this.addVarListVarPanel(list);
                }
            });
        }
    }

    public void setCameraTracking(boolean track, boolean trackX, boolean trackY, boolean trackZ) {
        if (this.robots == null) {
            return;
        }
        this.viewportPanel.setCameraTracking(track, trackX, trackY, trackZ);
        this.makeCheckBoxesConsistentWithCamera();
    }

    public void setCameraDolly(boolean dolly, boolean dollyX, boolean dollyY, boolean dollyZ) {
        if (this.robots == null) {
            return;
        }
        this.viewportPanel.setCameraDolly(dolly, dollyX, dollyY, dollyZ);
        this.makeCheckBoxesConsistentWithCamera();
    }

    public void makeCheckBoxesConsistentWithCamera() {
        this.standardGUIActions.makeCheckBoxesConsistentWithCamera();
    }

    public void makeCameraConsistentWithCheckBoxes() {
        this.standardGUIActions.makeCameraConsistentWithCheckBoxes();
    }

    public void disableGUIComponents() {
        if (this.standardGUIActions != null) {
            this.standardGUIActions.disableGUIComponents();
        }
        if (this.myGraphArrayPanel != null) {
            this.myGraphArrayPanel.setInteractionEnable(false);
        }
    }

    public void enableGUIComponents() {
        if (this.standardGUIActions != null) {
            this.standardGUIActions.enableGUIComponents();
        }
        if (this.myGraphArrayPanel != null) {
            this.myGraphArrayPanel.setInteractionEnable(true);
        }
    }

    public void notifySimulationStopped() {
        if (this.standardGUIActions != null) {
            this.standardGUIActions.notifySimulationStopped();
        }
    }

    public void addStaticLinkGraphics(List<Graphics3DObject> staticLinkGraphics) {
        for (Graphics3DObject graphics3dObject : staticLinkGraphics) {
            this.addStaticLinkGraphics(graphics3dObject);
        }
    }

    public Graphics3DNode addStaticLinkGraphics(Graphics3DObject staticLinkGraphics) {
        return this.addStaticLinkGraphics(staticLinkGraphics, Graphics3DNodeType.GROUND);
    }

    public Graphics3DNode addStaticLinkGraphics(Graphics3DObject staticLinkGraphics, Graphics3DNodeType nodeType) {
        Graphics3DNode staticGraphics3d = new Graphics3DNode("Static Link Graphic", nodeType);
        staticGraphics3d.setGraphicsObject(staticLinkGraphics);
        this.graphics3dAdapter.addRootNode(staticGraphics3d);
        return staticGraphics3d;
    }

    public void setupGraph(String varname) {
        if (this.robots == null) {
            return;
        }
        this.myGraphArrayPanel.setupGraph(varname);
    }

    public void setupGraph(String[] varnames) {
        this.myGraphArrayPanel.setupGraph(varnames);
    }

    public void setupGraph(String[][] varnames) {
        if (varnames.length > 1 && varnames[1].length > 0) {
            String graphConfiguration = varnames[1][0];
            this.myGraphArrayPanel.setupGraph(varnames[0], this.graphConfigurationList.getGraphConfiguration(graphConfiguration));
        } else {
            this.myGraphArrayPanel.setupGraph(varnames[0]);
        }
    }

    public void setClipDistances(double near, double far) {
        this.viewportPanel.setClipDistances(near, far);
    }

    public void setFieldOfView(double fieldOfView) {
        this.viewportPanel.setFieldOfView(fieldOfView);
    }

    public void setBackgroundColor(MutableColor color) {
        this.graphics3dAdapter.setBackgroundColor(color);
    }

    public void setBackgroundImage(URL fileURL, Graphics3DBackgroundScaleMode backgroundScaleMode) {
        this.graphics3dAdapter.setBackgroundImage(fileURL, backgroundScaleMode);
    }

    public void setGroundAppearance(AppearanceDefinition app) {
        this.graphics3dAdapter.setGroundAppearance(app);
    }

    public void setupSky(String skyBox) {
        this.graphics3dAdapter.setupSky(skyBox);
    }

    public void setupSky(String west, String east, String north, String south, String up, String down) {
        this.graphics3dAdapter.setupSky(west, east, north, south, up, down);
    }

    public void setGroundVisible(boolean isVisible) {
        this.graphics3dAdapter.setGroundVisible(isVisible);
    }

    public void updateGraphsLeisurely(int leisureRate) {
        if (!this.graphsReadyToUpdate()) {
            return;
        }
        ++this.updateCounts;
        if (this.updateCounts < leisureRate) {
            return;
        }
        this.updateCounts = 0;
        this.repaintGraphs();
    }

    public void updateGraphs() {
        YoVariableSearchPanel yoVariableSearchPanel;
        if (this.graphsReadyToUpdate()) {
            this.repaintGraphs();
        }
        if (this.yoVariableExplorerTabbedPane != null && (yoVariableSearchPanel = this.yoVariableExplorerTabbedPane.getYoVariableSearchPanel()) != null) {
            yoVariableSearchPanel.updateFrameLabel();
        }
    }

    private void repaintGraphs() {
        this.myGraphArrayPanel.repaintGraphs();
        if (this.graphArrayWindows != null) {
            for (int i = 0; i < this.graphArrayWindows.size(); ++i) {
                GraphArrayWindow graphArrayWindow = this.graphArrayWindows.get(i);
                graphArrayWindow.updateGraphs();
            }
        }
    }

    private boolean graphsReadyToUpdate() {
        if (this.myGraphArrayPanel == null) {
            return false;
        }
        if (this.myGraphArrayPanel.isPaintingPanel()) {
            return false;
        }
        if (this.graphArrayWindows != null) {
            for (int i = 0; i < this.graphArrayWindows.size(); ++i) {
                GraphArrayWindow graphArrayWindow = this.graphArrayWindows.get(i);
                if (!graphArrayWindow.isPainting()) continue;
                return false;
            }
        }
        return true;
    }

    public void updateGUI() {
        if (this.myGraphArrayPanel == null) {
            return;
        }
        this.myGraphArrayPanel.repaint();
        for (int i = 0; i < this.graphArrayWindows.size(); ++i) {
            GraphArrayWindow graphArrayWindow = this.graphArrayWindows.get(i);
            graphArrayWindow.updateGUI();
        }
    }

    public void show() {
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (StandardSimulationGUI.this.jFrame != null) {
                    StandardSimulationGUI.this.jFrame.setVisible(true);
                }
                if (StandardSimulationGUI.this.jApplet != null) {
                    ((JPanel)StandardSimulationGUI.this.jApplet.getContentPane()).updateUI();
                }
            }
        });
    }

    public void zoomIn() {
        this.myGraphArrayPanel.zoomIn();
    }

    public void zoomOut() {
        this.myGraphArrayPanel.zoomOut();
    }

    public void gotoInPoint() {
        if (this.myGraphArrayPanel != null) {
            this.myGraphArrayPanel.setIndexLater(this.myDataBuffer.getInPoint());
        }
    }

    public void gotoInPointNow() {
        if (this.myGraphArrayPanel != null) {
            this.myGraphArrayPanel.goToInPointNow();
        }
    }

    public void gotoOutPoint() {
        if (this.myGraphArrayPanel != null) {
            this.myGraphArrayPanel.setIndexLater(this.myDataBuffer.getOutPoint());
        }
    }

    public void gotoOutPointNow() {
        if (this.myGraphArrayPanel != null) {
            this.myGraphArrayPanel.goToOutPointNow();
        }
    }

    public void setInPoint() {
        this.myDataBuffer.setInPoint();
        if (this.rePaintOnSetPoint) {
            this.myGraphArrayPanel.RepaintOnSetPoint();
        }
        this.repaintWindows();
    }

    public void setOutPoint() {
        this.myDataBuffer.setOutPoint();
        if (this.rePaintOnSetPoint) {
            this.myGraphArrayPanel.RepaintOnSetPoint();
        }
        this.repaintWindows();
    }

    public void setInOutPointFullBuffer() {
        this.myDataBuffer.setInOutPointFullBuffer();
        if (this.rePaintOnSetPoint) {
            this.myGraphArrayPanel.RepaintOnSetPoint();
        }
        this.repaintWindows();
    }

    public List<Integer> getKeyPoints() {
        return this.myDataBuffer.getKeyPointsHandler().getKeyPoints();
    }

    public void setKeyPoint() {
        this.myDataBuffer.toggleKeyPoint();
        this.repaintWindows();
    }

    public void toggleCameraKeyMode() {
        this.getCameraPropertiesForActiveCamera().toggleCameraKeyMode();
    }

    public void addCameraKey() {
        this.addCameraKey(this.getCamera());
    }

    private void addCameraKey(TrackingDollyCameraController j3dCameraController) {
        j3dCameraController.setCameraKeyPoint(this.myDataBuffer.getCurrentIndex());
        this.repaintWindows();
    }

    public List<Integer> getCameraKeyPoints() {
        ClassicCameraController classicCameraController = (ClassicCameraController)this.viewportPanel.getCamera();
        return classicCameraController.getCameraKeyPoints();
    }

    public void removeCameraKey() {
        this.removeCameraKey(this.getCameraPropertiesForActiveCamera());
    }

    private void removeCameraKey(TrackingDollyCameraController j3dCameraController) {
        j3dCameraController.removeCameraKeyPoint(this.myDataBuffer.getCurrentIndex());
        this.repaintWindows();
    }

    public void nextCameraKey() {
        this.nextCameraKey(this.getCamera());
    }

    private void nextCameraKey(TrackingDollyCameraController j3dCameraController) {
        j3dCameraController.nextCameraKeyPoint(this.myDataBuffer.getCurrentIndex());
        this.repaintWindows();
    }

    public void previousCameraKey() {
        this.previousCameraKey(this.getCamera());
    }

    private void previousCameraKey(TrackingDollyCameraController j3dCameraController) {
        j3dCameraController.previousCameraKeyPoint(this.myDataBuffer.getCurrentIndex());
        this.repaintWindows();
    }

    public void stepBackward() {
        if (this.myGraphArrayPanel != null) {
            this.myGraphArrayPanel.tickLater(-1);
        }
    }

    public void stepBackward(int ticks) {
        if (this.myGraphArrayPanel != null) {
            this.myGraphArrayPanel.tickLater(-ticks);
        }
    }

    public void stepForward() {
        if (this.myGraphArrayPanel != null) {
            this.myGraphArrayPanel.tickLater(1);
        }
    }

    public void stepForward(int ticks) {
        if (this.myGraphArrayPanel != null) {
            this.myGraphArrayPanel.tickLater(ticks);
        }
    }

    public void stepForwardNow(int ticks) {
        if (this.myGraphArrayPanel != null) {
            this.myGraphArrayPanel.tick(ticks);
        }
    }

    public void zoomFullView() {
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (StandardSimulationGUI.this.myGraphArrayPanel != null) {
                    StandardSimulationGUI.this.myGraphArrayPanel.zoomFullView();
                }
                for (int i = 0; i < StandardSimulationGUI.this.graphArrayWindows.size(); ++i) {
                    GraphArrayWindow graphArrayWindow = (GraphArrayWindow)StandardSimulationGUI.this.graphArrayWindows.get(i);
                    graphArrayWindow.zoomFullView();
                }
            }
        });
    }

    public void repaintWindows() {
        if (this.myGraphArrayPanel != null) {
            this.myGraphArrayPanel.repaint();
        }
        for (int i = 0; i < this.graphArrayWindows.size(); ++i) {
            GraphArrayWindow graphArrayWindow = this.graphArrayWindows.get(i);
            graphArrayWindow.repaint();
        }
    }

    public void setCameraTrackingVars(String xName, String yName, String zName) {
        this.setCameraTrackingVars(null, xName, yName, zName);
    }

    public void setCameraTrackingVars(String namespace, String xName, String yName, String zName) {
        YoDouble zVar;
        YoDouble yVar;
        YoDouble xVar;
        if (namespace != null) {
            xVar = (YoDouble)this.rootRegistry.findVariable(namespace, xName);
            yVar = (YoDouble)this.rootRegistry.findVariable(namespace, yName);
            zVar = (YoDouble)this.rootRegistry.findVariable(namespace, zName);
        } else {
            xVar = (YoDouble)this.rootRegistry.findVariable(xName);
            yVar = (YoDouble)this.rootRegistry.findVariable(yName);
            zVar = (YoDouble)this.rootRegistry.findVariable(zName);
        }
        this.viewportPanel.setCameraTrackingVars(xVar, yVar, zVar);
    }

    public void setCameraDollyVars(String xName, String yName, String zName) {
        this.setCameraDollyVars(null, xName, yName, zName);
    }

    public void setCameraDollyVars(String namespace, String xName, String yName, String zName) {
        YoDouble zVar;
        YoDouble yVar;
        YoDouble xVar;
        if (namespace != null) {
            xVar = (YoDouble)this.rootRegistry.findVariable(namespace, xName);
            yVar = (YoDouble)this.rootRegistry.findVariable(namespace, yName);
            zVar = (YoDouble)this.rootRegistry.findVariable(namespace, zName);
        } else {
            xVar = (YoDouble)this.rootRegistry.findVariable(xName);
            yVar = (YoDouble)this.rootRegistry.findVariable(yName);
            zVar = (YoDouble)this.rootRegistry.findVariable(zName);
        }
        this.viewportPanel.setCameraDollyVars(xVar, yVar, zVar);
    }

    public void setCameraTrackingOffsets(double dx, double dy, double dz) {
        this.viewportPanel.setCameraTrackingOffsets(dx, dy, dz);
    }

    public void setCameraDollyOffsets(double dx, double dy, double dz) {
        this.viewportPanel.setCameraDollyOffsets(dx, dy, dz);
    }

    public void setCameraFix(double fixX, double fixY, double fixZ) {
        this.viewportPanel.setCameraFix(fixX, fixY, fixZ);
    }

    public void setCameraFix(Tuple3DBasics cameraFix) {
        this.viewportPanel.setCameraFix(cameraFix);
    }

    public void setCameraPosition(double posX, double posY, double posZ) {
        this.viewportPanel.setCameraPosition(posX, posY, posZ);
    }

    public void setCameraPosition(Tuple3DBasics cameraPosition) {
        this.viewportPanel.setCameraPosition(cameraPosition);
    }

    public boolean allowTickUpdatesNow() {
        boolean ret = false;
        ret |= this.myGraphArrayPanel.allowTickUpdatesNow();
        for (int i = 0; i < this.graphArrayWindows.size(); ++i) {
            GraphArrayWindow graphArrayWindow = this.graphArrayWindows.get(i);
            ret |= graphArrayWindow.allowTickUpdatesNow();
        }
        TrackingDollyCameraController[] cameras = this.getCameras();
        for (int i = 0; i < cameras.length; ++i) {
            if (!cameras[i].useKeyCameraPoints()) continue;
            cameras[i].setKeyFrameTime(this.myDataBuffer.getCurrentIndex());
        }
        for (TickUpdateListener tickUpdateListener : this.tickUpdateListeners) {
            tickUpdateListener.update(this.myDataBuffer.getCurrentIndex());
        }
        return ret;
    }

    public void addTickUpdateListener(TickUpdateListener tickUpdateListener) {
        this.tickUpdateListeners.add(tickUpdateListener);
    }

    public void removeTickUpdateListener(TickUpdateListener tickUpdateListener) {
        this.tickUpdateListeners.remove(tickUpdateListener);
    }

    @Override
    public void notifyExitActionListeners() {
        for (int i = 0; i < this.exitActionListeners.size(); ++i) {
            ExitActionListener listener = this.exitActionListeners.get(i);
            listener.exitActionPerformed();
        }
    }

    protected void frameResized() {
        if (this.myEntryBoxArrayPanel != null && this.myEntryBoxArrayPanel.getCurrentPanel() != null) {
            this.myEntryBoxArrayPanel.getCurrentPanel().updateRowsColumns();
            this.myEntryBoxArrayPanel.updateUI();
        }
    }

    public void setupConfiguration(String name, String graphGroupName, String entryBoxGroupName) {
        if (this.robots == null) {
            return;
        }
        Configuration config = new Configuration(name);
        config.setGraphGroupName(graphGroupName);
        config.setEntryBoxGroupName(entryBoxGroupName);
        this.configurationList.addConfiguration(config);
        this.standardGUIActions.setupConfigurationMenu(this.configurationList, this, this.allCommandsExecutor);
        GUIConfigurationSaveAndLoad guiConfigurationSaveAndLoad = new GUIConfigurationSaveAndLoad(this.guiEnablerAndDisabler, this);
        guiConfigurationSaveAndLoad.loadGraphConfigurationsInConfigurationMenu();
    }

    public void updateVarGroupList(final VarGroupList varGroupList) {
        if (this.standardGUIActions != null) {
            EventDispatchThreadHelper.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    StandardSimulationGUI.this.standardGUIActions.updateVarGroupList(varGroupList, StandardSimulationGUI.this.getStandardSimulationGUI());
                }
            });
        }
    }

    private StandardSimulationGUI getStandardSimulationGUI() {
        return this;
    }

    public void setupGraphGroup(String name, String[][] vars) {
        this.setupGraphGroup(name, vars, 1);
    }

    public void setupGraphGroup(String name, String[][][] vars) {
        this.setupGraphGroup(name, vars, 1);
    }

    public void setupGraphGroup(String name, String[][] vars, int numColumns) {
        if (this.robots == null) {
            return;
        }
        GraphGroup group = new GraphGroup(name);
        group.addGraphVars(vars);
        group.setNumColumns(numColumns);
        this.graphGroupList.addGraphGroup(group);
        this.standardGUIActions.setupGraphGroupsMenu(this.graphGroupList, this);
    }

    public void setupGraphGroup(String name, String[][][] vars, int numColumns) {
        if (this.robots == null) {
            return;
        }
        GraphGroup group = new GraphGroup(name);
        group.addGraphVars(vars);
        group.setNumColumns(numColumns);
        boolean exists = false;
        for (String currentGroup : this.graphGroupList.getGraphGroupNames()) {
            if (!currentGroup.equals(name)) continue;
            exists = true;
        }
        if (!exists) {
            this.graphGroupList.addGraphGroup(group);
            this.standardGUIActions.setupGraphGroupsMenu(this.graphGroupList, this);
        }
    }

    public void setupEntryBoxGroup(String name, String[] vars) {
        this.setupEntryBoxGroup(name, vars, null);
    }

    public void setupEntryBoxGroup(String name, String[] vars, String[] regularExpressions) {
        if (this.robots == null) {
            return;
        }
        if (this.entryBoxGroupList.getEntryBoxGroup(name) != null) {
            this.entryBoxGroupList.removeEntryBoxGroup(this.entryBoxGroupList.getEntryBoxGroup(name));
        }
        EntryBoxGroup group = new EntryBoxGroup(name);
        if (vars != null) {
            group.addEntryBoxVars(vars);
        }
        if (regularExpressions != null) {
            group.addEntryBoxRegularExpressions(regularExpressions);
        }
        this.entryBoxGroupList.addEntryBoxGroup(group);
        this.standardGUIActions.setupEntryBoxGroupMenu(this.entryBoxGroupList, this);
    }

    @Override
    public void selectGraphConfiguration(String name) {
        if (this.robots == null) {
            return;
        }
        Configuration config = this.configurationList.getConfiguration(name);
        if (config == null) {
            return;
        }
        this.selectGraphGroup(config.getGraphGroupName());
        this.createNewEntryBoxTabFromEntryBoxGroup(config.getEntryBoxGroupName());
    }

    @Override
    public void selectVarGroup(String name) {
        if (this.robots == null) {
            return;
        }
        VarGroup group = this.varGroupList.getVarGroup(name);
        if (group == null) {
            return;
        }
        String[] varNames = group.getVars();
        String[] regularExpressions = group.getRegularExpressions();
        ArrayList matchedVariables = new ArrayList();
        if (varNames != null) {
            Stream.of(varNames).map(varName -> this.rootRegistry.findVariable(varName)).filter(var -> var != null).forEach(matchedVariables::add);
        }
        if (regularExpressions != null) {
            Stream.of(regularExpressions).map(regex -> YoSearchTools.filterVariables((Predicate)YoSearchTools.regularExpressionFilter((String[])new String[]{regex}), (YoVariableHolder)this.rootRegistry)).forEach(matchedVariables::addAll);
        }
        YoVariableList varList = new YoVariableList(name);
        varList.addAll(matchedVariables);
        this.addVarListVarPanel(varList);
    }

    private void addVarListVarPanel(YoVariableList varList) {
        if (this.yoVariableExplorerTabbedPane != null) {
            YoVariablePanelJPopupMenu varPanelJPopupMenu = new YoVariablePanelJPopupMenu(this.myGraphArrayPanel, this.myEntryBoxArrayPanel, this.selectedVariableHolder, this.yoVariableExplorerTabbedPane, this.bookmarkedVariablesHolder);
            YoVariableListPanel panel = new YoVariableListPanel(varList, this.selectedVariableHolder, varPanelJPopupMenu);
            this.yoVariableExplorerTabbedPane.addExtraVarPanel(panel);
        }
    }

    @Override
    public void selectGraphGroup(final String name) {
        if (this.myGraphArrayPanel == null) {
            return;
        }
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                GraphGroup group = StandardSimulationGUI.this.graphGroupList.getGraphGroup(name);
                if (group == null) {
                    return;
                }
                StandardSimulationGUI.this.myGraphArrayPanel.removeAllGraphs();
                StandardSimulationGUI.this.myGraphArrayPanel.setNumColumns(group.getNumColumns());
                ArrayList<String[][]> graphVars = group.getGraphVars();
                for (int i = 0; i < graphVars.size(); ++i) {
                    StandardSimulationGUI.this.setupGraph((String[][])graphVars.get(i));
                }
            }
        });
    }

    public EntryBoxArrayPanel getEntryBoxArrayPanel() {
        return this.myEntryBoxArrayPanel.getCurrentPanel(true);
    }

    public void createNewEntryBoxTabFromEntryBoxGroup(final String name) {
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                StandardSimulationGUI.this.createNewEntryBoxTabFromEntryBoxGroupLocal(name);
            }
        });
    }

    public void createNewEntryBoxTabFromEntryBoxGroupLocal(String name) {
        if (this.myEntryBoxArrayPanel.getTabCount() > 0) {
            for (int i = 0; i < this.myEntryBoxArrayPanel.getTabCount(); ++i) {
                if (this.myEntryBoxArrayPanel.getComponentAt(i) == null || !this.myEntryBoxArrayPanel.getComponentAt(i).getName().equals(name)) continue;
                this.myEntryBoxArrayPanel.removeTabAt(i);
                break;
            }
        }
        if (this.myEntryBoxArrayPanel == null) {
            return;
        }
        EntryBoxGroup group = this.entryBoxGroupList.getEntryBoxGroup(name);
        if (group == null) {
            return;
        }
        String[] entryBoxVars = group.getEntryBoxVars();
        String[] entryBoxRegularExpressions = group.getEntryBoxRegularExpressions();
        ArrayList matchingVariables = new ArrayList();
        if (entryBoxVars != null) {
            Stream.of(entryBoxVars).filter(varName -> varName != null).map(varName -> this.rootRegistry.findVariable(varName)).filter(var -> var != null).forEach(matchingVariables::add);
        }
        if (entryBoxRegularExpressions != null) {
            Stream.of(entryBoxRegularExpressions).filter(regex -> regex != null).map(regex -> YoSearchTools.filterVariables((Predicate)YoSearchTools.regularExpressionFilter((String[])new String[]{regex}), (YoVariableHolder)this.rootRegistry)).forEach(matchingVariables::addAll);
        }
        EntryBoxArrayPanel tmpEntryBoxArrayPanel = new EntryBoxArrayPanel(this.parentContainer, this.selectedVariableHolder, matchingVariables);
        tmpEntryBoxArrayPanel.setName(name);
        this.myEntryBoxArrayPanel.addEntryBoxArrayPanel(name, tmpEntryBoxArrayPanel);
        this.myEntryBoxArrayPanel.getCurrentPanel().checkStatus();
        this.numericContentPane.repaint();
    }

    @Override
    public void selectEntryBoxGroup(String name) {
        if (this.myEntryBoxArrayPanel == null) {
            return;
        }
        EntryBoxGroup group = this.entryBoxGroupList.getEntryBoxGroup(name);
        if (group == null) {
            return;
        }
        String[] entryBoxVars = group.getEntryBoxVars();
        String[] entryBoxRegularExpressions = group.getEntryBoxRegularExpressions();
        ArrayList matchingVariables = new ArrayList();
        if (entryBoxVars != null) {
            Stream.of(entryBoxVars).map(varName -> this.rootRegistry.findVariable(varName)).filter(var -> var != null).forEach(matchingVariables::add);
        }
        if (entryBoxRegularExpressions != null) {
            Stream.of(entryBoxRegularExpressions).map(regex -> YoSearchTools.filterVariables((Predicate)YoSearchTools.regularExpressionFilter((String[])new String[]{regex}), (YoVariableHolder)this.rootRegistry)).forEach(matchingVariables::addAll);
        }
        this.setupEntryBox(matchingVariables);
        this.myEntryBoxArrayPanel.getCurrentPanel().checkStatus();
        this.numericContentPane.repaint();
    }

    public void setupEntryBox(String varname) {
        final YoVariable v = this.rootRegistry.findVariable(varname);
        if (v != null) {
            EventDispatchThreadHelper.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    StandardSimulationGUI.this.myEntryBoxArrayPanel.getCurrentPanel(true).addEntryBox(v);
                }
            });
        }
    }

    public void setupEntryBox(final List<? extends YoVariable> variables) {
        if (variables == null) {
            return;
        }
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < variables.size(); ++i) {
                    YoVariable v = (YoVariable)variables.get(i);
                    if (v == null) continue;
                    StandardSimulationGUI.this.myEntryBoxArrayPanel.getCurrentPanel(true).addEntryBox(v);
                }
            }
        });
    }

    public void setupEntryBox(String[] varnames) {
        if (varnames == null) {
            return;
        }
        for (int i = 0; i < varnames.length; ++i) {
            YoVariable v = this.rootRegistry.findVariable(varnames[i]);
            if (v == null) continue;
            this.myEntryBoxArrayPanel.getCurrentPanel().addEntryBox(v);
        }
    }

    public void setupCamera(CameraConfiguration cameraConfiguration) {
        if (this.robots == null) {
            return;
        }
        this.cameraConfigurationList.addCameraConfiguration(cameraConfiguration);
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                StandardSimulationGUI.this.standardGUIActions.setupCameraMenu(StandardSimulationGUI.this.cameraConfigurationList, StandardSimulationGUI.this.getStandardSimulationGUI());
            }
        });
    }

    public void setupExtraPanels(ExtraPanelConfiguration panelConfiguration) {
        if (this.robots == null) {
            return;
        }
        this.extraPanelConfigurationList.addExtraPanelConfiguration(panelConfiguration);
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                StandardSimulationGUI.this.standardGUIActions.setupExtraPanelsMenu(StandardSimulationGUI.this.extraPanelConfigurationList, StandardSimulationGUI.this.getStandardSimulationGUI());
            }
        });
    }

    @Override
    public void selectCamera(String cameraName) {
        this.viewportPanel.selectCamera(cameraName);
        this.makeCheckBoxesConsistentWithCamera();
    }

    public void drawMainViewportWithExtraPanels() {
        if (this.mainPanel != null) {
            this.mainPanel.removeAll();
        }
        if (this.jSplitPane != null) {
            this.jSplitPane.removeAll();
        }
        if (this.tempPanelsHolder.size() == 0) {
            this.mainPanel.add(this.viewportPanel);
        } else {
            ArrayList<JSplitPane> dividers = new ArrayList<JSplitPane>();
            this.jSplitPane = new JSplitPane(1, this.viewportPanel, this.tempPanelsHolder.get(0));
            dividers.add(this.jSplitPane);
            for (int i = 1; i < this.tempPanelsHolder.size(); ++i) {
                this.jSplitPane = new JSplitPane(1, this.jSplitPane, this.tempPanelsHolder.get(i));
                dividers.add(this.jSplitPane);
            }
            int currentPlaceOfLastDivider = 0;
            for (int j = 0; j < dividers.size(); ++j) {
                ((JSplitPane)dividers.get(j)).setDividerLocation(currentPlaceOfLastDivider + this.mainPanel.getWidth() / (dividers.size() + 1));
                currentPlaceOfLastDivider += this.mainPanel.getWidth() / (dividers.size() + 1);
            }
            this.mainPanel.add(this.jSplitPane);
        }
        int width = this.sim.getJFrame().getWidth() + 1;
        int height = this.sim.getJFrame().getHeight() + 1;
        Dimension d = new Dimension(width, height);
        this.sim.setFrameSize(d);
        this.viewportPanel.repaint();
        this.mainPanel.updateUI();
    }

    public void addJComponentToMainPanel(JComponent comp, String index) {
        this.mainPanelHolder.add((Component)comp, index);
    }

    public void addJComponentToNumericContentPane(JComponent comp, String index) {
        this.numericContentPane.add((Component)comp, index);
    }

    @Override
    public void selectPanel(String panelName) {
        if (!this.scsWindowOpened) {
            this.panelsSelectedEarly.add(panelName);
            return;
        }
        for (int i = 0; i < this.standardGUIActions.extraPanelsMenu.getItemCount(); ++i) {
            if (!this.standardGUIActions.extraPanelsMenu.getItem(i).getText().equals(panelName)) continue;
            this.makeCheckMarksConsistentForExtraPanels(panelName, this.standardGUIActions.extraPanelsMenu.getItem(i).isSelected());
            if (this.standardGUIActions.extraPanelsMenu.getItem(i).isSelected()) {
                this.tempPanelsHolder.add(this.getExtraPanel(panelName));
                this.drawMainViewportWithExtraPanels();
                continue;
            }
            boolean wasInThisWindow = true;
            if (!this.tempPanelsHolder.contains(this.getExtraPanel(panelName))) {
                wasInThisWindow = false;
            }
            this.removeExtraPanel(panelName);
            if (wasInThisWindow) continue;
            this.tempPanelsHolder.add(this.getExtraPanel(panelName));
            this.drawMainViewportWithExtraPanels();
        }
    }

    public TrackingDollyCameraController getCameraPropertiesForActiveCamera() {
        return this.viewportPanel.getCameraPropertiesForActiveCamera();
    }

    public ViewportAdapter getActiveView() {
        return this.viewportPanel.getActiveView();
    }

    @Override
    public TrackingDollyCameraController getCamera() {
        return this.viewportPanel.getCamera();
    }

    public TrackingDollyCameraController[] getCameras() {
        return this.viewportPanel.getCameras();
    }

    @Override
    public CaptureDevice getActiveCaptureDevice() {
        return this.getActiveView().getCaptureDevice();
    }

    public void setupViewport(ViewportConfiguration viewportConfiguration) {
        if (this.robots == null) {
            return;
        }
        this.viewportConfigurationList.addViewportConfiguration(viewportConfiguration);
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                StandardSimulationGUI.this.standardGUIActions.setupViewportMenu(StandardSimulationGUI.this.allCommandsExecutor, StandardSimulationGUI.this.viewportConfigurationList, StandardSimulationGUI.this.getStandardSimulationGUI());
            }
        });
    }

    @Override
    public void selectViewport(final String viewportName) {
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                StandardSimulationGUI.this.selectViewportLocal(viewportName);
            }
        });
    }

    public void selectViewportLocal(String viewportName) {
        if (this.robots == null) {
            return;
        }
        ViewportConfiguration config = this.viewportConfigurationList.getViewportConfiguration(viewportName);
        if (config == null) {
            return;
        }
        GraphicsDevice graphicsDevice = this.jFrame != null ? this.jFrame.getGraphicsConfiguration().getDevice() : null;
        this.viewportPanel.setupViews(graphicsDevice, config);
        this.makeCheckBoxesConsistentWithCamera();
        this.currentView = viewportName;
        int width = this.parentContainer.getWidth() + 1;
        int height = this.parentContainer.getHeight() + 1;
        Dimension d = new Dimension(width, height);
        this.parentContainer.setSize(d);
        this.viewportPanel.repaint();
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                StandardSimulationGUI.this.mainPanel.updateUI();
            }
        });
    }

    public void selectViewport_ViewPorts(String view) {
        int z = this.multiViewCanvas;
        if (this.robots == null) {
            return;
        }
        ViewportConfiguration config = this.viewportConfigurationList.getViewportConfiguration(view);
        if (config == null) {
            return;
        }
        this.viewportWindows.get(z).getViewportPanel().setupViews(this.viewportWindows.get(z).getViewportPanel().getParent().getGraphicsConfiguration().getDevice(), config);
        this.makeCheckBoxesConsistentWithCamera();
        int width = this.viewportWindows.get(z).getViewportPanel().getParent().getWidth() + 1;
        int height = this.viewportWindows.get(z).getViewportPanel().getParent().getHeight() + 1;
        Dimension d = new Dimension(width, height);
        this.viewportWindows.get(z).getViewportPanel().getParent().setSize(d);
        this.viewportWindows.get(z).getViewportPanel().updateUI();
    }

    public void setupGraphConfigurations(GraphConfiguration[] configurations) {
        if (this.robots == null) {
            return;
        }
        for (int i = 0; i < configurations.length; ++i) {
            this.graphConfigurationList.addGraphConfiguration(configurations[i]);
        }
    }

    public void updateRobots() {
        for (Robot robot : this.robots) {
            robot.updateForPlayback();
        }
    }

    public void updateRobotsAndCamera() {
        if (this.robots != null) {
            for (Robot robot : this.robots) {
                robot.update();
            }
        }
        this.updateSimulationGraphics();
    }

    public void maximizeMainWindow() {
        this.jFrame.setExtendedState(6);
    }

    public void setExportDataDirectory(String directory) {
        this.standardGUIActions.setExportDataDirectory(directory);
    }

    public void setImportDataDirectory(String directory) {
        this.standardGUIActions.setImportDataDirectory(directory);
    }

    public void loadGUIConfigurationFile(File file) {
        this.standardGUIActions.loadGUIConfigurationFile(file);
    }

    @Override
    public void hideViewport() {
        boolean isEventDispatchingThread = SwingUtilities.isEventDispatchThread();
        if (!isEventDispatchingThread) {
            System.err.println("hideViewport() called but not isEventDispatchingThread. This can cause threading issues!");
        }
        this.isViewportHidden = true;
        this.dividerLocation = this.splitPane.getDividerLocation();
        this.contentPane.removeAll();
        this.contentPane.setLayout(new GridLayout(1, 1));
        this.contentPane.add(this.numericContentPane);
        this.viewportSelectorCommandListener.updateViewportStatus();
        this.contentPane.validate();
    }

    @Override
    public void showViewport() {
        this.contentPane.removeAll();
        this.contentPane.setLayout(new GridLayout(1, 1));
        this.splitPane = new JSplitPane(0);
        this.contentPane.add(this.splitPane);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setDividerSize(3);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setTopComponent(this.mainPanel);
        this.splitPane.setBottomComponent(this.numericContentPane);
        this.splitPane.setDividerLocation(this.dividerLocation);
        this.isViewportHidden = false;
        this.viewportSelectorCommandListener.updateViewportStatus();
        this.contentPane.validate();
    }

    @Override
    public boolean isViewportHidden() {
        return this.isViewportHidden;
    }

    @Override
    public void registerViewportSelectorCommandListener(ViewportSelectorCommandListener viewportSelectorCommandListener) {
        this.viewportSelectorCommandListener = viewportSelectorCommandListener;
    }

    public List<ViewportWindow> getViewportWindows() {
        return this.viewportWindows;
    }

    public List<GraphArrayWindow> getGraphArrayWindows() {
        return this.graphArrayWindows;
    }

    public GraphArrayPanel getGraphArrayPanel() {
        return this.myGraphArrayPanel;
    }

    public String getXMLStyleRepresentationOfEntryBoxes() {
        return this.myEntryBoxArrayPanel.getXMLRepresentationOfClass();
    }

    public String getXMLStyleRepresentationOfGraphArrayPanel() {
        return this.myGraphArrayPanel.getXMLRepresentationOfClass();
    }

    public String getXMLStyleRepresentationofJPanels() {
        String textToWrite = "";
        textToWrite = textToWrite + "\n<Extra Panels>";
        textToWrite = textToWrite + "\n<Main Viewport>\n";
        for (Component panel : this.tempPanelsHolder) {
            textToWrite = textToWrite + panel.getName() + ",";
        }
        textToWrite = textToWrite + "\n</Main Viewport>";
        int viewportNumber = 1;
        for (ViewportWindow viewport : this.viewportWindows) {
            if (!viewport.isVisable()) continue;
            textToWrite = textToWrite + "\n<Viewport" + viewportNumber + ">\n";
            textToWrite = textToWrite + viewport.savingExtraPanels();
            textToWrite = textToWrite + "\n</Viewport" + viewportNumber + ">\n";
            ++viewportNumber;
        }
        textToWrite = textToWrite + "</Extra Panels>\n";
        return textToWrite;
    }

    public void addPanelToTempHolderMainViewport(String panelName) {
        this.tempPanelsHolder.add(this.getExtraPanel(panelName));
        this.drawMainViewportWithExtraPanels();
    }

    public void addPanelToTempHolderViewport(String panelName, int i) {
        this.viewportWindows.get(--i).addPanelToTempHolder(this.getExtraPanel(panelName));
    }

    public String getXMLStyleRepresentationOfViewPorts() {
        String textToWrite = "";
        int z = 1;
        int counter = 1;
        for (ViewportWindow viewport : this.getViewportWindows()) {
            if (!viewport.isVisable()) continue;
            ++z;
        }
        textToWrite = textToWrite + "\n<Number of ViewPorts>" + z + "</Number of ViewPorts>";
        textToWrite = textToWrite + this.viewportPanel.getXMLStyleRepresentationOfMainViewPort(!this.isViewportHidden);
        for (ViewportWindow viewport : this.getViewportWindows()) {
            if (!viewport.isVisable()) continue;
            textToWrite = textToWrite + "\n<Viewport" + counter + ">\n<Visible>" + !viewport.isViewportHidden() + "</Visible>";
            int canvasNumber = 1;
            textToWrite = textToWrite + "\n<Canvas Number>" + viewport.getCameraAdapters().size() + "</Canvas Number>";
            for (ViewportAdapterAndCameraControllerHolder view3d : viewport.getCameraAdapters()) {
                textToWrite = textToWrite + viewport.getXMLStyleRepresentationOfClass(view3d, canvasNumber);
                ++canvasNumber;
            }
            textToWrite = textToWrite + "\n</Viewport" + counter + ">";
            ++counter;
        }
        return textToWrite;
    }

    public boolean setViewportFromXMLDescription(String importXML) {
        boolean visible = this.viewportPanel.setMainViewPortFromXMLDescription(importXML);
        return visible;
    }

    public String getXMLStyleRepresentationOfGraphWindows() {
        String textToWrite = "";
        int numberOfGraphWindows = 0;
        for (GraphArrayWindow grapharray : this.getGraphArrayWindows()) {
            if (!grapharray.isVisable()) continue;
            ++numberOfGraphWindows;
        }
        textToWrite = textToWrite + "\n<Graph Array Window Size>" + numberOfGraphWindows + "</Graph Array Window Size>\n";
        int z = 0;
        int window = 1;
        for (GraphArrayWindow grapharray : this.getGraphArrayWindows()) {
            if (grapharray.isVisable()) {
                textToWrite = textToWrite + "<Graph Array Window" + window + ">\n";
                textToWrite = textToWrite + "<ScreenID>" + grapharray.getScreenID() + "</ScreenID>\n";
                Point windowLocation = grapharray.getWindowLocationOnScreen();
                textToWrite = textToWrite + "<WindowLocation>" + windowLocation.getX() + ", " + windowLocation.getY() + "</WindowLocation>\n";
                Dimension windowSize = grapharray.getWindowSize();
                textToWrite = textToWrite + "<WindowSize>" + windowSize.getWidth() + ", " + windowSize.getHeight() + "</WindowSize>\n";
                textToWrite = textToWrite + this.graphArrayWindows.get((int)z).myGraphArrayPanel.getXMLRepresentationOfClass();
                textToWrite = textToWrite + "\n</Graph Array Window" + window + ">";
                ++window;
            }
            ++z;
        }
        return textToWrite;
    }

    public void makeCheckBoxesConsistent(int item, boolean selected) {
        this.standardGUIActions.extraPanelsMenu.getItem(item).setSelected(selected);
    }

    public String getXMLStyleRepresentationofMultiViews() {
        return this.viewportPanel.getXMLStyleRepresentationofMultiViews(this.currentView);
    }

    public void setupMultiViews(String xmlRepresentation, String currentView) {
        this.viewportPanel.setupMultiViews(xmlRepresentation, currentView);
    }

    public void loadDefaultGUIConfigurationFile() {
        GUIConfigurationSaveAndLoad guiConfigurationSaveAndLoad = new GUIConfigurationSaveAndLoad(this.guiEnablerAndDisabler, this);
        guiConfigurationSaveAndLoad.loadGUIConfiguration(this.getDefaultFile(this.guiConfigFileEnding));
    }

    public void saveNormalGUIConfigurationFile() {
        GUIConfigurationSaveAndLoad guiConfigurationSaveAndLoad = new GUIConfigurationSaveAndLoad(this.guiEnablerAndDisabler, this);
        guiConfigurationSaveAndLoad.saveNormalGUIConfiguration();
    }

    private void saveDefaultGUIConfigurationFile() {
        GUIConfigurationSaveAndLoad guiConfigurationSaveAndLoad = new GUIConfigurationSaveAndLoad(this.guiEnablerAndDisabler, this);
        guiConfigurationSaveAndLoad.defaultSave(this.getDefaultFile(this.guiConfigFileEnding));
    }

    private String getDefaultFile(String extension) {
        if (this.robots == null) {
            return null;
        }
        if (this.robots[0] == null) {
            return null;
        }
        this.configFileName = this.robots[0].getName() + "_" + this.sim.getRunningName() + "_" + extension;
        File Configs = new File("Configurations");
        if (!Configs.exists()) {
            Configs.mkdir();
        }
        String path = Configs.toURI().getPath();
        String defaultConfiguration = path + this.configFileName;
        return defaultConfiguration;
    }

    public void setupMultiViewsMultipleViewports(String xmlRepresentation, int size) {
        int z = this.multiViewCanvas;
        for (int i = 0; i < size; ++i) {
            int label = i + 1;
            String first = "<Canvas" + label + ">";
            String second = "</Canvas" + label + ">";
            String textToLoad = XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)first, (String)second);
            double posX = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Viewport Camera X>", (String)"</Viewport Camera X>"));
            double posY = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Viewport Camera Y>", (String)"</Viewport Camera Y>"));
            double posZ = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Viewport Camera Z>", (String)"</Viewport Camera Z>"));
            this.viewportWindows.get(z).getCameraAdapters().get(i).getCameraController().setCameraPosition(posX, posY, posZ);
            String Dolly = XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Dolly data>", (String)"</Dolly data>");
            double DollyX = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Position X>", (String)"</Position X>"));
            double DollyY = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Position Y>", (String)"</Position Y>"));
            double DollyZ = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Position Z>", (String)"</Position Z>"));
            this.viewportWindows.get(z).getCameraAdapters().get(i).getCameraController().setDollyOffsets(DollyX, DollyY, DollyZ);
            String Dolly_Boolean = XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Dolly>", (String)"</Dolly>");
            String Dolly_Boolean_X = XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Dolly X>", (String)"</Dolly X>");
            String Dolly_Boolean_Y = XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Dolly Y>", (String)"</Dolly Y>");
            String Dolly_Boolean_Z = XMLReaderUtility.getMiddleString((int)0, (String)Dolly, (String)"<Dolly Z>", (String)"</Dolly Z>");
            boolean dolly_set = true;
            boolean dolly_setX = true;
            boolean dolly_setY = true;
            boolean dolly_setZ = true;
            if (Dolly_Boolean.equals("false")) {
                dolly_set = false;
            }
            if (Dolly_Boolean_X.equals("false")) {
                dolly_setX = false;
            }
            if (Dolly_Boolean_Y.equals("false")) {
                dolly_setY = false;
            }
            if (Dolly_Boolean_Z.equals("false")) {
                dolly_setZ = false;
            }
            this.viewportWindows.get(z).getCameraAdapters().get(i).getCameraController().setDolly(dolly_set, dolly_setX, dolly_setY, dolly_setZ);
            String Track = XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Track data>", (String)"</Track data>");
            double TrackX = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Position X>", (String)"</Position X>"));
            double TrackY = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Position Y>", (String)"</Position Y>"));
            double TrackZ = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Position Z>", (String)"</Position Z>"));
            this.viewportWindows.get(z).getCameraAdapters().get(i).getCameraController().setTrackingOffsets(TrackX, TrackY, TrackZ);
            String Track_Boolean = XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Track>", (String)"</Track>");
            String Track_Boolean_X = XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Track X>", (String)"</Track X>");
            String Track_Boolean_Y = XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Track Y>", (String)"</Track Y>");
            String Track_Boolean_Z = XMLReaderUtility.getMiddleString((int)0, (String)Track, (String)"<Track Z>", (String)"</Track Z>");
            boolean track_set = true;
            boolean track_setX = true;
            boolean track_setY = true;
            boolean track_setZ = true;
            if (Track_Boolean.equals("false")) {
                track_set = false;
            }
            if (Track_Boolean_X.equals("false")) {
                track_setX = false;
            }
            if (Track_Boolean_Y.equals("false")) {
                track_setY = false;
            }
            if (Track_Boolean_Z.equals("false")) {
                track_setZ = false;
            }
            this.viewportWindows.get(z).getCameraAdapters().get(i).getCameraController().setTracking(track_set, track_setX, track_setY, track_setZ);
            String Fix = XMLReaderUtility.getMiddleString((int)0, (String)textToLoad, (String)"<Fix Position>", (String)"</Fix Position>");
            double FixX = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Fix, (String)"<Fix X>", (String)"</Fix X>"));
            double FixY = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Fix, (String)"<Fix Y>", (String)"</Fix Y>"));
            double FixZ = Double.parseDouble(XMLReaderUtility.getMiddleString((int)0, (String)Fix, (String)"<Fix Z>", (String)"</Fix Z>"));
            this.viewportWindows.get(z).getCameraAdapters().get(i).getCameraController().setFixPosition(FixX, FixY, FixZ);
        }
        ++this.multiViewCanvas;
    }

    public Component getExtraPanel(String panelName) {
        return this.extraPanelConfigurationList.getExtraPanelConfiguration(panelName).getPanel();
    }

    public void makeCheckMarksConsistentForExtraPanels(String panelName, boolean isSelected) {
        for (int i = 0; i < this.standardGUIActions.extraPanelsMenu.getItemCount(); ++i) {
            if (!panelName.equals(this.standardGUIActions.extraPanelsMenu.getItem(i).getText())) continue;
            this.standardGUIActions.extraPanelsMenu.getItem(i).setSelected(isSelected);
        }
        for (ViewportWindow viewport : this.viewportWindows) {
            viewport.makeExtraPanelsMenuConsistent(panelName, isSelected);
        }
    }

    public void removeExtraPanel(String panelName) {
        for (ViewportWindow viewport : this.viewportWindows) {
            viewport.removeExtraPanel(panelName);
        }
        this.tempPanelsHolder.remove(this.getExtraPanel(panelName));
        this.drawMainViewportWithExtraPanels();
    }

    public void makeCheckMarksConsistentWithMainPanel(ViewportWindow viewport) {
        for (int i = 0; i < this.standardGUIActions.extraPanelsMenu.getItemCount(); ++i) {
            if (!this.standardGUIActions.extraPanelsMenu.getItem(i).isSelected()) continue;
            viewport.makeExtraPanelsMenuConsistent(this.standardGUIActions.extraPanelsMenu.getItem(i).getText(), true);
        }
    }

    public BookmarkedVariablesHolder getBookmarkedVariablesHolder() {
        return this.bookmarkedVariablesHolder;
    }

    public GraphicsDynamicGraphicsObject addYoGraphic(YoGraphic yoGraphic, boolean updateFromSimulationThread) {
        GraphicsDynamicGraphicsObject graphicsDynamicGraphicsObject = new GraphicsDynamicGraphicsObject(yoGraphic);
        if (updateFromSimulationThread) {
            this.graphicsUpdatables.add(graphicsDynamicGraphicsObject);
        }
        this.graphics3dAdapter.addRootNode((Graphics3DNode)graphicsDynamicGraphicsObject);
        return graphicsDynamicGraphicsObject;
    }

    public void addYoGraphicsList(YoGraphicsList yoGraphicsList, boolean updateFromSimulationThread) {
        for (YoGraphic yoGraphic : yoGraphicsList.getYoGraphics()) {
            this.addYoGraphic(yoGraphic, updateFromSimulationThread);
        }
    }

    public void addYoGraphicsList(YoGraphicsList yoGraphicObjectsList, boolean updateFromSimulationThread, List<GraphicsUpdatable> graphicsUpdatablesToPack) {
        for (YoGraphic yoGraphic : yoGraphicObjectsList.getYoGraphics()) {
            graphicsUpdatablesToPack.add(this.addYoGraphic(yoGraphic, updateFromSimulationThread));
        }
    }

    public void addYoGraphicsLists(List<YoGraphicsList> yoGraphicObjectsLists, boolean updateFromSimulationThread, List<GraphicsUpdatable> graphicsUpdatablesToPack) {
        for (YoGraphicsList yoGraphicsList : yoGraphicObjectsLists) {
            this.addYoGraphicsList(yoGraphicsList, updateFromSimulationThread, graphicsUpdatablesToPack);
        }
    }

    public void setYoGraphicsGlobalScale(double globalScale) {
        this.yoGraphicsGlobalScale = globalScale;
    }

    public double getYoGraphicsGlobalScale() {
        return this.yoGraphicsGlobalScale;
    }

    public DoubleProvider getYoGraphicsGlobalScaleProvider() {
        return () -> this.yoGraphicsGlobalScale;
    }

    public void addYoGraphicsListRegistry(YoGraphicsListRegistry yoGraphicsListRegistry, boolean updateFromSimulationThread) {
        if (!updateFromSimulationThread && this.graphics3dAdapter != null) {
            yoGraphicsListRegistry.setGraphicsConch(this.graphics3dAdapter.getGraphicsConch());
        }
        ArrayList<GraphicsUpdatable> graphicsDynamicGraphicsObjects = new ArrayList<GraphicsUpdatable>();
        this.addYoGraphicsLists(yoGraphicsListRegistry.getYoGraphicsLists(), updateFromSimulationThread, graphicsDynamicGraphicsObjects);
        if (!updateFromSimulationThread) {
            yoGraphicsListRegistry.addGraphicsUpdatables(graphicsDynamicGraphicsObjects);
        }
        yoGraphicsListRegistry.setYoGraphicsUpdatedRemotely(updateFromSimulationThread);
        yoGraphicsListRegistry.setYoGraphicsRegistered();
        yoGraphicsListRegistry.setGlobalScaleProvider(() -> this.yoGraphicsGlobalScale);
    }

    public GraphGroupList getGraphGroupList() {
        return this.graphGroupList;
    }

    public EntryBoxGroupList getEntryBoxGroupList() {
        return this.entryBoxGroupList;
    }

    public ConfigurationList getConfigurationList() {
        return this.configurationList;
    }

    public CameraConfigurationList getCameraConfigurationList() {
        return this.cameraConfigurationList;
    }

    public ViewportConfigurationList getViewportConfigurationList() {
        return this.viewportConfigurationList;
    }

    public GraphConfigurationList getGraphConfigurationList() {
        return this.graphConfigurationList;
    }

    public StandardGUIActions getStandardGUIActions() {
        return this.standardGUIActions;
    }

    @Override
    public void closeAndDispose() {
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                StandardSimulationGUI.this.closeAndDisposeLocal();
            }
        });
    }

    private void closeAndDisposeLocal() {
        System.out.flush();
        System.out.flush();
        if (this.closeableAndDisposableRegistry != null) {
            this.closeableAndDisposableRegistry.closeAndDispose();
            this.closeableAndDisposableRegistry = null;
        }
        if (this.configurationList != null) {
            this.configurationList = null;
        }
        System.out.flush();
        if (this.graphArrayWindow != null) {
            for (GraphArrayWindow graphArrayWindow : this.graphArrayWindows) {
                graphArrayWindow.closeAndDispose();
            }
            this.graphArrayWindows.clear();
            this.graphArrayWindows = null;
        }
        System.out.flush();
        if (this.viewportWindows != null) {
            for (ViewportWindow viewportWindow : this.viewportWindows) {
                System.out.flush();
                viewportWindow.closeAndDispose();
            }
            this.viewportWindows.clear();
            this.viewportWindows = null;
        }
        System.out.flush();
        if (this.jFrame != null) {
            System.out.flush();
            WindowListener[] windowListeners = this.jFrame.getWindowListeners();
            if (windowListeners != null) {
                for (WindowListener windowListener : windowListeners) {
                    this.jFrame.removeWindowListener(windowListener);
                }
            }
            System.out.flush();
            ComponentListener[] componentListenerArray = this.jFrame.getComponentListeners();
            if (componentListenerArray != null) {
                for (ComponentListener componentListener : componentListenerArray) {
                    this.jFrame.removeComponentListener(componentListener);
                }
            }
            System.out.flush();
            this.jFrame.setMenuBar(null);
            if (this.menuBar != null) {
                this.menuBar.removeAll();
                this.menuBar = null;
            }
            System.out.flush();
            this.jFrame.removeAll();
            System.out.flush();
            this.jFrame.setVisible(false);
            this.jFrame.dispose();
            this.jFrame = null;
        }
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
        }
        System.out.flush();
        if (this.buttonPanel != null) {
            this.buttonPanel.removeAll();
            this.buttonPanel = null;
        }
        System.out.flush();
        if (this.contentPane != null) {
            this.contentPane.removeAll();
            this.contentPane = null;
        }
        System.out.flush();
        if (this.yoVariableExplorerTabbedPane != null) {
            this.yoVariableExplorerTabbedPane.closeAndDispose();
            this.yoVariableExplorerTabbedPane = null;
        }
        System.out.flush();
        if (this.myEntryBoxArrayPanel != null) {
            this.myEntryBoxArrayPanel.closeAndDispose();
            this.myEntryBoxArrayPanel = null;
        }
        System.out.flush();
        if (this.myGraphArrayPanel != null) {
            this.myGraphArrayPanel.closeAndDispose();
            this.myGraphArrayPanel = null;
        }
        System.out.flush();
        if (this.numericContentPane != null) {
            this.numericContentPane.removeAll();
            this.numericContentPane = null;
        }
        System.out.flush();
        if (this.standardGUIActions != null) {
            this.standardGUIActions.closeAndDispose();
            this.standardGUIActions = null;
        }
        if (this.allDialogConstructorsHolder != null) {
            this.allDialogConstructorsHolder.closeAndDispose();
            this.allDialogConstructorsHolder = null;
        }
        System.out.flush();
        if (this.viewportPanel != null) {
            this.viewportPanel.closeAndDispose();
            this.viewportPanel = null;
        }
        if (this.timeStepMouseWheelListener != null) {
            this.timeStepMouseWheelListener.closeAndDispose();
            this.timeStepMouseWheelListener = null;
        }
        if (this.splitPane != null) {
            this.splitPane.removeAll();
            this.splitPane = null;
        }
        if (this.jSplitPane != null) {
            this.jSplitPane.removeAll();
            this.jSplitPane = null;
        }
        if (this.bookmarkedVariablesHolder != null) {
            this.bookmarkedVariablesHolder = null;
        }
        if (this.mainPanel != null) {
            this.mainPanel.removeAll();
            this.mainPanel = null;
        }
        System.out.flush();
        this.graphicsUpdatables = null;
        this.graphicsRobots = null;
        if (this.graphics3dAdapter != null) {
            this.graphics3dAdapter.closeAndDispose();
            this.graphics3dAdapter = null;
        }
        this.varGroupList = null;
        this.cameraMountList = null;
        this.graphGroupList = null;
        this.graphConfigurationList = null;
        this.entryBoxGroupList = null;
        this.cameraConfigurationList = null;
        this.extraPanelConfigurationList = null;
        this.viewportConfigurationList = null;
        this.splitPane = null;
        this.viewportSelectorCommandListener = null;
        this.jApplet = null;
        this.parentContainer.removeAll();
        this.parentContainer = null;
        this.robots = null;
        this.selectedVariableHolder = null;
        this.sim = null;
        this.graphArrayWindow = null;
        splashWindow = null;
        this.myDataBuffer = null;
        this.tempPanelsHolder = null;
        this.rootRegistry = null;
        System.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSimulationGraphics() {
        if (this.graphics3dAdapter != null) {
            Object object = this.graphics3dAdapter.getGraphicsConch();
            synchronized (object) {
                for (GraphicsUpdatable graphicsUpdatable : this.graphicsUpdatables) {
                    graphicsUpdatable.update();
                }
            }
        }
    }

    public Object getGraphicsConch() {
        return this.graphics3dAdapter.getGraphicsConch();
    }

    public void removeStaticGraphics3dNode(Graphics3DNode nodeToRemove) {
        this.graphics3dAdapter.removeRootNode(nodeToRemove);
    }

    public void attachSelectedListener(SelectedListener selectedListener) {
        this.graphics3dAdapter.addSelectedListener(selectedListener);
    }

    public GraphicsRobot getGraphicsRobot(Robot robot) {
        return this.graphicsRobots.get(robot);
    }

    public void startStreamingVideoData(CameraConfiguration cameraConfiguration, int width, int height, ImageCallback imageCallback, TimestampProvider timestampProvider, int framesPerSecond) {
        CameraTrackAndDollyYoVariablesHolder cameraTrackingAndDollyPositionHolder = new CameraTrackAndDollyYoVariablesHolder(this.yoVariableHolder);
        new OffscreenBufferVideoServer(this.graphics3dAdapter, this.cameraMountList, cameraConfiguration, (CameraTrackingAndDollyPositionHolder)cameraTrackingAndDollyPositionHolder, width, height, imageCallback, timestampProvider, framesPerSecond);
    }

    public void startStreamingDepthData(CameraConfiguration cameraConfiguration, int width, int height, double nearClip, double farClip, DepthImageCallback imageCallback, TimestampProvider timestampProvider, int framesPerSecond) {
        CameraTrackAndDollyYoVariablesHolder cameraTrackingAndDollyPositionHolder = new CameraTrackAndDollyYoVariablesHolder(this.yoVariableHolder);
        new OffscreenBufferDepthImageServer(this.graphics3dAdapter, this.cameraMountList, cameraConfiguration, (CameraTrackingAndDollyPositionHolder)cameraTrackingAndDollyPositionHolder, width, height, nearClip, farClip, imageCallback, timestampProvider, framesPerSecond);
    }

    public Graphics3DAdapter getGraphics3dAdapter() {
        return this.graphics3dAdapter;
    }

    public void clearAllEntryTabs() {
        this.myEntryBoxArrayPanel.closeAndDispose();
    }

    public void addViewportPanelToMainPanel() {
        this.mainPanel.add(this.viewportPanel);
    }

    public void clearDirectionalLights() {
        this.graphics3dAdapter.clearDirectionalLights();
    }

    public void addDirectionalLight(Color color, Vector3D direction) {
        this.graphics3dAdapter.addDirectionalLight(color, direction);
    }

    public void setAmbientLight(Color color) {
        this.graphics3dAdapter.setAmbientLight(color);
    }

    public void addSpotLight(Graphics3DSpotLight spotLight) {
        this.graphics3dAdapter.addSpotLight(spotLight);
    }

    public void removeSpotLight(Graphics3DSpotLight spotLight) {
        this.graphics3dAdapter.removeSpotLight(spotLight);
    }

    public void addSelectedVariableChangedListener(ChangeListener listener) {
        this.selectedVariableHolder.addChangeListener(listener);
    }

    public YoVariable getSelectedVariable() {
        return this.selectedVariableHolder.getSelectedVariable();
    }

    public void setFrameMap(AdditionalPanelTools.FrameMap frameMap, Predicate<YoVariable> filter) {
        this.yoVariableExplorerTabbedPane.getYoVariableSearchPanel().setFrameMap(frameMap, filter);
    }
}

