/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.SliderJointPhysics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class SliderJoint
extends OneDegreeOfFreedomJoint {
    private static final long serialVersionUID = 1364230363983913667L;
    private final YoRegistry registry;
    protected YoDouble q;
    protected YoDouble qd;
    protected YoDouble qdd;
    protected YoDouble tau;
    public YoDouble tauJointLimit;
    public YoDouble tauDamping;
    public Vector3D vTranslate = new Vector3D();
    public double q_min = Double.NEGATIVE_INFINITY;
    public double q_max = Double.POSITIVE_INFINITY;
    public double k_limit;
    public double b_limit;
    public double b_damp = 0.0;
    public double f_stiction = 0.0;

    public SliderJoint(String jname, Tuple3DReadOnly offset, Robot rob, Vector3DReadOnly axis) {
        super(jname, offset, rob);
        this.physics = new SliderJointPhysics(this);
        this.registry = rob.getRobotsYoRegistry();
        this.q = new YoDouble("q_" + jname, "Slider joint displacement", this.registry);
        this.qd = new YoDouble("qd_" + jname, "Slider joint linear velocity", this.registry);
        this.qdd = new YoDouble("qdd_" + jname, "Slider joint linear acceleration", this.registry);
        this.tau = new YoDouble("tau_" + jname, "Slider joint torque", this.registry);
        this.physics.u_i = new Vector3D((Tuple3DReadOnly)axis);
        this.physics.u_i.normalize();
        this.setSliderTransform3D(this.jointTransform3D, this.physics.u_i);
    }

    @Override
    protected void update() {
        this.setSliderTransform3D(this.jointTransform3D, this.physics.u_i, this.q.getDoubleValue());
    }

    public void setLimitStops(double q_min, double q_max, double k_limit, double b_limit) {
        if (this.tauJointLimit == null) {
            this.tauJointLimit = new YoDouble("tau_joint_limit_" + this.name, "SliderJoint limit stop torque", this.registry);
        }
        this.q_min = q_min;
        this.q_max = q_max;
        this.k_limit = k_limit;
        this.b_limit = b_limit;
    }

    public void setDampingParameterOnly(double b_damp) {
        this.b_damp = b_damp;
    }

    @Override
    public void setDamping(double b_damp) {
        if (this.tauDamping == null) {
            this.tauDamping = new YoDouble("tau_damp_" + this.name, "SliderJoint damping torque", this.registry);
        }
        this.b_damp = b_damp;
    }

    public void setStiction(double f_stiction) {
        if (this.tauDamping == null) {
            this.tauDamping = new YoDouble("tau_damp_" + this.name, "SliderJoint damping torque", this.registry);
        }
        this.f_stiction = f_stiction;
    }

    public void setInitialState(double q_init, double qd_init) {
        this.setQ(q_init);
        this.setQd(qd_init);
    }

    @Override
    public void setQ(double q) {
        if (Double.isNaN(q)) {
            throw new RuntimeException("q = NaN.");
        }
        this.q.set(q);
    }

    @Override
    public void setQd(double qd) {
        if (Double.isNaN(qd)) {
            throw new RuntimeException("qd = NaN.");
        }
        this.qd.set(qd);
    }

    public void getState(double[] state) {
        state[0] = this.q.getDoubleValue();
        state[1] = this.qd.getDoubleValue();
    }

    @Override
    public void setTau(double tau) {
        if (Double.isNaN(tau)) {
            throw new RuntimeException("tau = NaN.");
        }
        this.tau.set(tau);
    }

    @Override
    public YoDouble getQYoVariable() {
        return this.q;
    }

    @Override
    public double getQ() {
        return this.q.getDoubleValue();
    }

    @Override
    public YoDouble getQDYoVariable() {
        return this.qd;
    }

    @Override
    public double getQD() {
        return this.qd.getDoubleValue();
    }

    @Override
    public YoDouble getQDDYoVariable() {
        return this.qdd;
    }

    @Override
    public double getQDD() {
        return this.qdd.getDoubleValue();
    }

    @Override
    public YoDouble getTauYoVariable() {
        return this.tau;
    }

    @Override
    public double getTau() {
        return this.tau.getDoubleValue();
    }

    protected void setSliderTransform3D(RigidBodyTransform tTranslate, Vector3D u_i) {
        this.setSliderTransform3D(tTranslate, u_i, 0.0);
    }

    protected void setSliderTransform3D(RigidBodyTransform tTranslate, Vector3D u_i, double transVal) {
        this.vTranslate.set(u_i);
        this.vTranslate.scale(transVal);
        tTranslate.setIdentity();
        tTranslate.getTranslation().set((Tuple3DReadOnly)this.vTranslate);
    }

    @Override
    public void setQdd(double qdd) {
        if (Double.isNaN(qdd)) {
            throw new RuntimeException("qdd = NaN.");
        }
        this.qdd.set(qdd);
    }

    @Override
    public double getDamping() {
        return this.b_damp;
    }

    @Override
    public double getTorqueLimit() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getVelocityLimit() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getJointUpperLimit() {
        return this.q_max;
    }

    @Override
    public double getJointLowerLimit() {
        return this.q_min;
    }

    @Override
    public double getJointStiction() {
        return this.f_stiction;
    }
}

