/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import us.ihmc.simulationconstructionset.gui.VarPropertiesPanel;
import us.ihmc.yoVariables.buffer.YoBufferVariableEntry;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferVariableEntryReader;

public class VarPropertiesDialog
extends JDialog
implements ActionListener {
    private JButton okButton;
    private JButton applyButton;
    private JButton cancelButton;
    private VarPropertiesPanel[] varPropertiesPanels;
    private JFrame parentFrame;

    public VarPropertiesDialog(JFrame frame, ArrayList<YoBufferVariableEntry> entries) {
        super(frame, "Variable Properties", false);
        this.parentFrame = frame;
        Container contentPane = this.getContentPane();
        JPanel panels = new JPanel(new GridLayout(entries.size(), 1));
        this.varPropertiesPanels = new VarPropertiesPanel[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            this.varPropertiesPanels[i] = new VarPropertiesPanel((YoBufferVariableEntryReader)entries.get(i));
            panels.add(this.varPropertiesPanels[i]);
        }
        contentPane.add(panels);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.applyButton);
        buttonPanel.add(this.cancelButton);
        contentPane.add((Component)buttonPanel, "South");
        Point point = frame.getLocation();
        Dimension frameSize = frame.getSize();
        point.translate(frameSize.width / 4, frameSize.height / 2);
        this.setLocation(point);
        this.setResizable(false);
        this.parentFrame.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int i;
        if (event.getSource() == this.cancelButton) {
            this.setVisible(false);
        }
        if (event.getSource() == this.applyButton) {
            for (i = 0; i < this.varPropertiesPanels.length; ++i) {
                this.varPropertiesPanels[i].commitChanges();
            }
        }
        if (event.getSource() == this.okButton) {
            for (i = 0; i < this.varPropertiesPanels.length; ++i) {
                this.varPropertiesPanels[i].commitChanges();
            }
            this.setVisible(false);
        }
        this.parentFrame.repaint();
    }
}

