/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogConstructors;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import us.ihmc.simulationconstructionset.GraphConfiguration;
import us.ihmc.simulationconstructionset.gui.GraphArrayPanel;
import us.ihmc.simulationconstructionset.gui.StandardSimulationGUI;
import us.ihmc.simulationconstructionset.gui.config.GraphGroupSelector;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.GUIEnablerAndDisabler;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.LoadGraphGroupDialogConstructor;
import us.ihmc.simulationconstructionset.util.XMLReaderUtility;
import us.ihmc.tools.gui.MyFileFilter;

public class LoadGraphGroupDialogGenerator
implements LoadGraphGroupDialogConstructor {
    private FileFilter dataFileFilter = new MyFileFilter(new String[]{".graphConf"}, "GraphGroup Configuration (.graphConf)");
    private JFileChooser dataFileChooser;
    private JFrame frame;
    private GUIEnablerAndDisabler guiEnablerAndDisabler;
    private StandardSimulationGUI myGUI;
    private GraphGroupSelector graphGroupSelector;

    public LoadGraphGroupDialogGenerator(GUIEnablerAndDisabler guiEnablerAndDisabler, StandardSimulationGUI myGUI, GraphGroupSelector graphGroupSelector, JFrame frame, GraphArrayPanel graphArrayPanel) {
        this.graphGroupSelector = graphGroupSelector;
        this.frame = frame;
        this.guiEnablerAndDisabler = guiEnablerAndDisabler;
        this.myGUI = myGUI;
        try {
            File Configs = new File("Configurations");
            String path = Configs.toURI().getPath();
            this.dataFileChooser = new JFileChooser();
            this.setCurrentDirectory(path);
            this.dataFileChooser.setAcceptAllFileFilterUsed(false);
            this.dataFileChooser.addChoosableFileFilter(this.dataFileFilter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setCurrentDirectory(File dir) {
        this.dataFileChooser.setCurrentDirectory(dir);
    }

    @Override
    public void setCurrentDirectory(String dir) {
        this.dataFileChooser.setCurrentDirectory(new File(dir));
    }

    @Override
    public void constructDialog() {
        this.guiEnablerAndDisabler.disableGUIComponents();
        if (this.dataFileChooser.showOpenDialog(this.frame) == 0) {
            File chosenFile = this.dataFileChooser.getSelectedFile();
            this.loadGraphGroupFile(chosenFile);
        }
        this.guiEnablerAndDisabler.enableGUIComponents();
    }

    @Override
    public void loadGraphGroupFile(File file) {
        String fileEnding = ".graphConf";
        try {
            String tempLine;
            String filename = file.getName();
            if (!filename.endsWith(fileEnding)) {
                filename = filename.concat(fileEnding);
                if (!file.getName().equals(filename)) {
                    File newChosenFile;
                    file = newChosenFile = new File(file.getParent(), filename);
                }
            }
            String name = file.getName().substring(0, file.getName().length() - fileEnding.length());
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String xmlRepresentation = "";
            while ((tempLine = reader.readLine()) != null) {
                xmlRepresentation = xmlRepresentation + tempLine;
            }
            this.setupGraphGroups(xmlRepresentation, name);
            reader.close();
            System.out.println("Your file has been loaded.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setupGraphGroups(String xmlRepresentation, String name) {
        try {
            String graphGroupString = XMLReaderUtility.getMiddleString((int)0, (String)xmlRepresentation, (String)"<GraphGroup>", (String)"</GraphGroup>");
            int numColumns = Integer.parseInt(XMLReaderUtility.getMiddleString((int)0, (String)graphGroupString, (String)"<Cols>", (String)"</Cols>"));
            String graphString = "";
            int currentgraphIndex = 0;
            String[] strArray = graphGroupString.split("<Graph>");
            int numberOfGraphs = strArray.length - 1;
            GraphConfiguration[] graphConfigurations = new GraphConfiguration[numberOfGraphs];
            String[][][] var = new String[numberOfGraphs][][];
            for (int graphIndex = 0; graphIndex < numberOfGraphs; ++graphIndex) {
                GraphConfiguration tmpGraphConfiguration;
                graphString = XMLReaderUtility.getMiddleString((int)currentgraphIndex, (String)graphGroupString, (String)"<Graph>", (String)"</Graph>");
                currentgraphIndex = XMLReaderUtility.getEndIndexOfSubString((int)currentgraphIndex, (String)graphGroupString, (String)"</Graph>");
                String variables = XMLReaderUtility.getMiddleString((int)0, (String)graphString, (String)"<Variables>", (String)"</Variables>");
                StringTokenizer tokenizer = new StringTokenizer(variables, ",");
                int numberOfTokens = tokenizer.countTokens();
                graphConfigurations[graphIndex] = tmpGraphConfiguration = GraphConfiguration.createClassBasedOnXMLRepresentation(0, graphString);
                String[] graphConfigurationStringArray = new String[]{tmpGraphConfiguration.getName()};
                var[graphIndex] = new String[2][numberOfTokens];
                for (int i = 0; i < numberOfTokens; ++i) {
                    var[graphIndex][0][i] = tokenizer.nextToken().trim();
                }
                var[graphIndex][1] = graphConfigurationStringArray;
            }
            this.myGUI.setupGraphConfigurations(graphConfigurations);
            this.myGUI.setupGraphGroup(name, var, numColumns);
            this.graphGroupSelector.selectGraphGroup(name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void closeAndDispose() {
        this.dataFileFilter = null;
        this.dataFileChooser = null;
        this.frame = null;
        this.guiEnablerAndDisabler = null;
        this.myGUI = null;
        this.graphGroupSelector = null;
    }
}

