/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import us.ihmc.simulationconstructionset.gui.YoEntryBox;
import us.ihmc.simulationconstructionset.gui.YoVariableEntryContainer;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoTextEntryContainer
implements YoVariableEntryContainer {
    private static final int TEXT_BOX_WIDTH = 100;
    private static final int BOX_HEIGHT = 26;
    private NumberFormat numFormat;
    private YoVariable variableInThisBox;
    private JLabel label;
    private JTextField jTextField;

    protected YoTextEntryContainer() {
    }

    @Override
    public YoVariable getVariable() {
        return this.variableInThisBox;
    }

    @Override
    public synchronized void update(YoEntryBox yoEntryBox) {
        if (!this.jTextField.hasFocus()) {
            if (this.variableInThisBox != null) {
                double varInBoxValue = this.variableInThisBox.getValueAsDouble();
                String textForTextField = this.numFormat.format(varInBoxValue) + " ";
                if (textForTextField.length() < 15) {
                    for (int i = 0; i < 15 - textForTextField.length(); ++i) {
                        textForTextField = textForTextField + " ";
                    }
                }
                this.jTextField.setText(textForTextField);
            } else {
                this.jTextField.setText(this.numFormat.format(0.0));
            }
            this.jTextField.setCaretPosition(0);
            yoEntryBox.updateUI();
        }
    }

    @Override
    public void actionPerformed(YoEntryBox yoEntryBox, ActionEvent evt) {
        String text = this.jTextField.getText();
        try {
            double val = Double.valueOf(text);
            if (this.variableInThisBox != null) {
                this.variableInThisBox.setValueFromDouble(val);
                this.update(yoEntryBox);
                yoEntryBox.repaint();
                YoEntryBox.informVariableChangedListeners(this.getVariable());
            }
            yoEntryBox.passOnFocusRequest();
        }
        catch (NumberFormatException e) {
            this.update(yoEntryBox);
        }
    }

    @Override
    public void removeVariable(YoVariable variable) {
        if (this.getVariable() == variable) {
            this.variableInThisBox = null;
        }
        this.label.setText("UNUSED");
    }

    @Override
    public void setup(YoEntryBox yoEntryBox) {
        this.label = new JLabel("UNUSED");
        this.label.setHorizontalAlignment(4);
        this.numFormat = NumberFormat.getInstance();
        this.numFormat.setMaximumFractionDigits(4);
        this.numFormat.setMinimumFractionDigits(1);
        this.numFormat.setGroupingUsed(false);
        this.jTextField = new JTextField("0.0");
        this.jTextField.setHorizontalAlignment(2);
        this.jTextField.addActionListener(yoEntryBox);
        this.jTextField.addFocusListener(yoEntryBox);
        yoEntryBox.add(this.label);
        yoEntryBox.add(this.jTextField);
    }

    @Override
    public void shutdown(YoEntryBox yoEntryBox) {
        this.numFormat = null;
        this.variableInThisBox = null;
        yoEntryBox.remove(this.label);
        yoEntryBox.remove(this.jTextField);
        this.label = null;
        this.jTextField = null;
    }

    @Override
    public void bindToVariable(YoEntryBox yoEntryBox, YoVariable variable) {
        this.variableInThisBox = variable;
        this.label.setText("  " + variable.getName() + "  ");
        String labelText = this.label.getText();
        Font labelFont = this.label.getFont();
        int stringWidth = this.label.getFontMetrics(labelFont).stringWidth(labelText);
        yoEntryBox.setPreferredSize(new Dimension(stringWidth + 100, 26));
    }

    private void updateJLabelTextSize(JLabel label, JComponent componentTOAddTo) {
        Font labelFont = label.getFont();
        String labelText = label.getText();
        int stringWidth = label.getFontMetrics(labelFont).stringWidth(labelText);
        int componentWidth = componentTOAddTo.getWidth() / 2;
        double widthRatio = (double)componentWidth / (double)stringWidth;
        System.out.println("OLD " + labelFont.getSize());
        int newFontSize = (int)((double)labelFont.getSize() * widthRatio);
        int componentHeight = componentTOAddTo.getHeight();
        System.out.println("componentHeight " + componentHeight);
        int fontSizeToUse = Math.max(12, componentHeight);
        label.setFont(new Font(labelFont.getName(), 0, fontSizeToUse));
        System.out.println("New " + fontSizeToUse);
    }

    @Override
    public boolean isEventSource(YoEntryBox yoEntryBox, FocusEvent evt) {
        return evt.getSource().equals(this.jTextField);
    }

    @Override
    public void focusLost(YoEntryBox yoEntryBox) {
        this.update(yoEntryBox);
        this.jTextField.setCaretPosition(1);
    }

    @Override
    public void focusGained(YoEntryBox yoEntryBox) {
        this.update(yoEntryBox);
        this.jTextField.setCaretPosition(1);
    }
}

