/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraPropertiesHolder;
import us.ihmc.simulationconstructionset.gui.ActiveCameraHolder;
import us.ihmc.simulationconstructionset.gui.EventDispatchThreadHelper;

public class TrackCheckBox
extends JCheckBox
implements ActionListener {
    private static final String TRACK = "Track";
    private static final long serialVersionUID = -9012772363648771937L;
    private ActiveCameraHolder cameraHolder;

    public TrackCheckBox(ActiveCameraHolder cameraHolder) {
        super(TRACK);
        this.setName(TRACK);
        this.cameraHolder = cameraHolder;
        CameraPropertiesHolder camera = cameraHolder.getCameraPropertiesForActiveCamera();
        this.setSelected(camera.isTracking());
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        CameraPropertiesHolder camera = this.cameraHolder.getCameraPropertiesForActiveCamera();
        camera.setTracking(this.isSelected());
    }

    public void makeCameraConsistent() {
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                CameraPropertiesHolder camera = TrackCheckBox.this.cameraHolder.getCameraPropertiesForActiveCamera();
                camera.setTracking(TrackCheckBox.this.isSelected());
            }
        });
    }

    public void makeCheckBoxConsistent() {
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                CameraPropertiesHolder camera = TrackCheckBox.this.cameraHolder.getCameraPropertiesForActiveCamera();
                if (camera != null) {
                    TrackCheckBox.this.setSelected(camera.isTracking());
                }
            }
        });
    }
}

