/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.robotics.robotDescription.CollisionMeshDescription;
import us.ihmc.robotics.robotDescription.InertiaTools;
import us.ihmc.simulationconstructionset.ContactingExternalForcePoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.RobotFromDescription;
import us.ihmc.simulationconstructionset.physics.CollisionHandler;
import us.ihmc.simulationconstructionset.robotdefinition.LinkDefinitionFixedFrame;
import us.ihmc.yoVariables.registry.YoRegistry;

public class Link
implements Serializable {
    private static final long serialVersionUID = 5447931499263283994L;
    private static final double minimumValidInertia = 2.0E-7;
    private final String name;
    protected Joint parentJoint;
    private double mass;
    public Matrix3D Inertia = new Matrix3D();
    public Vector3D principalMomentsOfInertia = new Vector3D();
    public RotationMatrix principalAxesRotation = new RotationMatrix();
    public Vector3D comOffset = new Vector3D();
    private Graphics3DObject linkGraphics;
    private ArrayList<CollisionMeshDescription> collisionMeshDescriptions;
    private List<ContactingExternalForcePoint> contactingExternalForcePoints;

    public Link(LinkDefinitionFixedFrame linkDefinition) {
        this(linkDefinition.getName());
        this.setMass(linkDefinition.getMass());
        this.setComOffset((Vector3DReadOnly)linkDefinition.getComOffset());
        this.setMomentOfInertia((Matrix3DReadOnly)linkDefinition.getInertia());
        this.linkGraphics = new Graphics3DObject(linkDefinition.getGraphicsDefinition().getGraphics3DInstructions());
    }

    public Link(String linkName) {
        this.name = linkName;
        this.linkGraphics = new Graphics3DObject();
    }

    public Link(Link other) {
        this.name = new String(other.name);
        this.linkGraphics = new Graphics3DObject(other.linkGraphics.getGraphics3DInstructions());
        this.setComOffset((Vector3DReadOnly)other.getComOffset());
        this.setMass(other.getMass());
        Matrix3D moi = new Matrix3D();
        other.getMomentOfInertia((Matrix3DBasics)moi);
        this.setMomentOfInertia((Matrix3DReadOnly)moi);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer retBuffer = new StringBuffer();
        retBuffer.append("      Link: " + this.name + "\n");
        retBuffer.append("         Mass: " + this.mass + "\n");
        retBuffer.append("         COM Offset: " + this.comOffset + "\n");
        retBuffer.append("         Moment of Inertia: \n" + this.Inertia);
        return retBuffer.toString();
    }

    public void setMomentOfInertia(double Ixx, double Iyy, double Izz) {
        this.Inertia.setM00(Ixx);
        this.Inertia.setM01(0.0);
        this.Inertia.setM02(0.0);
        this.Inertia.setM10(0.0);
        this.Inertia.setM11(Iyy);
        this.Inertia.setM12(0.0);
        this.Inertia.setM20(0.0);
        this.Inertia.setM21(0.0);
        this.Inertia.setM22(Izz);
        this.computePrincipalMomentsOfInertia();
    }

    public void setMomentOfInertia(Matrix3DReadOnly momentOfInertia) {
        this.Inertia.set(momentOfInertia);
        this.computePrincipalMomentsOfInertia();
    }

    public void setMomentOfInertia(DMatrix momentOfInertia) {
        this.Inertia.setM00(momentOfInertia.get(0, 0));
        this.Inertia.setM01(momentOfInertia.get(0, 1));
        this.Inertia.setM02(momentOfInertia.get(0, 2));
        this.Inertia.setM10(momentOfInertia.get(1, 0));
        this.Inertia.setM11(momentOfInertia.get(1, 1));
        this.Inertia.setM12(momentOfInertia.get(1, 2));
        this.Inertia.setM20(momentOfInertia.get(2, 0));
        this.Inertia.setM21(momentOfInertia.get(2, 1));
        this.Inertia.setM22(momentOfInertia.get(2, 2));
        this.computePrincipalMomentsOfInertia();
    }

    public Vector3D getComOffset() {
        return this.comOffset;
    }

    public void setComOffset(double xOffset, double yOffset, double zOffset) {
        this.comOffset.set(xOffset, yOffset, zOffset);
    }

    public void setComOffset(Vector3DReadOnly comOffset) {
        this.comOffset.set((Tuple3DReadOnly)comOffset);
    }

    protected void setParentJoint(Joint joint) {
        this.parentJoint = joint;
        if (this.contactingExternalForcePoints != null) {
            throw new RuntimeException("Need to attach link to joint before enabling collisions!");
        }
    }

    public static Link combineLinks(String name, Link linkOne, Link linkTwo) {
        return Link.combineLinks(name, linkOne, linkTwo, (Vector3DReadOnly)new Vector3D());
    }

    public static Link combineLinks(String name, Link linkOne, Link linkTwo, Vector3DReadOnly linkOffset) {
        Vector3D newComOffset = new Vector3D();
        newComOffset.setAndScale(linkOne.mass, (Tuple3DReadOnly)linkOne.comOffset);
        Vector3D linkToAddTotalOffset = new Vector3D((Tuple3DReadOnly)linkOffset);
        linkToAddTotalOffset.add((Tuple3DReadOnly)linkTwo.comOffset);
        Vector3D temp = new Vector3D();
        temp.setAndScale(linkTwo.mass, (Tuple3DReadOnly)linkToAddTotalOffset);
        newComOffset.add((Tuple3DReadOnly)temp);
        newComOffset.scale(1.0 / (linkOne.mass + linkTwo.mass));
        double newMass = linkOne.mass + linkTwo.mass;
        Matrix3D newInertia = new Matrix3D();
        newInertia.add((Matrix3DReadOnly)linkOne.Inertia, (Matrix3DReadOnly)linkTwo.Inertia);
        double a = linkOne.comOffset.getX() - newComOffset.getX();
        double b = linkOne.comOffset.getY() - newComOffset.getY();
        double c = linkOne.comOffset.getZ() - newComOffset.getZ();
        Matrix3D inertiaOffset1 = new Matrix3D(b * b + c * c, -a * b, -a * c, -a * b, c * c + a * a, -b * c, -a * c, -b * c, a * a + b * b);
        a = linkToAddTotalOffset.getX() - newComOffset.getX();
        b = linkToAddTotalOffset.getY() - newComOffset.getY();
        c = linkToAddTotalOffset.getZ() - newComOffset.getZ();
        Matrix3D inertiaOffset2 = new Matrix3D(b * b + c * c, -a * b, -a * c, -a * b, c * c + a * a, -b * c, -a * c, -b * c, a * a + b * b);
        inertiaOffset1.scale(linkOne.mass);
        inertiaOffset2.scale(linkTwo.mass);
        newInertia.add((Matrix3DReadOnly)inertiaOffset1);
        newInertia.add((Matrix3DReadOnly)inertiaOffset2);
        Link ret = new Link(name);
        ret.setMass(newMass);
        ret.setComOffset((Vector3DReadOnly)newComOffset);
        ret.setMomentOfInertia((Matrix3DReadOnly)newInertia);
        Graphics3DObject newLinkGraphics = new Graphics3DObject(linkOne.linkGraphics);
        newLinkGraphics.combine(linkTwo.linkGraphics, linkOffset);
        ret.setLinkGraphics(newLinkGraphics);
        return ret;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public double getMass() {
        return this.mass;
    }

    public void getMomentOfInertia(Matrix3DBasics momentOfInertiaToPack) {
        momentOfInertiaToPack.set((Matrix3DReadOnly)this.Inertia);
    }

    public void setMassAndRadiiOfGyration(double mass, double radiusOfGyrationX, double radiusOfGyrationY, double radiusOfGyrationZ) {
        this.mass = mass;
        double Ixx = mass * (radiusOfGyrationY * radiusOfGyrationY + radiusOfGyrationZ * radiusOfGyrationZ);
        double Iyy = mass * (radiusOfGyrationX * radiusOfGyrationX + radiusOfGyrationZ * radiusOfGyrationZ);
        double Izz = mass * (radiusOfGyrationX * radiusOfGyrationX + radiusOfGyrationY * radiusOfGyrationY);
        this.setMomentOfInertia(Ixx, Iyy, Izz);
    }

    public void setMassAndRadiiOfGyration(double mass, Vector3DReadOnly radiiOfGyration) {
        this.setMassAndRadiiOfGyration(mass, radiiOfGyration.getX(), radiiOfGyration.getY(), radiiOfGyration.getZ());
    }

    public void setLinkGraphics(Graphics3DObject linkGraphics) {
        this.linkGraphics = linkGraphics;
    }

    public void addCollisionMesh(CollisionMeshDescription collisionMeshDescription) {
        if (this.collisionMeshDescriptions == null) {
            this.collisionMeshDescriptions = new ArrayList();
        }
        this.collisionMeshDescriptions.add(collisionMeshDescription);
    }

    public Graphics3DObject getLinkGraphics() {
        return this.linkGraphics;
    }

    public List<CollisionMeshDescription> getCollisionMeshDescriptions() {
        return this.collisionMeshDescriptions;
    }

    public List<ContactingExternalForcePoint> getContactingExternalForcePoints() {
        return this.contactingExternalForcePoints;
    }

    public void enableCollisions(int maximumNumberOfPotentialContacts, CollisionHandler collisionHandler, YoRegistry registry) {
        if (this.parentJoint == null) {
            throw new RuntimeException("Need to attach link to joint before enabling collisions!");
        }
        this.contactingExternalForcePoints = new ArrayList<ContactingExternalForcePoint>();
        for (int i = 0; i < maximumNumberOfPotentialContacts; ++i) {
            ContactingExternalForcePoint contactingExternalForcePoint = new ContactingExternalForcePoint(this.name + "ContactingPoint" + i, this.parentJoint, registry);
            this.contactingExternalForcePoints.add(contactingExternalForcePoint);
            this.parentJoint.addExternalForcePoint(contactingExternalForcePoint);
        }
        collisionHandler.addContactingExternalForcePoints(this, this.contactingExternalForcePoints);
    }

    public void enableContactingExternalForcePoints(int maximumNumberOfPotentialContacts, YoRegistry registry) {
        if (this.parentJoint == null) {
            throw new RuntimeException("Need to attach link to joint before enabling collisions!");
        }
        this.contactingExternalForcePoints = new ArrayList<ContactingExternalForcePoint>();
        for (int i = 0; i < maximumNumberOfPotentialContacts; ++i) {
            ContactingExternalForcePoint contactingExternalForcePoint = new ContactingExternalForcePoint(this.name + "ContactingPoint" + i, this.parentJoint, registry);
            this.contactingExternalForcePoints.add(contactingExternalForcePoint);
            this.parentJoint.addExternalForcePoint(contactingExternalForcePoint);
        }
    }

    public void enableCollisions(CollisionHandler collisionHandler) {
        collisionHandler.addContactingExternalForcePoints(this, this.contactingExternalForcePoints);
    }

    public static void addEllipsoidFromMassPropertiesToAllLinks(RobotFromDescription robot, AppearanceDefinition appearance) {
        ArrayList<Joint> joints = new ArrayList<Joint>(robot.getRootJoints());
        while (!joints.isEmpty()) {
            int lastIndex = joints.size() - 1;
            Joint joint = joints.get(lastIndex);
            joint.getLink().addEllipsoidFromMassProperties(appearance);
            joints.remove(lastIndex);
            List<Joint> childrenJoints = joint.getChildrenJoints();
            if (childrenJoints == null) continue;
            joints.addAll(childrenJoints);
        }
    }

    public void addEllipsoidFromMassProperties() {
        this.addEllipsoidFromMassProperties(null);
    }

    public void addCoordinateSystemToCOM(double length) {
        this.linkGraphics.identity();
        Vector3D comOffset = new Vector3D();
        this.getComOffset((Vector3DBasics)comOffset);
        this.linkGraphics.translate(comOffset.getX(), comOffset.getY(), comOffset.getZ());
        this.linkGraphics.addCoordinateSystem(length);
        this.linkGraphics.identity();
    }

    public void addEllipsoidFromMassProperties2(AppearanceDefinition appearance) {
        this.computePrincipalMomentsOfInertia();
        Vector3D inertiaEllipsoidRadii = InertiaTools.getInertiaEllipsoidRadii((Vector3D)this.principalMomentsOfInertia, (double)this.mass);
        ArrayList<Vector3D> inertiaEllipsoidAxes = new ArrayList<Vector3D>();
        Vector3D e1 = new Vector3D();
        this.principalAxesRotation.getColumn(0, (Tuple3DBasics)e1);
        e1.normalize();
        e1.scale(inertiaEllipsoidRadii.getX());
        inertiaEllipsoidAxes.add(e1);
        Vector3D e2 = new Vector3D();
        this.principalAxesRotation.getColumn(1, (Tuple3DBasics)e2);
        e2.normalize();
        e2.scale(inertiaEllipsoidRadii.getY());
        inertiaEllipsoidAxes.add(e2);
        Vector3D e3 = new Vector3D();
        this.principalAxesRotation.getColumn(2, (Tuple3DBasics)e3);
        e3.normalize();
        e3.scale(inertiaEllipsoidRadii.getZ());
        inertiaEllipsoidAxes.add(e3);
        Vector3D e4 = new Vector3D((Tuple3DReadOnly)e1);
        e4.negate();
        inertiaEllipsoidAxes.add(e4);
        Vector3D e5 = new Vector3D((Tuple3DReadOnly)e2);
        e5.negate();
        inertiaEllipsoidAxes.add(e5);
        Vector3D e6 = new Vector3D((Tuple3DReadOnly)e3);
        e6.negate();
        inertiaEllipsoidAxes.add(e6);
        double vertexSize = 0.01 * inertiaEllipsoidRadii.length();
        for (Vector3D vector : inertiaEllipsoidAxes) {
            this.linkGraphics.identity();
            this.linkGraphics.translate(this.comOffset.getX(), this.comOffset.getY(), this.comOffset.getZ());
            this.linkGraphics.translate((Tuple3DReadOnly)vector);
            this.linkGraphics.addCube(vertexSize, vertexSize, vertexSize, appearance);
        }
        ArrayList<Point3D> inertiaOctahedronVertices = new ArrayList<Point3D>();
        Point3D p1 = new Point3D((Tuple3DReadOnly)e1);
        inertiaOctahedronVertices.add(p1);
        Point3D p2 = new Point3D((Tuple3DReadOnly)e2);
        inertiaOctahedronVertices.add(p2);
        Point3D p3 = new Point3D((Tuple3DReadOnly)e4);
        inertiaOctahedronVertices.add(p3);
        Point3D p4 = new Point3D((Tuple3DReadOnly)e5);
        inertiaOctahedronVertices.add(p4);
        Point3D p5 = new Point3D((Tuple3DReadOnly)e3);
        inertiaOctahedronVertices.add(p5);
        Point3D p6 = new Point3D((Tuple3DReadOnly)e6);
        inertiaOctahedronVertices.add(p6);
        ArrayList<Point3D> face1 = new ArrayList<Point3D>();
        face1.add(p1);
        face1.add(p5);
        face1.add(p4);
        ArrayList<Point3D> face2 = new ArrayList<Point3D>();
        face2.add(p4);
        face2.add(p5);
        face2.add(p3);
        ArrayList<Point3D> face3 = new ArrayList<Point3D>();
        face3.add(p3);
        face3.add(p5);
        face3.add(p2);
        ArrayList<Point3D> face4 = new ArrayList<Point3D>();
        face4.add(p2);
        face4.add(p5);
        face4.add(p1);
        ArrayList<Point3D> face5 = new ArrayList<Point3D>();
        face5.add(p4);
        face5.add(p6);
        face5.add(p1);
        ArrayList<Point3D> face6 = new ArrayList<Point3D>();
        face6.add(p3);
        face6.add(p6);
        face6.add(p4);
        ArrayList<Point3D> face7 = new ArrayList<Point3D>();
        face7.add(p2);
        face7.add(p6);
        face7.add(p3);
        ArrayList<Point3D> face8 = new ArrayList<Point3D>();
        face8.add(p1);
        face8.add(p6);
        face8.add(p2);
        this.linkGraphics.identity();
        this.linkGraphics.translate(this.comOffset.getX(), this.comOffset.getY(), this.comOffset.getZ());
        this.linkGraphics.addPolygon(face1, appearance);
        this.linkGraphics.addPolygon(face2, appearance);
        this.linkGraphics.addPolygon(face3, appearance);
        this.linkGraphics.addPolygon(face4, appearance);
        this.linkGraphics.addPolygon(face5, appearance);
        this.linkGraphics.addPolygon(face6, appearance);
        this.linkGraphics.addPolygon(face7, appearance);
        this.linkGraphics.addPolygon(face8, appearance);
    }

    public void addEllipsoidFromMassProperties(AppearanceDefinition appearance) {
        this.computePrincipalMomentsOfInertia();
        Vector3D inertiaEllipsoidRadii = InertiaTools.getInertiaEllipsoidRadii((Vector3D)this.principalMomentsOfInertia, (double)this.mass);
        if (appearance == null) {
            appearance = YoAppearance.Black();
        }
        this.linkGraphics.identity();
        this.linkGraphics.translate(this.comOffset.getX(), this.comOffset.getY(), this.comOffset.getZ());
        this.linkGraphics.rotate((Orientation3DReadOnly)this.principalAxesRotation);
        this.linkGraphics.addEllipsoid(inertiaEllipsoidRadii.getX(), inertiaEllipsoidRadii.getY(), inertiaEllipsoidRadii.getZ(), appearance);
        this.linkGraphics.identity();
    }

    public void addBoxFromMassProperties(AppearanceDefinition appearance) {
        if (this.mass <= 0.0 || this.Inertia.getM00() <= 0.0 || this.Inertia.getM11() <= 0.0 || this.Inertia.getM22() <= 0.0 || this.Inertia.getM00() + this.Inertia.getM11() <= this.Inertia.getM22() || this.Inertia.getM11() + this.Inertia.getM22() <= this.Inertia.getM00() || this.Inertia.getM00() + this.Inertia.getM22() <= this.Inertia.getM11()) {
            System.err.println(this.getName() + " has unrealistic inertia");
        } else {
            this.linkGraphics.identity();
            this.linkGraphics.translate(this.comOffset.getX(), this.comOffset.getY(), this.comOffset.getZ());
            double lx = Math.sqrt(6.0 * (this.Inertia.getM22() + this.Inertia.getM11() - this.Inertia.getM00()) / this.mass);
            double ly = Math.sqrt(6.0 * (this.Inertia.getM22() + this.Inertia.getM00() - this.Inertia.getM11()) / this.mass);
            double lz = Math.sqrt(6.0 * (this.Inertia.getM00() + this.Inertia.getM11() - this.Inertia.getM22()) / this.mass);
            this.linkGraphics.translate(0.0, 0.0, -lz / 2.0);
            this.linkGraphics.addCube(lx, ly, lz, appearance);
            this.linkGraphics.identity();
        }
    }

    public void getComOffset(Vector3DBasics comOffsetRet) {
        comOffsetRet.set((Tuple3DReadOnly)this.comOffset);
    }

    public Joint getParentJoint() {
        return this.parentJoint;
    }

    public void computePrincipalMomentsOfInertia() {
        InertiaTools.computePrincipalMomentsOfInertia((Matrix3D)this.Inertia, (RotationMatrix)this.principalAxesRotation, (Vector3D)this.principalMomentsOfInertia);
        if (this.principalMomentsOfInertia.getX() < 2.0E-7 || this.principalMomentsOfInertia.getX() < 2.0E-7 || this.principalMomentsOfInertia.getX() < 2.0E-7) {
            System.err.println("Warning: Inertia may be too small for Link " + this.getName() + " for stable simulation. principalMomentsOfInertia = " + this.principalMomentsOfInertia);
        }
    }
}

