/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util;

public class RealTimeRateEnforcer {
    private long wallStartTimeInMilliseconds = -1L;
    private double simulatedStartTimeInSeconds = -1.0;

    public void sleepIfNecessaryToEnforceRealTimeRate(double simulatedCurrentTimeInSeconds) {
        if (this.wallStartTimeInMilliseconds == -1L) {
            this.wallStartTimeInMilliseconds = System.currentTimeMillis();
            this.simulatedStartTimeInSeconds = simulatedCurrentTimeInSeconds;
            return;
        }
        int simulatedElapsedTimeInMilliseconds = (int)(1000.0 * (simulatedCurrentTimeInSeconds - this.simulatedStartTimeInSeconds));
        long wallCurrentTimeInMilliseconds = System.currentTimeMillis();
        long wallElapsedTimeInMilliseconds = wallCurrentTimeInMilliseconds - this.wallStartTimeInMilliseconds;
        int timeToSleepInMilliseconds = (int)((long)simulatedElapsedTimeInMilliseconds - wallElapsedTimeInMilliseconds);
        if (timeToSleepInMilliseconds > 10) {
            try {
                Thread.sleep(timeToSleepInMilliseconds);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void reset() {
        this.wallStartTimeInMilliseconds = -1L;
        this.simulatedStartTimeInSeconds = -1.0;
    }
}

