/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util;

import java.io.Serializable;

public class QuarticRootFinder
implements Serializable {
    private static final long serialVersionUID = 1492976164809974715L;
    private static final double EQN_EPS = 1.0E-9;
    private static final double ONE_THIRD = 0.3333333333333333;
    private double[] cubic_overflow_coeffs = new double[3];
    private double[] coeffs = new double[4];
    private double[] s_temp = new double[2];
    private double[] quartic_overflow_coeffs = new double[4];

    private double cubeRoot(double x) {
        if (x >= 0.0) {
            return Math.pow(x, 0.3333333333333333);
        }
        return -Math.pow(-x, 0.3333333333333333);
    }

    private boolean IsZero(double x) {
        return x > -1.0E-9 && x < 1.0E-9;
    }

    public int SolveQuadric(double[] c, double[] s) {
        double p = c[1] / (2.0 * c[2]);
        double q = c[0] / c[2];
        double D = p * p - q;
        if (this.IsZero(D)) {
            s[0] = -p;
            return 1;
        }
        if (D < 0.0) {
            return 0;
        }
        double sqrt_D = Math.sqrt(D);
        s[0] = sqrt_D - p;
        s[1] = -sqrt_D - p;
        return 2;
    }

    public int SolveCubic(double[] c, double[] s) {
        int num;
        if (this.IsZero(c[3])) {
            this.cubic_overflow_coeffs[0] = c[0];
            this.cubic_overflow_coeffs[1] = c[1];
            this.cubic_overflow_coeffs[2] = c[2];
            return this.SolveQuadric(this.cubic_overflow_coeffs, s);
        }
        double A = c[2] / c[3];
        double sq_A = A * A;
        double B = c[1] / c[3];
        double C = c[0] / c[3];
        double q = 0.5 * (0.07407407407407407 * A * sq_A - 0.3333333333333333 * A * B + C);
        double p = 0.3333333333333333 * (-0.3333333333333333 * sq_A + B);
        double cb_p = p * p * p;
        double D = q * q + cb_p;
        if (this.IsZero(D)) {
            if (this.IsZero(q)) {
                s[0] = 0.0;
                num = 1;
            } else {
                double u = this.cubeRoot(-q);
                s[0] = 2.0 * u;
                s[1] = -u;
                num = 2;
            }
        } else if (D < 0.0) {
            double phi = 0.3333333333333333 * Math.acos(-q / Math.sqrt(-cb_p));
            double t = 2.0 * Math.sqrt(-p);
            s[0] = t * Math.cos(phi);
            s[1] = -t * Math.cos(phi + 1.0471975511965976);
            s[2] = -t * Math.cos(phi - 1.0471975511965976);
            num = 3;
        } else {
            double sqrt_D = Math.sqrt(D);
            double u = this.cubeRoot(sqrt_D - q);
            double v = -this.cubeRoot(sqrt_D + q);
            s[0] = u + v;
            num = 1;
        }
        double sub = 0.3333333333333333 * A;
        int i = 0;
        while (i < num) {
            int n = i++;
            s[n] = s[n] - sub;
        }
        return num;
    }

    public int SolveQuartic(double[] c, double[] s) {
        int num;
        if (this.IsZero(c[4])) {
            this.quartic_overflow_coeffs[0] = c[0];
            this.quartic_overflow_coeffs[1] = c[1];
            this.quartic_overflow_coeffs[2] = c[2];
            this.quartic_overflow_coeffs[3] = c[3];
            return this.SolveCubic(this.quartic_overflow_coeffs, s);
        }
        double A = c[3] / c[4];
        double B = c[2] / c[4];
        double C = c[1] / c[4];
        double D = c[0] / c[4];
        double sq_A = A * A;
        double p = -0.375 * sq_A + B;
        double q = 0.125 * sq_A * A - 0.5 * A * B + C;
        double r = -0.01171875 * sq_A * sq_A + 0.0625 * sq_A * B - 0.25 * A * C + D;
        if (this.IsZero(r)) {
            this.coeffs[0] = q;
            this.coeffs[1] = p;
            this.coeffs[2] = 0.0;
            this.coeffs[3] = 1.0;
            num = this.SolveCubic(this.coeffs, s);
            s[num++] = 0.0;
        } else {
            this.coeffs[0] = 0.5 * r * p - 0.125 * q * q;
            this.coeffs[1] = -r;
            this.coeffs[2] = -0.5 * p;
            this.coeffs[3] = 1.0;
            this.SolveCubic(this.coeffs, s);
            double z = s[0];
            double u = z * z - r;
            double v = 2.0 * z - p;
            if (this.IsZero(u)) {
                u = 0.0;
            } else if (u > 0.0) {
                u = Math.sqrt(u);
            } else {
                return 0;
            }
            if (this.IsZero(v)) {
                v = 0.0;
            } else if (v > 0.0) {
                v = Math.sqrt(v);
            } else {
                return 0;
            }
            this.coeffs[0] = z - u;
            this.coeffs[1] = q < 0.0 ? -v : v;
            this.coeffs[2] = 1.0;
            num = this.SolveQuadric(this.coeffs, s);
            this.coeffs[0] = z + u;
            this.coeffs[1] = q < 0.0 ? v : -v;
            this.coeffs[2] = 1.0;
            int num2 = this.SolveQuadric(this.coeffs, this.s_temp);
            for (int j = 0; j < num2; ++j) {
                s[j + num] = this.s_temp[j];
            }
            num += num2;
        }
        double sub = 0.25 * A;
        int i = 0;
        while (i < num) {
            int n = i++;
            s[n] = s[n] - sub;
        }
        return num;
    }
}

