/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.collision;

import java.util.List;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.ContactingExternalForcePoint;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.physics.CollisionHandler;
import us.ihmc.simulationconstructionset.physics.CollisionShape;
import us.ihmc.simulationconstructionset.physics.CollisionShapeDescription;
import us.ihmc.simulationconstructionset.physics.CollisionShapeFactory;
import us.ihmc.simulationconstructionset.physics.Contacts;
import us.ihmc.simulationconstructionset.physics.ScsCollisionDetector;
import us.ihmc.simulationconstructionset.physics.collision.CollisionDetectionResult;
import us.ihmc.simulationconstructionset.physics.collision.CollisionHandlerListener;

public abstract class SCSCollisionDetectorTest {
    public abstract ScsCollisionDetector createCollisionDetector();

    public void testSmallBox() {
        double epsilon = 0.001;
        double r = 0.5;
        ScsCollisionDetector collisionDetector = this.createCollisionDetector();
        CollisionDetectionResult result = new CollisionDetectionResult();
        FloatingJoint cubeA = this.cube(collisionDetector, "A", 10.0, r, r, r);
        FloatingJoint cubeB = this.cube(collisionDetector, "B", 10.0, r, r, r);
        this.setPosition(cubeA, 2.0 * r + epsilon, 0.0, 0.0);
        this.setPosition(cubeB, 0.0, 0.0, 0.0);
        collisionDetector.performCollisionDetection(result);
        Assert.assertEquals(0L, result.getNumberOfCollisions());
        result.clear();
        this.setPosition(cubeA, 2.0 * r - epsilon, 0.0, 0.0);
        this.setPosition(cubeB, 0.0, 0.0, 0.0);
        collisionDetector.performCollisionDetection(result);
        Assert.assertTrue(result.getNumberOfCollisions() > 0);
        result.clear();
        this.setPosition(cubeA, 20.0 * r, 0.0, 0.0);
        this.setPosition(cubeB, 0.0, 0.0, 0.0);
        collisionDetector.performCollisionDetection(result);
        Assert.assertTrue(result.getNumberOfCollisions() == 0);
        result.clear();
        this.setPosition(cubeA, 2.0 * r + 0.015, 0.0, 0.0);
        this.setPosition(cubeB, 0.0, 0.0, 0.0);
        collisionDetector.performCollisionDetection(result);
        Assert.assertEquals(0L, result.getNumberOfCollisions());
        result.clear();
        this.setPosition(cubeA, 2.0 * r - epsilon, 0.0, 0.0);
        this.setPosition(cubeB, 0.0, 0.0, 0.0);
        collisionDetector.performCollisionDetection(result);
        Assert.assertTrue(result.getNumberOfCollisions() > 0);
        result.clear();
        this.setPosition(cubeA, 2.0 * r + 0.015, 0.0, 0.0);
        this.setPosition(cubeB, 0.0, 0.0, 0.0);
        collisionDetector.performCollisionDetection(result);
        Assert.assertEquals(0L, result.getNumberOfCollisions());
        result.clear();
    }

    public void testUnitBox() {
        double epsilon = 0.1;
        ScsCollisionDetector collisionDetector = this.createCollisionDetector();
        CollisionDetectionResult result = new CollisionDetectionResult();
        FloatingJoint cubeA = this.cube(collisionDetector, "A", 10.0, 0.5, 0.5, 0.5);
        FloatingJoint cubeB = this.cube(collisionDetector, "B", 10.0, 0.5, 0.5, 0.5);
        this.setPosition(cubeA, 0.0, 0.0, 0.0);
        this.setPosition(cubeB, 1.0 + epsilon, 0.0, 0.0);
        collisionDetector.performCollisionDetection(result);
        Assert.assertEquals(0L, result.getNumberOfCollisions());
        result.clear();
        this.setPosition(cubeA, 0.0, 0.0, 0.0);
        this.setPosition(cubeB, 1.0 - epsilon, 0.0, 0.0);
        collisionDetector.performCollisionDetection(result);
        Assert.assertTrue(result.getNumberOfCollisions() > 0);
        result.clear();
        this.setPosition(cubeA, 0.0, 0.0, 0.0);
        this.setPosition(cubeB, 0.0, 1.0 + epsilon, 0.0);
        collisionDetector.performCollisionDetection(result);
        Assert.assertEquals(0L, result.getNumberOfCollisions());
        result.clear();
        this.setPosition(cubeA, 0.0, 0.0, 0.0);
        this.setPosition(cubeB, 0.0, 1.0 - epsilon, 0.0);
        collisionDetector.performCollisionDetection(result);
        Assert.assertTrue(result.getNumberOfCollisions() > 0);
        result.clear();
        this.setPosition(cubeA, 0.0, 0.0, 0.0);
        this.setPosition(cubeB, 0.0, 0.0, 1.0 + epsilon);
        collisionDetector.performCollisionDetection(result);
        Assert.assertEquals(0L, result.getNumberOfCollisions());
        result.clear();
        this.setPosition(cubeA, 0.0, 0.0, 0.0);
        this.setPosition(cubeB, 0.0, 0.0, 1.0 - epsilon);
        collisionDetector.performCollisionDetection(result);
        Assert.assertTrue(result.getNumberOfCollisions() > 0);
        result.clear();
    }

    public void testBoxCloseButNoCollisions() {
        ScsCollisionDetector collisionDetector = this.createCollisionDetector();
        FloatingJoint cubeA = this.cube(collisionDetector, "A", 10.0, 0.5, 1.0, 1.5);
        FloatingJoint cubeB = this.cube(collisionDetector, "B", 10.0, 0.75, 1.2, 1.7);
        double[] a = new double[]{1.25, 2.2, 3.2};
        double tau = 0.001;
        for (int i = 0; i < 3; ++i) {
            double Tz = 0.0;
            double Ty = 0.0;
            double Tx = 0.0;
            if (i == 0) {
                Tx = a[i] / 2.0 + tau;
            }
            if (i == 1) {
                Ty = a[i] / 2.0 + tau;
            }
            if (i == 2) {
                Tz = a[i] / 2.0 + tau;
            }
            cubeA.setPosition(Tx, Ty, Tz);
            cubeB.setPosition(-Tx, -Ty, -Tz);
            cubeA.getRobot().update();
            cubeB.getRobot().update();
            RigidBodyTransform transformToWorld = new RigidBodyTransform();
            cubeA.getTransformToWorld((RigidBodyTransformBasics)transformToWorld);
            CollisionDetectionResult result = new CollisionDetectionResult();
            collisionDetector.performCollisionDetection(result);
            Assert.assertEquals(0L, result.getNumberOfCollisions());
        }
    }

    public void testBoxBarelyCollisions() {
        ScsCollisionDetector collisionDetector = this.createCollisionDetector();
        FloatingJoint cubeA = this.cube(collisionDetector, "A", 10.0, 0.5, 1.0, 1.5);
        FloatingJoint cubeB = this.cube(collisionDetector, "B", 10.0, 0.75, 1.2, 1.7);
        double[] a = new double[]{1.25, 2.2, 3.2};
        double tau = -0.001;
        for (int i = 0; i < 3; ++i) {
            double Tz = 0.0;
            double Ty = 0.0;
            double Tx = 0.0;
            if (i == 0) {
                Tx = a[i] / 2.0 + tau;
            }
            if (i == 1) {
                Ty = a[i] / 2.0 + tau;
            }
            if (i == 2) {
                Tz = a[i] / 2.0 + tau;
            }
            cubeA.setPosition(Tx, Ty, Tz);
            cubeB.setPosition(-Tx, -Ty, -Tz);
            cubeA.getRobot().update();
            cubeB.getRobot().update();
            RigidBodyTransform transformToWorld = new RigidBodyTransform();
            cubeA.getTransformToWorld((RigidBodyTransformBasics)transformToWorld);
            CollisionDetectionResult result = new CollisionDetectionResult();
            collisionDetector.performCollisionDetection(result);
            Assert.assertTrue(result.getNumberOfCollisions() > 0);
            Contacts collision = result.getCollision(0);
            Point3D pointOnA = new Point3D();
            Point3D pointOnB = new Point3D();
            collision.getWorldA(0, pointOnA);
            collision.getWorldB(0, pointOnB);
            System.out.println("Contacted A at " + pointOnA);
            System.out.println("Contacted B at " + pointOnB);
        }
    }

    public void collisionMask_hit() {
        ScsCollisionDetector collisionDetector = this.createCollisionDetector();
        FloatingJoint cubeA = this.cube(collisionDetector, "A", 10.0, null, 0.5, 1.0, 1.5, 1, 2);
        FloatingJoint cubeB = this.cube(collisionDetector, "A", 10.0, null, 0.75, 1.2, 1.7, 2, 1);
        FloatingJoint cubeC = this.cube(collisionDetector, "A", 10.0, null, 10.0, 10.0, 10.0, 4, 4);
        cubeB.setPosition(0.4, 0.0, 0.0);
        cubeA.update();
        cubeB.update();
        cubeC.update();
        CollisionDetectionResult result = new CollisionDetectionResult();
        collisionDetector.performCollisionDetection(result);
        Assert.assertEquals(1L, result.getNumberOfCollisions());
    }

    public void checkCollisionShape_offset() {
        ScsCollisionDetector collisionDetector = this.createCollisionDetector();
        CheckCollisionMasks check = new CheckCollisionMasks();
        collisionDetector.initialize();
        RigidBodyTransform offset = new RigidBodyTransform();
        offset.getTranslation().set((Tuple3DReadOnly)new Vector3D(0.0, 0.0, -1.7));
        FloatingJoint cubeA = this.cube(collisionDetector, "A", 10.0, null, 1.0, 1.0, 1.0, 2, 2);
        FloatingJoint cubeB = this.cube(collisionDetector, "B", 10.0, null, 1.0, 1.0, 1.0, 2, 2);
        FloatingJoint cubeC = this.cube(collisionDetector, "C", 10.0, offset, 1.0, 1.0, 1.0, 2, 2);
        cubeA.setPosition(0.0, 0.0, 0.5);
        cubeB.setPosition(0.0, 0.0, 0.5);
        cubeA.update();
        cubeB.update();
        cubeC.update();
        CollisionDetectionResult result = new CollisionDetectionResult();
        collisionDetector.performCollisionDetection(result);
        Assert.assertEquals(1L, result.getNumberOfCollisions());
    }

    public FloatingJoint cube(ScsCollisionDetector collisionDetector, String name, double mass, double radiusX, double radiusY, double radiusZ) {
        return this.cube(collisionDetector, name, mass, null, radiusX, radiusY, radiusZ, -1, -1);
    }

    public FloatingJoint cube(ScsCollisionDetector collisionDetector, String name, double mass, RigidBodyTransform shapeToLink, double radiusX, double radiusY, double radiusZ, int collisionGroup, int collisionMask) {
        Robot robot = new Robot("null");
        FloatingJoint joint = new FloatingJoint("cube", (Tuple3DReadOnly)new Vector3D(), robot);
        Link link = new Link(name);
        CollisionShapeFactory factory = collisionDetector.getShapeFactory();
        factory.setMargin(2.0E-7);
        CollisionShapeDescription shapeDesc = factory.createBox(radiusX, radiusY, radiusZ);
        factory.addShape(link, shapeToLink, shapeDesc, false, collisionGroup, collisionMask);
        joint.setLink(link);
        robot.addRootJoint((Joint)joint);
        return joint;
    }

    private void setPosition(FloatingJoint cubeJoint, double x, double y, double z) {
        cubeJoint.setPosition(x, y, z);
        cubeJoint.getRobot().update();
    }

    private static class CheckCollisionMasks
    implements CollisionHandler {
        int totalCollisions = 0;

        private CheckCollisionMasks() {
        }

        public void maintenanceBeforeCollisionDetection() {
        }

        public void maintenanceAfterCollisionDetection() {
        }

        public void addListener(CollisionHandlerListener listener) {
        }

        public void handle(Contacts contacts) {
            ++this.totalCollisions;
            CollisionShape shapeA = contacts.getShapeA();
            CollisionShape shapeB = contacts.getShapeB();
            Assert.assertTrue((shapeA.getCollisionMask() & shapeB.getCollisionGroup()) != 0 || (shapeB.getCollisionMask() & shapeA.getCollisionGroup()) != 0);
        }

        public void handleCollisions(CollisionDetectionResult results) {
        }

        public void addContactingExternalForcePoints(Link link, List<ContactingExternalForcePoint> contactingExternalForcePoints) {
        }
    }
}

