/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class HumanAssistedTestFrame
extends JFrame {
    private static final long serialVersionUID = -6270384898459053226L;
    private final GoodButton goodButton;
    private final BadButton badButton;

    public HumanAssistedTestFrame(String name) {
        JFrame frame = new JFrame(name);
        this.goodButton = new GoodButton();
        this.badButton = new BadButton();
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(this.goodButton);
        buttonPanel.add(this.badButton);
        frame.add((Component)buttonPanel, "South");
        frame.setSize(800, 800);
        frame.setVisible(true);
    }

    public boolean hasGoodButtonBeenPressed() {
        return this.goodButton.hasBeenPressed();
    }

    public boolean hasBadButtonBeenPressed() {
        return this.badButton.hasBeenPressed();
    }

    public void waitForButtonPush() {
        while (!this.hasGoodButtonBeenPressed() && !this.hasBadButtonBeenPressed()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.hasBadButtonBeenPressed()) {
            throw new RuntimeException();
        }
    }

    private class GoodButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 3222645729570934059L;
        private boolean hasBeenPressed;

        public GoodButton() {
            super("Good");
            this.hasBeenPressed = false;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.hasBeenPressed = true;
        }

        public boolean hasBeenPressed() {
            return this.hasBeenPressed;
        }
    }

    private class BadButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = -4648731010106093744L;
        private boolean hasBeenPressed;

        public BadButton() {
            super("Bad");
            this.hasBeenPressed = false;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.hasBeenPressed = true;
        }

        public boolean hasBeenPressed() {
            return this.hasBeenPressed;
        }
    }
}

