/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.torqueSpeedCurve;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.torqueSpeedCurve.TypicalTorqueSpeedCurve;

public class TypicalTorqueSpeedCurveTest {
    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testOne() {
        TypicalTorqueSpeedCurve torqueSpeedCurve = new TypicalTorqueSpeedCurve();
        double maxTorque = 100.0;
        double maxSpeed = 12.0;
        double maxSpeedAtMaxTorque = 2.0;
        torqueSpeedCurve.setMaxTorque(maxTorque);
        torqueSpeedCurve.setMaxSpeed(maxSpeed);
        torqueSpeedCurve.setMaxSpeedAtMaxTorque(maxSpeedAtMaxTorque);
        Assert.assertEquals(0.0, torqueSpeedCurve.limitTorque(0.0, 0.0), 1.0E-7);
        Assert.assertEquals(0.0, torqueSpeedCurve.limitTorque(0.0, 10.0 * maxSpeed), 1.0E-7);
        Assert.assertEquals(0.0, torqueSpeedCurve.limitTorque(0.0, -10.0 * maxSpeed), 1.0E-7);
        Assert.assertEquals(maxTorque, torqueSpeedCurve.limitTorque(2.0 * maxTorque, 0.0), 1.0E-7);
        Assert.assertEquals(-maxTorque, torqueSpeedCurve.limitTorque(-2.0 * maxTorque, 0.0), 1.0E-7);
        Assert.assertEquals(0.5 * maxTorque, torqueSpeedCurve.limitTorque(0.5 * maxTorque, 0.0), 1.0E-7);
        Assert.assertEquals(0.5 * maxTorque, torqueSpeedCurve.limitTorque(0.5 * maxTorque, 0.0), 1.0E-7);
        Assert.assertEquals(0.0, torqueSpeedCurve.limitTorque(0.5 * maxTorque, maxSpeed), 1.0E-7);
        Assert.assertEquals(0.0, torqueSpeedCurve.limitTorque(0.5 * maxTorque, 1.5 * maxSpeed), 1.0E-7);
        Assert.assertEquals(0.0, torqueSpeedCurve.limitTorque(-0.5 * maxTorque, -maxSpeed), 1.0E-7);
        Assert.assertEquals(0.0, torqueSpeedCurve.limitTorque(-0.5 * maxTorque, -1.5 * maxSpeed), 1.0E-7);
        Assert.assertEquals(0.5 * maxTorque, torqueSpeedCurve.limitTorque(0.5 * maxTorque, -maxSpeed), 1.0E-7);
        Assert.assertEquals(0.5 * maxTorque, torqueSpeedCurve.limitTorque(0.5 * maxTorque, -10.0 * maxSpeed), 1.0E-7);
        Assert.assertEquals(-0.5 * maxTorque, torqueSpeedCurve.limitTorque(-0.5 * maxTorque, maxSpeed), 1.0E-7);
        Assert.assertEquals(-0.5 * maxTorque, torqueSpeedCurve.limitTorque(-0.5 * maxTorque, 10.0 * maxSpeed), 1.0E-7);
        Assert.assertEquals(maxTorque, torqueSpeedCurve.limitTorque(2.0 * maxTorque, 0.5 * maxSpeedAtMaxTorque), 1.0E-7);
        Assert.assertEquals(maxTorque, torqueSpeedCurve.limitTorque(maxTorque, 0.5 * maxSpeedAtMaxTorque), 1.0E-7);
        Assert.assertEquals(0.5 * maxTorque, torqueSpeedCurve.limitTorque(0.5 * maxTorque, 0.5 * maxSpeedAtMaxTorque), 1.0E-7);
        Assert.assertEquals(-maxTorque, torqueSpeedCurve.limitTorque(-2.0 * maxTorque, -0.5 * maxSpeedAtMaxTorque), 1.0E-7);
        Assert.assertEquals(-maxTorque, torqueSpeedCurve.limitTorque(-maxTorque, -0.5 * maxSpeedAtMaxTorque), 1.0E-7);
        Assert.assertEquals(-0.5 * maxTorque, torqueSpeedCurve.limitTorque(-0.5 * maxTorque, -0.5 * maxSpeedAtMaxTorque), 1.0E-7);
        Assert.assertEquals(maxTorque, torqueSpeedCurve.limitTorque(2.0 * maxTorque, maxSpeedAtMaxTorque), 1.0E-7);
        Assert.assertEquals(0.0, torqueSpeedCurve.limitTorque(2.0 * maxTorque, maxSpeed), 1.0E-7);
        Assert.assertEquals(0.5 * maxTorque, torqueSpeedCurve.limitTorque(2.0 * maxTorque, (maxSpeed + maxSpeedAtMaxTorque) / 2.0), 1.0E-7);
        Assert.assertEquals(-maxTorque, torqueSpeedCurve.limitTorque(-2.0 * maxTorque, -maxSpeedAtMaxTorque), 1.0E-7);
        Assert.assertEquals(-0.0, torqueSpeedCurve.limitTorque(-2.0 * maxTorque, -maxSpeed), 1.0E-7);
        Assert.assertEquals(-0.5 * maxTorque, torqueSpeedCurve.limitTorque(-2.0 * maxTorque, -(maxSpeed + maxSpeedAtMaxTorque) / 2.0), 1.0E-7);
    }
}

