/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.util.IndexOrderChecker;
import us.ihmc.yoVariables.registry.YoRegistry;

public class IndexOrderCheckerTest {
    private IndexOrderChecker indexOrderChecker;

    @BeforeEach
    public void setUp() {
        YoRegistry registry = new YoRegistry("testRegistry");
        this.indexOrderChecker = new IndexOrderChecker("test", registry, 1);
    }

    @Test
    public void testNoOverflow() {
        int index = 0;
        this.indexOrderChecker.update(index);
        int increment = 5;
        this.indexOrderChecker.update(index += increment);
        Assert.assertEquals(increment - 1, this.indexOrderChecker.getMissedIndices());
    }

    @Test
    public void testOverflowOne() {
        int index = Integer.MAX_VALUE;
        this.indexOrderChecker.update(index);
        this.indexOrderChecker.update(++index);
        Assert.assertEquals(0L, this.indexOrderChecker.getMissedIndices());
    }

    @Test
    public void testOverflowTwo() {
        int index = 0x7FFFFFFD;
        this.indexOrderChecker.update(index);
        int increment = 5;
        this.indexOrderChecker.update(index += increment);
        Assert.assertEquals(increment - 1, this.indexOrderChecker.getMissedIndices());
    }

    @Test
    public void testABunch() {
        Assert.assertEquals(0L, this.indexOrderChecker.getMissedIndices());
        this.indexOrderChecker.update(0);
        Assert.assertEquals(0L, this.indexOrderChecker.getMissedIndices());
        this.indexOrderChecker.update(1);
        Assert.assertEquals(0L, this.indexOrderChecker.getMissedIndices());
        this.indexOrderChecker.update(3);
        Assert.assertEquals(1L, this.indexOrderChecker.getMissedIndices());
        this.indexOrderChecker.update(8);
        Assert.assertEquals(5L, this.indexOrderChecker.getMissedIndices());
    }
}

