/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.scripts;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.scripts.TimeScript;
import us.ihmc.simulationconstructionset.scripts.TimeScriptCommand;
import us.ihmc.simulationconstructionset.scripts.TimeScriptEntry;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;

public class TimeScriptTest {
    private YoRegistry rootRegistry;
    private YoRegistry registryOne;
    private YoRegistry registryTwo;
    private YoDouble doubleVariable;
    private YoBoolean booleanVariable;
    private YoInteger integerVariable;
    private YoEnum<TimeScriptTestEnums> enumVariable;

    @BeforeEach
    public void setUp() throws Exception {
        this.rootRegistry = new YoRegistry("root");
        this.registryOne = new YoRegistry("registryOne");
        this.registryTwo = new YoRegistry("registryTwo");
        this.rootRegistry.addChild(this.registryOne);
        this.registryOne.addChild(this.registryTwo);
        this.doubleVariable = new YoDouble("doubleVariable", this.rootRegistry);
        this.booleanVariable = new YoBoolean("booleanVariable", this.registryOne);
        this.integerVariable = new YoInteger("integerVariable", this.registryTwo);
        this.enumVariable = new YoEnum("enumVariable", this.registryTwo, TimeScriptTestEnums.class);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.rootRegistry = null;
        this.registryOne = null;
        this.registryTwo = null;
        this.doubleVariable = null;
        this.booleanVariable = null;
        this.integerVariable = null;
        this.enumVariable = null;
    }

    @Test
    public void testEmptyTimeScript() {
        YoRegistry registry = new YoRegistry("Test");
        TimeScript timeScript = new TimeScript(registry);
        double time = 1.0;
        timeScript.doScript(time);
    }

    @Test
    public void testAddEntryAndDoScript() {
        TimeScript timeScript = new TimeScript(this.rootRegistry);
        double timeOne = 1.0;
        double valueOne = 1.11;
        double timeTwo = 1.9;
        double valueTwo = 3.55;
        double timeThree = 5.5;
        double valueThree = -72.4;
        double epsilon = 1.0E-7;
        double initialValue = 99.9;
        this.doubleVariable.set(initialValue);
        TimeScriptEntry timeScriptEntryOne = new TimeScriptEntry(timeOne);
        timeScriptEntryOne.addVarValue(this.doubleVariable, valueOne);
        timeScript.addEntry(timeScriptEntryOne);
        TimeScriptEntry timeScriptEntryThree = new TimeScriptEntry(timeThree);
        timeScriptEntryThree.addVarValue(this.doubleVariable, valueThree);
        timeScript.addEntry(timeScriptEntryThree);
        TimeScriptEntry timeScriptEntryTwo = new TimeScriptEntry(timeTwo);
        timeScriptEntryTwo.addVarValue(this.doubleVariable, valueTwo);
        timeScript.addEntry(timeScriptEntryTwo);
        double time = 0.0;
        timeScript.doScript(time);
        Assert.assertEquals(initialValue, this.doubleVariable.getDoubleValue(), epsilon);
        for (time = 0.0; time < 10.0; time += 0.001) {
            timeScript.doScript(time);
            if (time < timeOne) {
                Assert.assertEquals(initialValue, this.doubleVariable.getDoubleValue(), epsilon);
                continue;
            }
            if (time < timeTwo) {
                Assert.assertEquals(valueOne, this.doubleVariable.getDoubleValue(), epsilon);
                continue;
            }
            if (time < timeThree) {
                Assert.assertEquals(valueTwo, this.doubleVariable.getDoubleValue(), epsilon);
                continue;
            }
            Assert.assertEquals(valueThree, this.doubleVariable.getDoubleValue(), epsilon);
        }
    }

    @Test
    public void testTimeScriptCommand() {
        TimeScript timeScript = new TimeScript(this.rootRegistry);
        double timeOne = 1.0;
        double timeTwo = 2.2;
        double timeThree = 3.3;
        double initialValue = 0.3;
        double valueOne = 3.7;
        double valueTwo = 5.6;
        double valueThree = 9.9;
        this.doubleVariable.set(initialValue);
        TimeScriptEntry timeScriptEntryOne = new TimeScriptEntry(timeOne);
        TimeScriptCommand timeScriptCommandOne = new TimeScriptCommand(){

            public void doCommand() {
                TimeScriptTest.this.doubleVariable.set(3.7);
            }
        };
        timeScriptEntryOne.addTimeScriptCommand(timeScriptCommandOne);
        timeScript.addEntry(timeScriptEntryOne);
        TimeScriptEntry timeScriptEntryTwo = new TimeScriptEntry(timeTwo);
        TimeScriptCommand timeScriptCommandTwo = new TimeScriptCommand(){

            public void doCommand() {
                TimeScriptTest.this.doubleVariable.set(5.6);
            }
        };
        timeScriptEntryTwo.addTimeScriptCommand(timeScriptCommandTwo);
        timeScript.addEntry(timeScriptEntryTwo);
        TimeScriptEntry timeScriptEntryThree = new TimeScriptEntry(timeThree);
        TimeScriptCommand timeScriptCommandThree = new TimeScriptCommand(){

            public void doCommand() {
                TimeScriptTest.this.doubleVariable.set(9.9);
            }
        };
        timeScriptEntryThree.addTimeScriptCommand(timeScriptCommandThree);
        timeScript.addEntry(timeScriptEntryThree);
        double epsilon = 1.0E-10;
        double time = 0.0;
        timeScript.doScript(time);
        Assert.assertEquals(initialValue, this.doubleVariable.getDoubleValue(), epsilon);
        for (time = 0.0; time < 10.0; time += 0.001) {
            timeScript.doScript(time);
            if (time < timeOne) {
                Assert.assertEquals(initialValue, this.doubleVariable.getDoubleValue(), epsilon);
                continue;
            }
            if (time < timeTwo) {
                Assert.assertEquals(3.7, this.doubleVariable.getDoubleValue(), epsilon);
                continue;
            }
            if (time < timeThree) {
                Assert.assertEquals(5.6, this.doubleVariable.getDoubleValue(), epsilon);
                continue;
            }
            Assert.assertEquals(9.9, this.doubleVariable.getDoubleValue(), epsilon);
        }
    }

    @Test
    public void testSaveAndLoad() {
        Random random = new Random(1776L);
        String doubleVariableName = "doubleVariable";
        String booleanVariableName = "booleanVariable";
        String integerVariableName = "integerVariable";
        String enumVariableName = "enumVariable";
        double[] times = new double[]{1.0, 2.1, 5.77, 12.44, 17.90993};
        double[] doubleValues = new double[times.length];
        boolean[] booleanValues = new boolean[times.length];
        int[] integerValues = new int[times.length];
        TimeScriptTestEnums[] enumValues = new TimeScriptTestEnums[times.length];
        for (int i = 0; i < times.length; ++i) {
            doubleValues[i] = 100.0 * random.nextDouble() - 50.0;
            booleanValues[i] = random.nextBoolean();
            integerValues[i] = random.nextInt();
            enumValues[i] = TimeScriptTestEnums.values()[random.nextInt(TimeScriptTestEnums.values().length)];
        }
        TimeScript timeScript = new TimeScript(this.rootRegistry);
        String pseudoFile = "";
        for (int i = 0; i < times.length; ++i) {
            pseudoFile = pseudoFile + "t = " + times[i] + ":\n";
            pseudoFile = pseudoFile + "/* This is a comment!! */\n";
            pseudoFile = pseudoFile + doubleVariableName + " = " + doubleValues[i] + ";\n";
            pseudoFile = pseudoFile + "// This is a comment!! \n";
            pseudoFile = pseudoFile + booleanVariableName + " = " + booleanValues[i] + ";\n";
            pseudoFile = pseudoFile + "// This is a comment!! \n";
            pseudoFile = pseudoFile + integerVariableName + " = " + integerValues[i] + ";\n";
            pseudoFile = pseudoFile + "// This is a comment!! \n";
            pseudoFile = pseudoFile + enumVariableName + " = " + (Object)((Object)enumValues[i]) + ";\n";
        }
        StringReader reader = new StringReader(pseudoFile);
        BufferedReader in = new BufferedReader(reader);
        timeScript.readTimeScript((YoVariableHolder)this.rootRegistry, in);
        int timeIndex = -1;
        for (double time = 0.0; time < times[times.length - 1] + 1.0; time += 0.01) {
            timeScript.doScript(time);
            if (timeIndex < times.length - 1 && time >= times[timeIndex + 1]) {
                ++timeIndex;
            }
            if (timeIndex < 0) continue;
            Assert.assertEquals(doubleValues[timeIndex], this.doubleVariable.getDoubleValue(), 1.0E-7);
            Assert.assertEquals(booleanValues[timeIndex], this.booleanVariable.getBooleanValue());
            Assert.assertEquals(integerValues[timeIndex], this.integerVariable.getIntegerValue());
            Assert.assertEquals((Object)enumValues[timeIndex], this.enumVariable.getEnumValue());
        }
    }

    private static enum TimeScriptTestEnums {
        V0,
        V1,
        V2;

    }
}

