/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.screwTools;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyTwistProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointReadOnly;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyReadOnly;

public class SimRigidBodyDeltaTwistCalculator
implements Function<RigidBodyReadOnly, TwistReadOnly> {
    private final ReferenceFrame inertialFrame;
    private final Map<RigidBodyReadOnly, Twist> rigidBodyTwistMap = new HashMap<RigidBodyReadOnly, Twist>();
    private final Twist jointTwist = new Twist();
    private RigidBodyTwistProvider deltaTwistProvider;

    public SimRigidBodyDeltaTwistCalculator(ReferenceFrame inertialFrame) {
        this.inertialFrame = inertialFrame;
        this.deltaTwistProvider = RigidBodyTwistProvider.toRigidBodyTwistProvider((Function)this, (ReferenceFrame)inertialFrame);
    }

    public void reset() {
        this.rigidBodyTwistMap.clear();
    }

    public RigidBodyTwistProvider getDeltaTwistProvider() {
        return this.deltaTwistProvider;
    }

    @Override
    public TwistReadOnly apply(RigidBodyReadOnly body) {
        if (body instanceof SimRigidBodyReadOnly) {
            throw new IllegalArgumentException("The given body is not a " + SimRigidBodyReadOnly.class.getSimpleName());
        }
        Twist twistOfBody = this.rigidBodyTwistMap.get(body);
        if (twistOfBody == null) {
            JointReadOnly parentJoint = body.getParentJoint();
            RigidBodyReadOnly parentBody = parentJoint.getPredecessor();
            TwistReadOnly twistOfParentBody = parentBody.isRootBody() ? null : this.apply(parentBody);
            this.jointTwist.setIncludingFrame((SpatialMotionReadOnly)((SimJointReadOnly)parentJoint).getJointDeltaTwist());
            this.jointTwist.changeFrame((ReferenceFrame)body.getBodyFixedFrame());
            this.jointTwist.setBaseFrame((ReferenceFrame)parentBody.getBodyFixedFrame());
            this.jointTwist.setBodyFrame((ReferenceFrame)body.getBodyFixedFrame());
            twistOfBody = new Twist();
            if (twistOfParentBody == null) {
                twistOfBody.setToZero((ReferenceFrame)parentBody.getBodyFixedFrame(), this.inertialFrame, (ReferenceFrame)parentBody.getBodyFixedFrame());
            } else {
                twistOfBody.setIncludingFrame((SpatialMotionReadOnly)twistOfParentBody);
            }
            twistOfBody.changeFrame((ReferenceFrame)body.getBodyFixedFrame());
            twistOfBody.add((TwistReadOnly)this.jointTwist);
            this.rigidBodyTwistMap.put(body, twistOfBody);
        }
        return twistOfBody;
    }
}

