/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ejml.data.DMatrix;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.JointIterable;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.scs2.definition.robot.ExternalWrenchPointDefinition;
import us.ihmc.scs2.definition.robot.GroundContactPointDefinition;
import us.ihmc.scs2.definition.robot.IMUSensorDefinition;
import us.ihmc.scs2.definition.robot.KinematicPointDefinition;
import us.ihmc.scs2.definition.robot.WrenchSensorDefinition;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointReadOnly;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.scs2.simulation.robot.sensors.SimIMUSensor;
import us.ihmc.scs2.simulation.robot.sensors.SimWrenchSensor;
import us.ihmc.scs2.simulation.robot.trackers.ExternalWrenchPoint;
import us.ihmc.scs2.simulation.robot.trackers.GroundContactPoint;
import us.ihmc.scs2.simulation.robot.trackers.KinematicPoint;

public interface SimJointBasics
extends JointBasics,
SimJointReadOnly {
    public void setPinned(boolean var1);

    @Override
    public SimRigidBodyBasics getPredecessor();

    @Override
    public SimRigidBodyBasics getSuccessor();

    public void setJointDeltaTwistToZero();

    public void setJointDeltaTwist(JointReadOnly var1);

    public int setJointDeltaVelocity(int var1, DMatrix var2);

    default public void setJointDeltaTwist(TwistReadOnly jointDeltaTwist) {
        jointDeltaTwist.checkBodyFrameMatch((ReferenceFrame)this.getFrameAfterJoint());
        jointDeltaTwist.checkBaseFrameMatch((ReferenceFrame)this.getFrameBeforeJoint());
        jointDeltaTwist.checkExpressedInFrameMatch((ReferenceFrame)this.getFrameAfterJoint());
        this.setJointAngularDeltaVelocity((Vector3DReadOnly)jointDeltaTwist.getAngularPart());
        this.setJointLinearDeltaVelocity((Vector3DReadOnly)jointDeltaTwist.getLinearPart());
    }

    default public void setJointAngularDeltaVelocity(FrameVector3DReadOnly jointAngularDeltaVelocity) {
        jointAngularDeltaVelocity.checkReferenceFrameMatch((ReferenceFrame)this.getFrameAfterJoint());
        this.setJointAngularDeltaVelocity((Vector3DReadOnly)jointAngularDeltaVelocity);
    }

    default public void setJointLinearDeltaVelocity(FrameVector3DReadOnly jointLinearDeltaVelocity) {
        jointLinearDeltaVelocity.checkReferenceFrameMatch((ReferenceFrame)this.getFrameAfterJoint());
        this.setJointLinearDeltaVelocity((Vector3DReadOnly)jointLinearDeltaVelocity);
    }

    public void setJointAngularDeltaVelocity(Vector3DReadOnly var1);

    public void setJointLinearDeltaVelocity(Vector3DReadOnly var1);

    default public KinematicPoint addKinematicPoint(String name) {
        return this.getAuxialiryData().addKinematicPoint(name);
    }

    default public KinematicPoint addKinematicPoint(String name, Tuple3DReadOnly offset) {
        return this.getAuxialiryData().addKinematicPoint(name, offset);
    }

    default public KinematicPoint addKinematicPoint(KinematicPointDefinition definition) {
        return this.getAuxialiryData().addKinematicPoint(definition);
    }

    default public ExternalWrenchPoint addExternalWrenchPoint(String name) {
        return this.getAuxialiryData().addExternalWrenchPoint(name);
    }

    default public ExternalWrenchPoint addExternalWrenchPoint(String name, Tuple3DReadOnly offset) {
        return this.getAuxialiryData().addExternalWrenchPoint(name, offset);
    }

    default public ExternalWrenchPoint addExternalWrenchPoint(ExternalWrenchPointDefinition definition) {
        return this.getAuxialiryData().addExternalWrenchPoint(definition);
    }

    default public GroundContactPoint addGroundContactPoint(String name) {
        return this.getAuxialiryData().addGroundContactPoint(name);
    }

    default public GroundContactPoint addGroundContactPoint(String name, Tuple3DReadOnly offset) {
        return this.getAuxialiryData().addGroundContactPoint(name, offset);
    }

    default public GroundContactPoint addGroundContactPoint(GroundContactPointDefinition definition) {
        return this.getAuxialiryData().addGroundContactPoint(definition);
    }

    default public SimIMUSensor addIMUSensor(String name) {
        return this.getAuxialiryData().addIMUSensor(name);
    }

    default public SimIMUSensor addIMUSensor(String name, Tuple3DReadOnly offset) {
        return this.getAuxialiryData().addIMUSensor(name, offset);
    }

    default public SimIMUSensor addIMUSensor(IMUSensorDefinition definition) {
        return this.getAuxialiryData().addIMUSensor(definition);
    }

    default public SimWrenchSensor addWrenchSensor(String name) {
        return this.getAuxialiryData().addWrenchSensor(name);
    }

    default public SimWrenchSensor addWrenchSensor(String name, Tuple3DReadOnly offset) {
        return this.getAuxialiryData().addWrenchSensor(name, offset);
    }

    default public SimWrenchSensor addWrenchSensor(WrenchSensorDefinition definition) {
        return this.getAuxialiryData().addWrenchSensor(definition);
    }

    default public void updateFrame() {
        super.updateFrame();
        this.getAuxialiryData().updateFrames();
    }

    default public Iterable<? extends SimJointBasics> subtreeIterable() {
        return new JointIterable(SimJointBasics.class, null, (JointReadOnly)this);
    }

    default public Stream<? extends SimJointBasics> subtreeStream() {
        return SubtreeStreams.from(SimJointBasics.class, (JointReadOnly)this);
    }

    default public List<? extends SimJointBasics> subtreeList() {
        return this.subtreeStream().collect(Collectors.toList());
    }

    default public SimJointBasics[] subtreeArray() {
        return (SimJointBasics[])this.subtreeStream().toArray(SimJointBasics[]::new);
    }
}

