/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.scs2.simulation.parameters.ContactParametersReadOnly;
import us.ihmc.scs2.simulation.parameters.ContactPointBasedContactParametersReadOnly;
import us.ihmc.scs2.simulation.physicsEngine.DoNothingPhysicsEngine;
import us.ihmc.scs2.simulation.physicsEngine.PhysicsEngine;
import us.ihmc.scs2.simulation.physicsEngine.contactPointBased.ContactPointBasedPhysicsEngine;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.ImpulseBasedPhysicsEngine;
import us.ihmc.yoVariables.registry.YoRegistry;

public interface PhysicsEngineFactory {
    public PhysicsEngine build(ReferenceFrame var1, YoRegistry var2);

    public static PhysicsEngineFactory newImpulseBasedPhysicsEngineFactory() {
        return (frame, rootRegistry) -> new ImpulseBasedPhysicsEngine(frame, rootRegistry);
    }

    public static PhysicsEngineFactory newImpulseBasedPhysicsEngineFactory(ContactParametersReadOnly contactParameters) {
        return (frame, rootRegistry) -> {
            ImpulseBasedPhysicsEngine physicsEngine = new ImpulseBasedPhysicsEngine(frame, rootRegistry);
            if (contactParameters != null) {
                physicsEngine.setGlobalContactParameters(contactParameters);
            }
            return physicsEngine;
        };
    }

    public static PhysicsEngineFactory newContactPointBasedPhysicsEngineFactory() {
        return (frame, rootRegistry) -> new ContactPointBasedPhysicsEngine(frame, rootRegistry);
    }

    public static PhysicsEngineFactory newContactPointBasedPhysicsEngineFactory(ContactPointBasedContactParametersReadOnly contactParameters) {
        return (frame, rootRegistry) -> {
            ContactPointBasedPhysicsEngine physicsEngine = new ContactPointBasedPhysicsEngine(frame, rootRegistry);
            if (contactParameters != null) {
                physicsEngine.setGroundContactParameters(contactParameters);
            }
            return physicsEngine;
        };
    }

    public static PhysicsEngineFactory newDoNothingPhysicsEngineFactory() {
        return (frame, rootRegistry) -> new DoNothingPhysicsEngine(frame, rootRegistry);
    }
}

