/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ejml.data.DMatrix;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.JointIterable;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.scs2.definition.robot.ExternalWrenchPointDefinition;
import us.ihmc.scs2.definition.robot.GroundContactPointDefinition;
import us.ihmc.scs2.definition.robot.IMUSensorDefinition;
import us.ihmc.scs2.definition.robot.KinematicPointDefinition;
import us.ihmc.scs2.definition.robot.WrenchSensorDefinition;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointReadOnly;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;

public interface SimJointBasics
extends JointBasics,
SimJointReadOnly {
    public void setPinned(boolean var1);

    @Override
    public SimRigidBodyBasics getPredecessor();

    @Override
    public SimRigidBodyBasics getSuccessor();

    public void setJointDeltaTwistToZero();

    public void setJointDeltaTwist(JointReadOnly var1);

    public int setJointDeltaVelocity(int var1, DMatrix var2);

    default public void setJointDeltaTwist(TwistReadOnly jointDeltaTwist) {
        jointDeltaTwist.checkBodyFrameMatch((ReferenceFrame)this.getFrameAfterJoint());
        jointDeltaTwist.checkBaseFrameMatch((ReferenceFrame)this.getFrameBeforeJoint());
        jointDeltaTwist.checkExpressedInFrameMatch((ReferenceFrame)this.getFrameAfterJoint());
        this.setJointAngularDeltaVelocity((Vector3DReadOnly)jointDeltaTwist.getAngularPart());
        this.setJointLinearDeltaVelocity((Vector3DReadOnly)jointDeltaTwist.getLinearPart());
    }

    default public void setJointAngularDeltaVelocity(FrameVector3DReadOnly jointAngularDeltaVelocity) {
        jointAngularDeltaVelocity.checkReferenceFrameMatch((ReferenceFrame)this.getFrameAfterJoint());
        this.setJointAngularDeltaVelocity((Vector3DReadOnly)jointAngularDeltaVelocity);
    }

    default public void setJointLinearDeltaVelocity(FrameVector3DReadOnly jointLinearDeltaVelocity) {
        jointLinearDeltaVelocity.checkReferenceFrameMatch((ReferenceFrame)this.getFrameAfterJoint());
        this.setJointLinearDeltaVelocity((Vector3DReadOnly)jointLinearDeltaVelocity);
    }

    public void setJointAngularDeltaVelocity(Vector3DReadOnly var1);

    public void setJointLinearDeltaVelocity(Vector3DReadOnly var1);

    default public void addKinematicPoint(KinematicPointDefinition definition) {
        this.getAuxialiryData().addKinematicPoint(definition);
    }

    default public void addExternalWrenchPoint(ExternalWrenchPointDefinition definition) {
        this.getAuxialiryData().addExternalWrenchPoint(definition);
    }

    default public void addGroundContactPoint(GroundContactPointDefinition definition) {
        this.getAuxialiryData().addGroundContactPoint(definition);
    }

    default public void addIMUSensor(IMUSensorDefinition definition) {
        this.getAuxialiryData().addIMUSensor(definition);
    }

    default public void addWrenchSensor(WrenchSensorDefinition definition) {
        this.getAuxialiryData().addWrenchSensor(definition);
    }

    default public Iterable<? extends SimJointBasics> subtreeIterable() {
        return new JointIterable(SimJointBasics.class, null, (JointReadOnly)this);
    }

    default public Stream<? extends SimJointBasics> subtreeStream() {
        return SubtreeStreams.from(SimJointBasics.class, (JointReadOnly)this);
    }

    default public List<? extends SimJointBasics> subtreeList() {
        return this.subtreeStream().collect(Collectors.toList());
    }

    default public SimJointBasics[] subtreeArray() {
        return (SimJointBasics[])this.subtreeStream().toArray(SimJointBasics[]::new);
    }
}

