/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.screwTools;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialImpulse;
import us.ihmc.mecano.spatial.interfaces.SpatialImpulseReadOnly;

public class RigidBodyImpulseRegistry
implements Function<RigidBodyReadOnly, SpatialImpulseReadOnly> {
    private final Map<RigidBodyReadOnly, SpatialImpulse> rigidBodyImpulseMap = new HashMap<RigidBodyReadOnly, SpatialImpulse>();
    private final Function<RigidBodyReadOnly, SpatialImpulse> impulseFactory = body -> new SpatialImpulse((ReferenceFrame)body.getBodyFixedFrame(), (ReferenceFrame)body.getBodyFixedFrame());

    public void reset() {
        this.rigidBodyImpulseMap.clear();
    }

    public void addImpulse(RigidBodyReadOnly target, SpatialImpulseReadOnly impulseToAdd) {
        SpatialImpulse impulse = this.rigidBodyImpulseMap.computeIfAbsent(target, this.impulseFactory);
        impulse.setMatchingFrame(impulseToAdd);
    }

    @Override
    public SpatialImpulseReadOnly apply(RigidBodyReadOnly query) {
        return (SpatialImpulseReadOnly)this.rigidBodyImpulseMap.get(query);
    }
}

