/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.commons.Conversions;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.controller.interfaces.Controller;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.RobotStateDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.session.SessionState;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.RobotInterface;
import us.ihmc.scs2.simulation.robot.controller.RobotControllerManager;

public class VisualizationSession
extends Session {
    public static final ReferenceFrame DEFAULT_INERTIAL_FRAME = ReferenceFrameTools.constructARootFrame((String)"worldFrame");
    private final String sessionName;
    private final List<Robot> robots = new ArrayList<Robot>();
    private final List<TerrainObjectDefinition> terrainObjects = new ArrayList<TerrainObjectDefinition>();
    private final List<YoGraphicDefinition> yoGraphicDefinitions = new ArrayList<YoGraphicDefinition>();
    private final List<Controller> controllers = new ArrayList<Controller>();

    public VisualizationSession() {
        this(VisualizationSession.retrieveCallerName());
    }

    public VisualizationSession(String sessionName) {
        this.sessionName = sessionName;
        this.setSessionModeTask(SessionMode.RUNNING, () -> {});
        this.setSessionMode(SessionMode.RUNNING);
        this.setSessionState(SessionState.ACTIVE);
    }

    protected double doSpecificRunTick() {
        double dt = Conversions.nanosecondsToSeconds((long)this.getSessionDTNanoseconds());
        for (RobotInterface robotInterface : this.robots) {
            RobotControllerManager controllerManager = robotInterface.getControllerManager();
            controllerManager.updateControllers(this.time.getValue());
            controllerManager.writeControllerOutput(JointStateType.values());
        }
        for (Controller controller : this.controllers) {
            controller.doControl();
        }
        return this.time.getValue() + dt;
    }

    protected void schedulingSessionMode(SessionMode previousMode, SessionMode newMode) {
        if (previousMode == newMode) {
            return;
        }
        if (previousMode == SessionMode.RUNNING) {
            for (RobotInterface robotInterface : this.robots) {
                robotInterface.getControllerManager().pauseControllers();
            }
            for (Controller controller : this.controllers) {
                controller.pause();
            }
        }
    }

    public void addController(Controller controller) {
        this.rootRegistry.addChild(controller.getYoRegistry());
        this.controllers.add(controller);
    }

    public void addRobot(Robot robot) {
        this.rootRegistry.addChild(robot.getRegistry());
        this.robots.add(robot);
    }

    public Robot addRobot(RobotDefinition robotDefinition) {
        Robot robot = new Robot(robotDefinition, DEFAULT_INERTIAL_FRAME);
        this.addRobot(robot);
        return robot;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public List<RobotDefinition> getRobotDefinitions() {
        return this.robots.stream().map(Robot::getRobotDefinition).collect(Collectors.toList());
    }

    public List<TerrainObjectDefinition> getTerrainObjectDefinitions() {
        return this.terrainObjects;
    }

    public List<YoGraphicDefinition> getYoGraphicDefinitions() {
        return this.yoGraphicDefinitions;
    }

    public List<RobotStateDefinition> getCurrentRobotStateDefinitions(boolean initialState) {
        return this.robots.stream().map(Robot::getCurrentRobotStateDefinition).collect(Collectors.toList());
    }
}

