/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

public class SpyList<E>
extends AbstractList<E> {
    private final List<E> list;
    private final List<ChangeListener<E>> listeners = new ArrayList<ChangeListener<E>>();

    public SpyList() {
        this.list = new ArrayList();
    }

    public SpyList(List<E> list) {
        this.list = list;
    }

    public void addListener(ChangeListener<E> listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(ChangeListener<E> listener) {
        return this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E set(int index, E element) {
        E oldElement = this.list.set(index, element);
        this.notifyChange(ChangeImpl.replaced(index, element, oldElement));
        return oldElement;
    }

    @Override
    public void add(int index, E element) {
        this.list.add(index, element);
        this.notifyChange(ChangeImpl.added(index, element));
    }

    @Override
    public E remove(int index) {
        E oldElement = this.list.remove(index);
        this.notifyChange(ChangeImpl.removed(index, oldElement));
        return oldElement;
    }

    @Override
    public void clear() {
        if (this.list.isEmpty()) {
            return;
        }
        ArrayList<E> oldElements = new ArrayList<E>(this.list);
        this.list.clear();
        this.notifyChange(ChangeImpl.removed(0, oldElements));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (this.list.addAll(index, c)) {
            this.notifyChange(ChangeImpl.added(index, new ArrayList<E>(c)));
            return true;
        }
        return false;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ListIterator<E> it = this.list.listIterator(fromIndex);
        ArrayList<E> oldElements = new ArrayList<E>();
        int n = toIndex - fromIndex;
        for (int i = 0; i < n; ++i) {
            oldElements.add(it.next());
            it.remove();
        }
        this.notifyChange(ChangeImpl.removed(fromIndex, oldElements));
    }

    @Override
    public int size() {
        return this.list.size();
    }

    private void notifyChange(Change<E> change) {
        for (ChangeListener<E> listener : this.listeners) {
            listener.onChange(change);
        }
    }

    private static class ChangeImpl<E>
    implements Change<E> {
        private final boolean wasAdded;
        private final boolean wasRemoved;
        private final boolean wasReplaced;
        private final int index;
        private final int size;
        private final List<E> newElements;
        private final List<E> oldElements;

        public static <E> Change<E> added(int index, E newElement) {
            return new ChangeImpl<Object>(true, false, false, index, newElement, null);
        }

        public static <E> Change<E> added(int index, List<E> newElements) {
            return new ChangeImpl<E>(true, false, false, index, newElements.size(), new ArrayList<E>(newElements), null);
        }

        public static <E> Change<E> removed(int index, E oldElement) {
            return new ChangeImpl<Object>(false, true, false, index, null, oldElement);
        }

        public static <E> Change<E> removed(int index, List<E> oldElements) {
            return new ChangeImpl<E>(false, true, false, index, oldElements.size(), null, new ArrayList<E>(oldElements));
        }

        public static <E> Change<E> replaced(int index, E newElement, E oldElement) {
            return new ChangeImpl<E>(false, false, true, index, newElement, oldElement);
        }

        public ChangeImpl(boolean wasAdded, boolean wasRemoved, boolean wasReplaced, int index, E newElement, E oldElement) {
            this(wasAdded, wasRemoved, wasReplaced, index, 1, newElement == null ? null : Collections.singletonList(newElement), oldElement == null ? null : Collections.singletonList(oldElement));
        }

        public ChangeImpl(boolean wasAdded, boolean wasRemoved, boolean wasReplaced, int index, int size, List<E> newElements, List<E> oldElements) {
            this.wasAdded = wasAdded;
            this.wasRemoved = wasRemoved;
            this.wasReplaced = wasReplaced;
            this.index = index;
            this.size = size;
            this.newElements = newElements;
            this.oldElements = oldElements;
        }

        @Override
        public boolean wasAdded() {
            return this.wasAdded;
        }

        @Override
        public boolean wasRemoved() {
            return this.wasRemoved;
        }

        @Override
        public boolean wasReplaced() {
            return this.wasReplaced;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public List<E> getNewElements() {
            return this.newElements;
        }

        @Override
        public List<E> getOldElements() {
            return this.oldElements;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Change) {
                Change other = (Change)object;
                if (this.wasAdded != other.wasAdded()) {
                    return false;
                }
                if (this.wasRemoved != other.wasRemoved()) {
                    return false;
                }
                if (this.wasReplaced != other.wasReplaced()) {
                    return false;
                }
                if (this.index != other.getIndex()) {
                    return false;
                }
                if (this.size != other.getSize()) {
                    return false;
                }
                if (!Objects.equals(this.newElements, other.getNewElements())) {
                    return false;
                }
                return Objects.equals(this.oldElements, other.getOldElements());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.wasAdded, this.wasRemoved, this.wasReplaced, this.newElements, this.oldElements);
        }
    }

    public static interface Change<E> {
        public boolean wasAdded();

        public boolean wasRemoved();

        public boolean wasReplaced();

        public int getIndex();

        public int getSize();

        public List<E> getNewElements();

        public List<E> getOldElements();
    }

    public static interface ChangeListener<E> {
        public void onChange(Change<E> var1);
    }
}

