/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.collision;

import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameUnitVector3D;
import us.ihmc.euclid.referenceFrame.collision.EuclidFrameShape3DCollisionResult;
import us.ihmc.scs2.simulation.collision.Collidable;
import us.ihmc.scs2.simulation.collision.PhysicsEngineTools;

public class CollisionResult {
    private final EuclidFrameShape3DCollisionResult collisionData = new EuclidFrameShape3DCollisionResult();
    private Collidable collidableA;
    private Collidable collidableB;
    private final FramePoint3D pointOnARootFrame = new FramePoint3D();
    private final FramePoint3D pointOnBRootFrame = new FramePoint3D();
    private final FrameUnitVector3D collisionAxisForA = new FrameUnitVector3D();
    private int collisionID = 0;

    public CollisionResult() {
        this.collisionAxisForA.setToNaN();
    }

    public boolean isCollisionOf(Collidable candidateA, Collidable candidateB) {
        if (candidateA == this.collidableA) {
            return candidateB == this.collidableB;
        }
        return candidateA == this.collidableB && candidateB == this.collidableA;
    }

    public void setCollisionID(int collisionID) {
        this.collisionID = collisionID;
    }

    public void updateCollisionID() {
        this.collisionID = PhysicsEngineTools.computeCollisionHashCode(this.collidableA, this.collidableB);
    }

    public void setCollidableA(Collidable collidableA) {
        this.collidableA = collidableA;
    }

    public void setCollidableB(Collidable collidableB) {
        this.collidableB = collidableB;
    }

    public void swapCollidables() {
        this.collisionData.swapShapes();
        this.collisionAxisForA.negate();
    }

    public EuclidFrameShape3DCollisionResult getCollisionData() {
        return this.collisionData;
    }

    public Collidable getCollidableA() {
        return this.collidableA;
    }

    public Collidable getCollidableB() {
        return this.collidableB;
    }

    public FramePoint3D getPointOnARootFrame() {
        return this.pointOnARootFrame;
    }

    public FramePoint3D getPointOnBRootFrame() {
        return this.pointOnBRootFrame;
    }

    public FrameUnitVector3D getCollisionAxisForA() {
        return this.collisionAxisForA;
    }

    public int hashCode() {
        if ((long)this.collisionID == 0L) {
            this.updateCollisionID();
        }
        return this.collisionID;
    }

    public String toString() {
        String prefix = this.collisionData.areShapesColliding() ? "Colliding" : "Non-colliding";
        return prefix + ", collidableA: " + PhysicsEngineTools.collidableSimpleName(this.collidableA) + ", collidableB: " + PhysicsEngineTools.collidableSimpleName(this.collidableB);
    }
}

