/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.collision;

import gnu.trove.map.hash.TObjectLongHashMap;

public class CollidableHelper {
    private static final long EMPTY_VALUE = -1L;
    private long nextCollisionMask = 1L;
    private final TObjectLongHashMap<String> namedCollisionMask = new TObjectLongHashMap(64, 1.0f, -1L);

    public long getCollisionMask(String name) {
        long collisionMask = this.namedCollisionMask.get((Object)name);
        if (collisionMask == -1L) {
            return this.nextCollisionMask(name);
        }
        return collisionMask;
    }

    private long nextCollisionMask(String name) {
        if (!this.canAddCollisionMask()) {
            throw new RuntimeException("Max capacity reached.");
        }
        long collisionMask = this.nextCollisionMask;
        this.namedCollisionMask.put((Object)name, collisionMask);
        this.nextCollisionMask = CollidableHelper.shiftBitLeft(this.nextCollisionMask);
        return collisionMask;
    }

    public boolean canAddCollisionMask() {
        return this.nextCollisionMask != 0L;
    }

    public long createCollisionGroup(String ... collidables) {
        long group = 0L;
        for (String collidable : collidables) {
            group |= this.getCollisionMask(collidable);
        }
        return group;
    }

    private static long shiftBitLeft(long value) {
        return value << 1;
    }
}

