/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.impulseBased;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import us.ihmc.mecano.algorithms.ForwardDynamicsCalculator;
import us.ihmc.mecano.algorithms.MultiBodyResponseCalculator;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyTwistProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.scs2.simulation.parameters.ConstraintParameters;
import us.ihmc.scs2.simulation.parameters.ConstraintParametersBasics;
import us.ihmc.scs2.simulation.parameters.ConstraintParametersReadOnly;
import us.ihmc.scs2.simulation.physicsEngine.JointStateProvider;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.ImpulseBasedConstraintCalculator;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.ImpulseBasedJointTwistProvider;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.ImpulseBasedRigidBodyTwistProvider;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.LinearComplementarityProblemSolver;

public class RobotJointLimitImpulseBasedCalculator
implements ImpulseBasedConstraintCalculator {
    private static final int matrixInitialSize = 40;
    private final ConstraintParameters constraintParameters = new ConstraintParameters(0.0, 0.0, 0.0);
    private final List<OneDoFJointBasics> jointsAtLimit = new ArrayList<OneDoFJointBasics>();
    private final List<ActiveLimit> activeLimits = new ArrayList<ActiveLimit>();
    private boolean isFirstUpdate;
    private boolean isImpulseZero = false;
    private JointStateProvider externalJointTwistModifier;
    private final ImpulseBasedRigidBodyTwistProvider rigidBodyTwistModifier;
    private final ImpulseBasedJointTwistProvider jointTwistModifier;
    private final DMatrixRMaj jointVelocityNoImpulse = new DMatrixRMaj(40, 1);
    private final DMatrixRMaj jointVelocityDueToOtherImpulse = new DMatrixRMaj(40, 1);
    private final DMatrixRMaj jointVelocity = new DMatrixRMaj(40, 1);
    private final DMatrixRMaj jointVelocityPrevious = new DMatrixRMaj(40, 1);
    private final DMatrixRMaj jointVelocityUpdate = new DMatrixRMaj(40, 1);
    private final DMatrixRMaj solverInput_A = new DMatrixRMaj(40, 40);
    private final DMatrixRMaj solverInput_b = new DMatrixRMaj(40, 1);
    private final LinearComplementarityProblemSolver solver = new LinearComplementarityProblemSolver();
    private final DMatrixRMaj impulse = new DMatrixRMaj(40, 1);
    private final DMatrixRMaj impulsePrevious = new DMatrixRMaj(40, 1);
    private final DMatrixRMaj impulseUpdate = new DMatrixRMaj(40, 1);
    private final RigidBodyBasics rootBody;
    private final ForwardDynamicsCalculator forwardDynamicsCalculator;
    private final MultiBodyResponseCalculator responseCalculator;

    public RobotJointLimitImpulseBasedCalculator(RigidBodyBasics rootBody, ForwardDynamicsCalculator forwardDynamicsCalculator) {
        this.rootBody = rootBody;
        this.forwardDynamicsCalculator = forwardDynamicsCalculator;
        this.responseCalculator = new MultiBodyResponseCalculator(forwardDynamicsCalculator);
        this.rigidBodyTwistModifier = new ImpulseBasedRigidBodyTwistProvider(this.responseCalculator.getTwistChangeProvider().getInertialFrame(), rootBody);
        this.jointTwistModifier = new ImpulseBasedJointTwistProvider(rootBody);
    }

    @Override
    public void initialize(double dt) {
        this.jointsAtLimit.clear();
        this.activeLimits.clear();
        for (JointBasics joint : this.rootBody.childrenSubtreeIterable()) {
            OneDoFJointBasics oneDoFJoint;
            ActiveLimit activeLimit;
            if (!(joint instanceof OneDoFJointBasics) || (activeLimit = this.computeActiveLimit((OneDoFJointReadOnly)(oneDoFJoint = (OneDoFJointBasics)joint), dt)) == null) continue;
            this.jointsAtLimit.add(oneDoFJoint);
            this.activeLimits.add(activeLimit);
        }
        this.jointVelocityNoImpulse.reshape(this.jointsAtLimit.size(), 1);
        this.jointVelocityDueToOtherImpulse.reshape(this.jointsAtLimit.size(), 1);
        this.jointVelocity.reshape(this.jointsAtLimit.size(), 1);
        this.jointVelocityPrevious.reshape(this.jointsAtLimit.size(), 1);
        this.jointVelocityUpdate.reshape(this.jointsAtLimit.size(), 1);
        this.solverInput_A.reshape(this.jointsAtLimit.size(), this.jointsAtLimit.size());
        this.solverInput_b.reshape(this.jointsAtLimit.size(), 1);
        this.impulse.reshape(this.jointsAtLimit.size(), 1);
        this.impulsePrevious.reshape(this.jointsAtLimit.size(), 1);
        this.impulseUpdate.reshape(this.jointsAtLimit.size(), 1);
        for (int i = 0; i < this.jointsAtLimit.size(); ++i) {
            JointBasics joint;
            joint = this.jointsAtLimit.get(i);
            ActiveLimit activeLimit = this.activeLimits.get(i);
            double qd = joint.getQd() + dt * this.forwardDynamicsCalculator.getComputedJointAcceleration((JointReadOnly)joint).get(0);
            if (Math.abs(qd) >= this.constraintParameters.getRestitutionThreshold()) {
                qd *= 1.0 + this.constraintParameters.getCoefficientOfRestitution();
            }
            if (activeLimit == ActiveLimit.LOWER) {
                double distanceToLowerLimit = joint.getQ() - joint.getJointLimitLower();
                qd += distanceToLowerLimit * this.constraintParameters.getErrorReductionParameter() / dt;
            } else {
                double distanceToUpperLimit = joint.getQ() - joint.getJointLimitUpper();
                qd += distanceToUpperLimit * this.constraintParameters.getErrorReductionParameter() / dt;
            }
            this.jointVelocityNoImpulse.set(i, qd);
        }
        this.isFirstUpdate = true;
    }

    @Override
    public void updateInertia(List<? extends RigidBodyBasics> rigidBodyTargets, List<? extends JointBasics> jointTargets) {
        this.rigidBodyTwistModifier.clear(this.jointsAtLimit.size());
        this.jointTwistModifier.clear(this.jointsAtLimit.size());
        if (rigidBodyTargets != null) {
            this.rigidBodyTwistModifier.addAll(rigidBodyTargets);
        }
        if (jointTargets != null) {
            this.jointTwistModifier.addAll(jointTargets);
        }
        this.responseCalculator.reset();
        RigidBodyTwistProvider twistChangeProvider = this.responseCalculator.getTwistChangeProvider();
        for (int i = 0; i < this.jointsAtLimit.size(); ++i) {
            DMatrixRMaj externalInertiaMatrix;
            OneDoFJointBasics joint = this.jointsAtLimit.get(i);
            ActiveLimit activeLimit = this.activeLimits.get(i);
            this.responseCalculator.applyJointImpulse((OneDoFJointReadOnly)joint, 1.0);
            for (int j = i; j < this.jointsAtLimit.size(); ++j) {
                OneDoFJointBasics oneDoFJointBasics = this.jointsAtLimit.get(j);
                ActiveLimit otherActiveLimit = this.activeLimits.get(j);
                double a = this.responseCalculator.getJointTwistChange((OneDoFJointReadOnly)oneDoFJointBasics);
                a = activeLimit.transform(otherActiveLimit.transform(a));
                this.solverInput_A.set(j, i, a);
                this.solverInput_A.set(i, j, a);
            }
            for (RigidBodyBasics rigidBodyBasics : this.rigidBodyTwistModifier.getRigidBodies()) {
                externalInertiaMatrix = this.rigidBodyTwistModifier.getApparentInertiaMatrixInverse(rigidBodyBasics);
                twistChangeProvider.getTwistOfBody((RigidBodyReadOnly)rigidBodyBasics).get(0, i, (DMatrix)externalInertiaMatrix);
            }
            for (JointBasics jointBasics : this.jointTwistModifier.getJoints()) {
                externalInertiaMatrix = this.jointTwistModifier.getApparentInertiaMatrixInverse(jointBasics);
                externalInertiaMatrix.set((DMatrixD1)this.responseCalculator.getJointTwistChange((JointReadOnly)jointBasics));
            }
            this.responseCalculator.reset();
        }
    }

    private ActiveLimit computeActiveLimit(OneDoFJointReadOnly joint, double dt) {
        double qdd;
        double qd;
        double q = joint.getQ();
        double projected_q = q + dt * (qd = joint.getQd()) + 0.5 * dt * dt * (qdd = this.forwardDynamicsCalculator.getComputedJointAcceleration((JointReadOnly)joint).get(0));
        if (projected_q <= joint.getJointLimitLower()) {
            return ActiveLimit.LOWER;
        }
        if (projected_q >= joint.getJointLimitUpper()) {
            return ActiveLimit.UPPER;
        }
        return null;
    }

    @Override
    public void updateImpulse(double dt, double alpha, boolean ignoreOtherImpulses) {
        int i;
        if (this.jointsAtLimit.isEmpty()) {
            this.isImpulseZero = true;
            return;
        }
        if (this.externalJointTwistModifier != null) {
            for (i = 0; i < this.jointsAtLimit.size(); ++i) {
                this.jointVelocityDueToOtherImpulse.set(i, this.externalJointTwistModifier.getJointState((OneDoFJointReadOnly)this.jointsAtLimit.get(i)));
            }
            CommonOps_DDRM.add((DMatrixD1)this.jointVelocityNoImpulse, (DMatrixD1)this.jointVelocityDueToOtherImpulse, (DMatrixD1)this.jointVelocity);
        } else {
            this.jointVelocityDueToOtherImpulse.zero();
            this.jointVelocity.set((DMatrixD1)this.jointVelocityNoImpulse);
        }
        if (this.isFirstUpdate) {
            this.jointVelocityPrevious.set((DMatrixD1)this.jointVelocity);
            this.jointVelocityUpdate.set((DMatrixD1)this.jointVelocity);
        } else {
            CommonOps_DDRM.subtract((DMatrixD1)this.jointVelocity, (DMatrixD1)this.jointVelocityPrevious, (DMatrixD1)this.jointVelocityUpdate);
            this.jointVelocityPrevious.set((DMatrixD1)this.jointVelocity);
        }
        for (i = 0; i < this.jointsAtLimit.size(); ++i) {
            ActiveLimit activeLimit = this.activeLimits.get(i);
            this.solverInput_b.set(i, activeLimit.transform(this.jointVelocity.get(i)));
        }
        DMatrixRMaj solverOutput_f = this.solver.solve(this.solverInput_A, this.solverInput_b);
        for (int i2 = 0; i2 < this.jointsAtLimit.size(); ++i2) {
            ActiveLimit activeLimit = this.activeLimits.get(i2);
            this.impulse.set(i2, activeLimit.transform(solverOutput_f.get(i2)));
        }
        if (this.isFirstUpdate) {
            this.impulseUpdate.set((DMatrixD1)this.impulse);
        } else {
            CommonOps_DDRM.add((double)(1.0 - alpha), (DMatrixD1)this.impulsePrevious, (double)alpha, (DMatrixD1)this.impulse, (DMatrixD1)this.impulse);
        }
        this.isImpulseZero = NormOps_DDRM.normP2((DMatrixRMaj)this.impulse) < 1.0E-12;
        this.impulsePrevious.set((DMatrixD1)this.impulse);
        this.isFirstUpdate = false;
    }

    @Override
    public void updateTwistModifiers() {
        if (this.isImpulseZero) {
            this.rigidBodyTwistModifier.setImpulseToZero();
            this.jointTwistModifier.setImpulseToZero();
        } else {
            this.rigidBodyTwistModifier.setImpulse(this.impulse);
            this.jointTwistModifier.setImpulse(this.impulse);
        }
    }

    public void setConstraintParameters(ConstraintParametersReadOnly parameters) {
        this.constraintParameters.set(parameters);
    }

    public List<OneDoFJointBasics> getJointTargets() {
        return this.jointsAtLimit;
    }

    @Override
    public List<? extends RigidBodyBasics> getRigidBodyTargets() {
        return Collections.emptyList();
    }

    public List<ActiveLimit> getActiveLimits() {
        return this.activeLimits;
    }

    public DMatrixRMaj getImpulse() {
        return this.impulse;
    }

    @Override
    public double getImpulseUpdate() {
        return NormOps_DDRM.normP2((DMatrixRMaj)this.impulseUpdate);
    }

    @Override
    public double getVelocityUpdate() {
        return NormOps_DDRM.normP2((DMatrixRMaj)this.jointVelocityUpdate);
    }

    @Override
    public boolean isConstraintActive() {
        return !this.isImpulseZero;
    }

    @Override
    public void setExternalTwistModifier(JointStateProvider externalJointTwistModifier) {
        this.externalJointTwistModifier = externalJointTwistModifier;
    }

    @Override
    public int getNumberOfRobotsInvolved() {
        return 1;
    }

    @Override
    public RigidBodyBasics getRootBody(int index) {
        return this.rootBody;
    }

    @Override
    public RigidBodyTwistProvider getRigidBodyTwistChangeProvider(int index) {
        return this.rigidBodyTwistModifier;
    }

    @Override
    public JointStateProvider getJointTwistChangeProvider(int index) {
        return this.jointTwistModifier;
    }

    @Override
    public DMatrixRMaj getJointVelocityChange(int index) {
        if (!this.isConstraintActive()) {
            return null;
        }
        DMatrixRMaj response = this.responseCalculator.propagateImpulse();
        if (response != null) {
            return response;
        }
        for (int i = 0; i < this.jointsAtLimit.size(); ++i) {
            this.responseCalculator.applyJointImpulse((OneDoFJointReadOnly)this.jointsAtLimit.get(i), this.impulse.get(i));
        }
        return this.responseCalculator.propagateImpulse();
    }

    public DMatrixRMaj getJointVelocityDueToOtherImpulse() {
        return this.jointVelocityDueToOtherImpulse;
    }

    public MultiBodyResponseCalculator getResponseCalculator() {
        return this.responseCalculator;
    }

    public ConstraintParametersBasics getConstraintParameters() {
        return this.constraintParameters;
    }

    public static enum ActiveLimit {
        LOWER(DoubleUnaryOperator.identity()),
        UPPER(value -> -value);

        private final DoubleUnaryOperator signOperator;

        private ActiveLimit(DoubleUnaryOperator signOperator) {
            this.signOperator = signOperator;
        }

        double transform(double value) {
            return this.signOperator.applyAsDouble(value);
        }
    }
}

